/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.app.message;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.sm.pur.b2b.PurB2BFacadeFactory;
import com.kingdee.eas.scm.sm.pur.b2b.app.info.BuyerOrderMsg;
import com.kingdee.eas.scm.sm.pur.b2b.app.message.IMessageService;
import com.kingdee.eas.scm.sm.pur.b2b.model.ObjectCollection;
import com.kingdee.eas.scm.sm.pur.b2b.model.OrderEntryModel;
import com.kingdee.eas.scm.sm.pur.b2b.model.OrderModelInfo;
import com.kingdee.messageCenter.Message;
import com.kingdee.messageCenter.pushletClient.EASWorker;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class BuyerOrderMsgService
extends EASWorker
implements IMessageService<BuyerOrderMsg> {
    private static Logger logger = Logger.getLogger(BuyerOrderMsgService.class);

    @Override
    public boolean process(Context ctx, BuyerOrderMsg msgInfo) throws Exception {
        boolean bl;
        if (msgInfo == null) {
            return false;
        }
        Connection conn = null;
        String companyId = msgInfo.getCompanyId();
        String orderId = msgInfo.getData().get("orderId");
        try {
            OrderModelInfo orderInfo = PurB2BFacadeFactory.getLocalInstance(ctx).getWebOrderModelById(companyId, orderId);
            conn = EJBFactory.getConnection((Context)ctx);
            if (!this.isSavedOrder(conn, orderId)) {
                this.saveOrderModel(orderInfo, conn, msgInfo);
            }
            this.updatePurOrder(conn, msgInfo);
            bl = true;
        }
        catch (Exception e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        return bl;
    }

    private boolean saveOrderModel(OrderModelInfo order, Connection conn, BuyerOrderMsg msgInfo) throws SQLException, JSONException {
        this.saveOrderModelHeader(conn, order, msgInfo);
        return this.saveOrderModelEntry(conn, order.getOrderEntries(), msgInfo);
    }

    private boolean saveOrderModelHeader(Connection conn, OrderModelInfo order, BuyerOrderMsg msgInfo) throws SQLException {
        String sql = "insert into T_SM_WebOrderModelali (FId,FStatus,FGmtCreate,FRefundStatus,FGmtpayment,FGmtGoodSend,FCarriage,FRefundPayment,FSumparyment,FSellerCompany,FPrId,FBuyOfferId,FtradeType,FtradeTypeStr) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        String orderId = msgInfo.getData().get("orderId");
        String buyOfferId = msgInfo.getData().get("buyOfferId");
        String prId = msgInfo.getData().get("prId").replace("&", "+");
        PreparedStatement ps = conn.prepareStatement(sql);
        ps.setString(1, orderId);
        ps.setString(2, order.getStatus());
        if (order.getGmtCreate() != null) {
            ps.setTimestamp(3, new Timestamp(order.getGmtCreate().getTime()));
        } else {
            ps.setTimestamp(3, null);
        }
        ps.setString(4, order.getRefundStatus());
        if (order.getGmtPayment() != null) {
            ps.setTimestamp(5, new Timestamp(order.getGmtPayment().getTime()));
        } else {
            ps.setTimestamp(5, null);
        }
        if (order.getGmtGoodsSend() != null) {
            ps.setTimestamp(6, new Timestamp(order.getGmtGoodsSend().getTime()));
        } else {
            ps.setTimestamp(6, null);
        }
        ps.setLong(7, order.getCarriage());
        ps.setLong(8, order.getRefundPayment());
        ps.setLong(9, order.getSumPayment());
        ps.setString(10, order.getSellerCompanyName());
        ps.setString(11, prId);
        ps.setString(12, buyOfferId);
        ps.setString(13, order.getTradeType());
        ps.setString(14, order.getTradeTypeStr());
        int result = ps.executeUpdate();
        ps.close();
        return result > 0;
    }

    private boolean saveOrderModelEntry(Connection conn, ObjectCollection<OrderEntryModel> entris, BuyerOrderMsg msgInfo) throws SQLException, JSONException {
        String sql = "insert into T_SM_WebOrderEntryModelAli (FId,FProductName,FsourceId,FPrItemId,FsupplyNoteItemId,FQuotatity,FUnit,FPrice,FDiscountPrice,FAmount,FDiscount,FEntryStatusStr,FEntryRefundstatus,FEntryParyStatus,FGmtCreate,FParentId) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        String items = msgInfo.getData().get("items");
        String orderId = msgInfo.getData().get("orderId");
        JSONArray jsonItems = new JSONArray(items);
        HashMap<String, String> prItems = new HashMap<String, String>();
        HashMap<String, String> supplyNoteItemIds = new HashMap<String, String>();
        for (int i = 0; i < jsonItems.length(); ++i) {
            JSONObject obj = (JSONObject)jsonItems.get(i);
            String prItemId = obj.optString("prItemId").replace("&", "+");
            prItems.put(obj.getString("orderItemId"), prItemId);
            supplyNoteItemIds.put(obj.getString("orderItemId"), obj.getString("supplyNoteItemId"));
        }
        PreparedStatement ps = conn.prepareStatement(sql);
        for (int i = 0; i < entris.size(); ++i) {
            OrderEntryModel entry = entris.getItem(i);
            ps.setString(1, entry.getId());
            ps.setString(2, entry.getProductName());
            ps.setString(3, entry.getSourceId());
            ps.setString(4, (String)prItems.get(entry.getId()));
            ps.setString(5, (String)supplyNoteItemIds.get(entry.getId()));
            ps.setDouble(6, entry.getQuantity());
            ps.setString(7, entry.getUnit());
            ps.setLong(8, entry.getPrice());
            ps.setLong(9, entry.getDiscountPrice());
            ps.setLong(10, entry.getAmount());
            ps.setLong(11, entry.getDiscount());
            ps.setString(12, entry.getEntryStatusStr());
            ps.setString(13, entry.getEntryRefundStatus());
            ps.setInt(14, entry.getEntryPayStatus());
            if (entry.getGmtCreate() != null) {
                ps.setTimestamp(15, new Timestamp(entry.getGmtCreate().getTime()));
            } else {
                ps.setTimestamp(15, null);
            }
            ps.setString(16, orderId);
            ps.addBatch();
        }
        int[] results = ps.executeBatch();
        int result = 0;
        for (int i = 0; i < results.length; ++i) {
            result += results[i];
        }
        ps.close();
        return result > 0;
    }

    private boolean isSavedOrder(Connection conn, String orderId) throws SQLException {
        String sql = "select count(*) as count from T_SM_WebOrderModelali where FId=?";
        PreparedStatement ps = conn.prepareStatement(sql);
        ps.setString(1, orderId);
        ResultSet rs = ps.executeQuery();
        int result = 0;
        while (rs.next()) {
            result = rs.getInt("count");
        }
        ps.close();
        return result > 0;
    }

    private boolean updatePurOrder(Connection conn, BuyerOrderMsg msgInfo) throws SQLException, JSONException {
        this.updatePurOrderEntry(conn, msgInfo);
        return this.updatePurOrderHeader(conn, msgInfo);
    }

    private boolean updatePurOrderHeader(Connection conn, BuyerOrderMsg msgInfo) throws SQLException {
        String sql = "update t_sm_purorder set FnetOrderId=?,FIsNetOrder=1 where fid in (select FparentId from t_sm_purorderentry where FnetQuotationId=?) ";
        PreparedStatement ps = conn.prepareStatement(sql);
        String orderId = msgInfo.getData().get("orderId");
        String quotationId = msgInfo.getData().get("quotationId");
        ps.setString(1, orderId);
        ps.setString(2, quotationId);
        boolean b = ps.executeUpdate() > 0;
        ps.close();
        return b;
    }

    private boolean updatePurOrderEntry(Connection conn, BuyerOrderMsg msgInfo) throws SQLException, JSONException {
        String sql = "update t_sm_purorderentry set FnetOrderEntryId=? where FnetQuotationItemId=?";
        String items = msgInfo.getData().get("items");
        JSONArray jsonItems = new JSONArray(items);
        HashMap<String, String> supplyNoteItemIds = new HashMap<String, String>();
        for (int i = 0; i < jsonItems.length(); ++i) {
            JSONObject obj = (JSONObject)jsonItems.get(i);
            supplyNoteItemIds.put(obj.getString("orderItemId"), obj.getString("supplyNoteItemId"));
        }
        PreparedStatement ps = conn.prepareStatement(sql);
        for (String orderItemId : supplyNoteItemIds.keySet()) {
            ps.setString(1, orderItemId);
            ps.setString(2, (String)supplyNoteItemIds.get(orderItemId));
            ps.addBatch();
        }
        int[] count = ps.executeBatch();
        int sum = 0;
        for (int i = 0; i < count.length; ++i) {
            sum += count[i];
        }
        ps.close();
        return sum > 0;
    }

    @Override
    public Message runInEAS(Context ctx, Message message) throws EASBizException, BOSException {
        BuyerOrderMsg msg = new BuyerOrderMsg();
        msg.copyMessage(message);
        try {
            this.process(ctx, msg);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }
}

