/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.app.message;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.sm.pur.b2b.app.info.BuyerTradeSuccessMsg;
import com.kingdee.eas.scm.sm.pur.b2b.app.message.IMessageService;
import com.kingdee.messageCenter.Message;
import com.kingdee.messageCenter.pushletClient.EASWorker;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class BuyerTradeSuccessMsgService
extends EASWorker
implements IMessageService<BuyerTradeSuccessMsg> {
    private static Logger logger = Logger.getLogger(BuyerTradeSuccessMsgService.class);

    @Override
    public Message runInEAS(Context ctx, Message message) throws EASBizException, BOSException {
        BuyerTradeSuccessMsg msg = new BuyerTradeSuccessMsg();
        msg.copyMessage(message);
        try {
            this.process(ctx, msg);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    public boolean process(Context ctx, BuyerTradeSuccessMsg msgInfo) throws Exception {
        if (msgInfo == null) {
            return false;
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String webOrderId = msgInfo.getData().get("orderId");
            this.updateWebOrder(conn, webOrderId);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return true;
    }

    private boolean updateWebOrder(Connection conn, String webOrderId) throws SQLException {
        String sql = "update T_SM_WebOrderModelali set FStatus='SUCCESS' where FId=?";
        PreparedStatement ps = conn.prepareStatement(sql);
        ps.setString(1, webOrderId);
        boolean b = ps.executeUpdate() > 0;
        ps.close();
        return b;
    }
}

