/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.app.message;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.sm.pur.b2b.app.info.SupplierCancelQuotationMsg;
import com.kingdee.eas.scm.sm.pur.b2b.app.message.IMessageService;
import com.kingdee.messageCenter.Message;
import com.kingdee.messageCenter.pushletClient.EASWorker;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class SupplierCancleQuotationMsgService
extends EASWorker
implements IMessageService<SupplierCancelQuotationMsg> {
    private static Logger logger = Logger.getLogger(SupplierCancleQuotationMsgService.class);

    @Override
    public Message runInEAS(Context ctx, Message message) throws EASBizException, BOSException {
        SupplierCancelQuotationMsg msg = new SupplierCancelQuotationMsg();
        msg.copyMessage(message);
        try {
            this.process(ctx, msg);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    public boolean process(Context ctx, SupplierCancelQuotationMsg msgInfo) throws Exception {
        if (msgInfo == null) {
            return false;
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String quotationId = msgInfo.getData().get("quotationId");
            if (this.isQuotationSaved(quotationId, conn)) {
                this.updateQuotationByCancle(quotationId, conn);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return false;
    }

    private boolean updateQuotationByCancle(String quotationId, Connection conn) throws SQLException {
        if (quotationId == null) {
            return false;
        }
        String sql = "update t_sm_quotationali set FQuoStatus='0' where FID=?";
        PreparedStatement ps = conn.prepareStatement(sql);
        long quoId = Long.parseLong(quotationId);
        ps.setLong(1, quoId);
        boolean ret = ps.executeUpdate() > 0;
        ps.close();
        return ret;
    }

    private boolean isQuotationSaved(String quoId, Connection conn) throws SQLException {
        String sql = "select count(*) as count from T_SM_QuotationAli where FId=?";
        PreparedStatement ps = conn.prepareStatement(sql);
        long id = Long.parseLong(quoId);
        ps.setLong(1, id);
        ResultSet rs = ps.executeQuery();
        int result = 0;
        while (rs.next()) {
            result = rs.getInt("count");
        }
        ps.close();
        return result > 0;
    }
}

