/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.app.message.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitExt;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitExtInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.sm.pur.b2b.app.message.model.NetPurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.b2b.app.message.model.NetPurOrderInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MessageUtils {
    public static Set getAuthorizedCompanyOrgIds(Context ctx, String userId, String permissionItem, OrgType orgType, boolean isbizUnit) throws BOSException {
        HashSet<String> authorizedOrgIds = null;
        if (!StringUtil.isEmpty((String)userId) && !StringUtil.isEmpty((String)permissionItem)) {
            try {
                FullOrgUnitCollection orgUnitCol = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userId), orgType, null, permissionItem);
                authorizedOrgIds = new HashSet<String>();
                FullOrgUnitInfo orgUnit = null;
                int size = orgUnitCol.size();
                for (int i = 0; i < size; ++i) {
                    orgUnit = orgUnitCol.get(i);
                    OrgUnitExtInfo orgInfo = MessageUtils.getOrgUnitExt(ctx, orgType, orgUnit.get("id").toString());
                    if (orgInfo != null && isbizUnit) {
                        if (!orgInfo.isIsBizUnit()) continue;
                        authorizedOrgIds.add(orgUnitCol.get(i).getId().toString());
                        continue;
                    }
                    authorizedOrgIds.add(orgUnitCol.get(i).getId().toString());
                }
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return authorizedOrgIds;
    }

    public static OrgUnitExtInfo getOrgUnitExt(Context ctx, OrgType orgType, String orgUnitId) throws BOSException, EASBizException {
        if (orgType != null) {
            IOrgUnitExt iOrgUnitExt = null;
            if (1 == orgType.getValue()) {
                iOrgUnitExt = (IOrgUnitExt)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)new BOSObjectType("16FD9F90"));
            } else if (5 == orgType.getValue()) {
                iOrgUnitExt = (IOrgUnitExt)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)new BOSObjectType("7FAFDF41"));
            } else if (16 == orgType.getValue()) {
                iOrgUnitExt = (IOrgUnitExt)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)new BOSObjectType("58B332D9"));
            } else if (6 == orgType.getValue()) {
                iOrgUnitExt = (IOrgUnitExt)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)new BOSObjectType("A70FCF6A"));
            } else if (3 == orgType.getValue()) {
                iOrgUnitExt = (IOrgUnitExt)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)new BOSObjectType("DF1A22A2"));
            } else if (32 == orgType.getValue()) {
                iOrgUnitExt = (IOrgUnitExt)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)new BOSObjectType("743064CE"));
            } else if (2 == orgType.getValue()) {
                iOrgUnitExt = (IOrgUnitExt)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)new BOSObjectType("6F9FB21C"));
            } else if (4 == orgType.getValue()) {
                iOrgUnitExt = (IOrgUnitExt)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)new BOSObjectType("EB1F7FD2"));
            } else if (24 == orgType.getValue()) {
                iOrgUnitExt = (IOrgUnitExt)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)new BOSObjectType("5CEBCE24"));
            }
            if (iOrgUnitExt != null) {
                OrgUnitExtInfo orgInfo = iOrgUnitExt.getOrgUnitExtInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
                return orgInfo;
            }
        }
        return null;
    }

    public static CompanyOrgUnitInfo getHasPermissionOrg(Context ctx, String userID, String curCompanyId, String invoiceCompanyId, String permission, OrgType orgType) throws EASBizException, BOSException {
        Set orgsID = MessageUtils.getAuthorizedCompanyOrgIds(ctx, userID, permission, orgType, true);
        if (orgsID == null || orgsID.size() == 0) {
            return null;
        }
        if (invoiceCompanyId != null && orgsID.contains(invoiceCompanyId)) {
            CompanyOrgUnitInfo retValue = new CompanyOrgUnitInfo();
            retValue.setId(BOSUuid.read((String)invoiceCompanyId));
            return retValue;
        }
        if (curCompanyId != null && orgsID.contains(curCompanyId)) {
            CompanyOrgUnitInfo retValue = new CompanyOrgUnitInfo();
            retValue.setId(BOSUuid.read((String)curCompanyId));
            return retValue;
        }
        CompanyOrgUnitInfo retValue = new CompanyOrgUnitInfo();
        retValue.setId(BOSUuid.read((String)orgsID.toArray()[0].toString()));
        return retValue;
    }

    public static Map getMaterialIDByNumber(Context ctx, NetPurOrderInfo netInfo) throws BOSException, EASBizException {
        String numbers = MessageUtils.getNumbers(netInfo);
        String sql = "select fid,fnumber from t_bd_material where fnumber in " + numbers;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, String> retMap = new HashMap<String, String>();
        try {
            while (rs.next()) {
                String number = rs.getString("fnumber");
                String id = rs.getString("fid");
                retMap.put(number, id);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return retMap;
    }

    public static String getNumbers(NetPurOrderInfo netInfo) {
        ArrayList<String> materiaNum = new ArrayList<String>();
        List<NetPurOrderEntryInfo> entrys = netInfo.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            NetPurOrderEntryInfo entry = entrys.get(i);
            materiaNum.add(entry.getMaterialNumber());
        }
        String numbers = MessageUtils.getInStringFromList(materiaNum);
        return numbers;
    }

    public static String getInStringFromList(List list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        StringBuffer in = new StringBuffer();
        in.append(" (");
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            in.append("'").append(iter.next().toString()).append("'");
            if (!iter.hasNext()) continue;
            in.append(",");
        }
        in.append(") ");
        return in.toString();
    }
}

