/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.util;

import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.b2b.app.info.MessageInfo;
import com.kingdee.eas.scm.sm.pur.b2b.model.BusinessInfo;
import com.kingdee.eas.scm.sm.pur.b2b.model.BuyOfferInfo;
import com.kingdee.eas.scm.sm.pur.b2b.model.BuyOfferItem;
import com.kingdee.eas.scm.sm.pur.b2b.model.ContactInfo;
import com.kingdee.eas.scm.sm.pur.b2b.model.ObjectCollection;
import com.kingdee.eas.scm.sm.pur.b2b.model.OrderEntryModel;
import com.kingdee.eas.scm.sm.pur.b2b.model.OrderModelInfo;
import com.kingdee.eas.scm.sm.pur.b2b.model.QuotationInfo;
import com.kingdee.eas.scm.sm.pur.b2b.model.QuotationItem;
import com.kingdee.eas.scm.sm.pur.b2b.model.SupplierCompanyInfo;
import com.kingdee.eas.scm.sm.pur.b2b.model.SupplierContactInfo;
import com.kingdee.eas.scm.sm.pur.b2b.model.SupplierInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class JSONUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.b2b.util.JSONUtil");

    public static ObjectCollection<BuyOfferInfo> json2BuyOfferList(String value) throws JSONException {
        return JSONUtil.json2BuyOfferList(new JSONObject(value));
    }

    public static ObjectCollection<BuyOfferInfo> json2BuyOfferList(JSONObject value) throws JSONException {
        ObjectCollection<BuyOfferInfo> result = new ObjectCollection<BuyOfferInfo>();
        if (value == null || value.length() == 0) {
            return null;
        }
        JSONArray buyOffList = value.optJSONArray("buyOfferList");
        BuyOfferInfo info = null;
        int size = buyOffList.length();
        for (int index = 0; index < size; ++index) {
            Object item = buyOffList.get(index);
            info = JSONUtil.json2BuyOffInfo((JSONObject)item, false);
            if (info == null) continue;
            result.addItem(info);
        }
        return result;
    }

    public static BuyOfferInfo json2BuyOffInfo(String value, boolean isHasProfix) throws JSONException {
        JSONObject json = new JSONObject(value);
        return JSONUtil.json2BuyOffInfo(json, isHasProfix);
    }

    public static BuyOfferInfo json2BuyOffInfo(JSONObject value, boolean isHasProfix) throws JSONException {
        JSONObject buyOff;
        logger.debug((Object)"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
        logger.debug((Object)("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& json2BuyOffInfo =" + value));
        BuyOfferInfo result = new BuyOfferInfo();
        if (value == null || value.length() == 0) {
            return null;
        }
        if (isHasProfix) {
            buyOff = value.optJSONObject("buyOffer");
            if (buyOff == null || buyOff.length() == 0) {
                return null;
            }
        } else {
            buyOff = value;
        }
        result.setGmtQuotationExpire(JSONUtil.parseDate(buyOff.opt("gmtQuotationExpire"), "gmtQuotationExpire"));
        result.setDescription(buyOff.optString("description"));
        result.setStatus(buyOff.optString("status"));
        result.setTitle(buyOff.optString("title"));
        result.setPurchaseNoteId(buyOff.optString("purchaseNoteId"));
        result.setSubUserId(buyOff.optString("subUserId"));
        result.setBuyerMemberId(buyOff.optString("buyerMemberId"));
        result.setGmtCreate(JSONUtil.parseDate(buyOff.opt("gmtCreate"), "gmtCreate"));
        result.setPrId(buyOff.optString("prId"));
        result.setIncludeTax(buyOff.optBoolean("includeTax"));
        result.setVisibleAfterEndQuote(buyOff.optBoolean("isVisibleAfterEndQuote"));
        JSONObject contact = buyOff.optJSONObject("contactInfo");
        if (contact != null) {
            result.setContactInfo(JSONUtil.json2ContactInfo(contact));
        }
        JSONArray buyOffItems = buyOff.optJSONArray("purchaseNoteItems");
        ObjectCollection<BuyOfferItem> coll = new ObjectCollection<BuyOfferItem>();
        BuyOfferItem buyOfferItem = null;
        int len = buyOffItems.length();
        for (int index = 0; index < len; ++index) {
            Object item = buyOffItems.get(index);
            buyOfferItem = JSONUtil.json2BuyOffItem((JSONObject)item);
            if (buyOfferItem == null) continue;
            coll.addItem(buyOfferItem);
        }
        result.setPurchaseNoteItems(coll);
        return result;
    }

    public static BuyOfferItem json2BuyOffItem(JSONObject value) {
        BuyOfferItem result = new BuyOfferItem();
        if (value == null || value.length() == 0) {
            return result;
        }
        result.setSubject(value.optString("subject"));
        result.setPurchaseAmount(value.optLong("purchaseAmount"));
        result.setUnit(value.optString("unit"));
        result.setDesc(value.optString("productFeature"));
        result.setPurchaseNoteItemId(value.optString("purchaseNoteItemId"));
        result.setProductCode(value.optString("productCode"));
        String prItemId = value.optString("prItemId").replace("&", "+");
        result.setPrItemId(prItemId);
        result.setDesc(value.optString("desc"));
        return result;
    }

    public static ObjectCollection<QuotationInfo> json2QuotationList(String value) throws JSONException {
        logger.debug((Object)"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
        logger.debug((Object)("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& json2QuotationList =" + value));
        JSONObject json = new JSONObject(value);
        return JSONUtil.json2QuotationList(json);
    }

    public static ObjectCollection<QuotationInfo> json2QuotationList(JSONObject value) throws JSONException {
        ObjectCollection<QuotationInfo> result = new ObjectCollection<QuotationInfo>();
        if (value == null || value.length() == 0) {
            return null;
        }
        JSONArray quotationList = value.optJSONArray("quotationList");
        QuotationInfo info = null;
        int len = quotationList.length();
        for (int i = 0; i < len; ++i) {
            Object item = quotationList.get(i);
            info = JSONUtil.json2QuotationInfo((JSONObject)item, false);
            if (info == null) continue;
            result.addItem(info);
        }
        return result;
    }

    public static QuotationInfo json2QuotationInfo(JSONObject value, boolean isHasProfix) throws JSONException {
        JSONObject payRequirement;
        JSONObject quotation;
        logger.debug((Object)"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
        logger.debug((Object)("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& json2QuotationInfo =" + value));
        QuotationInfo result = new QuotationInfo();
        if (value == null || value.length() == 0) {
            return null;
        }
        if (isHasProfix) {
            quotation = value.optJSONObject("quotation");
            if (quotation == null || quotation.length() == 0) {
                return null;
            }
        } else {
            quotation = value;
        }
        result.setId(quotation.optLong("id"));
        result.setExpireDate(JSONUtil.parseDate(quotation.opt("expireDate"), "expireDate"));
        result.setBuyOfferId(quotation.optString("buyOfferId"));
        result.setSupplierMemberId(quotation.optString("supplierMemberId"));
        result.setInvoiceType(quotation.optString("invoiceType"));
        result.setFreight(quotation.optLong("freight"));
        result.setTotalPrice(quotation.optLong("totalPrice"));
        result.setSpecifications(quotation.optString("specifications"));
        result.setGmtCreate(JSONUtil.parseDate(quotation.opt("gmtCreate"), "gmtCreate"));
        String prId = quotation.optString("prId").replace("&", "+");
        result.setPrId(prId);
        JSONObject contact = quotation.optJSONObject("contactInfo");
        if (contact != null && contact.length() != 0) {
            result.setContactInfo(JSONUtil.json2ContactInfo(contact));
        }
        if ((payRequirement = quotation.optJSONObject("payRequirementInfo")) != null && payRequirement.length() != 0) {
            result.setPayType(payRequirement.optString("type"));
            result.setPaySpecification(payRequirement.optString("desc"));
        }
        JSONArray quotationItems = quotation.getJSONArray("supplyNoteItems");
        ObjectCollection<QuotationItem> coll = new ObjectCollection<QuotationItem>();
        QuotationItem quotationItem = null;
        int len = quotationItems.length();
        for (int i = 0; i < len; ++i) {
            Object item = quotationItems.get(i);
            quotationItem = JSONUtil.json2QuotationItem((JSONObject)item);
            if (quotationItem == null) continue;
            coll.addItem(quotationItem);
        }
        result.setSupplyNoteItems(coll);
        JSONObject jsonSupplier = quotation.optJSONObject("supplier");
        if (jsonSupplier != null && jsonSupplier.length() != 0) {
            SupplierInfo supplier = JSONUtil.json2SupplierInfo(jsonSupplier);
            result.setSupplier(supplier);
        }
        return result;
    }

    public static OrderModelInfo json2OrderModelInfo(String value, boolean isHasProfix) throws JSONException {
        JSONObject json = new JSONObject(value);
        return JSONUtil.json2OrderModelInfo(json, isHasProfix);
    }

    public static OrderModelInfo json2OrderModelInfo(JSONObject value, boolean isHasProfix) throws JSONException {
        JSONObject orderModel;
        OrderModelInfo result = new OrderModelInfo();
        if (value == null || value.length() == 0) {
            return null;
        }
        if (isHasProfix) {
            orderModel = value.optJSONObject("orderModel");
            if (orderModel == null || orderModel.length() == 0) {
                return null;
            }
        } else {
            orderModel = value;
        }
        result.setId(orderModel.optString("id"));
        result.setStatus(orderModel.optString("status"));
        result.setGmtCreate(JSONUtil.parseDate(orderModel.opt("gmtCreate"), "gmtCreate"));
        result.setRefundStatus(orderModel.optString(""));
        result.setGmtPayment(JSONUtil.parseDate(orderModel.opt("gmtPayment"), "gmtPayment"));
        result.setGmtGoodsSend(JSONUtil.parseDate(orderModel.opt("gmtGoodsSend"), "gmtGoodsSend"));
        result.setCarriage(orderModel.optLong("carriagee"));
        result.setRefundPayment(orderModel.optLong("refundPayment"));
        result.setSumPayment(orderModel.optLong("sumPayment"));
        result.setSellerCompanyName(orderModel.optString("sellerCompanyName"));
        result.setTradeType(orderModel.optString("tradeType"));
        result.setTradeTypeStr(orderModel.optString("tradeTypeStr"));
        JSONArray orderEntries = orderModel.optJSONArray("orderEntries");
        ObjectCollection<OrderEntryModel> coll = new ObjectCollection<OrderEntryModel>();
        OrderEntryModel orderEntryModel = null;
        for (int i = 0; i < orderEntries.length(); ++i) {
            Object item = orderEntries.get(i);
            orderEntryModel = JSONUtil.json2OrderEntryModel((JSONObject)item);
            if (orderEntryModel == null) continue;
            coll.addItem(orderEntryModel);
        }
        result.setOrderEntries(coll);
        return result;
    }

    public static OrderEntryModel json2OrderEntryModel(JSONObject value) {
        OrderEntryModel result = new OrderEntryModel();
        if (value == null || value.length() == 0) {
            return null;
        }
        result.setId(value.optString("id"));
        result.setOrderId(value.optString("orderId"));
        result.setProductName(value.optString("productName"));
        result.setSourceId(value.optString("sourceId"));
        result.setQuantity(value.optDouble("quantity"));
        result.setUnit(value.optString("unit"));
        result.setPrice(value.optLong("price"));
        result.setDiscountPrice(value.optLong("discountPrice"));
        result.setCurrencyCode(value.optString("currencyCode"));
        result.setAmount(value.optLong("amount"));
        result.setDiscount(value.optLong("discount"));
        result.setEntryStatusStr(value.optString("entryStatusStr"));
        result.setEntryRefundStatus(value.optString("entryRefundStatus"));
        result.setEntryPayStatus(value.optInt("entryPayStatus"));
        result.setGmtCreate(JSONUtil.parseDate(value.opt("gmtCreate"), "gmtCreate"));
        return result;
    }

    public static ContactInfo json2ContactInfo(JSONObject value) {
        ContactInfo result = new ContactInfo();
        if (value == null || value.length() == 0) {
            return result;
        }
        result.setContact(value.optString("contact"));
        result.setPhone(value.optString("phone"));
        result.setMobile(value.optString("mobile"));
        result.setEmail(value.optString("email"));
        return result;
    }

    public static QuotationItem json2QuotationItem(JSONObject value) {
        logger.debug((Object)"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
        logger.debug((Object)("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& json2QuotationItem =" + value));
        QuotationItem result = new QuotationItem();
        if (value == null || value.length() == 0) {
            return result;
        }
        result.setSubject(value.optString("subject"));
        result.setProductId(value.optLong("productId"));
        result.setAmount(value.optInt("amount"));
        result.setUnit(value.optString("unit"));
        result.setPrice(value.optLong("price"));
        String prItemId = value.optString("prItemId").replace("&", "+");
        result.setPrItemId(prItemId);
        result.setId(value.optLong("id"));
        String taxRate = value.optString("taxRate");
        result.setIncludeTax(true);
        result.setTaxRate(taxRate);
        if (StringUtils.isEmpty((String)taxRate) || "-1".equals(taxRate) || "-2".equals(taxRate)) {
            result.setIncludeTax(false);
            result.setTaxRate("0");
        }
        return result;
    }

    public static SupplierInfo json2SupplierInfo(JSONObject value) throws JSONException {
        SupplierInfo supplierInfo = new SupplierInfo();
        if (value == null || value.length() == 0) {
            return supplierInfo;
        }
        JSONObject company = value.optJSONObject("companyInfo");
        if (company != null && company.length() != 0) {
            SupplierCompanyInfo companyInfo = new SupplierCompanyInfo();
            companyInfo.setCompanySummary(company.optString("companySummary"));
            companyInfo.setName(company.optString("name"));
            companyInfo.setPrincipal(company.optString("principal"));
            companyInfo.setCompanyAddress(company.optString("companyAddress"));
            companyInfo.setRegistrationId(company.optString("registrationId"));
            companyInfo.setEnterpriseType(company.optString("enterpriseType"));
            companyInfo.setDateOfEstablishment(company.optString("dateOfEstablishment"));
            companyInfo.setRegisteredCapital(company.optString("registeredCapital"));
            companyInfo.setBusinessTerm(company.optString("businessTerm"));
            companyInfo.setBusinessScope(company.optString("businessScope"));
            companyInfo.setBank(company.optString("bank"));
            companyInfo.setBankAccount(company.optString("bankAccount"));
            supplierInfo.setCompanyInfo(companyInfo);
        }
        BusinessInfo businessInfo = new BusinessInfo();
        JSONObject business = value.optJSONObject("businessInfo");
        if (business != null) {
            businessInfo.setMainIndustries(business.optString("mainIndustries"));
            businessInfo.setBusinessAddress(business.optString("businessAddress"));
        }
        supplierInfo.setBusinessInfo(businessInfo);
        SupplierContactInfo contactInfo = new SupplierContactInfo();
        JSONObject contact = value.optJSONObject("contactInfo");
        if (contact != null && contact.length() != 0) {
            contactInfo.setName(contact.optString("name"));
            contactInfo.setMobile(contact.optString("mobile"));
            contactInfo.setPhone(contact.optString("phone"));
            contactInfo.setGender(contact.optString("gender"));
            contactInfo.setFax(contact.optString("fax"));
            contactInfo.setZipCode(contact.optString("zipCode"));
            contactInfo.setContactAddress(contact.optString("contactAddress"));
        }
        supplierInfo.setContactInfo(contactInfo);
        return supplierInfo;
    }

    public static Date parseDate(Object dateValue, String fieldName) {
        if (dateValue != null && dateValue instanceof Date) {
            return (Date)dateValue;
        }
        if (dateValue != null) {
            try {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateValue.toString());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public static List<MessageInfo> json2MessageList(String value) throws JSONException {
        logger.debug((Object)"&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
        logger.debug((Object)("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& json2MessageList =" + value));
        ArrayList<MessageInfo> msgList = new ArrayList<MessageInfo>();
        if (StringUtils.isEmpty((String)value)) {
            return msgList;
        }
        JSONObject jsonObj = new JSONObject(value);
        JSONArray jsonArr = jsonObj.getJSONArray("messages");
        int size = jsonArr.length();
        for (int i = 0; i < size; ++i) {
            JSONObject msgJson = jsonArr.optJSONObject(i);
            MessageInfo msg = MessageInfo.parse(msgJson);
            msgList.add(msg);
        }
        return msgList;
    }

    public static String makeOrderInfo2Json(PurRequestEntryCollection entries) throws JSONException, UnsupportedEncodingException {
        PurRequestEntryInfo entry;
        int i;
        JSONArray entryJsonArray = new JSONArray();
        for (i = 0; i < entries.size(); ++i) {
            entry = entries.get(i);
            if (entry.getBaseStatus().equals((Object)EntryBaseStatusEnum.AUDITED)) continue;
            String msg = EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.b2b.PurB2BResource.ENTRY_NOT_AUDIT");
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
            break;
        }
        for (i = 0; i < entries.size(); ++i) {
            entry = entries.get(i);
            String entryId = entry.getId().toString();
            String parentId = entry.getParent().getId().toString();
            MaterialInfo materialInfo = entry.getMaterial();
            String materialName = entry.getMaterialName();
            String qty = entry.getQty().toString();
            String materialId = "";
            if (materialInfo != null) {
                materialId = materialInfo.getId().toString();
            }
            String rowTypeId = "";
            RowTypeInfo rowType = entry.getRowType();
            if (rowType != null) {
                rowTypeId = rowType.getId().toString();
            }
            JSONObject entryJsonObject = new JSONObject();
            entryJsonObject.put("parentId", (Object)URLEncoder.encode(parentId, "UTF-8"));
            entryJsonObject.put("entryId", (Object)URLEncoder.encode(entryId, "UTF-8"));
            entryJsonObject.put("materialName", (Object)materialName);
            if (entry.getMaterial() != null) {
                entryJsonObject.put("materialNumber", (Object)entry.getMaterial().getNumber());
                entryJsonObject.put("materialModel", (Object)entry.getMaterial().getModel());
            }
            entryJsonObject.put("materialId", (Object)URLEncoder.encode(materialId, "UTF-8"));
            entryJsonObject.put("qty", (Object)qty);
            entryJsonObject.put("rowTypeId", (Object)URLEncoder.encode(rowTypeId, "UTF-8"));
            entryJsonArray.put((Object)entryJsonObject);
        }
        JSONObject makeOrderJsonInfo = new JSONObject();
        makeOrderJsonInfo.put("result", (Object)entryJsonArray);
        return makeOrderJsonInfo.toString();
    }
}

