/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.ISCMGroupFacade;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.PurEntryDataVO;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.b2b.PurB2BFacadeFactory;
import com.kingdee.eas.scm.sm.pur.b2b.PurCloudServiceFactory;
import com.kingdee.eas.util.client.MsgBox;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Map;

public class PurCloudHelper {
    public static String buildRequestData(PurRequestInfo requestBill, UserInfo userInfo) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("contact", (Object)userInfo.getName());
        jsonObject.put("phone", (Object)userInfo.getCell());
        jsonObject.put("description", (Object)requestBill.getDescription());
        String prId = requestBill.getId().toString().replace("+", "&");
        jsonObject.put("prId", (Object)prId);
        PurRequestEntryInfo entry = null;
        PurRequestEntryCollection coll = requestBill.getEntries();
        JSONArray entryArray = new JSONArray();
        for (int i = 0; i < coll.size(); ++i) {
            entry = coll.get(i);
            JSONObject entryObject = new JSONObject();
            if (entry.getMaterial() == null) {
                entryObject.put("subject", (Object)entry.getMaterialName());
                entryObject.put("productCode", (Object)"");
            } else {
                entryObject.put("subject", (Object)entry.getMaterial().getName());
                entryObject.put("productCode", (Object)entry.getMaterial().getNumber());
            }
            entryObject.put("desc", (Object)PurCloudHelper.buildProductDesc(entry));
            entryObject.put("unit", (Object)entry.getUnit().getName());
            entryObject.put("purchaseAmount", Math.round(entry.getQty().doubleValue()));
            String prItemId = entry.getId().toString().toString().replace("+", "&");
            entryObject.put("prItemId", (Object)prItemId);
            entryArray.put((Object)entryObject);
        }
        jsonObject.put("items", (Object)entryArray);
        return jsonObject.toString();
    }

    public static String buildProductDesc(PurRequestEntryInfo entry) {
        StringBuilder desc = new StringBuilder();
        if (entry.getNoNumMaterialModel() != null) {
            desc.append("\u89c4\u683c\u578b\u53f7\uff1a" + entry.getNoNumMaterialModel()).append("\r\n");
        }
        if (entry.getAssistProperty() != null) {
            if (entry.getMaterial() != null) {
                desc.append(entry.getMaterial().getAssistAttr().getName() + "\uff1a" + entry.getAssistProperty().getName()).append("\r\n");
            } else {
                desc.append("\u8f85\u52a9\u5c5e\u6027\uff1a" + entry.getAssistProperty().getName()).append("\r\n");
            }
        }
        if (entry.getRemark() != null) {
            desc.append("\u5907\u6ce8\u8bf4\u660e\uff1a" + entry.getRemark());
        }
        return desc.toString();
    }

    public static void openPur100(String sendJson) throws BOSException, EASBizException, MalformedURLException, IOException, ProtocolException, UnsupportedEncodingException {
        String config = PurCloudServiceFactory.getRemoteInstance().getPurCloudConfigInfo();
        if (config == null || config.split("&")[0].split("=").length == 1) {
            MsgBox.showInfo((String)"\u83b7\u53d6\u91c7\u8d2d\u7535\u5546\u914d\u7f6e\u5931\u8d25");
            return;
        }
        String enterpriseID = config.split("&")[0].split("=")[1];
        String host = config.split("&")[1].split("=")[1];
        String port = config.split("&")[2].split("=")[1];
        URL url = new URL("http://" + host + ":" + port + "/purchase/platform/loginHelp");
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestProperty("accept", "*/*");
        con.setRequestProperty("connection", "Keep-Alive");
        con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setRequestMethod("POST");
        PrintWriter out = new PrintWriter(new OutputStreamWriter(con.getOutputStream(), "utf-8"));
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        StringBuffer str = new StringBuffer();
        str.append("userName=").append(user.getName());
        str.append("&userNumber=").append(user.getNumber());
        String userId = user.getId().toString().replace("+", "!");
        str.append("&userID=").append(userId);
        str.append("&enterpriseID=").append(enterpriseID);
        str.append("&sendJson=").append(sendJson);
        out.write(str.toString());
        out.flush();
        out.close();
        if (con.getResponseCode() == 200) {
            InputStream is = con.getInputStream();
            byte[] b = new byte[is.available()];
            is.read(b);
            System.out.println(new String(b, "utf-8"));
            System.out.println("------");
        }
        String session_value = con.getHeaderField("Set-Cookie");
        String[] values = session_value.split(";");
        String sessionId = values[0].substring(values[0].lastIndexOf("="), values[0].length());
        String reqCode = "PUR110";
        StringBuffer urlGet = new StringBuffer("http://" + host + ":" + port + "/purchase/platform/loginHelp?id");
        urlGet.append(sessionId).append("&reqCode=").append(reqCode);
        PurCloudHelper.openURL4Get(urlGet.toString());
    }

    public static boolean openURL4Get(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser != null) {
                    Runtime.getRuntime().exec(new String[]{browser, url});
                }
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static void openPur1004Ali(Map param) throws BOSException, EASBizException, MalformedURLException, IOException, ProtocolException, UnsupportedEncodingException {
        String config = PurCloudServiceFactory.getRemoteInstance().getPurCloudConfigInfo();
        if (config == null || config.split("&")[0].split("=").length == 1) {
            MsgBox.showInfo((String)"\u83b7\u53d6\u91c7\u8d2d\u7535\u5546\u914d\u7f6e\u5931\u8d25");
            return;
        }
        String enterpriseID = config.split("&")[0].split("=")[1];
        String host = config.split("&")[1].split("=")[1];
        String port = config.split("&")[2].split("=")[1];
        URL url = new URL("http://" + host + ":" + port + "/purchase/platform/loginHelp2");
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestProperty("accept", "*/*");
        con.setRequestProperty("connection", "Keep-Alive");
        con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setRequestMethod("POST");
        PrintWriter out = new PrintWriter(new OutputStreamWriter(con.getOutputStream(), "utf-8"));
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        StringBuffer str = new StringBuffer();
        str.append("userName=").append(user.getName());
        str.append("&userNumber=").append(user.getNumber());
        String userId = user.getId().toString().replace("+", "!");
        str.append("&userID=").append(userId);
        str.append("&enterpriseID=").append(enterpriseID);
        str.append("&companyid=").append(param.get("CompanyId"));
        str.append("&ParamJson=").append(param.get("Params"));
        str.append("&targetUrl=").append(param.get("TargetUrl"));
        out.write(str.toString());
        out.flush();
        out.close();
        if (con.getResponseCode() == 200) {
            InputStream is = con.getInputStream();
            byte[] b = new byte[is.available()];
            is.read(b);
            System.out.println(new String(b, "utf-8"));
            System.out.println("------");
        }
        String session_value = con.getHeaderField("Set-Cookie");
        String[] values = session_value.split(";");
        String sessionId = values[0].substring(values[0].lastIndexOf("="), values[0].length());
        String reqCode = "PUR110";
        StringBuffer urlGet = new StringBuffer("http://" + host + ":" + port + "/purchase/platform/loginHelp?id");
        urlGet.append(sessionId).append("&reqCode=").append(reqCode);
        PurCloudHelper.openURL4Get(urlGet.toString());
    }

    public static void jdprocess(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws EASBizException, BOSException {
        if (batchAction.equals((Object)BatchActionEnum.AUDIT)) {
            String[] ids = batchResults.getToDoIdsArray();
            if (ids == null || ids.length == 0) {
                return;
            }
            PurB2BFacadeFactory.getLocalInstance(ctx).confirmJDOrder(ids);
        }
    }

    public static String saveForNet(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurOrderInfo info = (PurOrderInfo)model;
        PurEntryDataVO scmEntryDataVO = new PurEntryDataVO();
        ISCMGroupFacade scmGroupFacade = SCMGroupFacadeFactory.getLocalInstance((Context)ctx);
        scmEntryDataVO = PurCloudHelper.getEntryDataVO(ctx, scmGroupFacade, info, scmEntryDataVO);
        PurCloudHelper.reCalcAmount(ctx, info, (SCMEntryDataVO)scmEntryDataVO, scmEntryDataVO.getBaseCurrencyInfo(), null);
        IObjectPK pk = PurOrderFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)info);
        return pk.toString();
    }

    private static PurEntryDataVO getEntryDataVO(Context ctx, ISCMGroupFacade scmGroupFacade, PurOrderInfo info, PurEntryDataVO scmEntryDataVO) throws BOSException, EASBizException {
        scmEntryDataVO.setMainOrg((OrgUnitInfo)info.getPurchaseOrgUnit());
        scmEntryDataVO.setMainOrgType(OrgType.Purchase);
        scmEntryDataVO = (PurEntryDataVO)PurCloudHelper.loadScmEntryBizDate(scmGroupFacade, info, (SCMEntryDataVO)scmEntryDataVO);
        return scmEntryDataVO;
    }

    protected static SCMEntryDataVO loadScmEntryBizDate(ISCMGroupFacade scmGroupFacade, PurOrderInfo info, SCMEntryDataVO purEntryDataVO) throws BOSException, EASBizException {
        int m = info.getEntries().size();
        MaterialInfo[] materialInfos = new MaterialInfo[m];
        MeasureUnitInfo[] unitInfos = new MeasureUnitInfo[m];
        MeasureUnitInfo[] baseUnitInfos = new MeasureUnitInfo[m];
        MeasureUnitInfo[] assistUnitInfos = new MeasureUnitInfo[m];
        for (int k = 0; k < m; ++k) {
            SCMBillEntryBaseInfo entryInfo = (SCMBillEntryBaseInfo)info.getEntries().getObject(k);
            MeasureUnitInfo unitInfo = entryInfo.getUnit();
            MaterialInfo materialInfo = entryInfo.getMaterial();
            MeasureUnitInfo baseunitInfo = entryInfo.getBaseUnit();
            MeasureUnitInfo assistUnitInfo = entryInfo.getAssistUnit();
            if (materialInfo != null) {
                materialInfos[k] = materialInfo;
            }
            if (materialInfo != null && unitInfo != null) {
                unitInfos[k] = unitInfo;
            }
            if (materialInfo != null && baseunitInfo != null) {
                baseUnitInfos[k] = baseunitInfo;
            }
            if (materialInfo == null || assistUnitInfo == null) continue;
            assistUnitInfos[k] = assistUnitInfo;
        }
        purEntryDataVO.setIsLoadingCurrency(true);
        purEntryDataVO.setIsLoadingMou(true);
        purEntryDataVO.setIsLoadingMmuPrecision(true);
        purEntryDataVO.setMaterialInfos(materialInfos);
        purEntryDataVO.setMeasureUnitInfos(unitInfos);
        purEntryDataVO.setBaseMeasureUnitInfos(baseUnitInfos);
        purEntryDataVO.setAssistMeasureUnitInfos(assistUnitInfos);
        purEntryDataVO = scmGroupFacade.loadComplexData(purEntryDataVO);
        return purEntryDataVO;
    }

    protected static void reCalcAmount(Context ctx, PurOrderInfo info, SCMEntryDataVO vo, CurrencyInfo baseCurrencyInfo, Map ParametersMap) throws BOSException, EASBizException {
        BigDecimal ZERO = SysConstant.BIGZERO;
        BigDecimal HUNDRED = SCMConstant.BIGDECIMAL_ONEHUNDRED;
        CurrencyInfo currencyInfo = null;
        currencyInfo = info.getCurrency() != null ? info.getCurrency() : baseCurrencyInfo;
        BigDecimal exchangeRate = info.getExchangeRate();
        ExchangeAuxInfo exchangeAuxInfo = vo.getExchangeAuxInfo();
        boolean isContainsTax = info.isIsInTax();
        if (baseCurrencyInfo == null) {
            baseCurrencyInfo = currencyInfo;
        }
        int localScale = baseCurrencyInfo.getPrecision();
        int scale = currencyInfo.getPrecision();
        BigDecimal totalAmount = ZERO;
        BigDecimal totalTax = ZERO;
        BigDecimal totalTaxAmount = ZERO;
        PurOrderEntryCollection collection = info.getEntries();
        PurOrderEntryInfo entryInfo = null;
        MaterialInfo materialInfo = null;
        int m = collection.size();
        for (int j = 0; j < m; ++j) {
            entryInfo = collection.get(j);
            materialInfo = entryInfo.getMaterial();
            int priceScale = 0;
            priceScale = materialInfo == null ? 4 : materialInfo.getPricePrecision();
            BigDecimal qty = SCMUtils.effectualNumeric((BigDecimal)entryInfo.getQty());
            BigDecimal price = SCMUtils.effectualNumeric((BigDecimal)entryInfo.getPrice());
            BigDecimal taxRate = SCMUtils.effectualNumeric((BigDecimal)entryInfo.getTaxRate());
            BigDecimal taxPrice = SCMUtils.effectualNumeric((BigDecimal)entryInfo.getTaxPrice());
            DiscountModeEnum discountMode = DiscountModeEnum.PERCENT;
            BigDecimal discount = SCMUtils.effectualNumeric((BigDecimal)entryInfo.getDiscountRate());
            BigDecimal actualPrice = ZERO;
            BigDecimal amount = ZERO;
            BigDecimal tax = ZERO;
            BigDecimal taxAmount = ZERO;
            BigDecimal discountAmount = ZERO;
            BigDecimal localAmount = ZERO;
            BigDecimal localTax = ZERO;
            BigDecimal localTaxAmount = ZERO;
            if (isContainsTax) {
                BigDecimal actualTaxPrice2 = CalculateUtils.calActualTaxPrice((DiscountModeEnum)discountMode, (BigDecimal)taxPrice, (BigDecimal)discount, (int)10);
                taxAmount = CalculateUtils.calAmount((BigDecimal)qty, (BigDecimal)actualTaxPrice2, (int)scale);
                tax = taxAmount.multiply(taxRate).divide(HUNDRED.add(taxRate), scale, 4);
                amount = taxAmount.subtract(tax);
                discountAmount = CalculateUtils.calDiscountAmountByTaxAmount((BigDecimal)taxPrice, (BigDecimal)qty, (BigDecimal)taxAmount, (int)scale);
                if (qty.compareTo(ZERO) != 0) {
                    actualPrice = amount.divide(qty, priceScale, 4);
                }
            } else {
                BigDecimal actualPrice2 = CalculateUtils.calActualTaxPrice((DiscountModeEnum)discountMode, (BigDecimal)price, (BigDecimal)discount, (int)10);
                amount = CalculateUtils.calAmount((BigDecimal)qty, (BigDecimal)actualPrice2, (int)scale);
                tax = CalculateUtils.calTax((BigDecimal)amount, (BigDecimal)taxRate, (int)scale);
                taxAmount = CalculateUtils.calTotalTaxAmount((BigDecimal)amount, (BigDecimal)tax, (int)scale);
                discountAmount = CalculateUtils.calDiscountAmount((DiscountModeEnum)discountMode, (BigDecimal)discount, (BigDecimal)qty, (BigDecimal)taxPrice, (BigDecimal)taxRate, (int)scale, (boolean)isContainsTax);
                actualPrice = actualPrice2.setScale(priceScale, 4);
            }
            localAmount = CalculateUtils.calcByExchangeRate((ExchangeAuxInfo)exchangeAuxInfo, (BigDecimal)exchangeRate, (BigDecimal)amount, (int)localScale);
            localTax = CalculateUtils.calcByExchangeRate((ExchangeAuxInfo)exchangeAuxInfo, (BigDecimal)exchangeRate, (BigDecimal)tax, (int)localScale);
            localTaxAmount = CalculateUtils.calcByExchangeRate((ExchangeAuxInfo)exchangeAuxInfo, (BigDecimal)exchangeRate, (BigDecimal)taxAmount, (int)localScale);
            totalAmount = totalAmount.add(amount);
            totalTax = totalTax.add(tax);
            totalTaxAmount = totalTaxAmount.add(taxAmount);
            entryInfo.setAmount(amount);
            entryInfo.setTax(tax);
            entryInfo.setTaxAmount(taxAmount);
            entryInfo.setDiscountAmount(discountAmount);
            entryInfo.setActualPrice(actualPrice);
            entryInfo.setUnOrderedQty(qty);
            if (PurCloudHelper.isBotpBill((SCMBillBaseInfo)info, "510b6503-0105-1000-e000-0113c0a812fd463ED552")) {
                entryInfo.setCurSeOrderQty(qty);
            }
            entryInfo.setLocalAmount(localAmount);
            entryInfo.setLocalTax(localTax);
            entryInfo.setLocalTaxAmount(localTaxAmount);
        }
        info.setTotalAmount(totalAmount);
        info.setTotalTax(totalTax);
        info.setTotalTaxAmount(totalTaxAmount);
        PurCloudHelper.calPrepayment(info);
    }

    public static void calPrepayment(PurOrderInfo info) {
        PurOrderEntryInfo poe = null;
        BigDecimal prepaymentRate = info.getPrepaymentRate();
        prepaymentRate = prepaymentRate == null ? SCMConstant.BIGDECIMAL_ZERO : prepaymentRate;
        BigDecimal taxAmount = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal prepayment = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal preReceived = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal unPreReceived = SCMConstant.BIGDECIMAL_ZERO;
        CurrencyInfo currencyInfo = null;
        if (info.getCurrency() != null) {
            currencyInfo = info.getCurrency();
        }
        int scale = 0;
        if (currencyInfo != null) {
            scale = currencyInfo.getPrecision();
        }
        BigDecimal HUNDRED = new BigDecimal("100.00");
        for (int i = 0; i < info.getEntries().size(); ++i) {
            poe = info.getEntries().get(i);
            taxAmount = poe.getTaxAmount();
            taxAmount = taxAmount == null ? SCMConstant.BIGDECIMAL_ZERO : taxAmount;
            prepayment = taxAmount.multiply(prepaymentRate).divide(HUNDRED, scale, 4);
            preReceived = poe.getPreReceived();
            preReceived = preReceived == null ? SCMConstant.BIGDECIMAL_ZERO : preReceived;
            unPreReceived = prepayment.subtract(preReceived);
            poe.setPrepayment(prepayment);
            poe.setUnPrereceivedAm(unPreReceived);
            if (poe.getTotalReqPayAmt() == null) {
                poe.setTotalReqPayAmt(SCMConstant.BIGDECIMAL_ZERO);
            }
            if (poe.getTotalPrePayAmt() == null) {
                poe.setTotalPrePayAmt(SCMConstant.BIGDECIMAL_ZERO);
            }
            poe.setIsReqPrePayGTprePay(1);
        }
        prepayment = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal entryPrepayment = SCMConstant.BIGDECIMAL_ZERO;
        for (int i = 0; i < info.getEntries().size(); ++i) {
            poe = info.getEntries().get(i);
            entryPrepayment = poe.getPrepayment();
            if (entryPrepayment == null) continue;
            prepayment = prepayment.add(entryPrepayment);
        }
        info.setPrepayment(prepayment);
    }

    public static boolean isBotpBill(SCMBillBaseInfo scmBillBaseInfo) {
        boolean isBotpBill = false;
        if (scmBillBaseInfo != null && scmBillBaseInfo.getSourceBillType() != null) {
            isBotpBill = true;
        }
        return isBotpBill;
    }

    public static boolean isBotpBill(SCMBillBaseInfo scmBillBaseInfo, String sourceBillTypeID) {
        boolean isBotpBill = false;
        if (PurCloudHelper.isBotpBill(scmBillBaseInfo) && scmBillBaseInfo.getSourceBillType().getId().toString().equals(sourceBillTypeID)) {
            isBotpBill = true;
        }
        return isBotpBill;
    }
}

