/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.messageCenter.pushletClient;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.messageCenter.IClientManager;
import com.kingdee.messageCenter.IMessageDAO;
import com.kingdee.messageCenter.Message;
import com.kingdee.messageCenter.MessageException;
import com.kingdee.messageCenter.common.ObjectFactory;
import com.kingdee.messageCenter.pushletClient.DCConfig;
import com.kingdee.messageCenter.utils.GsonUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MessageDAO
implements IMessageDAO {
    private static final Logger logger = Logger.getLogger(MessageDAO.class);
    private static final String ACTIVE_TABLE_NAME = "T_B2B_MessageActive";
    private static final String HISTORY_TABLE_NAME = "T_B2B_MessageHistory";

    private IClientManager getClientManager() {
        return ObjectFactory.getInstance().getClientManager();
    }

    private Message mapRow(IRowSet rs) throws SQLException {
        Message m = new Message();
        m.setId(rs.getString("FID"));
        m.setEnterpriseId(rs.getString("FEnterpriseId"));
        m.setSubject(rs.getString("FSubject"));
        m.setDirector(rs.getInt("FDirector"));
        Map body = (Map)GsonUtils.fromJson((String)rs.getString("FBody"), HashMap.class);
        m.setBody(body);
        m.setLastUpdatetime(rs.getDate("FLastUpdatetime"));
        m.setStatus(10);
        return m;
    }

    private String getTableName(boolean isActive) {
        return isActive ? ACTIVE_TABLE_NAME : HISTORY_TABLE_NAME;
    }

    public List<Message> getUnPushedMessage(String enterpriseId) throws MessageException {
        String sql = "select FID,FEnterpriseId,FSubject,FBody,FLastUpdatetime,FDirector  from  T_B2B_MessageActive where FEnterpriseId = ? and FDirector = ? ";
        Object[] args = new Object[]{enterpriseId, 10};
        Context ctx = DCConfig.getContext();
        IRowSet rs = null;
        ArrayList<Message> msgList = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])args);
            msgList = new ArrayList<Message>();
            while (rs.next()) {
                msgList.add(this.mapRow(rs));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new MessageException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new MessageException((Throwable)e);
        }
        return msgList;
    }

    public List<Message> getUnProcessedMessage() throws MessageException {
        String sql = "select FID,FEnterpriseId,FSubject,FBody,FLastUpdatetime,FDirector  from  T_B2B_MessageActive where FDirector = ? ";
        Object[] args = new Object[]{0};
        Context ctx = DCConfig.getContext();
        IRowSet rs = null;
        ArrayList<Message> msgList = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])args);
            msgList = new ArrayList<Message>();
            while (rs.next()) {
                msgList.add(this.mapRow(rs));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new MessageException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new MessageException((Throwable)e);
        }
        return msgList;
    }

    public void save(boolean isActive, Message message) throws MessageException {
        if (message.getEnterpriseId() == null) {
            message.setEnterpriseId(this.getClientManager().getClientId());
        }
        String sql = "insert into " + this.getTableName(isActive) + " (FID,FEnterpriseId,FSubject,FBody,FLastUpdatetime,FDirector) " + " values (?,?,?,?,?,?)";
        String body = GsonUtils.toJson((Object)message.getBody());
        Context ctx = DCConfig.getContext();
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{message.getId(), message.getEnterpriseId(), message.getSubject(), body, message.getLastUpdatetime(), message.getDirector()});
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new MessageException((Throwable)e);
        }
    }

    public void update(boolean isActive, Message message) throws MessageException {
        String sql = "update " + this.getTableName(isActive) + " SET FEnterpriseId = ?,FSubject = ?,FBody = ?," + "FLastUpdatetime = ?,FDirector = ? " + "WHERE FID = ?";
        String body = GsonUtils.toJson((Object)message.getBody());
        Context ctx = DCConfig.getContext();
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{message.getEnterpriseId(), message.getSubject(), body, message.getLastUpdatetime(), message.getDirector(), message.getId()});
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new MessageException((Throwable)e);
        }
    }

    public void delete(boolean isActive, String id) throws MessageException {
        String sql = "delete from " + this.getTableName(isActive) + " WHERE FID = ?";
        Context ctx = DCConfig.getContext();
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{id});
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new MessageException((Throwable)e);
        }
    }

    public Message getValue(boolean isActive, String id) throws MessageException {
        String sql = "select FID,FEnterpriseId,FSubject,FBody,FLastUpdatetime,FDirector  from  " + this.getTableName(isActive) + " where FID = ? ";
        Context ctx = DCConfig.getContext();
        Message message = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id});
            if (rs.next()) {
                message = this.mapRow(rs);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new MessageException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new MessageException((Throwable)e);
        }
        return message;
    }
}

