/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.autoupdate.util.StringUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.barcode.common.IGeneCoreTreeBaseCollection;
import com.kingdee.eas.barcode.common.IGeneCoreTreeBaseInfo;
import com.kingdee.eas.barcode.common.app.util.GeneLongNumberGenerator;
import com.kingdee.eas.barcode.common.app.util.GeneSeverMetadataUtils;
import com.kingdee.eas.barcode.common.util.GeneSelectorUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.BaseTreeModel;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.app.ObjectBaseControllerBean;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.LocaleUtils;
import java.util.Locale;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class GeneCoreTreeBaseControllerBeanTools {
    private ObjectBaseControllerBean bean;
    private BOSObjectType bosType;
    private static final int startlevel = 1;
    public static Locale locale_L1 = LocaleUtils.getLocale((String)"L1");
    public static Locale locale_L2 = LocaleUtils.getLocale((String)"L2");
    public static Locale locale_L3 = LocaleUtils.getLocale((String)"L3");

    public ObjectBaseControllerBean getBean() {
        return this.bean;
    }

    public BOSObjectType getBosType() {
        return this.bosType;
    }

    public GeneCoreTreeBaseControllerBeanTools(ObjectBaseControllerBean bean, BOSObjectType bosType) {
        this.bean = bean;
        this.bosType = bosType;
    }

    public SelectorItemCollection getSelector(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        boolean notExistLongNumber = false;
        SelectorItemInfo info = null;
        for (int i = 0; i < selector.size(); ++i) {
            info = selector.get(i);
            if (!info.getPropertyName().equals("longNumber")) continue;
            notExistLongNumber = true;
        }
        if (notExistLongNumber) {
            info = new SelectorItemInfo("longNumber");
            selector.add(info);
        }
        return selector;
    }

    public void checkParentDataExist(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException, TreeBaseException {
        IGeneCoreTreeBaseInfo currentTreeBaseInfo = (IGeneCoreTreeBaseInfo)model;
        currentTreeBaseInfo = this.lazyLoad(ctx, currentTreeBaseInfo);
        boolean deleted = false;
        String longNumber = currentTreeBaseInfo.getLongNumber();
        if (longNumber.charAt("!".charAt(1)) < '\u0000') {
            return;
        }
        IGeneCoreTreeBaseInfo parent = this.getFullParent(ctx, currentTreeBaseInfo);
        if (parent == null) {
            throw new TreeBaseException(TreeBaseException.CHECKPARENTNOTNULL);
        }
        if (GeneSeverMetadataUtils.isExistPropertyName(ctx, (ObjectBaseInfo)parent, "deletedStatus") && currentTreeBaseInfo.getBoolean("deletedStatus")) {
            deleted = true;
        }
        if (deleted) {
            throw new TreeBaseException(TreeBaseException.CHECKPARENTDELETED, new Object[0]);
        }
    }

    public void checkParentValid(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException, TreeBaseException {
        IGeneCoreTreeBaseInfo IGeneCoreTreeBaseInfo2 = (IGeneCoreTreeBaseInfo)model;
        IGeneCoreTreeBaseInfo2 = this.lazyLoad(ctx, IGeneCoreTreeBaseInfo2);
        this.checkParentDataExist(ctx, pk, IGeneCoreTreeBaseInfo2);
        IGeneCoreTreeBaseInfo parent = this.getFullParent(ctx, IGeneCoreTreeBaseInfo2);
        if (GeneSeverMetadataUtils.isExistPropertyName(ctx, (ObjectBaseInfo)parent, "effectedStatus") && !parent.getBoolean("effectedStatus")) {
            throw new TreeBaseException(TreeBaseException.CHECKPARENTINVALIDED, new Object[0]);
        }
    }

    public void checkParentBeUsed(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException, TreeBaseException {
        this.getBean().isReferenced(ctx, pk);
    }

    public IObjectValue getRoot(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IGeneCoreTreeBaseInfo currentTreeBaseInfo = (IGeneCoreTreeBaseInfo)model;
        currentTreeBaseInfo = this.lazyLoad(ctx, currentTreeBaseInfo);
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("longNumber", (Object)currentTreeBaseInfo.getLongNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        CoreBaseCollection results = this.getBean().getCollection(ctx, ev);
        if (results != null && results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    public void deleteWithChildren(Context ctx, IObjectValue model) throws BOSException, EASBizException, TreeBaseException {
        if (model == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        IGeneCoreTreeBaseInfo currentTreeBaseInfo = (IGeneCoreTreeBaseInfo)model;
        currentTreeBaseInfo = this.lazyLoad(ctx, currentTreeBaseInfo);
        IGeneCoreTreeBaseCollection childrenCol = (IGeneCoreTreeBaseCollection)this.getAllChildren(ctx, currentTreeBaseInfo);
        for (int i = 0; i < childrenCol.size(); ++i) {
            this.getBean().delete(ctx, (IObjectPK)new ObjectUuidPK(childrenCol.get(i).getId()));
        }
        this.getBean().delete(ctx, (IObjectPK)new ObjectUuidPK(currentTreeBaseInfo.getId()));
        IGeneCoreTreeBaseInfo parent = this.getFullParent(ctx, currentTreeBaseInfo);
        if (parent != null) {
            this.resetLeafAndUpdateByChildRemoved(ctx, parent);
        }
    }

    public IObjectCollection getChildren(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        IGeneCoreTreeBaseInfo currentTreeBaseInfo = (IGeneCoreTreeBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)currentTreeBaseInfo.getId().toString(), CompareType.EQUALS));
        CoreBaseCollection col = this.getBean().getCollection(ctx, ev);
        for (int i = 0; i < col.size(); ++i) {
            ((IGeneCoreTreeBaseInfo)col.get(i)).innerSetParent(currentTreeBaseInfo);
        }
        return col;
    }

    public BaseTreeModel getTreeModel(Context ctx, IObjectValue node) throws BOSException, EASBizException {
        if (node == null) {
            throw new TreeBaseException(TreeBaseException.CHECKNODEISNULL);
        }
        IGeneCoreTreeBaseInfo rootObject = (IGeneCoreTreeBaseInfo)node;
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        BaseTreeModel treeModel = new BaseTreeModel((TreeNode)rootNode);
        rootNode.setUserObject(rootObject);
        this.buildChildrenTreeModel(ctx, rootObject, rootNode, treeModel);
        return treeModel;
    }

    private void buildChildrenTreeModel(Context ctx, IGeneCoreTreeBaseInfo parentObject, DefaultMutableTreeNode parentNode, BaseTreeModel treeModel) throws BOSException, EASBizException {
        IGeneCoreTreeBaseCollection childrenObject = (IGeneCoreTreeBaseCollection)this.getChildren(ctx, parentObject);
        for (int i = 0; i < childrenObject.size(); ++i) {
            IGeneCoreTreeBaseInfo childInfo = childrenObject.get(i);
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode();
            childNode.setUserObject(childInfo);
            treeModel.insertNodeInto((MutableTreeNode)childNode, (MutableTreeNode)parentNode, i);
            this.buildChildrenTreeModel(ctx, childInfo, childNode, treeModel);
        }
    }

    public IObjectValue getValueWithParent(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        IGeneCoreTreeBaseInfo info = (IGeneCoreTreeBaseInfo)this.getBean().getValue(ctx, pk);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("parent"));
        IGeneCoreTreeBaseInfo infoWithParent = (IGeneCoreTreeBaseInfo)this.getBean().getValue(ctx, pk, selector);
        info.innerSetParent(infoWithParent.innerGetParent());
        return info;
    }

    public IObjectCollection getAllChildren(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IGeneCoreTreeBaseInfo currentTreeBaseInfo = (IGeneCoreTreeBaseInfo)model;
        if (currentTreeBaseInfo == null) {
            EntityViewInfo ev = new EntityViewInfo();
            ev.setFilter(new FilterInfo());
            ev.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)"%", CompareType.LIKE));
            FilterInfo filterCU = this.getFilterForDefaultCU(ctx, currentTreeBaseInfo);
            if (filterCU != null && FilterUtility.hasFilterItem((FilterInfo)filterCU)) {
                ev.getFilter().mergeFilter(filterCU, "AND");
            }
            CoreBaseCollection col = this.getBean().getCollection(ctx, ev);
            return col;
        }
        currentTreeBaseInfo = this.lazyLoad(ctx, currentTreeBaseInfo);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(new FilterInfo());
        ev.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(currentTreeBaseInfo.getLongNumber() + "!" + "%"), CompareType.LIKE));
        SorterItemCollection sic = new SorterItemCollection();
        sic.add(new SorterItemInfo("longNumber"));
        ev.setSorter(sic);
        CoreBaseCollection col = this.getBean().getCollection(ctx, ev);
        return col;
    }

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IGeneCoreTreeBaseInfo treeModel = (IGeneCoreTreeBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        if (treeModel.innerGetParent() == null) {
            filterItem = new FilterItemInfo("number", (Object)treeModel.getNumber(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            filter.getFilterItems().add(new FilterItemInfo("parent", null, CompareType.EQUALS));
            filter.setMaskString("#0 and #1");
            if (treeModel.getId() != null) {
                filterItem = new FilterItemInfo("id", (Object)treeModel.getId().toString(), CompareType.NOTEQUALS);
                filter.getFilterItems().add(filterItem);
                filter.setMaskString("#0 and #1 and #2");
            }
        } else {
            filterItem = new FilterItemInfo("number", (Object)treeModel.getNumber(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            if (treeModel.innerGetParent().getId() != null) {
                filterItem = new FilterItemInfo("parent", (Object)treeModel.innerGetParent().getId().toString(), CompareType.EQUALS);
                filter.getFilterItems().add(filterItem);
                filter.setMaskString("#0 and #1");
            }
            if (treeModel.getId() != null) {
                filterItem = new FilterItemInfo("id", (Object)treeModel.getId().toString(), CompareType.NOTEQUALS);
                filter.getFilterItems().add(filterItem);
                if (treeModel.innerGetParent().getId() != null) {
                    filter.setMaskString("#0 and #1 and #2");
                } else {
                    filter.setMaskString("#0 and #1");
                }
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, treeModel);
        if (FilterUtility.hasFilterItem((FilterInfo)filterCU)) {
            if (FilterUtility.hasFilterItem((FilterInfo)filter)) {
                filter.mergeFilter(filterCU, "AND");
            } else {
                filter = filterCU;
            }
        }
        view.setFilter(filter);
        CoreBaseCollection results = this.getBean().getCollection(ctx, view);
        if (results != null && results.size() > 0) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{treeModel.getNumber()});
        }
    }

    private int getLongNumberLen(Context ctx, IGeneCoreTreeBaseInfo info) throws EASBizException, BOSException {
        return 255;
    }

    private void checkLongNumberLen(Context ctx, IGeneCoreTreeBaseInfo info) throws EASBizException, BOSException {
        String propertyAlias = null;
        int maxLen = 0;
        propertyAlias = GeneSeverMetadataUtils.getPropertyAlias(ctx, (ObjectBaseInfo)info, "longNumber", ctx.getLocale(), this.getBosType());
        int len = null == info.getLongNumber() ? -1 : info.getLongNumber().getBytes().length;
        if (len > (maxLen = this.getLongNumberLen(ctx, info))) {
            throw new TreeBaseException(TreeBaseException.CHECKLONGNUMBERLEN, new Object[]{propertyAlias, String.valueOf(maxLen)});
        }
    }

    private void LinkDisplayName(IGeneCoreTreeBaseInfo parent, IGeneCoreTreeBaseInfo info, Locale locale) {
        String disPlayName = null;
        String parentDisplayName = parent.getDisplayName(locale);
        disPlayName = parentDisplayName != null ? parentDisplayName + "_" + info.getName(locale) : info.getName(locale);
        info.setDisplayName(disPlayName, locale);
    }

    public IObjectValue updateTreePropertiesOnAddNew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        IGeneCoreTreeBaseInfo currentTreeBaseInfo = (IGeneCoreTreeBaseInfo)model;
        this.checkNumberDup(ctx, currentTreeBaseInfo);
        currentTreeBaseInfo.setIsLeaf(true);
        IGeneCoreTreeBaseInfo parent = this.getFullParent(ctx, currentTreeBaseInfo);
        if (parent == null || parent.getId().equals((Object)currentTreeBaseInfo.getId())) {
            currentTreeBaseInfo.setLevel(1);
            currentTreeBaseInfo.setLongNumber(GeneLongNumberGenerator.genLongNumber(ctx, (CoreBaseInfo)currentTreeBaseInfo, this.getBosType()));
            this.checkLongNumberLen(ctx, currentTreeBaseInfo);
        } else {
            currentTreeBaseInfo.setLevel(parent.getLevel() + 1);
            currentTreeBaseInfo.setLongNumber(GeneLongNumberGenerator.genLongNumber(ctx, (CoreBaseInfo)parent, this.getBosType()));
            this.checkLongNumberLen(ctx, currentTreeBaseInfo);
            if (parent.isIsLeaf()) {
                parent.setIsLeaf(false);
                this.getBean().update(ctx, (IObjectPK)new ObjectUuidPK(parent.getId()), (CoreBaseInfo)parent);
            }
        }
        return currentTreeBaseInfo;
    }

    public IObjectValue updateTreePropertiesOnAddNew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        IGeneCoreTreeBaseInfo geneCoreTreeBaseInfo = (IGeneCoreTreeBaseInfo)model;
        IGeneCoreTreeBaseInfo parent = this.getFullParent(ctx, geneCoreTreeBaseInfo);
        geneCoreTreeBaseInfo.setIsLeaf(true);
        if (parent == null || parent.getId().equals((Object)geneCoreTreeBaseInfo.getId())) {
            geneCoreTreeBaseInfo.setLevel(1);
            geneCoreTreeBaseInfo.setLongNumber(GeneLongNumberGenerator.genLongNumber(ctx, null, this.getBosType()));
            this.checkLongNumberLen(ctx, geneCoreTreeBaseInfo);
        } else {
            geneCoreTreeBaseInfo.setLevel(parent.getLevel() + 1);
            geneCoreTreeBaseInfo.setLongNumber(GeneLongNumberGenerator.genLongNumber(ctx, (CoreBaseInfo)parent, this.getBosType()));
            this.checkLongNumberLen(ctx, geneCoreTreeBaseInfo);
            if (parent.isIsLeaf()) {
                parent.setIsLeaf(false);
                this.getBean().update(ctx, (IObjectPK)new ObjectUuidPK(parent.getId()), (CoreBaseInfo)parent);
            }
        }
        return geneCoreTreeBaseInfo;
    }

    public void checkDelete(Context ctx, IGeneCoreTreeBaseInfo info) throws BOSException, EASBizException {
        if (info == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        if (!info.isIsLeaf()) {
            throw new TreeBaseException(TreeBaseException.CHECKHAVECHILDREN, new Object[]{info.getNumber()});
        }
    }

    public void afterDelete(Context ctx, IGeneCoreTreeBaseInfo info) throws BOSException, EASBizException, TreeBaseException {
        IGeneCoreTreeBaseInfo parent = this.getFullParent(ctx, info);
        if (parent != null) {
            this.resetLeafAndUpdateByChildRemoved(ctx, parent);
        }
    }

    public IObjectValue updateTreePropertyOnUpdate(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        IGeneCoreTreeBaseInfo currentTreeBaseInfo = (IGeneCoreTreeBaseInfo)model;
        return currentTreeBaseInfo;
    }

    private void resetLeafAndUpdateByChildRemoved(Context ctx, IObjectValue model) throws BOSException, EASBizException, TreeBaseException {
        if (model == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        IGeneCoreTreeBaseInfo geneCoreTreeBaseInfo = (IGeneCoreTreeBaseInfo)model;
        int childCount = this.getChildren(ctx, geneCoreTreeBaseInfo).size();
        if (childCount == 0) {
            geneCoreTreeBaseInfo.setIsLeaf(true);
            this.getBean().update(ctx, (IObjectPK)new ObjectUuidPK(geneCoreTreeBaseInfo.getId()), (CoreBaseInfo)geneCoreTreeBaseInfo);
        }
    }

    private IGeneCoreTreeBaseInfo getFullParent(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IGeneCoreTreeBaseInfo currentTreeBaseInfo = (IGeneCoreTreeBaseInfo)model;
        IGeneCoreTreeBaseInfo parent = currentTreeBaseInfo.innerGetParent();
        if (parent == null || parent.getId().equals((Object)currentTreeBaseInfo.getId())) {
            return null;
        }
        parent = this.lazyLoad(ctx, parent);
        currentTreeBaseInfo.innerSetParent(parent);
        return parent;
    }

    private IGeneCoreTreeBaseInfo lazyLoad(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IGeneCoreTreeBaseInfo IGeneCoreTreeBaseInfo2 = (IGeneCoreTreeBaseInfo)model;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("CU.id"));
        selector.add(new SelectorItemInfo("longNumber"));
        selector.add(new SelectorItemInfo("parent"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("level"));
        selector.add(new SelectorItemInfo("isLeaf"));
        selector.add(new SelectorItemInfo("displayName"));
        selector.add(new SelectorItemInfo("deletedStatus"));
        GeneSelectorUtils.addSelectorWithIDAndNumberAndName(selector, IGeneCoreTreeBaseInfo2.getBizOrgPropertyName());
        IGeneCoreTreeBaseInfo result = (IGeneCoreTreeBaseInfo)this.getBean().getValue(ctx, (IObjectPK)new ObjectUuidPK(IGeneCoreTreeBaseInfo2.getId()), selector);
        return result;
    }

    public IObjectCollection getAllChildren(Context ctx, IObjectValue model, EntityViewInfo view) throws BOSException, EASBizException {
        IGeneCoreTreeBaseInfo geneCoreTreeBaseInfo = (IGeneCoreTreeBaseInfo)model;
        if (geneCoreTreeBaseInfo == null) {
            EntityViewInfo ev = view;
            if (view.getFilter() == null || view.getFilter().size() == 0) {
                ev.setFilter(new FilterInfo());
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)"%", CompareType.LIKE));
            if (FilterUtility.hasFilterItem((FilterInfo)ev.getFilter())) {
                ev.getFilter().mergeFilter(filter, "AND");
            } else {
                ev.setFilter(filter);
            }
            FilterInfo filterCU = this.getFilterForDefaultCU(ctx, geneCoreTreeBaseInfo);
            if (filterCU != null && FilterUtility.hasFilterItem((FilterInfo)filterCU)) {
                ev.getFilter().mergeFilter(filterCU, "AND");
            }
            CoreBaseCollection col = this.getBean().getCollection(ctx, view);
            return col;
        }
        geneCoreTreeBaseInfo = this.lazyLoad(ctx, geneCoreTreeBaseInfo);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(new FilterInfo());
        ev.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(geneCoreTreeBaseInfo.getLongNumber() + "!" + "%"), CompareType.LIKE));
        if (FilterUtility.hasFilterItem((FilterInfo)view.getFilter())) {
            ev.getFilter().mergeFilter(view.getFilter(), "AND");
        }
        if (view != null && view.getSelector() != null) {
            ev.getSelector().addObjectCollection((IObjectCollection)view.getSelector());
        }
        CoreBaseCollection col = this.getBean().getCollection(ctx, ev);
        return col;
    }

    private void limitDisplayNameLength(IGeneCoreTreeBaseInfo tree) {
        String displayName = tree.getDisplayName();
        String[] displayNameVar = StringUtil.split((String)displayName, (String)"_");
        if (displayNameVar == null) {
            return;
        }
        if (displayNameVar.length > 1 && displayName.length() > 80) {
            int len = displayName.indexOf("_");
            displayName = displayName.substring(len + 1);
            tree.setDisplayName(displayName);
            this.limitDisplayNameLength(tree);
        }
    }

    private void limitDisplayNameLength(IGeneCoreTreeBaseInfo tree, Locale locale) {
        String displayName = tree.getDisplayName(locale);
        String[] displayNameVar = StringUtil.split((String)displayName, (String)"_");
        if (displayNameVar == null) {
            return;
        }
        if (displayNameVar.length > 1 && displayName.length() > 80) {
            int len = displayName.indexOf("_");
            displayName = displayName.substring(len + 1);
            tree.setDisplayName(displayName, locale);
            this.limitDisplayNameLength(tree, locale);
        }
    }

    protected String _getFullDisplayName(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String fullDisplayName = "";
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("displayName"));
        IGeneCoreTreeBaseInfo tree = (IGeneCoreTreeBaseInfo)this.getBean().getValue(ctx, pk, selector);
        fullDisplayName = tree.getDisplayName();
        return fullDisplayName;
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        IGeneCoreTreeBaseInfo info = (IGeneCoreTreeBaseInfo)model;
        if (info == null) {
            return null;
        }
        if (info.getCU() == null) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)this.getCU(ctx, info).getId().toString(), CompareType.EQUALS));
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)info.getCU().getId().toString(), CompareType.EQUALS));
        return filter;
    }

    protected CtrlUnitInfo getCU(Context ctx, IGeneCoreTreeBaseInfo model) {
        CtrlUnitInfo cu = null;
        if (model.getCU() != null) {
            return model.getCU();
        }
        cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        return cu;
    }

    public void moveTreeNode(Context ctx, IObjectValue sourceNode, IObjectValue targetNode) throws EASBizException, BOSException {
        IGeneCoreTreeBaseInfo sourceTreeValue = (IGeneCoreTreeBaseInfo)sourceNode;
        IGeneCoreTreeBaseInfo targetTreeValue = (IGeneCoreTreeBaseInfo)targetNode;
        ObjectUuidPK sourceTreePK = new ObjectUuidPK(((IGeneCoreTreeBaseInfo)sourceNode).getId());
        ObjectUuidPK targetTreePK = null;
        if (sourceTreeValue.get("AllInfo") == null) {
            sourceTreeValue = (IGeneCoreTreeBaseInfo)this.getBean().getValue(ctx, (IObjectPK)sourceTreePK);
        }
        IObjectCollection srcChildren = this.getAllChildren(ctx, sourceNode);
        if (targetNode == null) {
            targetTreeValue = null;
        } else {
            targetTreePK = new ObjectUuidPK(((IGeneCoreTreeBaseInfo)targetNode).getId());
            targetTreeValue = (IGeneCoreTreeBaseInfo)this.getBean().getValue(ctx, (IObjectPK)targetTreePK);
        }
        if (sourceTreeValue.getLevel() > 1 && sourceTreeValue.get("parent") != null) {
            ObjectUuidPK parentPK = new ObjectUuidPK(((IGeneCoreTreeBaseInfo)sourceTreeValue.get("parent")).getId());
            IGeneCoreTreeBaseInfo parent = (IGeneCoreTreeBaseInfo)this.getBean().getValue(ctx, (IObjectPK)parentPK);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent", (Object)parent.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sourceTreeValue.getId().toString(), CompareType.NOTEQUALS));
            if (!this.getBean().exists(ctx, filter)) {
                parent.setIsLeaf(true);
                this.getBean().update(ctx, (IObjectPK)parentPK, (CoreBaseInfo)parent);
            }
        }
        sourceTreeValue.innerSetParent(targetTreeValue);
        String newLongNumber = GeneLongNumberGenerator.genLongNumber(ctx, targetTreeValue == null ? null : (CoreBaseInfo)targetTreeValue, this.getBosType());
        sourceTreeValue.setLongNumber(newLongNumber);
        sourceTreeValue.setLevel(targetTreeValue == null ? 1 : targetTreeValue.getLevel() + 1);
        sourceTreeValue.put("From", "moveNode");
        this.getBean().update(ctx, (IObjectPK)sourceTreePK, (CoreBaseInfo)sourceTreeValue);
        CoreBaseCollection col = new CoreBaseCollection();
        GeneLongNumberGenerator.updateTreeLongNumber(ctx, (CoreBaseInfo)sourceTreeValue, srcChildren, col);
        this.getBean().update(ctx, col);
        if (targetTreeValue != null) {
            targetTreeValue.setIsLeaf(false);
            this.getBean().update(ctx, (IObjectPK)targetTreePK, (CoreBaseInfo)targetTreeValue);
        }
    }
}

