/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.common.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class GeneDbUtil
extends DbUtil {
    private static final int MAX_DATA_ROW = 8000;

    public static void executeBatch(Context ctx, List sqlList) throws BOSException {
        Statement stmt = null;
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.createStatement();
            for (int i = 0; i < sqlList.size(); ++i) {
                if (sqlList.get(i) == null) continue;
                stmt.addBatch((String)sqlList.get(i));
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup((Connection)cn);
    }

    public static void executeBatch(Context ctx, String sql, List paramsList) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            Object[] params = null;
            int k = 1;
            boolean flag = false;
            for (int i = 0; i < paramsList.size(); ++i) {
                params = (Object[])paramsList.get(i);
                for (int j = 0; j < params.length; ++j) {
                    if (params[j] != null) {
                        if ("-1E-8".equalsIgnoreCase(params[j].toString())) {
                            ps.setObject(j + 1, new Double(-1.0E-8));
                            continue;
                        }
                        if ("-1.0E-7".equalsIgnoreCase(params[j].toString())) {
                            ps.setObject(j + 1, new Double(-1.0E-7));
                            continue;
                        }
                        ps.setObject(j + 1, params[j]);
                        continue;
                    }
                    ps.setNull(j + 1, 12);
                }
                ps.addBatch();
                if (i == k * 8000) {
                    flag = true;
                }
                if (i <= k * 8000 || !flag) continue;
                ps.executeBatch();
                ++k;
                flag = false;
                ps.clearBatch();
            }
            if (!flag) {
                ps.executeBatch();
            }
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    public static void executeWithOutTimeOut(Context ctx, String sql) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
        }
        try {
            statement = conn.createStatement();
            statement.setQueryTimeout(0);
            statement.execute(sql);
        }
        catch (SQLException exc) {
            throw new BOSException("Sql1 execute exception : " + sql, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((Statement)statement, (Connection)conn);
        }
    }

    public static void executeBatchWithOutTimeOut(Context ctx, String sql, List paramsList) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            ps.setQueryTimeout(0);
            Object[] params = null;
            int k = 1;
            boolean flag = false;
            for (int i = 0; i < paramsList.size(); ++i) {
                params = (Object[])paramsList.get(i);
                for (int j = 0; j < params.length; ++j) {
                    if (params[j] != null) {
                        ps.setObject(j + 1, params[j]);
                        continue;
                    }
                    ps.setNull(j + 1, 12);
                }
                ps.addBatch();
                if (i == k * 8000) {
                    flag = true;
                }
                if (i <= k * 8000 || !flag) continue;
                ps.executeBatch();
                ++k;
                flag = false;
                ps.clearBatch();
            }
            if (!flag) {
                ps.executeBatch();
            }
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    public static void executeBatchWithOutTimeOut(Context ctx, List<String> sqlList) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
        }
        try {
            statement = conn.createStatement();
            statement.setQueryTimeout(0);
            int i = 0;
            int j = 1;
            while (i < sqlList.size()) {
                if (j > 8000) {
                    statement.executeBatch();
                    statement.clearBatch();
                    j = 0;
                }
                String sql = sqlList.get(i);
                statement.addBatch(sql);
                ++i;
                ++j;
            }
            statement.executeBatch();
        }
        catch (SQLException exc) {
            throw new BOSException("Sql execute exception : ", (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((Statement)statement, (Connection)conn);
        }
    }
}

