/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.common.app.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.common.GeneException;
import com.kingdee.eas.barcode.common.verify.AbstractVerifyItem;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.util.BizReference;

public class ReferencedVerify
extends AbstractVerifyItem {
    private Context ctx;
    private ObjectUuidPK pk;

    public ReferencedVerify(Context ctx, ObjectUuidPK objectUuidPK) {
        this.ctx = ctx;
        this.pk = objectUuidPK;
    }

    @Override
    public boolean verify() throws EASBizException, BOSException {
        BizReference ref = null;
        try {
            ref = ReferenceDAO.getReference((Context)this.ctx, (BOSUuid)BOSUuid.read((String)this.pk.toString()));
        }
        catch (Exception e) {
            throw new ObjectReferedException(ref, (Throwable)e);
        }
        if (ref != null) {
            this.throwException(ref);
        }
        return true;
    }

    protected void throwException(BizReference ref) throws EASBizException {
        String msg = ref.getClass() + "," + ref.getRefEntityName() + "," + ref.getRefFieldName() + "," + ref.getRefFieldName() + "," + ref.getRefTableName();
        throw new GeneException(GeneException.REFERENCEEXISTS, new Object[]{msg});
    }
}

