/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.common.core.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceManager;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.binding.IServiceBinder;
import com.kingdee.bos.service.binding.ServiceBindItem;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.common.GeneException;
import com.kingdee.eas.barcode.common.util.GeneSelectorUtils;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.app.service.FunctionPermissionService;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.IQualityOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.ITransportOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.QualityOrgUnitCollection;
import com.kingdee.eas.basedata.org.QualityOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.TransportOrgUnitCollection;
import com.kingdee.eas.basedata.org.TransportOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;

public final class GeneServerUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.common.core.app.util.GeneServerUtils");

    public static OrgUnitCollection getOrgsByRelation(Context ctx, OrgType srcOrgType, OrgType destOrgType, String orgPK) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        int iSrcOrg = srcOrgType.getValue();
        int iDestOrg = destOrgType.getValue();
        switch (iSrcOrg) {
            case 0: {
                return iDestOrg == 1 ? iOrgRelation.getToUnit(orgPK, iSrcOrg, iDestOrg) : iOrgRelation.getFromUnit(orgPK, iSrcOrg, iDestOrg);
            }
            case 1: {
                return iOrgRelation.getFromUnit(orgPK, iSrcOrg, iDestOrg);
            }
            case 2: {
                if (iDestOrg == 4) {
                    return iOrgRelation.getFromUnit(orgPK, iSrcOrg, iDestOrg);
                }
                if (iDestOrg == 3) {
                    return GeneServerUtils.getSalePurchaseRelation(ctx, srcOrgType, destOrgType, orgPK);
                }
                return iOrgRelation.getToUnit(orgPK, iSrcOrg, iDestOrg);
            }
            case 3: {
                if (iDestOrg == 1) {
                    return iOrgRelation.getToUnit(orgPK, iSrcOrg, iDestOrg);
                }
                if (iDestOrg == 2) {
                    return GeneServerUtils.getSalePurchaseRelation(ctx, srcOrgType, destOrgType, orgPK);
                }
                return iOrgRelation.getFromUnit(orgPK, iSrcOrg, iDestOrg);
            }
            case 4: {
                return iOrgRelation.getToUnit(orgPK, iSrcOrg, iDestOrg);
            }
            case 24: {
                if (iDestOrg != 4) break;
                return iOrgRelation.getFromUnit(orgPK, iSrcOrg, iDestOrg);
            }
        }
        return null;
    }

    public static OrgUnitInfo getDefaultOrgsByRelation(Context ctx, OrgType srcOrgType, OrgType destOrgType, String orgPK) throws BOSException, EASBizException {
        OrgUnitInfo defaultOrg = null;
        if (srcOrgType.equals((Object)OrgType.Storage) && (destOrgType.equals((Object)OrgType.Purchase) || destOrgType.equals((Object)OrgType.Sale)) || srcOrgType.equals((Object)OrgType.Admin) && destOrgType.equals((Object)OrgType.Storage)) {
            IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            defaultOrg = iOrgRelation.getDefaultToUnit(orgPK, srcOrgType.getValue(), destOrgType.getValue());
        }
        return defaultOrg;
    }

    private static OrgUnitCollection getSalePurchaseRelation(Context ctx, OrgType srcOrgType, OrgType destOrgType, String orgPK) throws BOSException, EASBizException {
        OrgUnitCollection resultOrgs = new OrgUnitCollection();
        OrgUnitCollection companyOrgs = GeneServerUtils.getOrgsByRelation(ctx, srcOrgType, OrgType.Company, orgPK);
        if (companyOrgs != null && companyOrgs.size() > 0) {
            return GeneServerUtils.getOrgsByRelation(ctx, OrgType.Company, destOrgType, companyOrgs.get(0).getId().toString());
        }
        return resultOrgs;
    }

    public static String getPermissionItem(Context context, IMetaDataPK pk) throws BOSException, EASBizException {
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(context);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.BASEQUERY, pk);
        if (bind != null) {
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                String permItemName;
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)(permItemName = bind[i].getName()))) continue;
                return permItemName;
            }
        }
        return null;
    }

    public static OrgUnitCollection getAuthOrgByPermItem(Context context, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        IPermission permission = PermissionFactory.getLocalInstance((Context)context);
        if (orgType == null) {
            return null;
        }
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        FullOrgUnitCollection result = permission.getAuthorizedOrg(context.getCaller(), orgType, (IObjectPK)treePK, permItem);
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        return collection;
    }

    public static OrgUnitCollection getOrgUnitInfosByType(Context ctx, OrgUnitCollection orgs, OrgType orgType, boolean isBizUnit) {
        OrgUnitCollection results = new OrgUnitCollection();
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.size(); ++i) {
            keys.add(orgs.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        if (!orgType.equals((Object)OrgType.Admin) && isBizUnit) {
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Boolean(true), CompareType.EQUALS));
        }
        view.setFilter(filter);
        try {
            switch (orgType.getValue()) {
                case 0: {
                    IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                    AdminOrgUnitCollection collection = iAdmin.getAdminOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 1: {
                    ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                    CompanyOrgUnitCollection collection = iCompany.getCompanyOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 2: {
                    ISaleOrgUnit iSale = SaleOrgUnitFactory.getLocalInstance((Context)ctx);
                    SaleOrgUnitCollection collection = iSale.getSaleOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 3: {
                    IPurchaseOrgUnit iPurchase = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
                    PurchaseOrgUnitCollection collection = iPurchase.getPurchaseOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 4: {
                    IStorageOrgUnit iStorage = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
                    view.setSelector(GeneSelectorUtils.getSelector(new StorageOrgUnitInfo().getBOSType(), "", false, true, false));
                    StorageOrgUnitCollection collection = iStorage.getStorageOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 24: {
                    ITransportOrgUnit iTransport = TransportOrgUnitFactory.getLocalInstance((Context)ctx);
                    TransportOrgUnitCollection collection = iTransport.getTransportOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 32: {
                    IQualityOrgUnit iTransport = QualityOrgUnitFactory.getLocalInstance((Context)ctx);
                    QualityOrgUnitCollection collection = iTransport.getQualityOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    public static OrgUnitInfo[] getOrgUnitInfos(Context context, String ids) {
        try {
            IFullOrgUnit iOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)context);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)StringUtil.getKeyIdList((String)ids), CompareType.INCLUDE));
            view.setFilter(filter);
            FullOrgUnitCollection collection = iOrgUnit.getFullOrgUnitCollection(view);
            OrgUnitInfo[] results = new OrgUnitInfo[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                results[i] = collection.get(i);
            }
            return results;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static void checkLastUpTime(Context ctx, ObjectBaseInfo info, String tableName) throws BOSException, EASBizException {
        block6: {
            Timestamp time = info.getLastUpdateTime();
            BOSUuid id = info.getId();
            if (time != null && id != null) {
                String sql = "select fid ,flastupdatetime from " + tableName + " where fid =?";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id.toString()});
                try {
                    if (rs.next()) {
                        Timestamp lst = rs.getTimestamp(2);
                        if (lst.getTime() > time.getTime()) {
                            throw new GeneException(GeneException.SUBMIT_MODIFY);
                        }
                        break block6;
                    }
                    throw new EASBizException(EASBizException.CHECKEXIST);
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    public static void checkPermission(Context ctx, IObjectPK orgPK, String permItemName) throws BOSException, EASBizException {
        IObjectPK userPK = ctx.getCaller();
        FunctionPermissionService service = new FunctionPermissionService(ctx);
        service.checkPermission(userPK, orgPK, permItemName, true);
    }
}

