/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.common.core.codingrule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.barcode.common.core.codingrule.GeneCodingRuleData;
import com.kingdee.eas.barcode.common.core.codingrule.ISuportCodingRule;
import com.kingdee.eas.barcode.common.core.codingrule.ISuportCodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.EqualsUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;

public class ServerCodingRuleStrategy {
    /*
     * Enabled aggressive block sorting
     */
    public void initNumber(ISuportCodingRule bean, Context ctx, ISuportCodingRuleInfo info) throws BOSException, EASBizException {
        GeneCodingRuleData codingRuleData = (GeneCodingRuleData)info.get("codingRuleData");
        if (codingRuleData != null && codingRuleData.isExistRule()) {
            if (codingRuleData.isUseIntermitNumber()) {
                this.setNumber(bean, ctx, info);
                return;
            }
            if (codingRuleData.isAddView() && !codingRuleData.isModifable()) {
                if (!EmptyUtil.isEmpty((String)info.getNumber())) {
                    return;
                }
                this.setNumber(bean, ctx, info);
                return;
            }
            if (codingRuleData.isAddView() && codingRuleData.isModifable()) {
                String oldNumber = info.getString("oldNumber");
                if (EqualsUtil.equals((String)oldNumber, (String)info.getNumber())) {
                    this.setNumber(bean, ctx, info);
                    return;
                }
                if (!EmptyUtil.isEmpty((String)info.getNumber())) {
                    return;
                }
                this.setNumber(bean, ctx, info);
                return;
            }
            if (codingRuleData.isAddView() && !codingRuleData.isUseIntermitNumber()) {
                this.setNumber(bean, ctx, info);
                return;
            }
            if (codingRuleData.isAddView()) return;
            this.setNumber(bean, ctx, info);
            return;
        }
        if (!EmptyUtil.isEmpty((String)info.getNumber())) {
            return;
        }
        this.setNumber(bean, ctx, info);
    }

    public void initEditNumber(ISuportCodingRule bean, Context ctx, ISuportCodingRuleInfo info) throws BOSException, EASBizException {
        GeneCodingRuleData codingRuleData = (GeneCodingRuleData)info.get("codingRuleData");
        if (codingRuleData != null && codingRuleData.isExistRule() && codingRuleData.isUseIntermitNumber() && codingRuleData.isModifable()) {
            String oldNumber = info.getString("oldNumber");
            if (EqualsUtil.equals((String)oldNumber, (String)info.getNumber())) {
                return;
            }
            this.recycleNumber(ctx, (CoreBaseInfo)info, info.getMainOrgUnit().getId().toString());
            return;
        }
    }

    public void setNumber(ISuportCodingRule bean, Context ctx, ISuportCodingRuleInfo info) throws BOSException, CodingRuleException, EASBizException {
        do {
            String numberSilent;
            if (EmptyUtil.isEmpty((String)(numberSilent = this.getNumberSilent(ctx, info, info.getMainOrgUnit().getId().toString())))) {
                return;
            }
            info.setNumber(numberSilent);
        } while (bean.isNumberDup(ctx, null, info));
    }

    public String getNumberSilent(Context ctx, ISuportCodingRuleInfo info, String companyId) throws BOSException, CodingRuleException, EASBizException {
        if (info == null || companyId == null || companyId.equals("")) {
            return null;
        }
        String result = null;
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (codingRuleManager.isExist((IObjectValue)info, companyId)) {
            result = codingRuleManager.getNumber((IObjectValue)info, companyId);
        }
        return result;
    }

    public void recycleNumber(Context ctx, CoreBaseInfo info, String companyId) {
        if (info == null || companyId == null || companyId.equals("")) {
            return;
        }
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (codingRuleManager.isExist((IObjectValue)info, companyId) && codingRuleManager.isUseIntermitNumber((IObjectValue)info, companyId)) {
                codingRuleManager.recycleNumber((IObjectValue)info, companyId, info.getString("number"));
            }
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
    }
}

