/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.common.core.print;

import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.barcode.common.GeneCommonFacadeFactory;
import com.kingdee.eas.barcode.common.core.print.GenePrintActionAdapter;
import com.kingdee.eas.barcode.common.core.print.GenePrintIntegrationHelper;
import java.util.List;
import java.util.Map;

public class GeneTDPrintActionListener
extends GenePrintActionAdapter {
    private KDNoteHelper kdNotePrinter = null;
    private BOSObjectType bosType = null;
    private String tdPath = "";
    private List dataIdList = null;
    private boolean hasPrinted = false;
    private GenePrintIntegrationHelper printIntegrationHelper;

    public GeneTDPrintActionListener(KDNoteHelper kdNotePrinter, BOSObjectType bosType, List dataIdList, String tdPath) {
        this.kdNotePrinter = kdNotePrinter;
        this.bosType = bosType;
        this.tdPath = tdPath;
        this.dataIdList = dataIdList;
        this.printIntegrationHelper = new GenePrintIntegrationHelper(this.kdNotePrinter, this.bosType, this.dataIdList, this.tdPath);
    }

    @Override
    public void beforePrint() {
        this.hasPrinted = true;
        this.printIntegrationHelper.doInvokePrintIntegration();
        this.doLog();
    }

    public void doLog() {
        if (this.bosType == null || this.dataIdList == null || this.dataIdList.size() == 0) {
            return;
        }
        try {
            GeneCommonFacadeFactory.getRemoteInstance().writeTDPrintLog(this.dataIdList, this.bosType);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Map getPrintedErrorMap() {
        return this.printIntegrationHelper.getPrintedErrorMap();
    }

    public Map getWillPrintedErrorMap() {
        return this.printIntegrationHelper.getWillPrintedErrorMap();
    }

    public boolean hasPrinted() {
        return this.hasPrinted;
    }
}

