/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.common.ctx;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.barcode.common.ctx.IGeneContextHelper;
import com.kingdee.eas.base.core.fi.gl.GLUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.HashMap;
import org.apache.log4j.Logger;

final class GeneContextHelper
implements IGeneContextHelper {
    public static final String resClassName = "com.kingdee.eas.fm.common.FMResource";
    private static final Logger logger = Logger.getLogger(GeneContextHelper.class);

    GeneContextHelper() {
    }

    @Override
    public CompanyOrgUnitInfo getCurrentCompany() {
        CompanyOrgUnitInfo companyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (companyOrgUnitInfo == null) {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"currenctCompanyNotEmpty"));
            SysUtil.abort();
        }
        if (companyOrgUnitInfo.getAccountTable() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"currenctCompanyAcctTableNull"));
            SysUtil.abort();
        }
        return companyOrgUnitInfo;
    }

    @Override
    public CtrlUnitInfo getCurrentCtrlUnit() {
        CtrlUnitInfo companyOrgUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        if (companyOrgUnitInfo == null) {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"currenctCUNotEmpty"));
            SysUtil.abort();
        }
        return companyOrgUnitInfo;
    }

    @Override
    public CurrencyInfo getCompanyBaseCurrency(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        CurrencyInfo currency = null;
        if (company == null) {
            return null;
        }
        if (company.getBaseCurrency() != null) {
            return company.getBaseCurrency();
        }
        ICompanyOrgUnit corgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("baseCurrency.*");
        CompanyOrgUnitInfo info = corgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selectors);
        currency = info.getBaseCurrency();
        return currency;
    }

    @Override
    public UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    @Override
    public String getSessionID() {
        return SysContext.getSysContext().getSessionID();
    }

    @Override
    public boolean isOnlyUnion(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (company.containsKey("isOnlyUnion")) {
            return GLUtil.isCompanyUnion((CompanyOrgUnitInfo)company);
        }
        ICompanyOrgUnit corgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("isOnlyUnion");
        CompanyOrgUnitInfo info = corgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selectors);
        return GLUtil.isCompanyUnion((CompanyOrgUnitInfo)info);
    }

    @Override
    public int getIntParam(String key, IObjectPK orgPK) {
        int rst = 0;
        String value = this.getStringParam(key, orgPK);
        if (EmptyUtil.isEmpty((String)value)) {
            return 0;
        }
        rst = Integer.parseInt(value);
        return rst;
    }

    @Override
    public String getStringParam(String key, IObjectPK orgPK) {
        HashMap<String, IObjectPK> map = new HashMap<String, IObjectPK>();
        map.put(key, orgPK);
        String value = null;
        try {
            IParamControl iParamControl = ParamControlFactory.getRemoteInstance();
            HashMap param = iParamControl.getParamHashMap(map);
            value = (String)param.get(key);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return value;
    }

    @Override
    public boolean getBooleanParam(String key, IObjectPK orgPK) {
        String value = this.getStringParam(key, orgPK);
        boolean rst = Boolean.valueOf(value);
        return rst;
    }

    public Object[] getAllCompany() {
        try {
            return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection().toArray();
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public AdminOrgUnitInfo getCurrentAdmin() {
        AdminOrgUnitInfo orgInfo = SysContext.getSysContext().getCurrentAdminUnit();
        if (orgInfo == null) {
            MsgBox.showWarning((String)"currenctAdminNotEmpty");
            SysUtil.abort();
        }
        return orgInfo;
    }

    @Override
    public QualityOrgUnitInfo getCurrentQuality() {
        QualityOrgUnitInfo orgInfo = SysContext.getSysContext().getCurrentQualityUnit();
        if (orgInfo == null) {
            MsgBox.showWarning((String)"\u5f53\u524d\u8d28\u68c0\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a!");
            SysUtil.abort();
        }
        return orgInfo;
    }
}

