/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import java.math.BigDecimal;
import java.util.HashMap;
import javax.swing.JTextField;

public class GenePrecisionUtil {
    public static final int DEFAULT_PRICISION = 4;
    public static final int DEFAULT_AMOUT_PRICISION = 4;
    public static final int DEFAULT_QTY_PRICISION = 8;
    public static final BigDecimal BigDecimal_MaxValue = new BigDecimal("9999999999999.99999999");
    public static final BigDecimal BigDecimal_MinValue = new BigDecimal("-9999999999999.99999999");
    private static HashMap multiMeasureUnitMap = new HashMap();
    private static HashMap precisionMap = new HashMap();

    public static String getFormatString(int precision) {
        if (precision == 0) {
            return "%R-{#,##0}f";
        }
        StringBuffer buffer = new StringBuffer();
        if (precision == 0) {
            buffer.append("#");
        } else {
            buffer.append("0.");
        }
        for (int i = 0; i < precision; ++i) {
            buffer = buffer.append("0");
        }
        StringBuffer formatString = new StringBuffer();
        formatString.append("%r-[=]{#,##").append(buffer).append("}f");
        return formatString.toString();
    }

    public static KDFormattedTextField getNumberEditor(int precision, BigDecimal maxValue, BigDecimal minValue) {
        KDFormattedTextField colTxtField = new KDFormattedTextField();
        colTxtField.setDataType(1);
        colTxtField.setPrecision(precision);
        colTxtField.setHorizontalAlignment(4);
        colTxtField.setSupportedEmpty(true);
        colTxtField.setRemoveingZeroInDispaly(false);
        colTxtField.setRemoveingZeroInEdit(false);
        if (minValue != null) {
            colTxtField.setMinimumValue((Comparable)minValue);
        }
        if (minValue == null || colTxtField.getMinimumValue() == null || colTxtField.getMinimumValue().compareTo(BigDecimal_MinValue) == -1) {
            colTxtField.setMinimumValue((Comparable)BigDecimal_MinValue);
        }
        if (maxValue != null) {
            colTxtField.setMaximumValue((Comparable)maxValue);
        }
        if (maxValue == null || colTxtField.getMaximumValue() == null || colTxtField.getMaximumValue().compareTo(BigDecimal_MaxValue) == 1) {
            colTxtField.setMaximumValue((Comparable)BigDecimal_MaxValue);
        }
        return colTxtField;
    }

    public static void setColNumberEditor(int precision, KDTable table, String[] cols, BigDecimal maxValue, BigDecimal minValue) {
        for (int i = 0; i < cols.length; ++i) {
            KDFormattedTextField txtNum = GenePrecisionUtil.getNumberEditor(precision, maxValue, minValue);
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)txtNum);
            table.getColumn(cols[i]).setEditor((ICellEditor)editor);
            table.getColumn(cols[i]).getStyleAttributes().setNumberFormat(GenePrecisionUtil.getFormatString(precision));
        }
    }

    public static void setRowNumberEditor(int precision, KDTable table, int rowIndex, String[] cols, BigDecimal maxValue, BigDecimal minValue) {
        GenePrecisionUtil.setRowNumberEditor(precision, table, rowIndex, cols, maxValue, minValue, true);
    }

    public static void setRowNumberEditor(int precision, KDTable table, int rowIndex, String[] cols, BigDecimal maxValue, BigDecimal minValue, boolean canUsed) {
        IRow row = table.getRow(rowIndex);
        for (int i = 0; i < cols.length; ++i) {
            KDFormattedTextField txtNum = GenePrecisionUtil.getNumberEditor(precision, maxValue, minValue);
            txtNum.setEditable(canUsed);
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)txtNum);
            row.getCell(cols[i]).setEditor((ICellEditor)editor);
            row.getCell(cols[i]).getStyleAttributes().setNumberFormat(GenePrecisionUtil.getFormatString(precision));
        }
    }

    public static int qtyPrecision(MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        return GenePrecisionUtil.multiUnitQTYPrecision(GenePrecisionUtil.multiMeasureUnit(null, material, unit));
    }

    public static int qtyPrecision(Context ctx, MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        return GenePrecisionUtil.multiUnitQTYPrecision(GenePrecisionUtil.multiMeasureUnit(ctx, material, unit));
    }

    public static int multiUnitQTYPrecision(MultiMeasureUnitInfo multiUnit) {
        int scale = 4;
        if (null != multiUnit) {
            scale = GenePrecisionUtil.effectualQtyPrecision(multiUnit.getQtyPrecision());
        }
        return scale;
    }

    public static int effectualQtyPrecision(int scale) {
        return scale >= 0 ? scale : 4;
    }

    public static MultiMeasureUnitInfo multiMeasureUnit(Context ctx, MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        String key;
        MultiMeasureUnitInfo multiUnit = null;
        if (null != material && null != material.getId() && null != unit && null != unit.getId() && (multiUnit = (MultiMeasureUnitInfo)multiMeasureUnitMap.get(key = material.getId().toString() + "AND" + unit.getId().toString())) == null) {
            multiUnit = GenePrecisionUtil.getMultiUnitBizInterface(ctx).getMultiUnit(material.getId().toString(), unit.getId().toString());
            multiMeasureUnitMap.put(key, multiUnit);
        }
        return multiUnit;
    }

    private static IMultiMeasureUnit getMultiUnitBizInterface(Context ctx) throws BOSException {
        IMultiMeasureUnit ie = null;
        ie = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        return ie;
    }
}

