/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.common.util;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.barcode.common.GeneBillBaseEntryInfo;
import com.kingdee.eas.barcode.common.GeneDataBaseInfo;
import com.kingdee.eas.barcode.common.util.GeneCommonUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class GeneSelectorUtils {
    private static final Logger logger = Logger.getLogger(GeneSelectorUtils.class);

    public static SelectorItemCollection getSelector(String prex, String[] properties) {
        SelectorItemCollection sic = new SelectorItemCollection();
        GeneSelectorUtils.addSelectorWithPros(sic, prex, properties);
        return sic;
    }

    public static SelectorItemCollection getSelector(BOSObjectType bosType, String prex, boolean loadEntry, boolean loadAssociation, boolean filter) {
        prex = GeneCommonUtils.isEmpty(prex) ? "" : prex + ".";
        SelectorItemCollection sic = new SelectorItemCollection();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entityObjectInfo = loader.getEntity(bosType);
        List excludeProperties = GeneSelectorUtils.getFilterItem(entityObjectInfo);
        PropertyCollection propCollection = entityObjectInfo.getInheritedPropertiesRuntime();
        for (PropertyInfo propInfo : propCollection) {
            if (filter && excludeProperties.contains(propInfo.getName())) continue;
            if (propInfo instanceof OwnPropertyInfo) {
                sic.add(new SelectorItemInfo(prex + propInfo.getName()));
                continue;
            }
            if (!loadAssociation || !(propInfo instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propInfo;
            EntityObjectInfo supplierObject = linkPropertyInfo.getRelationship().getSupplierObject();
            if (linkPropertyInfo.getMappingField() == null) {
                if (!loadEntry) continue;
                try {
                    Class<?> clzz = Class.forName(supplierObject.getObjectValueClass());
                    CoreBaseInfo coreBaseInfo = (CoreBaseInfo)clzz.newInstance();
                    sic.addObjectCollection((IObjectCollection)GeneSelectorUtils.getSelector(coreBaseInfo.getBOSType(), linkPropertyInfo.getName(), loadEntry, loadAssociation, filter));
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
                continue;
            }
            sic.add(new SelectorItemInfo(prex + propInfo.getName() + ".id"));
            if (supplierObject.getPropertyByName("name", true) != null) {
                sic.add(new SelectorItemInfo(prex + propInfo.getName() + ".name"));
            }
            if (supplierObject.getPropertyByName("number", true) == null) continue;
            sic.add(new SelectorItemInfo(prex + propInfo.getName() + ".number"));
        }
        return sic;
    }

    public static SelectorItemCollection getSelector(BOSObjectType bosType, String prex, boolean loadEntry) {
        return GeneSelectorUtils.getSelector(bosType, prex, loadEntry, true, true);
    }

    public static SelectorItemCollection getSelector(BOSObjectType bosType, String prex, boolean loadEntry, boolean loadAssociation) {
        return GeneSelectorUtils.getSelector(bosType, prex, loadEntry, loadAssociation, true);
    }

    private static List getFilterItem(EntityObjectInfo entityObjectInfo) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Class<?> class1 = Class.forName(entityObjectInfo.getObjectValueClass());
            Object obj = class1.newInstance();
            if (obj instanceof GeneDataBaseInfo) {
                list.add("helpCode");
                list.add("deletedStatus");
                list.add("checkedStatus");
                list.add("blockedStatus");
                list.add("effectedStatus");
            }
            if (obj instanceof CoreBillEntryBaseInfo) {
                list.add("seq");
            }
            if (obj instanceof GeneBillBaseEntryInfo) {
                list.add("sourceBillID");
                list.add("sourceBillEntryID");
                list.add("remark");
            }
            if (obj instanceof CoreBillBaseInfo) {
                list.add("handler");
                list.add("description");
                list.add("hasEffected");
                list.add("sourceFunction");
            }
            if (obj instanceof DataBaseInfo) {
                list.add("description");
                list.add("simpleName");
            }
            if (obj instanceof ObjectBaseInfo) {
                list.add("creator");
                list.add("createTime");
                list.add("lastUpdateUser");
                list.add("lastUpdateTime");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return list;
    }

    public static void addSelectorWithIDAndNumberAndName(SelectorItemCollection sic, String item) {
        GeneSelectorUtils.addSelectorWithPros(sic, item, new String[]{"id", "number", "name"});
    }

    public static void addSelectorWithIDAndNumberAndName(SelectorItemCollection sic, String[] items) {
        for (int i = 0; i < items.length; ++i) {
            GeneSelectorUtils.addSelectorWithPros(sic, items[i], new String[]{"id", "number", "name"});
        }
    }

    public static void addSelectorWithPros(SelectorItemCollection sic, String item, String[] pros) {
        for (int i = 0; pros != null && i < pros.length; ++i) {
            sic.add(new SelectorItemInfo(item == null || item.length() == 0 ? pros[i] : "" + item + "." + pros[i] + ""));
        }
    }

    public static void addSelectorWithPros(SelectorItemCollection sic, String[] items, String[] pros) {
        for (int i = 0; i < items.length; ++i) {
            GeneSelectorUtils.addSelectorWithPros(sic, items[i], pros);
        }
    }

    public static void addSelectorWithPros(SelectorItemCollection sic, String[] pros) {
        for (int i = 0; pros != null && i < pros.length; ++i) {
            sic.add(new SelectorItemInfo(pros[i]));
        }
    }
}

