/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;

public class QMUnitAndExchangeUtils {
    public static MeasureUnitInfo getBaseUnitForServer(Context ctx, String materialID) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)materialID)) {
            return null;
        }
        MeasureUnitInfo baseUnit = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("baseUnit.*"));
        MaterialInfo material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID), sic);
        if (null != material && null != material.getBaseUnit()) {
            baseUnit = material.getBaseUnit();
        }
        return baseUnit;
    }

    public static BigDecimal getExchangeQtyForServer(Context ctx, MeasureUnitInfo srcUnit, MeasureUnitInfo desUnit, BigDecimal qty, String materialID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)materialID) || null == srcUnit || null == desUnit || qty == null) {
            return null;
        }
        BigDecimal targetQty = null;
        if (srcUnit.getId().toString().equals(desUnit.getId().toString())) {
            return qty;
        }
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo srcMultiUnitInfo = multiUnit.getMultiUnit(materialID, srcUnit.getId().toString());
        MultiMeasureUnitInfo desMultiUnitInfo = multiUnit.getMultiUnit(materialID, desUnit.getId().toString());
        if (srcMultiUnitInfo != null && desMultiUnitInfo != null) {
            BigDecimal baseExchangeRate1 = srcMultiUnitInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = desMultiUnitInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = qty.multiply(baseExchangeRate1);
            targetQty = baseQty.divide(baseExchangeRate2, baseQty.scale() + qty.scale(), 4);
        }
        return targetQty;
    }
}

