/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.eqm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.barcode.common.BillBaseStatusEnum;
import com.kingdee.eas.barcode.common.app.util.GeneServerUtils;
import com.kingdee.eas.barcode.common.util.GeneStringUtils;
import com.kingdee.eas.barcode.common.verify.IVerifyManager;
import com.kingdee.eas.barcode.eqm.StocktakingBillInfo;
import com.kingdee.eas.barcode.eqm.StocktakingTaskBillFactory;
import com.kingdee.eas.barcode.eqm.StocktakingTaskBillInfo;
import com.kingdee.eas.barcode.eqm.app.AbstractStocktakingBillControllerBean;
import com.kingdee.eas.barcode.eqm.util.AttachmentServerManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.Date;
import org.apache.log4j.Logger;

public class StocktakingBillControllerBean
extends AbstractStocktakingBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.eqm.app.StocktakingBillControllerBean");

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._audit(ctx, pk);
        StocktakingBillInfo billInfo = (StocktakingBillInfo)this.getValue(ctx, pk);
        if (billInfo.getEndDate() == null) {
            billInfo.setEndDate(new java.util.Date());
        }
        if (billInfo.getOperator() == null) {
            billInfo.setOperator(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("operator"));
        this.updatePartial(ctx, billInfo, sic);
        this.updateTaskBillStates(ctx, 81, billInfo.getTaskBill().getId().toString(), new Date(billInfo.getBeginDate().getTime()), new Date(billInfo.getEndDate().getTime()));
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StocktakingTaskBillInfo taskBillInfo;
        this.lockData(ctx, pk.toString());
        StocktakingBillInfo info = (StocktakingBillInfo)this.getValue(ctx, pk);
        if (info.getTaskBill() != null && BillBaseStatusEnum.BEGINREPORT.equals((Object)(taskBillInfo = StocktakingTaskBillFactory.getLocalInstance(ctx).getStocktakingTaskBillInfo((IObjectPK)new ObjectUuidPK(info.getTaskBill().getId()))).getBillStatus())) {
            throw new EASBizException(new NumericExceptionSubItem("", "\u5df2\u751f\u6210\u76d8\u70b9/\u8d44\u4ea7\u4fe1\u606f\u5dee\u5f02\u8868\u4e0d\u80fd\u53cd\u5ba1\u6838"));
        }
        if (info.getMainOrgUnit() != null) {
            ObjectUuidPK orgPK = new ObjectUuidPK(info.getMainOrgUnit().getId());
            String permitItem = this.getPermissionItem();
            if (!GeneStringUtils.isEmpty(permitItem)) {
                GeneServerUtils.checkPermission(ctx, (IObjectPK)orgPK, permitItem);
            }
        }
        IVerifyManager verifymanager = this.getUnAuditVerifyManager(ctx, info);
        verifymanager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FBillStatus=? ,FAuditorId=null , FAuditTime=null where fid =?";
        this.fireServerAction(ctx, info, "BEFORE_UNAUDIT");
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2), pk.toString()});
        info.setEndDate(null);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("endDate"));
        this.updatePartial(ctx, info, sic);
        this.fireServerAction(ctx, info, "AFTER_UNAUDIT");
        StocktakingBillInfo billInfo = (StocktakingBillInfo)this.getValue(ctx, pk);
        this.updateTaskBillStates(ctx, 80, billInfo.getTaskBill().getId().toString(), new Date(billInfo.getBeginDate().getTime()), null);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue arg1) throws BOSException, EASBizException {
        StocktakingBillInfo billInfo = (StocktakingBillInfo)arg1;
        IObjectPK pk = super._submit(ctx, arg1);
        if (pk != null) {
            this.updateTaskBillStates(ctx, 80, billInfo.getTaskBill().getId().toString(), new Date(billInfo.getBeginDate().getTime()), null);
        }
        return pk;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            StocktakingBillInfo billInfo = (StocktakingBillInfo)this.getValue(ctx, pk);
            this.updateTaskBillStates(ctx, 4, billInfo.getTaskBill().getId().toString(), null, null);
            AttachmentServerManager attaServer = new AttachmentServerManager(ctx);
            attaServer.deleteAttachemtsByBoID(pk.toString());
        }
        super._delete(ctx, pk);
    }

    private void updateTaskBillStates(Context ctx, int billStatus, String taskBillId, Date beginDate, Date endDate) throws BOSException, EASBizException {
        StringBuffer _sql = new StringBuffer("update CT_EQM_StocktakingTaskBill   set");
        _sql.append(" FBillStatus = ?");
        _sql.append(" ,CFBeginDate = ?");
        _sql.append(" ,CFEndDate = ?");
        _sql.append(" where fid = ?");
        Object[] params = new Object[]{new Integer(billStatus), beginDate, endDate, taskBillId};
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
    }
}

