/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.barcode.pda.BarcodePDARecodeInfo;
import com.kingdee.eas.barcode.pda.BarcodePDataInfo;
import com.kingdee.eas.barcode.scm.BarcodeConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodeConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningBarcodeInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningPropertyInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningRecodeInfo;
import com.kingdee.eas.barcode.scm.BarcodeWSException;
import com.kingdee.eas.barcode.scm.IBarcodeConfig;
import com.kingdee.eas.barcode.scm.app.CustMappingInfo;
import com.kingdee.eas.barcode.scm.app.TableInfo;
import com.kingdee.eas.barcode.scm.util.BarcodeClientUtils;
import com.kingdee.eas.base.form.ide.utils.EntityObjectInfoHelp;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class XmlSerHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.uw.app.XmlSerHelper");

    public static String getGuuID(Document doc) {
        Element root = doc.getRootElement();
        List cNodes = root.getChildren();
        Element cNode = null;
        List billInfoChilList = null;
        int n = cNodes.size();
        for (int i = 0; i < n; ++i) {
            cNode = (Element)cNodes.get(i);
            billInfoChilList = cNode.getChildren();
            int m = billInfoChilList.size();
            for (int j = 0; j < m; ++j) {
                Element billNode = (Element)billInfoChilList.get(j);
                if (!billNode.getName().equals("GUID")) continue;
                return billNode.getTextTrim();
            }
        }
        return null;
    }

    public static String getBarcodeStr(Context ctx, Document doc) throws BOSException, EASBizException {
        Element root = doc.getRootElement();
        List cNodes = root.getChildren();
        BarcodeConfigInfo configInfo = null;
        IBarcodeConfig ibarCodeConfig = BarcodeConfigFactory.getLocalInstance(ctx);
        StringBuffer barcodeStr = new StringBuffer();
        String bosType = null;
        int n = cNodes.size();
        for (int i = 0; i < n; ++i) {
            Element cNode = (Element)cNodes.get(i);
            List billInfoChilList = cNode.getChildren();
            int m = billInfoChilList.size();
            for (int j = 0; j < m; ++j) {
                Element billNode = (Element)billInfoChilList.get(j);
                if (billNode.getName().equals("userNumber")) continue;
                if (billNode.getName().equals("BarcodeConfigId")) {
                    String barcodeConfigId = billNode.getTextTrim();
                    if (barcodeConfigId == null || "".equals(barcodeConfigId) || (configInfo = ibarCodeConfig.getBarcodeConfigInfo((IObjectPK)new ObjectUuidPK(barcodeConfigId))) == null) continue;
                    bosType = configInfo.getDestBosType();
                    continue;
                }
                if (billNode.getName().equals("GUID")) continue;
                if (billNode.getName().equals("barcodeStr")) {
                    return billNode.getTextTrim();
                }
                if (billNode.getName().equals("defaultSolutionId") || billNode.getName().equals("parentProperties")) continue;
                List detailsList = billNode.getChildren();
                int size = detailsList.size();
                for (int k = 0; k < size; ++k) {
                    Element detailsNode = (Element)detailsList.get(k);
                    List rowList = detailsNode.getChildren();
                    int b = rowList.size();
                    for (int l = 0; l < b; ++l) {
                        Element rowNode = (Element)rowList.get(l);
                        if (!"barcodeList".equalsIgnoreCase(rowNode.getName())) continue;
                        List barcodeList = rowNode.getChildren();
                        int f = barcodeList.size();
                        for (int h = 0; h < f; ++h) {
                            Element barcodeNode = (Element)barcodeList.get(h);
                            String value = barcodeNode.getAttributeValue("value");
                            if (bosType == null || value == null || value.length() <= 0) continue;
                            value = bosType + "-" + value.trim();
                            if (barcodeStr.length() > 0) {
                                barcodeStr.append(",").append(value);
                                continue;
                            }
                            barcodeStr.append(value);
                        }
                    }
                }
            }
        }
        return barcodeStr.toString();
    }

    public static String getDeviceId(Document doc) {
        Element root = doc.getRootElement();
        List cNodes = root.getChildren();
        Element cNode = null;
        List billInfoChilList = null;
        int n = cNodes.size();
        for (int i = 0; i < n; ++i) {
            cNode = (Element)cNodes.get(i);
            billInfoChilList = cNode.getChildren();
            int m = billInfoChilList.size();
            for (int j = 0; j < m; ++j) {
                Element billNode = (Element)billInfoChilList.get(j);
                if (!billNode.getName().equals("deviceId")) continue;
                return billNode.getTextTrim();
            }
        }
        return null;
    }

    public static Document preseXmlToDoc(String xml) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        StringReader strR = new StringReader(xml);
        doc = builder.build((Reader)strR);
        return doc;
    }

    public static List<BarcodePDARecodeInfo> parseRecodeXml(Context ctx, String xml) throws EASBizException, BOSException {
        try {
            Document doc = XmlSerHelper.preseXmlToDoc(xml);
            return XmlSerHelper.parseRecodeXml(ctx, doc);
        }
        catch (JDOMException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BarcodeWSException(BarcodeWSException.XMLERROR);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BarcodeWSException(BarcodeWSException.XMLERROR);
        }
    }

    public static List<BarcodePDARecodeInfo> parseRecodeXml(Context ctx, Document doc) throws EASBizException, BOSException {
        ArrayList<BarcodePDARecodeInfo> barcodePDARecodeInfoList = new ArrayList<BarcodePDARecodeInfo>();
        Element root = doc.getRootElement();
        List cNodes = root.getChildren();
        IBarcodeConfig ibarCodeConfig = BarcodeConfigFactory.getLocalInstance(ctx);
        int n = cNodes.size();
        for (int i = 0; i < n; ++i) {
            BarcodePDARecodeInfo pdaReCodeInfo = new BarcodePDARecodeInfo();
            BarcodeConfigInfo configInfo = null;
            BarcodeScanningRecodeInfo scanningRecodeInfo = new BarcodeScanningRecodeInfo();
            scanningRecodeInfo.setPDA(true);
            LinkedHashMap<String, List<BarcodeScanningRecodeInfo>> entriesMap = new LinkedHashMap<String, List<BarcodeScanningRecodeInfo>>();
            Map<String, List<BarcodeScanningRecodeInfo>> countingTableRow = null;
            Element cNode = (Element)cNodes.get(i);
            List billInfoChilList = cNode.getChildren();
            int m = billInfoChilList.size();
            for (int j = 0; j < m; ++j) {
                Element billNode = (Element)billInfoChilList.get(j);
                if (billNode.getName().equals("userNumber")) {
                    pdaReCodeInfo.setUserNumber(billNode.getTextTrim());
                    continue;
                }
                if (billNode.getName().equals("BarcodeConfigId")) {
                    String barcodeConfigId = billNode.getTextTrim();
                    if (barcodeConfigId == null || "".equals(barcodeConfigId) || (configInfo = ibarCodeConfig.getBarcodeConfigInfo((IObjectPK)new ObjectUuidPK(barcodeConfigId))) == null) continue;
                    pdaReCodeInfo.setConfigInfo(configInfo);
                    continue;
                }
                if (billNode.getName().equals("defaultSolutionId")) {
                    pdaReCodeInfo.setDefaultSolutionId(billNode.getTextTrim());
                    continue;
                }
                if (billNode.getName().equals("deviceId")) continue;
                if (billNode.getName().equals("parentProperties")) {
                    List parentPropertiesList = billNode.getChildren();
                    HashMap<String, BarcodeScanningPropertyInfo> parentPropertiesMap = new HashMap<String, BarcodeScanningPropertyInfo>();
                    EntityObjectInfo entity = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)configInfo.getDestBosType()));
                    int size = parentPropertiesList.size();
                    for (int k = 0; k < size; ++k) {
                        Element parentNode = (Element)parentPropertiesList.get(k);
                        String key = parentNode.getName();
                        String objectValue = parentNode.getTextTrim();
                        PropertyInfo property = entity.getPropertyByName(key);
                        BarcodeScanningPropertyInfo parentPropertyInfo = XmlSerHelper.setPropertyValue(scanningRecodeInfo, property, key, objectValue);
                        if ("fid".equals(key) && objectValue != null && !"".equals(objectValue)) {
                            key = "id";
                        }
                        parentPropertiesMap.put(key, parentPropertyInfo);
                    }
                    scanningRecodeInfo.setFbosType(configInfo.getDestBosType());
                    scanningRecodeInfo.setProperties(parentPropertiesMap);
                    continue;
                }
                countingTableRow = XmlSerHelper.paresRecodeEntry(billNode, configInfo, entriesMap);
            }
            if (entriesMap.size() <= 0) {
                throw new BarcodeWSException(new NumericExceptionSubItem("", "\u6ca1\u6709\u5206\u5f55\u6570\u636e\u4e0d\u80fd\u63d0\u4ea4\u6570\u636e\uff01"));
            }
            scanningRecodeInfo.setEntriesMap(entriesMap);
            pdaReCodeInfo.setScanningRecodeInfo(scanningRecodeInfo);
            barcodePDARecodeInfoList.add(pdaReCodeInfo);
        }
        return barcodePDARecodeInfoList;
    }

    public static Map<String, List<BarcodeScanningRecodeInfo>> paresRecodeEntry(Element billNode, BarcodeConfigInfo configInfo, Map<String, List<BarcodeScanningRecodeInfo>> entriesMap) {
        String[] billNodeName = billNode.getName().split("_");
        String entriesMapkey = billNodeName[0];
        String bosType = billNodeName[1];
        List detailsList = billNode.getChildren();
        ArrayList<BarcodeScanningRecodeInfo> entryRecodeList = new ArrayList<BarcodeScanningRecodeInfo>();
        LinkedHashMap<String, List<BarcodeScanningRecodeInfo>> countingTableRow = new LinkedHashMap<String, List<BarcodeScanningRecodeInfo>>();
        int size = detailsList.size();
        for (int k = 0; k < size; ++k) {
            BarcodeScanningRecodeInfo entryRecodeInfo = new BarcodeScanningRecodeInfo();
            Element detailsNode = (Element)detailsList.get(k);
            List rowList = detailsNode.getChildren();
            TreeMap<String, BarcodeScanningPropertyInfo> entryPropertiesMap = new TreeMap<String, BarcodeScanningPropertyInfo>();
            EntityObjectInfo entity = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)bosType));
            String countTingTableID = null;
            int b = rowList.size();
            for (int l = 0; l < b; ++l) {
                Element rowNode = (Element)rowList.get(l);
                if (!"barcodeList".equalsIgnoreCase(rowNode.getName())) {
                    String noteName = rowNode.getName();
                    String key = noteName.substring(noteName.lastIndexOf(".") + 1);
                    String objectValue = rowNode.getTextTrim();
                    entryRecodeInfo.setFparentBosType(configInfo.getDestBosType().toString());
                    entryRecodeInfo.setFbosType(bosType);
                    PropertyInfo property = entity.getPropertyByName(key);
                    BarcodeScanningPropertyInfo proInfo = XmlSerHelper.setPropertyValue(entryRecodeInfo, property, key, objectValue);
                    if ("fid".equals(key) && objectValue != null && !"".equals(objectValue)) {
                        key = "id";
                    }
                    entryPropertiesMap.put(key, proInfo);
                    if (!"D9D2CA5D".equalsIgnoreCase(configInfo.getDestBosType().toString()) || !"parent_number".equals(noteName) || objectValue == null || "".equals(objectValue)) continue;
                    countTingTableID = objectValue.toString();
                    continue;
                }
                List barcodeList = rowNode.getChildren();
                ArrayList<BarcodeScanningBarcodeInfo> barcodeScanningBarcodeList = new ArrayList<BarcodeScanningBarcodeInfo>();
                int f = barcodeList.size();
                for (int h = 0; h < f; ++h) {
                    BarcodeScanningBarcodeInfo barcodeInfo = new BarcodeScanningBarcodeInfo();
                    Element barcodeNode = (Element)barcodeList.get(h);
                    String barcodeRuleId = barcodeNode.getAttributeValue("barcodeRuleId");
                    String value = barcodeNode.getAttributeValue("value");
                    String barcodeQty = barcodeNode.getAttributeValue("barcodeQty");
                    if (barcodeQty == null) {
                        barcodeQty = barcodeNode.getAttributeValue("barcodeQ");
                    }
                    barcodeInfo.setBarcode(value);
                    barcodeInfo.setBarcodeRuleId(barcodeRuleId);
                    if (barcodeQty != null && !"".equals(barcodeQty)) {
                        barcodeInfo.setBarcodeQty(new BigDecimal(barcodeQty));
                    }
                    barcodeScanningBarcodeList.add(barcodeInfo);
                }
                entryRecodeInfo.setBarcodeList(barcodeScanningBarcodeList);
            }
            entryRecodeInfo.setPDA(true);
            entryRecodeInfo.setProperties(entryPropertiesMap);
            if (countTingTableID != null) {
                if (!countingTableRow.containsKey(countTingTableID)) {
                    ArrayList<BarcodeScanningRecodeInfo> newentryRecodeList = new ArrayList<BarcodeScanningRecodeInfo>();
                    newentryRecodeList.add(entryRecodeInfo);
                    countingTableRow.put(countTingTableID, newentryRecodeList);
                } else {
                    List newentryRecodeList = (List)countingTableRow.get(countTingTableID);
                    newentryRecodeList.add(entryRecodeInfo);
                    countingTableRow.put(countTingTableID, newentryRecodeList);
                }
            } else {
                countingTableRow = null;
            }
            entryRecodeList.add(entryRecodeInfo);
        }
        entriesMap.put(entriesMapkey, entryRecodeList);
        return countingTableRow;
    }

    public static BarcodeScanningPropertyInfo setPropertyValue(BarcodeScanningRecodeInfo recodeInfo, PropertyInfo property, String key, Object objectValue) {
        BarcodeScanningPropertyInfo proInfo = new BarcodeScanningPropertyInfo();
        if (property != null) {
            String dataType = property.getString("dataType");
            if (dataType.equals("Date")) {
                if (objectValue != null && !"".equals(objectValue)) {
                    objectValue = Date.valueOf(objectValue.toString());
                }
            } else if (dataType.equals("TimeStamp") && objectValue != null && !"".equals(objectValue)) {
                objectValue = Timestamp.valueOf(objectValue.toString());
            }
            Object txtValue = BarcodeClientUtils.getSingleValue(objectValue, property);
            if (property instanceof LinkPropertyInfo) {
                String filedNumber = key + "_number";
                proInfo = new BarcodeScanningPropertyInfo();
                proInfo.setKey(filedNumber);
                proInfo.setValue(txtValue);
            } else {
                proInfo = new BarcodeScanningPropertyInfo();
                proInfo.setKey(key);
                proInfo.setValue(txtValue);
            }
        } else if (key.indexOf("_") != -1) {
            proInfo.setKey(key);
            proInfo.setValue(objectValue);
        } else {
            proInfo.setKey(key);
            proInfo.setValue(objectValue);
            if (objectValue != null) {
                if ("fid".equalsIgnoreCase(key)) {
                    recodeInfo.setFid(objectValue.toString());
                }
                if ("fsrcBillId".equalsIgnoreCase(key)) {
                    recodeInfo.setFsrcBillId(objectValue.toString());
                }
                if ("fsrcEntryId".equalsIgnoreCase(key)) {
                    recodeInfo.setFsrcEntryId(objectValue.toString());
                }
            }
        }
        return proInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BarcodePDataInfo parseXml(String xml) {
        BarcodePDataInfo pInfo = null;
        StringReader strR = null;
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            int i;
            strR = new StringReader(xml);
            doc = builder.build((Reader)strR);
            Element root = doc.getRootElement();
            List cNodes = root.getChildren();
            pInfo = new BarcodePDataInfo();
            HashMap<String, String> billData = new HashMap<String, String>();
            ArrayList entriesData = new ArrayList();
            ArrayList custTables = new ArrayList();
            HashMap<String, String> params = new HashMap<String, String>();
            int n = cNodes.size();
            for (i = 0; i < n; ++i) {
                Element cNode = (Element)cNodes.get(i);
                if (cNode.getName().equals("DBServer")) {
                    pInfo.setDbHost(cNode.getTextTrim());
                    continue;
                }
                if (cNode.getName().equals("DBName")) {
                    pInfo.setDbName(cNode.getTextTrim());
                    continue;
                }
                if (cNode.getName().equals("DBUsername")) {
                    pInfo.setDbUserName(cNode.getTextTrim());
                    continue;
                }
                if (cNode.getName().equals("DBPassword")) {
                    pInfo.setDbPassword(cNode.getTextTrim());
                    continue;
                }
                if (cNode.getName().equals("K3Usernumber")) {
                    pInfo.setAppUserNum(cNode.getTextTrim());
                    billData.put("K3Usernumber", pInfo.getAppUserNum());
                    continue;
                }
                if (cNode.getName().equals("K3UserID")) {
                    pInfo.setAppUserId(cNode.getTextTrim());
                    billData.put("K3UserID", pInfo.getAppUserId());
                    continue;
                }
                if (cNode.getName().equals("BillTranID")) {
                    pInfo.setBusinessType(cNode.getTextTrim());
                    continue;
                }
                if (cNode.getName().equals("BillRobID")) {
                    pInfo.setBillRedBlue(cNode.getTextTrim());
                    continue;
                }
                if (cNode.getName().equals("ReloadTypeMapping")) {
                    pInfo.setReloadTypeMapping("true");
                    continue;
                }
                if (cNode.getName().equals("BillData")) {
                    List rows = cNode.getChildren("Row");
                    int p = rows.size();
                    for (int k = 0; k < p; ++k) {
                        Element row = (Element)rows.get(k);
                        List rNodes = row.getChildren();
                        HashMap<String, String> entryData = new HashMap<String, String>();
                        int m = rNodes.size();
                        for (int j = 0; j < m; ++j) {
                            Element node = (Element)rNodes.get(j);
                            entryData.put(node.getName(), node.getTextTrim());
                        }
                        entriesData.add(entryData);
                    }
                    continue;
                }
                if (cNode.getName().equals("Params")) {
                    List pNodes = cNode.getChildren();
                    int m = pNodes.size();
                    for (int j = 0; j < m; ++j) {
                        Element pNode = (Element)pNodes.get(j);
                        params.put(pNode.getName(), pNode.getTextTrim());
                    }
                    continue;
                }
                if (cNode.getName().equals("BusinessType")) {
                    XmlSerHelper.getCustTables(pInfo, cNode);
                    continue;
                }
                billData.put(cNode.getName(), cNode.getTextTrim());
            }
            pInfo.setParams(params);
            pInfo.setBillData(billData);
            pInfo.setEntriesData(entriesData);
            n = custTables.size();
            for (i = 0; i < n; ++i) {
                TableInfo tInfo = (TableInfo)custTables.get(i);
                if (tInfo.getType().equals("Head")) {
                    pInfo.setBillTable(tInfo.getTableName());
                    continue;
                }
                if (!tInfo.getType().equals("Body")) continue;
                pInfo.setEntryTable(tInfo.getTableName());
            }
        }
        catch (JDOMException e) {
            logger.error((Object)" parse input xml, cannot parse it", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)" prase xml, io error ", (Throwable)e);
        }
        finally {
            if (strR != null) {
                try {
                    ((Reader)strR).close();
                }
                catch (IOException e) {
                    logger.error((Object)" faile to close strR ", (Throwable)e);
                }
            }
        }
        return pInfo;
    }

    private static void getCustTables(BarcodePDataInfo pInfo, Element node) {
        List cNodes = node.getChildren();
        ArrayList<TableInfo> entriesTable = new ArrayList<TableInfo>();
        int n = cNodes.size();
        for (int i = 0; i < n; ++i) {
            Element cNode = (Element)cNodes.get(i);
            TableInfo tblInfo = new TableInfo();
            tblInfo.setTableName(cNode.getAttributeValue("Name"));
            tblInfo.setType(cNode.getAttributeValue("Type"));
            List fNodes = cNode.getChildren();
            ArrayList<CustMappingInfo> custMappings = new ArrayList<CustMappingInfo>();
            int m = fNodes.size();
            for (int j = 0; j < m; ++j) {
                Element fNode = (Element)fNodes.get(j);
                Element sNode = fNode.getChild("SourceField");
                CustMappingInfo mInfo = new CustMappingInfo();
                mInfo.setFieldType(fNode.getAttributeValue("Type"));
                mInfo.setSourceField(fNode.getChildText("SourceField"));
                mInfo.setTargetField(fNode.getChildText("TargetField"));
                mInfo.setFormula(sNode.getAttributeValue("Formual"));
                custMappings.add(mInfo);
            }
            tblInfo.setCustMappingInfo(custMappings);
            if (tblInfo.getType().equals("Head")) {
                pInfo.setBillTableInfo(tblInfo);
                continue;
            }
            entriesTable.add(tblInfo);
        }
        pInfo.setEntriesTableInfo(entriesTable);
    }
}

