/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTMappingUtil;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.pda.BarcodeLicenseUtils;
import com.kingdee.eas.barcode.pda.BarcodePDARecodeInfo;
import com.kingdee.eas.barcode.pda.BarcodePDARuleInfo;
import com.kingdee.eas.barcode.pda.BarcodePDAScanning;
import com.kingdee.eas.barcode.pda.BarcodeTerminalFactory;
import com.kingdee.eas.barcode.pda.BarcodeTerminalInfo;
import com.kingdee.eas.barcode.pda.FileObject;
import com.kingdee.eas.barcode.pda.PrivateUtil;
import com.kingdee.eas.barcode.pda.XmlSerHelper;
import com.kingdee.eas.barcode.pda.app.AbstractBarcodePdaBasedataFacadeControllerBean;
import com.kingdee.eas.barcode.scm.AbstractBarcodeConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeAnalysisResult;
import com.kingdee.eas.barcode.scm.BarcodeAnalysisResultItem;
import com.kingdee.eas.barcode.scm.BarcodeConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodeConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeConfigXML;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLDetail;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLProperty;
import com.kingdee.eas.barcode.scm.BarcodeDefaultSolutionFactory;
import com.kingdee.eas.barcode.scm.BarcodeDefaultSolutionInfo;
import com.kingdee.eas.barcode.scm.BarcodeDefaultXMLInfo;
import com.kingdee.eas.barcode.scm.BarcodeDefaultXMLItem;
import com.kingdee.eas.barcode.scm.BarcodeDossierCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.BarcodeDossierInfo;
import com.kingdee.eas.barcode.scm.BarcodeRuleCollection;
import com.kingdee.eas.barcode.scm.BarcodeRuleFactory;
import com.kingdee.eas.barcode.scm.BarcodeRuleInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningFactory;
import com.kingdee.eas.barcode.scm.BarcodeScanningRecodeInfo;
import com.kingdee.eas.barcode.scm.BarcodeUploadFacadeFactory;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.BarcodeWSException;
import com.kingdee.eas.barcode.scm.BarcodeXMLHelper;
import com.kingdee.eas.barcode.scm.FtpConfigCollection;
import com.kingdee.eas.barcode.scm.FtpConfigFactory;
import com.kingdee.eas.barcode.scm.FtpConfigInfo;
import com.kingdee.eas.barcode.scm.IBarcodeScanning;
import com.kingdee.eas.barcode.scm.IPackageBarcode;
import com.kingdee.eas.barcode.scm.IPackageBarcodeEntry;
import com.kingdee.eas.barcode.scm.OrgUnitUtils;
import com.kingdee.eas.barcode.scm.PackageBarcodeCollection;
import com.kingdee.eas.barcode.scm.PackageBarcodeEntryCollection;
import com.kingdee.eas.barcode.scm.PackageBarcodeEntryFactory;
import com.kingdee.eas.barcode.scm.PackageBarcodeEntryInfo;
import com.kingdee.eas.barcode.scm.PackageBarcodeFactory;
import com.kingdee.eas.barcode.scm.PackageBarcodeInfo;
import com.kingdee.eas.barcode.scm.ScanTaskBillFactory;
import com.kingdee.eas.barcode.scm.StatusEnum;
import com.kingdee.eas.barcode.scm.SynDataBaseCollection;
import com.kingdee.eas.barcode.scm.SynDataBaseFactory;
import com.kingdee.eas.barcode.scm.SynDataBaseInfo;
import com.kingdee.eas.barcode.scm.app.BarcodeServerUtils;
import com.kingdee.eas.barcode.scm.util.AttachmentServerManager;
import com.kingdee.eas.barcode.scm.util.BarcodeClientUtils;
import com.kingdee.eas.base.attachment.AttachmentCollection;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.form.ide.utils.EntityObjectInfoHelp;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IAsstAttrValue;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.TimeUnitEnum;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaStocktakingBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaStocktakingBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingBillInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.IObjectBase;
import com.kingdee.eas.framework.ObjectBaseCollection;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityCollection;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityFactory;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityInfo;
import com.kingdee.eas.scm.im.inv.IDateOfMinDurability;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InventoryCollection;
import com.kingdee.eas.scm.im.inv.InventoryFactory;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillInfo;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.MoveIssueBillInfo;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.util.BASE64Encoder;
import com.kingdee.eas.util.CryptException;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.castor.core.util.Base64Decoder;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Text;
import org.jdom2.input.SAXBuilder;

public class BarcodePdaBasedataFacadeControllerBean
extends AbstractBarcodePdaBasedataFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.pda.app.BarcodePdaBasedataFacadeControllerBean");
    private String resourceBaseStr = "com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource";
    public static final String resource = "com.kingdee.eas.scm.im.inv.WarehsManageResource";
    private Map mapDurability = new HashMap(0);

    public Map getMapDurability() {
        return this.mapDurability;
    }

    public void setMapDurability(Map mapDurability) {
        this.mapDurability = mapDurability;
    }

    private void initContext(Context ctx) throws BOSException {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (user.getDefOrgUnit() != null) {
            try {
                OrgSwitchFacadeFactory.getLocalInstance((Context)ctx).orgSwitch(user.getDefOrgUnit().getId().toString());
            }
            catch (EASBizException e) {
                e.printStackTrace();
                throw new BOSException("\u7528\u6237\u65e0\u7f3a\u7701\u7ec4\u7ec7");
            }
        }
    }

    @Override
    protected String _getMethod(Context ctx, String argumentXml) throws BOSException, EASBizException {
        logger.info((Object)("_getMethod,argumentXML:" + argumentXml));
        Map<String, String> argumentMap = this.parseXml(argumentXml);
        String CsName = argumentMap.get("CsName");
        String function = argumentMap.get("Function");
        String paramsStr = argumentMap.get("Params");
        String[] arrStr = paramsStr.split("\\|");
        String deviceid = argumentMap.get("deviceId");
        if (deviceid != null) {
            try {
                BarcodeLicenseUtils.checkLicense(ctx, true, null, deviceid);
            }
            catch (LicenseException e) {
                throw new BarcodeWSException(new NumericExceptionSubItem("", e.fillInStackTrace().getMessage()));
            }
        }
        try {
            Class<?> barcodeBaseDataClass = Class.forName(CsName);
            this.initContext(ctx);
            Object object = PrivateUtil.invoke(barcodeBaseDataClass.newInstance(), function, new Class[]{Context.class, Object[].class}, new Object[]{ctx, arrStr});
            return object == null ? "" : object.toString();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new BarcodeWSException(new NumericExceptionSubItem("", e.fillInStackTrace().getMessage()));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new BarcodeWSException(BarcodeWSException.DATABULL);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new BarcodeWSException(new NumericExceptionSubItem("", e.getTargetException().getMessage()));
        }
        catch (SecurityException e) {
            e.printStackTrace();
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new BarcodeWSException(BarcodeWSException.DATABULL);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new BarcodeWSException(BarcodeWSException.METHODNULL);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new BarcodeWSException(BarcodeWSException.DATABULL);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new BarcodeWSException(BarcodeWSException.DATABULL);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new BarcodeWSException(new NumericExceptionSubItem("", e.getMessage()));
        }
    }

    private Map<String, String> parseXml(String argumentStr) throws BarcodeWSException {
        HashMap<String, String> xmlMap = new HashMap<String, String>();
        StringReader strR = null;
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        strR = new StringReader(argumentStr);
        try {
            doc = builder.build((Reader)strR);
            Element root = doc.getRootElement();
            List cNodes = root.getChildren();
            List paremList = root.getChildren("Params");
            for (int j = 0; j < cNodes.size(); ++j) {
                Element xet = (Element)cNodes.get(j);
                int size = xet.getContent().size();
                for (int i = 0; i < size; ++i) {
                    Object content = xet.getContent().get(i);
                    if (!(content instanceof Text)) continue;
                    String key = xet.getName();
                    String value = ((Text)xet.getContent().get(i)).getText();
                    if (xmlMap.containsKey(key)) continue;
                    xmlMap.put(key, value);
                }
            }
            StringBuffer sbf = new StringBuffer();
            for (int j = 0; j < paremList.size(); ++j) {
                Element xet = (Element)paremList.get(j);
                int size = xet.getContent().size();
                for (int i = 0; i < size; ++i) {
                    Element paEle;
                    Object content = xet.getContent().get(i);
                    if (!(content instanceof Element) || (paEle = (Element)content).getContent().size() <= 0) continue;
                    String value = ((Text)paEle.getContent().get(0)).getText();
                    if (sbf.length() > 0) {
                        sbf.append("|").append(value);
                        continue;
                    }
                    sbf.append(value);
                }
            }
            xmlMap.put("Params", sbf.toString());
        }
        catch (JDOMException e) {
            e.printStackTrace();
            throw new BarcodeWSException(new NumericExceptionSubItem("", "XML\u683c\u5f0f\u4e0d\u652f\u6301!"));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BarcodeWSException(new NumericExceptionSubItem("", "XML\u683c\u5f0f\u4e0d\u652f\u6301!"));
        }
        return xmlMap;
    }

    @Override
    protected String _importBill(Context ctx, String xmlStr) throws BOSException, EASBizException {
        JSONObject object = JSONObject.fromObject((Object)xmlStr);
        String puuid = object.get("puuid").toString();
        String data = object.get("data").toString();
        BarcodeTerminalInfo barcodeTerminalInfo = new BarcodeTerminalInfo();
        barcodeTerminalInfo.setPuuid(puuid);
        barcodeTerminalInfo.setDetailsData(data);
        barcodeTerminalInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        barcodeTerminalInfo.setCreateTime(this.getTime());
        barcodeTerminalInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        barcodeTerminalInfo.setLastUpdateTime(this.getTime());
        IObjectPK pk = BarcodeTerminalFactory.getLocalInstance(ctx).save((CoreBaseInfo)barcodeTerminalInfo);
        String messageStr = null;
        if (pk != null) {
            JSONObject returnObje = new JSONObject();
            String guuid = null;
            String barcodeStr = null;
            try {
                xmlStr = this.unzip(data);
                Document doc = XmlSerHelper.preseXmlToDoc(xmlStr);
                guuid = XmlSerHelper.getGuuID(doc);
                barcodeStr = XmlSerHelper.getBarcodeStr(ctx, doc);
                String mesg = this.parseXmlSaveInfo(ctx, guuid, barcodeStr, doc, xmlStr);
                if (barcodeStr != null && barcodeStr.length() > 0) {
                    long time = System.currentTimeMillis();
                    BarcodeServerUtils.clearBarcodeMap(guuid, barcodeStr);
                    logger.info((Object)(" clearOnly  totalTime=\uff1a" + (System.currentTimeMillis() - time) / 1000L + "S"));
                }
                if (mesg == null || "".equals(mesg)) {
                    returnObje.put((Object)"state", (Object)0);
                    returnObje.put((Object)"msg", (Object)"");
                } else {
                    returnObje.put((Object)"state", (Object)1);
                    returnObje.put((Object)"msg", (Object)mesg);
                }
            }
            catch (BOSException e1) {
                e1.printStackTrace();
                returnObje.put((Object)"state", (Object)0);
                String message = e1.getMessage();
                if (message != null) {
                    message = message.substring(message.indexOf(":") + 1, message.length());
                }
                returnObje.put((Object)"msg", (Object)message);
                BarcodeServerUtils.clearMap(guuid, barcodeStr);
            }
            catch (EASBizException e1) {
                e1.printStackTrace();
                returnObje.put((Object)"state", (Object)0);
                String message = e1.getMessage();
                if (message != null) {
                    message = message.substring(message.indexOf(":") + 1, message.length());
                }
                returnObje.put((Object)"msg", (Object)message);
                BarcodeServerUtils.clearMap(guuid, barcodeStr);
            }
            catch (Exception e) {
                e.printStackTrace();
                returnObje.put((Object)"state", (Object)0);
                String message = e.getMessage();
                if (message != null) {
                    message = message.substring(message.indexOf(":") + 1, message.length());
                }
                returnObje.put((Object)"msg", (Object)message);
                BarcodeServerUtils.clearMap(guuid, barcodeStr);
            }
            messageStr = returnObje.toString();
        }
        logger.info((Object)(" messageStr  \uff1a" + messageStr));
        return messageStr;
    }

    private String parseXmlSaveInfo(Context ctx, String guuid, String barcodeStr, Document doc, String xmlStr) throws BarcodeWSException, Exception {
        String[] bar;
        String bars;
        if (StringUtils.isEmpty((String)xmlStr)) {
            logger.info((Object)" xmlStr is null");
            throw new BarcodeWSException(BarcodeWSException.NULL_XML);
        }
        long time = System.currentTimeMillis();
        logger.info((Object)(" parseRecodeXml begin\uff1a" + time));
        if (barcodeStr != null && barcodeStr.length() > 0 && (bars = BarcodeServerUtils.checkReaptBarcode(ctx, bar = barcodeStr.split(","), guuid)).length() > 0) {
            throw new BarcodeWSException(BarcodeWSException.BARCODEREPEATSUBMIT, new String[]{bars});
        }
        if (null != guuid) {
            String billNumber = BarcodeServerUtils.checkReaptBill(ctx, guuid);
            if (billNumber != null && !"submit".equals(billNumber)) {
                throw new BarcodeWSException(BarcodeWSException.GUUIDREPEATSUBMIT, new String[]{billNumber});
            }
            if (billNumber != null && "submit".equals(billNumber)) {
                throw new BarcodeWSException(BarcodeWSException.BILLSUBMINTING);
            }
        }
        String rev = this.parseXmlSaveInfo(ctx, doc);
        time = System.currentTimeMillis() - time;
        logger.info((Object)(" parseRecodeXml end,totalTime=\uff1a" + time));
        doc = null;
        return rev;
    }

    private String parseXmlSaveInfo(Context ctx, Document doc) throws BarcodeWSException, Exception {
        List<BarcodePDARecodeInfo> barcodePDARecodeInfoList = XmlSerHelper.parseRecodeXml(ctx, doc);
        AbstractBarcodeConfigInfo barcodeConfigInfo = null;
        ArrayList<BarcodeScanningRecodeInfo> recodeList = new ArrayList<BarcodeScanningRecodeInfo>();
        String defaultSolutionId = null;
        String srcBosType = null;
        String bosType = null;
        String botpId = null;
        int size = barcodePDARecodeInfoList.size();
        for (int i = 0; i < size; ++i) {
            BarcodePDARecodeInfo pdaRecodeInfo = barcodePDARecodeInfoList.get(i);
            defaultSolutionId = pdaRecodeInfo.getDefaultSolutionId();
            barcodeConfigInfo = pdaRecodeInfo.getConfigInfo();
            srcBosType = barcodeConfigInfo.getSrcBosType();
            bosType = barcodeConfigInfo.getDestBosType();
            botpId = barcodeConfigInfo.getBotMapping() != null ? barcodeConfigInfo.getBotMapping().getId().toString() : null;
            recodeList.add(pdaRecodeInfo.getScanningRecodeInfo());
        }
        if (barcodeConfigInfo != null && barcodeConfigInfo.isIsWholeScan()) {
            return this.getMassege(ctx, this.resourceBaseStr, "isIsWholeScan");
        }
        String number = null;
        if (recodeList.size() > 0) {
            number = BarcodeUploadFacadeFactory.getLocalInstance(ctx).uploadBarcodeBill(recodeList, defaultSolutionId, srcBosType, bosType, botpId);
        }
        if (number != null && !"".equals(number)) {
            String billStr = this.getMassege(ctx, this.resourceBaseStr, "211_PDABILL") + "\u3010" + number + "\u3011" + this.getMassege(ctx, this.resourceBaseStr, "210_PDABILL");
            return billStr;
        }
        return null;
    }

    public String getSrcBillList(Context ctx, Object[] argumentArg) throws EASBizException, BOSException {
        if (argumentArg.length < -1) {
            return null;
        }
        String barcodeConfigID = argumentArg[0].toString();
        String billNumber = argumentArg[1].toString();
        BarcodeConfigInfo configInfo = BarcodeConfigFactory.getLocalInstance(ctx).getBarcodeConfigInfo((IObjectPK)new ObjectUuidPK(barcodeConfigID));
        if (configInfo == null) {
            throw new BarcodeWSException(BarcodeWSException.CONFIGISNULL);
        }
        String warehouseNumber = null;
        String adminDept = null;
        String userDept = null;
        String pagerows = null;
        if ("D9D2CA5D".equalsIgnoreCase(configInfo.getDestBosType())) {
            if (argumentArg.length > 2) {
                warehouseNumber = argumentArg[2].toString();
            }
            if (argumentArg.length > 3) {
                pagerows = argumentArg[3].toString();
            }
        } else if ("84BEC1BB".equalsIgnoreCase(configInfo.getDestBosType())) {
            if (argumentArg.length > 2) {
                adminDept = argumentArg[2].toString();
            }
            if (argumentArg.length > 3) {
                userDept = argumentArg[3].toString();
            }
            if (argumentArg.length > 4) {
                pagerows = argumentArg[4].toString();
            }
        } else {
            if (argumentArg.length > 2) {
                warehouseNumber = argumentArg[2].toString();
            }
            if (argumentArg.length > 3) {
                pagerows = argumentArg[3].toString();
            }
        }
        long time1 = System.currentTimeMillis();
        IObjectCollection objectColl = (IObjectCollection)this.getDestBill(ctx, configInfo, billNumber, warehouseNumber, adminDept, userDept);
        long time2 = System.currentTimeMillis() - time1;
        logger.info((Object)("objectColl\uff1a" + time2));
        if (objectColl != null && objectColl.size() > 0) {
            int iprows;
            time1 = System.currentTimeMillis();
            IObjectValue billValue = null;
            if ("D9D2CA5D".equalsIgnoreCase(configInfo.getDestBosType())) {
                billValue = objectColl.getObject(0);
                IObjectCollection objectCol = (IObjectCollection)billValue.get("entry");
                int size = objectColl.size();
                for (int i = 1; i < size; ++i) {
                    IObjectValue newObjectValue = objectColl.getObject(i);
                    IObjectCollection newobjectCol = (IObjectCollection)newObjectValue.get("entry");
                    objectCol.addObjectCollection(newobjectCol);
                }
            } else {
                billValue = objectColl.getObject(0);
            }
            String srcBillStr = null;
            srcBillStr = pagerows != null && pagerows.length() > 0 ? ((iprows = Integer.parseInt(pagerows)) > 0 ? this.fillBilldata1(ctx, billValue, configInfo, iprows) : this.fillBilldata(ctx, billValue, configInfo)) : this.fillBilldata(ctx, billValue, configInfo);
            time2 = System.currentTimeMillis() - time1;
            logger.info((Object)("\u83b7\u53d6JSON\uff1a" + time2));
            logger.info((Object)("jeson\u5bf9\u8c61\u7684\u957f\u5ea6\uff1a" + srcBillStr.length()));
            return srcBillStr;
        }
        throw new BarcodeWSException(BarcodeWSException.QUERYNULL, new Object[]{billNumber});
    }

    private String fillBilldata1(Context ctx, IObjectValue billValue, BarcodeConfigInfo configInfo, int iprows) throws EASBizException, BOSException {
        JSONArray allArray = this.getBillDataAry(ctx, billValue, configInfo);
        String str = null;
        try {
            if (allArray.size() > 2) {
                BASE64Encoder beenCode;
                GZIPOutputStream gzip;
                ByteArrayOutputStream out;
                JSONArray tmpArray = new JSONArray();
                String tmpstr = null;
                int j = -1;
                for (int i = 0; i < allArray.size(); ++i) {
                    if (j < iprows) {
                        tmpArray.add(allArray.get(i));
                        ++j;
                        continue;
                    }
                    tmpstr = tmpArray.toString();
                    out = new ByteArrayOutputStream();
                    gzip = new GZIPOutputStream(out);
                    gzip.write(tmpArray.toString().getBytes("UTF-8"));
                    gzip.close();
                    beenCode = new BASE64Encoder();
                    tmpstr = beenCode.encode(out.toByteArray());
                    str = str != null && str.length() > 0 ? str + "||" + tmpstr : tmpstr;
                    tmpArray = new JSONArray();
                    tmpstr = null;
                    j = 0;
                    tmpArray.add(allArray.get(i));
                    ++j;
                }
                if (tmpArray.size() > 0) {
                    tmpstr = tmpArray.toString();
                    out = new ByteArrayOutputStream();
                    gzip = new GZIPOutputStream(out);
                    gzip.write(tmpArray.toString().getBytes("UTF-8"));
                    gzip.close();
                    beenCode = new BASE64Encoder();
                    tmpstr = beenCode.encode(out.toByteArray());
                    str = str != null && str.length() > 0 ? str + "||" + tmpstr : tmpstr;
                    tmpArray = null;
                    tmpstr = null;
                    j = 0;
                }
                logger.info((Object)("\u89e3\u538b\u540e\u957f\u5ea6\uff1a" + str.length()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BarcodeWSException(BarcodeWSException.SOURCEBILLFAIL);
        }
        return this.packageReturnXml(str);
    }

    private String fillBilldata(Context ctx, IObjectValue billValue, BarcodeConfigInfo configInfo) throws EASBizException, BOSException {
        JSONArray allArray = this.getBillDataAry(ctx, billValue, configInfo);
        String str = allArray.toString();
        if (allArray.size() > 0) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                GZIPOutputStream gzip = new GZIPOutputStream(out);
                gzip.write(allArray.toString().getBytes("UTF-8"));
                gzip.close();
                BASE64Encoder beenCode = new BASE64Encoder();
                str = beenCode.encode(out.toByteArray());
                logger.info((Object)("\u89e3\u538b\u540e\u957f\u5ea6\uff1a" + str.length()));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new BarcodeWSException(BarcodeWSException.SOURCEBILLFAIL);
            }
        }
        return this.packageReturnXml(str);
    }

    private JSONArray getBillDataAry(Context ctx, IObjectValue billValue, BarcodeConfigInfo configInfo) throws EASBizException, BOSException {
        JSONArray allArray = new JSONArray();
        JSONArray headArray = new JSONArray();
        int flowIndex = 0;
        headArray.add((Object)this.getJsonStr("Head", "1", this.getMassege(ctx, this.resourceBaseStr, "billHead"), false, false, ""));
        headArray.add((Object)this.getJsonStr("FLOWID", "" + flowIndex++, this.getMassege(ctx, this.resourceBaseStr, "billSeq"), false, false, "FLOWID"));
        headArray.add((Object)this.getJsonStr("id", billValue.get("id") != null ? billValue.get("id").toString() : "", "id", false, false, "id"));
        String bosType = "";
        IBarcodeScanning barcodeScanning = BarcodeScanningFactory.getLocalInstance(ctx);
        BarcodeConfigXML xmlInfo = BarcodeXMLHelper.toBarcodeConfigXML(configInfo.getDetailsXML());
        int size = xmlInfo.getDetails().size();
        for (int i = 0; i < 2; ++i) {
            BarcodeConfigXMLDetail xmlDetail = xmlInfo.getDetails().get(i);
            String parentBosType = xmlDetail.getParentBosType();
            List<BarcodeConfigXMLProperty> xmlPropertys = xmlDetail.getProperties();
            boolean isEntryBoType = false;
            if (parentBosType != null && !"".equals(parentBosType)) {
                isEntryBoType = true;
                bosType = "b_" + xmlDetail.getName() + "_" + xmlDetail.getBosType();
            }
            if (!isEntryBoType) {
                this.getLinkedPropertyXML(ctx, xmlPropertys, billValue, barcodeScanning, headArray, configInfo.getDestBosType());
                continue;
            }
            allArray.add((Object)headArray);
            IObjectCollection entryColl = (IObjectCollection)billValue.get(xmlDetail.getName());
            int m = entryColl.size();
            for (int k = 0; k < m; ++k) {
                JSONArray entryjsonArray = new JSONArray();
                entryjsonArray.add((Object)this.getJsonStr("FLOWID", "" + flowIndex++, this.getMassege(ctx, this.resourceBaseStr, "billSeq"), false, false, "FLOWID"));
                IObjectValue entryValue = entryColl.getObject(k);
                this.getLinkedPropertyXML(ctx, xmlPropertys, entryValue, barcodeScanning, entryjsonArray, configInfo.getDestBosType());
                allArray.add((Object)entryjsonArray);
            }
        }
        return allArray;
    }

    private void getLinkedPropertyXML(Context ctx, List<BarcodeConfigXMLProperty> xmlPropertys, IObjectValue entryValue, IBarcodeScanning barcodeScanning, JSONArray jsonArray, String destBosType) throws EASBizException, BOSException {
        for (int j = 0; j < xmlPropertys.size(); ++j) {
            String fullName;
            BarcodeConfigXMLProperty property = xmlPropertys.get(j);
            String key = fullName = property.getFullName();
            key = key.substring(key.lastIndexOf(".") + 1);
            if (property.isLinkedProperty()) {
                String filedNumber = key + "_number";
                String filedName = key + "_name";
                Object linkValue = entryValue.get(property.getName());
                if (linkValue != null) {
                    IObjectValue objectValue = (IObjectValue)linkValue;
                    Object number = objectValue != null ? objectValue.get("number") : null;
                    boolean isMaterialInfo = false;
                    if (objectValue != null && number == null && objectValue.get("id") != null) {
                        objectValue = (IObjectValue)barcodeScanning.getIObjectValueById(objectValue.get("id").toString());
                        if ("D9D2CA5D".equalsIgnoreCase(destBosType) && "parent_number".equals(filedNumber)) {
                            objectValue.put("number", (Object)objectValue.get("id").toString());
                        }
                        objectValue = (IObjectValue)barcodeScanning.getIObjectValueById(objectValue.get("id").toString());
                    }
                    if (objectValue instanceof MaterialInfo) {
                        isMaterialInfo = true;
                    }
                    String numberAlias = property.getAlias() + this.getMassege(ctx, this.resourceBaseStr, "145_BarcodeScanningEditUI");
                    String nameAlias = property.getAlias() + this.getMassege(ctx, this.resourceBaseStr, "103_BarcodeDefaultTablePanel");
                    jsonArray.add((Object)this.getJsonStr(filedNumber, objectValue != null ? objectValue.get("number") : null, numberAlias, property.isUnVisable(), property.isScanQty(), isMaterialInfo ? "FNumber" : filedNumber));
                    jsonArray.add((Object)this.getJsonStr(filedName, objectValue != null ? objectValue.get("name") : null, nameAlias, property.isUnVisable(), property.isScanQty(), isMaterialInfo ? "FName" : filedName));
                    if (!isMaterialInfo) continue;
                    jsonArray.add((Object)this.getJsonStr("material_model", objectValue != null ? objectValue.get("model") : null, this.getMassege(ctx, this.resourceBaseStr, "model"), property.isUnVisable(), property.isScanQty(), isMaterialInfo ? "FModel" : filedNumber));
                    continue;
                }
                jsonArray.add((Object)this.getJsonStr(filedNumber, entryValue.get(key), property.getAlias(), property.isUnVisable(), property.isScanQty(), key));
                continue;
            }
            if (property.isScanQty()) {
                BigDecimal qty;
                BigDecimal accountQty;
                String srcQtyStr = this.getMassege(ctx, this.resourceBaseStr, "146_BarcodeScanningEditUI");
                if (entryValue.get(key) instanceof BigDecimal && entryValue.get(key) != null) {
                    BigDecimal qty2 = (BigDecimal)entryValue.get(key);
                    if (qty2.compareTo(BigDecimal.ZERO) == 0) {
                        entryValue.put(key, (Object)BigDecimal.ZERO);
                    } else {
                        entryValue.put(key, (Object)new BigDecimal(qty2.stripTrailingZeros().toPlainString()));
                    }
                }
                if ("D9D2CA5D".equalsIgnoreCase(destBosType)) {
                    accountQty = BigDecimal.ZERO;
                    qty = BigDecimal.ZERO;
                    BigDecimal adjustQty = BigDecimal.ZERO;
                    if (entryValue.get("accountQty") != null) {
                        accountQty = new BigDecimal(entryValue.get("accountQty").toString());
                        accountQty = new BigDecimal(accountQty.stripTrailingZeros().toPlainString());
                    }
                    if (entryValue.get(key) != null) {
                        qty = new BigDecimal(entryValue.get(key).toString());
                        qty = new BigDecimal(qty.stripTrailingZeros().toPlainString());
                    }
                    if (entryValue.get("adjustQty") != null) {
                        adjustQty = new BigDecimal(entryValue.get("adjustQty").toString());
                        adjustQty = new BigDecimal(adjustQty.stripTrailingZeros().toPlainString());
                    }
                    jsonArray.add((Object)this.getJsonStr("fsrcQty", accountQty.toBigInteger(), srcQtyStr, true, false, "fsrcQty"));
                    jsonArray.add((Object)this.getJsonStr(fullName, entryValue.get(key), property.getAlias(), true, property.isScanQty(), fullName));
                    String difQtyStr = this.getMassege(ctx, this.resourceBaseStr, "148_BarcodeScanningEditUI");
                    jsonArray.add((Object)this.getJsonStr("fdifQty", qty.subtract(accountQty).subtract(adjustQty).stripTrailingZeros().toPlainString(), difQtyStr, true, false, "fdifQty"));
                    continue;
                }
                if ("84BEC1BB".equalsIgnoreCase(destBosType)) {
                    accountQty = BigDecimal.ZERO;
                    qty = BigDecimal.ZERO;
                    if (entryValue.get("assetAmt") != null) {
                        accountQty = new BigDecimal(entryValue.get("assetAmt").toString());
                        if (BigDecimal.ZERO.compareTo(accountQty) == 0) {
                            accountQty = BigDecimal.ZERO;
                        }
                        accountQty = new BigDecimal(accountQty.stripTrailingZeros().toPlainString());
                    }
                    if (entryValue.get(key) != null) {
                        qty = new BigDecimal(entryValue.get(key).toString());
                        qty = new BigDecimal(qty.stripTrailingZeros().toPlainString());
                    }
                    jsonArray.add((Object)this.getJsonStr("fsrcQty", accountQty, srcQtyStr, true, false, "fsrcQty"));
                    jsonArray.add((Object)this.getJsonStr(fullName, entryValue.get(key), property.getAlias(), true, property.isScanQty(), fullName));
                    String difQtyStr = this.getMassege(ctx, this.resourceBaseStr, "148_BarcodeScanningEditUI");
                    jsonArray.add((Object)this.getJsonStr("fdifQty", qty.subtract(accountQty).stripTrailingZeros().toPlainString(), difQtyStr, true, false, "fdifQty"));
                    continue;
                }
                if ("BA8AD747".equalsIgnoreCase(destBosType)) {
                    jsonArray.add((Object)this.getJsonStr(fullName, entryValue.get(key), property.getAlias(), true, property.isScanQty(), fullName));
                    continue;
                }
                jsonArray.add((Object)this.getJsonStr(fullName, BigDecimal.ZERO, property.getAlias(), true, property.isScanQty(), fullName));
                jsonArray.add((Object)this.getJsonStr("fsrcQty", entryValue.get(key), srcQtyStr, true, false, "fsrcQty"));
                String difQtyStr = this.getMassege(ctx, this.resourceBaseStr, "148_BarcodeScanningEditUI");
                jsonArray.add((Object)this.getJsonStr("fdifQty", entryValue.get(key), difQtyStr, true, false, "fdifQty"));
                continue;
            }
            Object value = BarcodeUtils.getValue(entryValue, property, key);
            jsonArray.add((Object)this.getJsonStr(fullName, value, property.getAlias(), property.isUnVisable(), property.isScanQty(), fullName));
        }
        jsonArray.add((Object)this.getJsonStr("fid", entryValue.get("id") != null ? entryValue.get("id").toString() : "", "fid", false, false, "fid"));
        jsonArray.add((Object)this.getJsonStr("fsrcBillId", entryValue.get("sourceBillId"), "sourceBillId", false, false, "fsrcBillId"));
        jsonArray.add((Object)this.getJsonStr("fsrcEntryId", entryValue.get("sourceBillEntryId"), "sourceBillEntryId", false, false, "fsrcEntryId"));
    }

    private JSONObject getJsonStr(String propertyName, Object value, String alias, boolean isUnVisable, boolean isScanQty, String aliasName) {
        if (value == null) {
            value = "";
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"Key", (Object)propertyName);
        if (value != null && !"".equals(value)) {
            jsonObj.put((Object)"value", (Object)value.toString());
        } else {
            jsonObj.put((Object)"value", (Object)"");
        }
        jsonObj.put((Object)"alias", (Object)alias);
        jsonObj.put((Object)"aliasName", (Object)aliasName);
        jsonObj.put((Object)"spc", (Object)"");
        jsonObj.put((Object)"isScanQty", (Object)isScanQty);
        return jsonObj;
    }

    private JSONObject getBarcodeJsonStr(String propertyName, Object value, String aliasName, boolean isMatchItem) {
        if (value == null) {
            value = "";
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"Key", (Object)propertyName);
        if (value != null && !"".equals(value)) {
            jsonObj.put((Object)"value", (Object)value.toString());
        } else {
            jsonObj.put((Object)"value", (Object)"");
        }
        jsonObj.put((Object)"aliasName", (Object)aliasName);
        jsonObj.put((Object)"isMatchItem", (Object)isMatchItem);
        return jsonObj;
    }

    private void getLinkedPropertyXML(Context ctx, List<BarcodeConfigXMLProperty> xmlPropertys, IObjectValue entryValue, IBarcodeScanning barcodeScanning, StringBuffer detailsXml, String destBosType) throws EASBizException, BOSException {
        for (int j = 0; j < xmlPropertys.size(); ++j) {
            String fullName;
            BarcodeConfigXMLProperty property = xmlPropertys.get(j);
            String key = fullName = property.getFullName();
            key = key.substring(key.lastIndexOf(".") + 1);
            if (property.isLinkedProperty()) {
                String filedNumber = key + "_number";
                String filedName = key + "_name";
                Object linkValue = entryValue.get(property.getName());
                if (linkValue != null) {
                    IObjectValue objectValue = (IObjectValue)linkValue;
                    Object number = objectValue.get("number");
                    boolean isMaterialInfo = false;
                    if (number == null && objectValue.get("id") != null) {
                        objectValue = (IObjectValue)barcodeScanning.getIObjectValueById(objectValue.get("id").toString());
                    }
                    if (objectValue instanceof MaterialInfo) {
                        isMaterialInfo = true;
                    }
                    String numberAlias = property.getAlias() + this.getMassege(ctx, this.resourceBaseStr, "145_BarcodeScanningEditUI");
                    String nameAlias = property.getAlias() + this.getMassege(ctx, this.resourceBaseStr, "103_BarcodeDefaultTablePanel");
                    if (objectValue == null) continue;
                    detailsXml.append(this.getXmlStr(filedNumber, objectValue.get("number"), numberAlias, property.isUnVisable(), property.isScanQty(), isMaterialInfo ? "FNumber" : filedNumber)).append("\n");
                    detailsXml.append(this.getXmlStr(filedName, objectValue.get("name"), nameAlias, property.isUnVisable(), property.isScanQty(), isMaterialInfo ? "FName" : filedName)).append("\n");
                    if (!isMaterialInfo) continue;
                    detailsXml.append(this.getXmlStr("material_model", objectValue.get("model"), this.getMassege(ctx, this.resourceBaseStr, "model"), property.isUnVisable(), property.isScanQty(), isMaterialInfo ? "FModel" : filedNumber)).append("\n");
                    continue;
                }
                detailsXml.append(this.getXmlStr(filedNumber, entryValue.get(key), property.getAlias(), property.isUnVisable(), property.isScanQty(), key)).append("\n");
                continue;
            }
            if (property.isScanQty()) {
                BigDecimal qty;
                BigDecimal accountQty;
                String srcQtyStr = this.getMassege(ctx, this.resourceBaseStr, "146_BarcodeScanningEditUI");
                if (entryValue.get(key) instanceof BigDecimal && entryValue.get(key) != null) {
                    BigDecimal qty2 = (BigDecimal)entryValue.get(key);
                    if (qty2.compareTo(BigDecimal.ZERO) == 0) {
                        entryValue.put(key, (Object)BigDecimal.ZERO);
                    } else {
                        entryValue.put(key, (Object)new BigDecimal(qty2.stripTrailingZeros().toPlainString()));
                    }
                }
                if ("D9D2CA5D".equalsIgnoreCase(destBosType)) {
                    accountQty = BigDecimal.ZERO;
                    qty = BigDecimal.ZERO;
                    BigDecimal adjustQty = BigDecimal.ZERO;
                    if (entryValue.get("accountQty") != null) {
                        accountQty = new BigDecimal(entryValue.get("accountQty").toString());
                        accountQty = new BigDecimal(accountQty.stripTrailingZeros().toPlainString());
                    }
                    if (entryValue.get(key) != null) {
                        qty = new BigDecimal(entryValue.get(key).toString());
                        qty = new BigDecimal(qty.stripTrailingZeros().toPlainString());
                    }
                    if (entryValue.get("adjustQty") != null) {
                        adjustQty = new BigDecimal(entryValue.get("adjustQty").toString());
                        adjustQty = new BigDecimal(adjustQty.stripTrailingZeros().toPlainString());
                    }
                    detailsXml.append(this.getXmlStr("fsrcQty", accountQty, srcQtyStr, true, false, "fsrcQty")).append("\n");
                    detailsXml.append(this.getXmlStr(fullName, entryValue.get(key), property.getAlias(), true, property.isScanQty(), fullName)).append("\n");
                    String difQtyStr = this.getMassege(ctx, this.resourceBaseStr, "148_BarcodeScanningEditUI");
                    detailsXml.append(this.getXmlStr("fdifQty", qty.subtract(accountQty).subtract(adjustQty).stripTrailingZeros().toPlainString(), difQtyStr, true, false, "fdifQty")).append("\n");
                    continue;
                }
                if ("84BEC1BB".equalsIgnoreCase(destBosType)) {
                    accountQty = BigDecimal.ZERO;
                    qty = BigDecimal.ZERO;
                    if (entryValue.get("assetAmt") != null) {
                        accountQty = new BigDecimal(entryValue.get("assetAmt").toString());
                        accountQty = new BigDecimal(accountQty.stripTrailingZeros().toPlainString());
                    }
                    if (entryValue.get(key) != null) {
                        qty = new BigDecimal(entryValue.get(key).toString());
                        qty = new BigDecimal(qty.stripTrailingZeros().toPlainString());
                    }
                    detailsXml.append(this.getXmlStr("fsrcQty", accountQty, srcQtyStr, true, false, "fsrcQty")).append("\n");
                    detailsXml.append(this.getXmlStr(fullName, entryValue.get(key), property.getAlias(), true, property.isScanQty(), fullName)).append("\n");
                    String difQtyStr = this.getMassege(ctx, this.resourceBaseStr, "148_BarcodeScanningEditUI");
                    detailsXml.append(this.getXmlStr("fdifQty", qty.subtract(accountQty).stripTrailingZeros().toPlainString(), difQtyStr, true, false, "fdifQty")).append("\n");
                    continue;
                }
                if ("BA8AD747".equalsIgnoreCase(destBosType)) {
                    detailsXml.append(this.getXmlStr(fullName, entryValue.get(key), property.getAlias(), true, property.isScanQty(), fullName)).append("\n");
                    continue;
                }
                detailsXml.append(this.getXmlStr(fullName, BigDecimal.ZERO, property.getAlias(), true, property.isScanQty(), fullName)).append("\n");
                detailsXml.append(this.getXmlStr("fsrcQty", entryValue.get(key), srcQtyStr, true, false, "fsrcQty")).append("\n");
                String difQtyStr = this.getMassege(ctx, this.resourceBaseStr, "148_BarcodeScanningEditUI");
                detailsXml.append(this.getXmlStr("fdifQty", entryValue.get(key), difQtyStr, true, false, "fdifQty")).append("\n");
                continue;
            }
            detailsXml.append(this.getXmlStr(fullName, entryValue.get(key), property.getAlias(), property.isUnVisable(), property.isScanQty(), fullName)).append("\n");
        }
        detailsXml.append(this.getXmlStr("fid", entryValue.get("id"), "fid", false, false, "fid")).append("\n");
        detailsXml.append(this.getXmlStr("fsrcBillId", entryValue.get("sourceBillId"), "sourceBillId", false, false, "fsrcBillId")).append("\n");
        detailsXml.append(this.getXmlStr("fsrcEntryId", entryValue.get("sourceBillEntryId"), "sourceBillEntryId", false, false, "fsrcEntryId")).append("\n");
    }

    private String getXmlStr(String propertyName, Object value, String alias, boolean isUnVisable, boolean isScanQty, String aliasName) {
        if (value == null) {
            value = "";
        }
        StringBuffer xmlStr = new StringBuffer();
        xmlStr.append("<").append(propertyName).append(" value='").append(value).append("' alias='").append(alias).append("' isUnVisable='").append(isUnVisable).append("' isScanQty='").append(isScanQty).append("' aliasName='").append(aliasName).append("'/>");
        return xmlStr.toString();
    }

    private Object getDestBill(Context ctx, BarcodeConfigInfo configInfo, String billNumber, String warehouseNumber, String adminDept, String useDept) throws BOSException, EASBizException {
        IMetaDataLoader loader;
        EntityObjectInfo entity;
        ICoreBillBase iCoreBase;
        if (billNumber == null) {
            return null;
        }
        String botpID = null;
        if (configInfo.getBotMapping() != null) {
            botpID = configInfo.getBotMapping().getId().toString();
        }
        String srcBosType = configInfo.getSrcBosType();
        try {
            if ("D9D2CA5D".equalsIgnoreCase(configInfo.getDestBosType())) {
                if (warehouseNumber == null || "".equals(warehouseNumber)) {
                    throw new BarcodeWSException(BarcodeWSException.CONTINGERROR);
                }
                srcBosType = "AC301916";
            }
            if ("84BEC1BB".equalsIgnoreCase(configInfo.getDestBosType())) {
                srcBosType = "84BEC1BD";
            }
            if (configInfo.isVerifyMode()) {
                srcBosType = configInfo.getDestBosType();
            }
            iCoreBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)srcBosType));
        }
        catch (BOSException e) {
            throw new BarcodeWSException(BarcodeWSException.BOSTYPENULL, new Object[]{srcBosType});
        }
        ObjectBaseCollection destBillColl = new ObjectBaseCollection();
        EntityViewInfo view = new EntityViewInfo();
        boolean isCheck = false;
        if (srcBosType != null && !srcBosType.equals("") && "com.kingdee.eas.scm.sm.pur.PurOrder".equals((entity = (loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx)).getEntity(BOSObjectType.create((String)srcBosType))).getBusinessImplName())) {
            isCheck = true;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("entries.storageOrgUnit.id"));
            sic.add(new SelectorItemInfo("entries.storageOrgUnit.number"));
            sic.add(new SelectorItemInfo("entries.storageOrgUnit.number"));
            view.setSelector(sic);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)billNumber, CompareType.EQUALS));
        view.setFilter(filter);
        CoreBillBaseCollection coll = iCoreBase.getCoreBillBaseCollection(view);
        if (coll == null || coll.size() == 0) {
            throw new BarcodeWSException(BarcodeWSException.SRCBILLNUMBERNULL);
        }
        CoreBillBaseInfo info = coll.get(0);
        if (srcBosType != null && !srcBosType.equals("")) {
            if (!(srcBosType.toString().equals("AC301916") || srcBosType.toString().equals("84BEC1BD") || configInfo.isVerifyMode())) {
                IBTPManager ibtp = BTPManagerFactory.getLocalInstance((Context)ctx);
                BOTMappingInfo botMappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo((IObjectPK)new ObjectUuidPK(botpID));
                if (isCheck) {
                    BTPTransformResult btpResult;
                    ArrayList<String> srcEntriesKey = new ArrayList<String>();
                    if (warehouseNumber != null && !"".equals(warehouseNumber)) {
                        PurOrderInfo purOrderInfo = (PurOrderInfo)info;
                        int size = purOrderInfo.getEntries().size();
                        for (int i = 0; i < size; ++i) {
                            PurOrderEntryInfo entryInfo = purOrderInfo.getEntries().get(i);
                            StorageOrgUnitInfo orgUnitInfo = entryInfo.getStorageOrgUnit();
                            if (!warehouseNumber.equals(orgUnitInfo.getNumber())) continue;
                            srcEntriesKey.add(entryInfo.getId().toString());
                        }
                    }
                    if (srcEntriesKey.size() > 0) {
                        btpResult = ibtp.transformForBotp(new String[]{info.getId().toString()}, new String[]{BOTMappingUtil.getSrcEntriesName((BOTMappingInfo)botMappingInfo)}, srcEntriesKey, null, configInfo.getDestBosType(), (IObjectPK)new ObjectUuidPK(botMappingInfo.getId().toString()), srcBosType);
                        IObjectCollection resultCol = btpResult.getBills();
                        destBillColl.addObject(resultCol.getObject(0));
                    } else {
                        if (warehouseNumber != null && !"".equals(warehouseNumber)) {
                            throw new BarcodeWSException(BarcodeWSException.NOTFUHEDATA);
                        }
                        btpResult = ibtp.transform(info, botMappingInfo);
                        IObjectCollection resultCol = btpResult.getBills();
                        destBillColl.addObject(resultCol.getObject(0));
                    }
                } else {
                    BTPTransformResult btpResult = ibtp.transform(info, botMappingInfo);
                    IObjectCollection resultCol = btpResult.getBills();
                    destBillColl.addObject(resultCol.getObject(0));
                }
            } else {
                StringBuffer sql;
                if ("D9D2CA5D".equalsIgnoreCase(configInfo.getDestBosType())) {
                    sql = new StringBuffer();
                    sql.append(this.getSelectFields());
                    sql.append("  where countingTask.id = '").append(info.getId().toString()).append("'");
                    sql.append(" and countingTask.taskStatus=").append(3);
                    sql.append(" and warehouse.number='").append(warehouseNumber).append("'");
                    ObjectBaseCollection collCount = ((IObjectBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)"D9D2CA5D"))).getObjectBaseCollection(sql.toString());
                    destBillColl.addObjectCollection((IObjectCollection)collCount);
                }
                if ("84BEC1BB".equalsIgnoreCase(configInfo.getDestBosType())) {
                    sql = new StringBuffer();
                    sql.append(this.getFASelectFields());
                    sql.append("  where taskBill.id = '").append(info.getId().toString()).append("'");
                    sql.append(" and taskBill.stocktakingStatus=").append(3);
                    boolean isCheckAdminDept = false;
                    boolean isCheckUseDept = false;
                    if (adminDept != null && !"".equals(adminDept) && !"null".equals(adminDept)) {
                        isCheckAdminDept = true;
                    }
                    if (useDept != null && !"".equals(useDept) && !"null".equals(useDept)) {
                        isCheckUseDept = true;
                    }
                    ObjectBaseCollection collCount = ((IObjectBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)"84BEC1BB"))).getObjectBaseCollection(sql.toString());
                    if (isCheckAdminDept || isCheckUseDept) {
                        int size = collCount.size();
                        for (int i = 0; i < size; ++i) {
                            FaStocktakingBillInfo objectValue = (FaStocktakingBillInfo)collCount.getObject(i);
                            FaStocktakingBillEntryCollection entryColle = objectValue.getEntries();
                            FaStocktakingBillEntryCollection entryCollection = new FaStocktakingBillEntryCollection();
                            int m = entryColle.size();
                            for (int j = 0; j < m; ++j) {
                                FaStocktakingBillEntryInfo entryInfo = entryColle.get(j);
                                AdminOrgUnitInfo adminDeptInfo = entryInfo.getAdminDept();
                                AdminOrgUnitInfo useDeptInfo = entryInfo.getUseDept();
                                if (isCheckAdminDept && isCheckUseDept) {
                                    if (adminDeptInfo == null || useDeptInfo == null || !adminDept.equalsIgnoreCase(adminDeptInfo.getNumber()) || !useDept.equalsIgnoreCase(useDeptInfo.getNumber())) continue;
                                    entryCollection.add(entryInfo);
                                    continue;
                                }
                                if (isCheckAdminDept) {
                                    if (adminDeptInfo == null || !adminDept.equalsIgnoreCase(adminDeptInfo.getNumber())) continue;
                                    entryCollection.add(entryInfo);
                                    continue;
                                }
                                if (!isCheckUseDept || useDeptInfo == null || !useDept.equalsIgnoreCase(useDeptInfo.getNumber())) continue;
                                entryCollection.add(entryInfo);
                            }
                            if (entryCollection.size() <= 0) {
                                throw new BarcodeWSException(BarcodeWSException.NOTFUHEDATA);
                            }
                            objectValue.getEntries().clear();
                            objectValue.getEntries().addCollection(entryCollection);
                        }
                    }
                    destBillColl.addObjectCollection((IObjectCollection)collCount);
                }
                if (configInfo.isVerifyMode() && coll.size() > 0) {
                    destBillColl.addObject(coll.getObject(0));
                }
            }
        }
        return destBillColl;
    }

    private String getSelectFields() {
        String select = "select *,storageOrgUnit.number,storageOrgUnit.name,warehouse.number,warehouse.name,countingPerson.number,countingPerson.name,countingAgainPerson.number,countingAgainPerson.name,countingMonitorer.number,entry.*,entry.location.number,entry.location.name,entry.material.number,entry.material.name,entry.storeType.number,entry.storeType.name,entry.unit.number,entry.unit.name,entry.assistUnit.number,entry.assistUnit.name,entry.storeStatus.number,entry.storeStatus.name";
        return select;
    }

    private String getFASelectFields() {
        String select = "select beginDate,endDate,operator.id,operator.name,operator.number,stocktakingStatus,taskBill.id,taskBill.number,entries.assetCat.id,entries.assetCat.number,entries.assetCat.name,entries.assetNum,entries.assetName,entries.specs,entries.measureUnit.name,entries.measureUnit.number,entries.assetAmt,entries.stocktakingAmt,entries.address.id,entries.address.*,entries.economicPurp.id,entries.economicPurp.*,entries.useStatus.id,entries.adminDept.*,entries.adminDept.*,entries.useDept.id,entries.useDept.*,entries.bill.*,entries.usePerson.id,entries.usePerson.*,entries.barcode,entries.keeper.id,entries.keeper.*";
        return select;
    }

    public String getBarcodeList(Context ctx, Object[] argumentArg) throws BOSException, EASBizException {
        if (argumentArg.length < -1) {
            throw new BarcodeWSException(BarcodeWSException.BARCOEDNULLDATA);
        }
        String barcode = argumentArg[0].toString();
        String configId = argumentArg[1].toString();
        String orgNumber = null;
        if (argumentArg.length > 4) {
            orgNumber = argumentArg[4].toString().equals("-1") ? null : argumentArg[4].toString();
        }
        String transTypeNumber = null;
        if (argumentArg.length > 5) {
            transTypeNumber = argumentArg[5].toString().equals("-1") ? null : argumentArg[5].toString();
        }
        BarcodePDAScanning pdaScanning = new BarcodePDAScanning();
        BarcodeConfigInfo configInfo = BarcodeConfigFactory.getLocalInstance(ctx).getBarcodeConfigInfo((IObjectPK)new ObjectUuidPK(configId));
        if (configInfo == null) {
            return null;
        }
        String srcBosType = configInfo.getSrcBosType();
        String destBosType = configInfo.getDestBosType();
        String paramValue = BarcodeClientUtils.getParamValueStr(ctx);
        ArrayList<BarcodeAnalysisResult> barcodeResultList = new ArrayList<BarcodeAnalysisResult>();
        CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        boolean isPackage = pdaScanning.executeBarcode(ctx, barcode, transTypeNumber, srcBosType, destBosType, paramValue, ctrlUnitInfo, barcodeResultList, true);
        if (barcodeResultList.size() == 0) {
            throw new BarcodeWSException(BarcodeWSException.BARCODENULL);
        }
        JSONArray allArray = new JSONArray();
        if (isPackage) {
            JSONArray packageArray = new JSONArray();
            packageArray.add((Object)this.getBarcodeJsonStr("Head", "1", this.getMassege(ctx, this.resourceBaseStr, "packageBig"), false));
            packageArray.add((Object)this.getBarcodeJsonStr("barcode", barcode, this.getMassege(ctx, this.resourceBaseStr, "barcode"), false));
            allArray.add((Object)packageArray);
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        int size = barcodeResultList.size();
        for (int i = 0; i < size; ++i) {
            BarcodeAnalysisResult analysisResult = (BarcodeAnalysisResult)barcodeResultList.get(i);
            if (orgNumber == null) {
                orgNumber = ContextUtil.getCurrentStorageUnit((Context)ctx).getNumber();
            }
            logger.info((Object)("orgNumber=" + orgNumber));
            if (orgNumber != null && analysisResult.getMaterialID() != null) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.number", (Object)orgNumber, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)analysisResult.getMaterialID(), CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                viewInfo.getSelector().add(new SelectorItemInfo("isPeriodValid"));
                viewInfo.getSelector().add(new SelectorItemInfo("isLotNumber"));
                viewInfo.getSelector().add(new SelectorItemInfo("material.id"));
                MaterialInventoryCollection con = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(viewInfo);
                if (con.size() > 0) {
                    MaterialInventoryInfo iventoryInfo = con.get(0);
                    analysisResult.setLotNumber(iventoryInfo.isIsLotNumber());
                    analysisResult.setPeriodValid(iventoryInfo.isIsPeriodValid());
                }
            }
            List<BarcodeAnalysisResultItem> resultItem = analysisResult.getItems();
            HashMap<String, String> exsitsMap = new HashMap<String, String>();
            JSONArray childArray = new JSONArray();
            int m = resultItem.size();
            for (int j = 0; j < m; ++j) {
                BarcodeAnalysisResultItem item = resultItem.get(j);
                if (j == 0) {
                    childArray.add((Object)this.getBarcodeJsonStr("barcode", analysisResult.getBarcode(), ResourceBase.getString((String)this.resourceBaseStr, (String)"barcode", (Locale)ctx.getLocale()), false));
                    childArray.add((Object)this.getBarcodeJsonStr("barcodeRuleId", item.getBarcodeRuleId(), ResourceBase.getString((String)this.resourceBaseStr, (String)"barcodeRuleId", (Locale)ctx.getLocale()), false));
                    childArray.add((Object)this.getBarcodeJsonStr("isCumsumQty", Boolean.toString(analysisResult.isCumsumQty()), ResourceBase.getString((String)this.resourceBaseStr, (String)"isCumsumQty", (Locale)ctx.getLocale()), false));
                    childArray.add((Object)this.getBarcodeJsonStr("isBarcodeRepeat", Boolean.toString(analysisResult.isBarcodeRepeat()), ResourceBase.getString((String)this.resourceBaseStr, (String)"isBarcodeRepeat", (Locale)ctx.getLocale()), false));
                    childArray.add((Object)this.getBarcodeJsonStr("isLotNumber", Boolean.toString(analysisResult.isLotNumber()), ResourceBase.getString((String)this.resourceBaseStr, (String)"isLotNumber", (Locale)ctx.getLocale()), false));
                    childArray.add((Object)this.getBarcodeJsonStr("isPeriodValid", Boolean.toString(analysisResult.isPeriodValid()), ResourceBase.getString((String)this.resourceBaseStr, (String)"isPeriodValid", (Locale)ctx.getLocale()), false));
                    if (configInfo.isIsMatchBill()) {
                        // empty if block
                    }
                }
                if (item.getValue() == null) {
                    item.setValue("");
                }
                if (item.getValue() instanceof Date && item.getValue() != null) {
                    item.setValue(format.format(item.getValue()));
                }
                if (item.isLinkedProperty()) {
                    if (exsitsMap.containsKey(item.getNumberProperty())) continue;
                    childArray.add((Object)this.getBarcodeJsonStr(item.getNumberProperty(), item.getValue(), item.getAlias(), item.getIsMatchItem()));
                    if (!exsitsMap.containsKey(item.getNumberProperty())) {
                        exsitsMap.put(item.getNumberProperty(), item.getNumberProperty());
                    }
                    if (item.getNameProperty() == null || exsitsMap.containsKey(item.getNameProperty())) continue;
                    childArray.add((Object)this.getBarcodeJsonStr(item.getNameProperty(), item.getNameValue(), item.getAlias(), item.getIsMatchItem()));
                    exsitsMap.put(item.getNameProperty(), item.getNameProperty());
                    continue;
                }
                childArray.add((Object)this.getBarcodeJsonStr(item.getField(), item.getValue(), item.getAlias(), item.getIsMatchItem()));
            }
            allArray.add((Object)childArray);
        }
        long time1 = System.currentTimeMillis();
        boolean isBotp = configInfo.getBotMapping() != null;
        BarcodeAnalysisResult analysisResult = (BarcodeAnalysisResult)barcodeResultList.get(0);
        BOTMappingInfo botMappingInfo = configInfo.getBotMapping();
        isBotp = botMappingInfo != null;
        boolean isExstsNumber = false;
        if (configInfo.isIsMatchBill() && argumentArg.length > 6) {
            for (String billNumber : argumentArg[6].toString().split(",")) {
                if (analysisResult.getSrcBillNumber() == null || !billNumber.equalsIgnoreCase(analysisResult.getSrcBillNumber())) continue;
                isExstsNumber = true;
                break;
            }
        }
        if (isBotp && configInfo.isIsMatchBill() && !isExstsNumber) {
            String billNumber = analysisResult.getSrcBillNumber() != null ? analysisResult.getSrcBillNumber() : null;
            IObjectCollection objectColl = (IObjectCollection)this.getDestBill(ctx, configInfo, billNumber, null, null, null);
            long time2 = System.currentTimeMillis() - time1;
            logger.info((Object)("\u83b7\u53d6\u76ee\u6807\u5bf9\u8c61\uff1a" + time2));
            if (objectColl != null && objectColl.size() > 0) {
                time1 = System.currentTimeMillis();
                IObjectValue billValue = null;
                if ("D9D2CA5D".equalsIgnoreCase(configInfo.getDestBosType())) {
                    billValue = objectColl.getObject(0);
                    IObjectCollection objectCol = (IObjectCollection)billValue.get("entry");
                    int size2 = objectColl.size();
                    for (int i = 1; i < size2; ++i) {
                        IObjectValue newObjectValue = objectColl.getObject(i);
                        IObjectCollection newobjectCol = (IObjectCollection)newObjectValue.get("entry");
                        objectCol.addObjectCollection(newobjectCol);
                    }
                } else {
                    billValue = objectColl.getObject(0);
                }
                JSONArray billArray = this.getBillDataAry(ctx, billValue, configInfo);
                if (configInfo.isIsMatchBill()) {
                    billArray.add((Object)this.getJsonStr("fsrcBillNumber", analysisResult.getSrcBillNumber(), "fsrcBillNumber", false, false, "fsrcBillNumber"));
                }
                JSONObject billObj = new JSONObject();
                billObj.put((Object)"bill", (Object)billArray);
                allArray.add((Object)billObj);
                time2 = System.currentTimeMillis() - time1;
            } else {
                throw new BarcodeWSException(BarcodeWSException.QUERYNULL, new Object[]{billNumber});
            }
        }
        String str = allArray.toString();
        if (allArray.size() > 0) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                GZIPOutputStream gzip = new GZIPOutputStream(out);
                gzip.write(allArray.toString().getBytes("UTF-8"));
                gzip.close();
                BASE64Encoder beenCode = new BASE64Encoder();
                str = beenCode.encode(out.toByteArray());
                logger.info((Object)("\u89e3\u538b\u540e\u957f\u5ea6\uff1a" + str.length()));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new BarcodeWSException(BarcodeWSException.BARCODEFAIL);
            }
        }
        return this.packageReturnXml(str);
    }

    protected String updatePackageBarcode(Context ctx, Object[] argumentArg) throws BOSException, EASBizException {
        BarcodeConfigInfo configInfo;
        if (argumentArg.length < -1) {
            throw new BarcodeWSException(BarcodeWSException.BARCOEDNULLDATA);
        }
        String barcode = argumentArg[0].toString();
        String configId = argumentArg[1].toString();
        String transTypeNumber = null;
        if (argumentArg.length > 2) {
            transTypeNumber = argumentArg[2].toString();
        }
        if ((configInfo = BarcodeConfigFactory.getLocalInstance(ctx).getBarcodeConfigInfo((IObjectPK)new ObjectUuidPK(configId))) == null) {
            return null;
        }
        String destBosType = configInfo.getDestBosType();
        int intOrUnitBill = BarcodeServerUtils.getInOrOutBill(ctx, destBosType, transTypeNumber);
        if (intOrUnitBill == 3) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("barcode", (Object)barcode));
            PackageBarcodeFactory.getLocalInstance(ctx).delete(filterInfo);
        }
        return "\u66f4\u65b0\u6210\u529f";
    }

    protected String updateBarcodeDossire(Context ctx, Object[] argumentArg) throws BOSException, EASBizException {
        if (argumentArg.length < -1) {
            throw new BarcodeWSException(BarcodeWSException.BARCOEDNULLDATA);
        }
        String barcode = argumentArg[0].toString();
        if (argumentArg.length > 3) {
            String isScan = argumentArg[2].toString();
            String bosType = argumentArg[3].toString();
            boolean isReapte = false;
            if (argumentArg.length > 4) {
                isReapte = Boolean.valueOf(argumentArg[4].toString());
            }
            String transTypeNumber = null;
            if (argumentArg.length > 5) {
                transTypeNumber = argumentArg[5].toString();
            }
            if (isReapte) {
                StringBuffer selectSql = new StringBuffer();
                selectSql.append(" select fnumber from CT_IND_BarcodeDossier").append("\n");
                selectSql.append(" where cfisScan=1").append("\n");
                selectSql.append(" and cfBarcodeState=").append(BarcodeServerUtils.getInOrOutBill(ctx, bosType, transTypeNumber)).append("\n");
                selectSql.append(" and fnumber in('").append(barcode).append("')");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
                try {
                    if (rs.next()) {
                        throw new BarcodeWSException(BarcodeWSException.BARCODEREPREAT, new Object[]{"\u3010" + barcode + "\u3011"});
                    }
                }
                catch (SQLException e) {
                    throw new BarcodeWSException(BarcodeWSException.BARCODEREPREAT, new Object[]{"\u3010" + barcode + "\u3011"});
                }
            }
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update CT_IND_BarcodeDossier set CFIsScan=").append(isScan);
            updateSql.append(" ,CFBarcodeState=").append(BarcodeServerUtils.getInOrOutBill(ctx, bosType, transTypeNumber)).append("\n");
            updateSql.append(" where fnumber in('").append(barcode).append("')");
            DbUtil.execute((Context)ctx, (String)updateSql.toString());
        }
        return "\u66f4\u65b0\u6210\u529f";
    }

    protected String getPackageBarcodeList(Context ctx, Object[] argumentArg) throws BOSException, EASBizException {
        if (argumentArg.length < 0) {
            throw new BarcodeWSException(BarcodeWSException.BARCOEDNULLDATA);
        }
        String packageBarcode = argumentArg[0].toString();
        String barcode = argumentArg[1].toString();
        int indexPacakgeBarcode = Integer.valueOf(argumentArg[2].toString());
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)barcode));
        if (!BarcodeDossierFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new BarcodeWSException(BarcodeWSException.BOSTYPENULL, new Object[]{barcode});
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser.*"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("pacakgeBarcode"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("entry.barcode"));
        sic.add(new SelectorItemInfo("entry.seq"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.id"));
        view.setSelector(sic);
        filterInfo = new FilterInfo();
        IAsstAttrValue IAsstAttrValue2 = AsstAttrValueFactory.getLocalInstance((Context)ctx);
        if (2 == indexPacakgeBarcode) {
            AsstAttrValueInfo valueInfo;
            filterInfo.getFilterItems().add(new FilterItemInfo("pacakgeBarcode", (Object)packageBarcode, CompareType.EQUALS));
            view.setFilter(filterInfo);
            PackageBarcodeCollection packageCol = PackageBarcodeFactory.getLocalInstance(ctx).getPackageBarcodeCollection(view);
            if (packageCol.size() > 1) {
                throw new BarcodeWSException(BarcodeWSException.BOXUP, new Object[]{"[" + packageBarcode + "]"});
            }
            StringBuffer valueStr = new StringBuffer();
            BarcodeDossierInfo dossierInfo = this.getBarcodeDossierInfo(ctx, packageBarcode);
            if (dossierInfo == null) {
                throw new BarcodeWSException(BarcodeWSException.BARCOEDNULLDATA);
            }
            valueStr.append("<packageBarcode").append("  value='").append(packageBarcode).append("'");
            if (dossierInfo.getMaterial() != null) {
                valueStr.append("  materialNumber='").append(dossierInfo.getMaterial().getNumber()).append("'");
                valueStr.append("  materialName='").append(dossierInfo.getMaterial().getName()).append("'");
            }
            if (dossierInfo.getAssistNature() != null && dossierInfo.getAssistNature() != null && (valueInfo = IAsstAttrValue2.getAsstAttrValueInfo((IObjectPK)new ObjectUuidPK(dossierInfo.getAssistNature()))) != null) {
                valueStr.append("  assistNature='").append(dossierInfo.getAssistNature()).append("'");
                valueStr.append("  assistNatureName='").append(valueInfo.getName()).append("'");
            }
            valueStr.append("/>").append("\n");
            if (packageCol.size() > 0) {
                PackageBarcodeInfo packaBacodeInfo = packageCol.get(0);
                PackageBarcodeEntryCollection barcodeEntry = packaBacodeInfo.getEntry();
                int size = barcodeEntry.size();
                for (int i = 0; i < size; ++i) {
                    AsstAttrValueInfo valueInfo2;
                    PackageBarcodeEntryInfo barcodeInfo = barcodeEntry.get(i);
                    String chidBarcode = barcodeInfo.getBarcode();
                    dossierInfo = this.getBarcodeDossierInfo(ctx, chidBarcode);
                    valueStr.append("<barcode").append("  value='").append(chidBarcode).append("'");
                    if (dossierInfo.getMaterial() != null) {
                        valueStr.append("  materialNumber='").append(dossierInfo.getMaterial().getNumber()).append("'");
                        valueStr.append("  materialName='").append(dossierInfo.getMaterial().getName()).append("'");
                    }
                    if (dossierInfo.getAssistNature() != null && (valueInfo2 = IAsstAttrValue2.getAsstAttrValueInfo((IObjectPK)new ObjectUuidPK(dossierInfo.getAssistNature()))) != null) {
                        valueStr.append("  assistNature='").append(dossierInfo.getAssistNature()).append("'");
                        valueStr.append("  assistNatureName='").append(valueInfo2.getName()).append("'");
                    }
                    valueStr.append("  barcodeQty='").append(dossierInfo.getQty()).append("'");
                    valueStr.append("/>\n");
                }
            }
            return this.packageReturnXml(valueStr.toString());
        }
        if (0 == indexPacakgeBarcode) {
            AsstAttrValueInfo valueInfo;
            StringBuffer valueStr = new StringBuffer();
            BarcodeDossierInfo dossierInfo = this.getBarcodeDossierInfo(ctx, barcode);
            if (dossierInfo == null) {
                throw new BarcodeWSException(BarcodeWSException.BARCODENULL);
            }
            StringBuffer selectSql = new StringBuffer();
            selectSql.append("select pBarcode.fpacakgeBarcode as fpacakgeBarcode from T_BC_PackageBarcode pBarcode").append("\t\n");
            selectSql.append("left join T_BC_PackageBarcodeEntry entry on pBarcode.fid=entry.fparentid").append("\t\n");
            selectSql.append("where entry.fbarcode='").append(barcode).append("'").append("\t\n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            try {
                while (rs.next()) {
                    if (rs.getString("fpacakgeBarcode").equalsIgnoreCase(packageBarcode)) continue;
                    throw new BarcodeWSException(BarcodeWSException.BOXUP, new Object[]{"[" + barcode + "]"});
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            valueStr.append("<barcode").append("  value='").append(barcode).append("'");
            if (dossierInfo.getMaterial() != null) {
                valueStr.append("  materialNumber='").append(dossierInfo.getMaterial().getNumber()).append("'");
                valueStr.append("  materialName='").append(dossierInfo.getMaterial().getName()).append("'");
            }
            if (dossierInfo.getAssistNature() != null && dossierInfo.getAssistNature() != null && (valueInfo = IAsstAttrValue2.getAsstAttrValueInfo((IObjectPK)new ObjectUuidPK(dossierInfo.getAssistNature()))) != null) {
                valueStr.append("  assistNature='").append(dossierInfo.getAssistNature()).append("'");
                valueStr.append("  assistNatureName='").append(valueInfo.getName()).append("'");
            }
            if (dossierInfo.getQty() != null && !"".equals(dossierInfo.getQty())) {
                valueStr.append("  barcodeQty='").append(dossierInfo.getQty().toBigInteger()).append("'");
            } else {
                valueStr.append("  barcodeQty='").append(1).append("'");
            }
            valueStr.append("/>").append("\n");
            return this.packageReturnXml(valueStr.toString());
        }
        return barcode;
    }

    protected String saveOrRemovePackageBarcode(Context ctx, Object[] argumentArg) throws BOSException, EASBizException {
        String packageXml = argumentArg[0].toString();
        if (packageXml == null && "".equals(packageXml)) {
            throw new BarcodeWSException(BarcodeWSException.NOTPACAKGEDATA);
        }
        StringReader strR = null;
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        strR = new StringReader(packageXml);
        IObjectPK[] pk = null;
        try {
            IPackageBarcode ipackageBarcode = PackageBarcodeFactory.getLocalInstance(ctx);
            CoreBaseCollection addNewCol = new CoreBaseCollection();
            CoreBaseCollection updateCol = new CoreBaseCollection();
            CoreBaseCollection deleteCol = new CoreBaseCollection();
            doc = builder.build((Reader)strR);
            Element root = doc.getRootElement();
            List cNodes = root.getChildren();
            for (int i = 0; i < cNodes.size(); ++i) {
                Element xet = (Element)cNodes.get(i);
                PackageBarcodeInfo packageInfo = new PackageBarcodeInfo();
                String type = xet.getAttribute("type").getValue();
                String pacakgeBarcode = xet.getAttribute("value").getValue();
                if (pacakgeBarcode == null || "".equals(pacakgeBarcode)) {
                    throw new BarcodeWSException(BarcodeWSException.PACAGEBARCODENOTNULL);
                }
                packageInfo.setPacakgeBarcode(pacakgeBarcode);
                packageInfo.setStatus(StatusEnum.ACTIVE);
                packageInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                PackageBarcodeEntryCollection barcodeEntry = packageInfo.getEntry();
                for (int j = 0; j < xet.getChildren().size(); ++j) {
                    Element barcodeXet = (Element)xet.getChildren().get(j);
                    String barcode = barcodeXet.getAttribute("value").getValue();
                    PackageBarcodeEntryInfo entryInfo = new PackageBarcodeEntryInfo();
                    entryInfo.setBarcode(barcode);
                    entryInfo.setParent(packageInfo);
                    barcodeEntry.add(entryInfo);
                }
                if ("0".equals(type)) {
                    packageInfo.setCreateTime(this.getTime());
                    UserInfo userInfo = new UserInfo();
                    userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
                    packageInfo.setCreator(userInfo);
                    PackageBarcodeCollection packageBarcodeInfo = ipackageBarcode.getPackageBarcodeCollection("where pacakgeBarcode='" + pacakgeBarcode + "'");
                    if (packageBarcodeInfo.size() > 0) {
                        packageInfo.setId(packageBarcodeInfo.get(0).getId());
                        updateCol.add((CoreBaseInfo)packageInfo);
                        continue;
                    }
                    addNewCol.add((CoreBaseInfo)packageInfo);
                    continue;
                }
                if ("1".equals(type)) {
                    PackageBarcodeCollection packageBarcodeInfoCol = ipackageBarcode.getPackageBarcodeCollection("where pacakgeBarcode='" + pacakgeBarcode + "'");
                    if (packageBarcodeInfoCol.size() <= 0) {
                        throw new BarcodeWSException(BarcodeWSException.NOTFUHEDATA);
                    }
                    packageInfo.setId(packageBarcodeInfoCol.get(0).getId());
                    packageInfo.setLastUpdateTime(this.getTime());
                    UserInfo userInfo = new UserInfo();
                    userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
                    packageInfo.setLastUpdateUser(userInfo);
                    updateCol.add((CoreBaseInfo)packageInfo);
                    continue;
                }
                if (!"2".equals(type)) continue;
                PackageBarcodeCollection packageBarcodeInfoCol = ipackageBarcode.getPackageBarcodeCollection("where pacakgeBarcode='" + pacakgeBarcode + "'");
                if (packageBarcodeInfoCol.size() > 0) {
                    deleteCol.addObjectCollection((IObjectCollection)packageBarcodeInfoCol);
                    continue;
                }
                throw new BarcodeWSException(BarcodeWSException.NOTFUHEDATA);
            }
            IPackageBarcodeEntry iPackageEntry = PackageBarcodeEntryFactory.getLocalInstance(ctx);
            if (addNewCol.size() > 0) {
                pk = ipackageBarcode.addnewBatchData(addNewCol);
                this.turnTheBox(addNewCol, iPackageEntry);
            }
            if (updateCol.size() > 0) {
                pk = ipackageBarcode.updateBatchData(updateCol);
                this.turnTheBox(updateCol, iPackageEntry);
            }
            if (deleteCol.size() > 0) {
                ObjectUuidPK[] iObjectPk = new ObjectUuidPK[deleteCol.size()];
                int size = deleteCol.size();
                for (int i = 0; i < size; ++i) {
                    CoreBaseInfo barseInfo = deleteCol.get(i);
                    iObjectPk[i] = new ObjectUuidPK(barseInfo.getId());
                    ipackageBarcode.deleteBatchData((IObjectPK[])iObjectPk);
                }
                pk = iObjectPk;
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return null;
        }
        return this.packageReturnXml(pk.toString());
    }

    private void turnTheBox(CoreBaseCollection col, IPackageBarcodeEntry iPackageEntry) throws EASBizException, BOSException {
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            PackageBarcodeInfo barcodeInfo = (PackageBarcodeInfo)col.get(i);
            StringBuffer barcodeStr = new StringBuffer();
            int m = barcodeInfo.getEntry().size();
            for (int j = 0; j < m; ++j) {
                PackageBarcodeEntryInfo entryInfo = barcodeInfo.getEntry().get(j);
                if (barcodeStr.length() > 0) {
                    barcodeStr.append(",").append(entryInfo.getBarcode());
                    continue;
                }
                barcodeStr.append(entryInfo.getBarcode());
            }
            if (barcodeStr.length() <= 0) continue;
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)barcodeInfo.getId(), CompareType.NOTEQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("barcode", (Object)barcodeStr.toString(), CompareType.INCLUDE));
            iPackageEntry.delete(filterInfo);
        }
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    protected BarcodeDossierInfo getBarcodeDossierInfo(Context ctx, String barcode) {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("material.id"));
        coll.add(new SelectorItemInfo("material.number"));
        coll.add(new SelectorItemInfo("material.name"));
        coll.add(new SelectorItemInfo("material.model"));
        coll.add(new SelectorItemInfo("assistNature"));
        coll.add(new SelectorItemInfo("qty"));
        coll.add(new SelectorItemInfo("useType"));
        view.setSelector(coll);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)barcode, CompareType.EQUALS));
        view.setFilter(filter);
        try {
            BarcodeDossierCollection barcodeCol = BarcodeDossierFactory.getLocalInstance(ctx).getBarcodeDossierCollection(view);
            if (barcodeCol.size() > 0) {
                return barcodeCol.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getBarcodeStr(String properyName, Object properyValue, boolean isMatchItem, String alias) {
        if (properyValue instanceof Date) {
            SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
            properyValue = SIMPLE_DATE_FORMAT.format((Date)properyValue);
        }
        StringBuffer valueStr = new StringBuffer();
        valueStr.append("<").append(properyName).append("  value='").append(properyValue).append("'").append("  isMatchItem='").append(isMatchItem).append("'").append("  aliasName='").append(alias).append("'").append("/>").append("\n");
        return valueStr.toString();
    }

    public String getBaseData(Context ctx, Object[] argumentArg) throws BOSException, EASBizException {
        String key;
        if (argumentArg.length < 2) {
            throw new BarcodeWSException(new NumericExceptionSubItem("", this.getMassege(ctx, this.resourceBaseStr, "argumentError")));
        }
        String number = argumentArg[0].toString();
        String name = argumentArg[1].toString();
        String bosType = argumentArg[2].toString();
        if (number == null || name == null || bosType == null) {
            throw new BarcodeWSException(new NumericExceptionSubItem("", this.getMassege(ctx, this.resourceBaseStr, "argumentError")));
        }
        EntityObjectInfo entity = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)bosType));
        PropertyInfo property = entity.getPropertyByName(key = name.substring(0, name.indexOf("_")));
        if (property != null && property instanceof LinkPropertyInfo) {
            EntityObjectInfo entryEntity = ((LinkPropertyInfo)property).getRelationship().getSupplierObject();
            ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)entryEntity.getType().toString()));
            boolean isWareHouse = false;
            String baseBosType = entryEntity.getType().toString();
            if ("BBE9F8AE".equals(baseBosType)) {
                isWareHouse = true;
            }
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection coll = new SelectorItemCollection();
            coll.add(new SelectorItemInfo("id"));
            coll.add(new SelectorItemInfo("name"));
            coll.add(new SelectorItemInfo("number"));
            if (isWareHouse) {
                coll.add(new SelectorItemInfo("hasLocation"));
            }
            view.setSelector(coll);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)number, CompareType.EQUALS));
            filter.setMaskString("#0 or #1");
            view.setFilter(filter);
            CoreBaseCollection coreBaseCol = iCoreBase.getCollection(view);
            if (coreBaseCol.size() > 0) {
                CoreBaseInfo info = coreBaseCol.get(0);
                StringBuffer sqlStr = new StringBuffer();
                sqlStr.append("<").append(name).append("  value='").append(info.get("number")).append("'/>").append("\n");
                sqlStr.append("<").append(key + "_name").append("  value='").append(info.get("name")).append("'/>").append("\n");
                if (isWareHouse) {
                    sqlStr.append("<hasLocation").append("  value='").append(info.get("hasLocation")).append("'/>").append("\n");
                }
                return this.packageReturnXml(sqlStr.toString());
            }
            throw new BarcodeWSException(new NumericExceptionSubItem("", "\u3010" + number + "\u3011" + this.getMassege(ctx, this.resourceBaseStr, "dataNotfund")));
        }
        return null;
    }

    public String getTransactionType(Context ctx, Object[] argumentArg) throws BOSException, EASBizException {
        BillTypeInfo billType;
        if (argumentArg.length < -1) {
            throw new BarcodeWSException(new NumericExceptionSubItem("", this.getMassege(ctx, this.resourceBaseStr, "argumentError")));
        }
        String bosType = argumentArg[0].toString();
        String defaultSolutionId = null;
        if (argumentArg.length > 1) {
            defaultSolutionId = argumentArg[1].toString();
        }
        if ((billType = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo("where bosType='" + bosType + "'")) == null) {
            return null;
        }
        String bizTypeNumber = null;
        if (defaultSolutionId != null && !"".equals(defaultSolutionId)) {
            BarcodeDefaultSolutionInfo solInfo = BarcodeDefaultSolutionFactory.getLocalInstance(ctx).getBarcodeDefaultSolutionInfo((IObjectPK)new ObjectUuidPK(defaultSolutionId));
            BarcodeDefaultXMLInfo defaultXmlInfo = BarcodeXMLHelper.toBarcodeDefaultXMLInfo(solInfo.getDetailsXML());
            for (int i = 0; i < defaultXmlInfo.getItems().size(); ++i) {
                BarcodeDefaultXMLItem item = defaultXmlInfo.getItems().get(i);
                String fullField = item.getField();
                if (!"bizType".equalsIgnoreCase(fullField)) continue;
                bizTypeNumber = item.getValue();
                break;
            }
        }
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("select distinct type.fnumber fnumber,type.fname_l2 fname_l2 ").append("\n");
        sqlStr.append("from T_SCM_TransactionType type").append("\n");
        sqlStr.append("left join T_SCM_BizType bizType on bizType.fid=type.FBizTypeID").append("\n");
        sqlStr.append("where 1=1 ").append("\n");
        sqlStr.append("and type.fstatus=1").append("\n");
        sqlStr.append("and type.fbillTypeId='").append(billType.getId()).append("' \n");
        if (bizTypeNumber != null && !"".equals(bizTypeNumber)) {
            sqlStr.append("and bizType.fnumber='").append(bizTypeNumber).append("' \n");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
        StringBuffer valueStr = new StringBuffer();
        if (rs.size() <= 0) {
            sqlStr = new StringBuffer();
            sqlStr.append("select distinct type.fnumber fnumber,type.fname_l2 fname_l2 ").append("\n");
            sqlStr.append("from T_SCM_TransactionType type").append("\n");
            sqlStr.append("left join T_SCM_BizType bizType on bizType.fid=type.FBizTypeID").append("\n");
            sqlStr.append("where 1=1 ").append("\n");
            sqlStr.append("and type.fstatus=1").append("\n");
            sqlStr.append("and type.fbillTypeId='").append(billType.getId()).append("' \n");
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
        }
        try {
            ResultSetMetaData rsd = rs.getMetaData();
            while (rs.next()) {
                valueStr.append("<transactionInfo ");
                int size = rsd.getColumnCount();
                for (int i = 1; i <= size; ++i) {
                    String columnName = rsd.getColumnName(i);
                    String value = rs.getString(columnName);
                    valueStr.append(columnName).append("='").append(value).append("' ");
                }
                valueStr.append("/>").append("\n");
            }
        }
        catch (SQLException e) {
            throw new BarcodeWSException(BarcodeWSException.DATABULL);
        }
        return this.packageReturnXml(valueStr.toString());
    }

    public String getAsstAttrValue(Context ctx, Object[] argumentArg) throws BOSException, EASBizException {
        if (argumentArg.length < -1) {
            return null;
        }
        String asstAttrNumber = argumentArg[0].toString();
        if (asstAttrNumber == null || "".equals(asstAttrNumber)) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid,fnumber from T_BD_AsstAttrValue where fnumber='").append(asstAttrNumber).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return this.packageReturnXml(this.getValueStr(rs, asstAttrNumber));
    }

    public String checkMaterialInventory(Context ctx, Object[] argumentArg) throws BOSException, EASBizException {
        if (argumentArg.length < -1) {
            return null;
        }
        String materialID = argumentArg[0].toString();
        String orgUnit = argumentArg[1].toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select FIsBatchNo from T_BD_MaterialInventory").append("\t\n");
        sql.append(" where 1=1").append("\t\n");
        sql.append(" and fmaterialid ='").append(materialID).append("' \t\n");
        sql.append(" and FOrgUnit ='").append(orgUnit).append("' \t\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return this.packageReturnXml(this.getValueStr(rs, materialID));
    }

    public String getWareHouse(Context ctx, Object[] argumentArg) throws BOSException, EASBizException {
        if (argumentArg.length < -1) {
            return null;
        }
        String warehouseNumber = argumentArg[0].toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid,fnumber as warehouse_number ,fname_l2 as warehouse_name, fhaslocation from T_DB_WAREHOUSE ").append("\t\n");
        sql.append(" where 1=1").append("\t\n");
        sql.append(" and FNumber ='").append(warehouseNumber).append("' \t\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return this.packageReturnXml(this.getValueStr(rs, warehouseNumber));
    }

    public String getLocation(Context ctx, Object[] argumentArg) throws BOSException, EASBizException {
        if (argumentArg.length < -1) {
            return null;
        }
        String warehouseNumber = argumentArg[0].toString();
        String warehouseID = argumentArg[1].toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID,fnumber as location_number,fname_l2 as location_name from T_DB_LOCATION ").append("\t\n");
        sql.append(" where 1=1").append("\t\n");
        sql.append(" and FNumber ='").append(warehouseNumber).append("' \t\n");
        sql.append(" and FWarehouseID ='").append(warehouseID).append("' \t\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return this.packageReturnXml(this.getValueStr(rs, warehouseNumber));
    }

    private String getValueStr(IRowSet rs, String number) throws EASBizException {
        StringBuffer valueStr = new StringBuffer();
        try {
            ResultSetMetaData rsd = rs.getMetaData();
            while (rs.next()) {
                int size = rsd.getColumnCount();
                for (int i = 1; i <= size; ++i) {
                    String columnName = rsd.getColumnName(i);
                    String value = rs.getString(columnName);
                    valueStr.append("<").append(columnName).append("  value='").append(value).append("'/>").append("\n");
                }
            }
        }
        catch (SQLException e) {
            throw new BarcodeWSException(BarcodeWSException.DATABULL);
        }
        return valueStr.toString();
    }

    private String packageReturnXml(String valueStr) {
        StringBuffer returnStr = new StringBuffer();
        returnStr.append("<Header>UWBCDtResponse</Header>").append("\n");
        returnStr.append("<Return>").append("\n").append(valueStr).append("\n").append("</Return>").append("\n");
        returnStr.append("<Tailer>UWBCEnd</Tailer>").append("\n");
        return returnStr.toString();
    }

    private String getMassege(Context ctx, String resourceStr, String key) {
        return ResourceBase.getString((String)resourceStr, (String)key, (Locale)ctx.getLocale());
    }

    public String getMenuConfig(Context ctx, Object[] argumentArg) throws BOSException {
        String sqlMainConfig = " select CFMenuXml,CFMD5Value from CT_BC_PDAMainMenu";
        IRowSet rsMainConfig = DbUtil.executeQuery((Context)ctx, (String)sqlMainConfig.toString());
        logger.info((Object)("\u83b7\u53d6PDA\u83dc\u5355SQl\uff1a" + sqlMainConfig));
        String sqlItemConfig = " select CFXMLByteData,CFXmlMD5,CFXmlFileName  from CT_BC_BARCODEPDACONFIG";
        IRowSet rsItemConfig = DbUtil.executeQuery((Context)ctx, (String)sqlItemConfig.toString());
        logger.info((Object)("\u83b7\u53d6PDA\u754c\u9762SQl\uff1a" + sqlMainConfig));
        String jsonStr = this.getConfigJsonStr(rsMainConfig, rsItemConfig);
        return jsonStr;
    }

    private String getConfigJsonStr(IRowSet rsMainConfig, IRowSet rsItemConfig) {
        FileObject fo = new FileObject();
        JSONArray ja = new JSONArray();
        JSONObject jo = null;
        try {
            String fileContent;
            String md5Code;
            String fileName;
            logger.info((Object)"\u83b7\u53d6PDA\u83dc\u5355\u5f00\u59cb\uff1a");
            while (rsMainConfig.next()) {
                jo = new JSONObject();
                fileName = "UWBCConfig.xml";
                md5Code = rsMainConfig.getString("CFMD5Value");
                fileContent = rsMainConfig.getString("CFMenuXml");
                fo.setFileContent(fileContent);
                fo.setFileName(fileName);
                fo.setMD5Code(md5Code);
                JSONObject.fromObject((Object)fo);
                jo = JSONObject.fromObject((Object)fo);
                ja.add((Object)jo);
            }
            logger.info((Object)("\u83b7\u53d6PDA\u83dc\u5355\u7ed3\u675f\uff1a" + ja.toString()));
            logger.info((Object)"\u83b7\u53d6PDA\u754c\u9762\u5f00\u59cb\uff1a");
            while (rsItemConfig.next()) {
                jo = new JSONObject();
                fileName = rsItemConfig.getString("CFXmlFileName");
                md5Code = rsItemConfig.getString("CFXmlMD5");
                fileContent = rsItemConfig.getString("CFXMLByteData");
                fo.setFileContent(fileContent);
                fo.setFileName(fileName);
                fo.setMD5Code(md5Code);
                jo = JSONObject.fromObject((Object)fo);
                ja.add((Object)jo);
            }
            logger.info((Object)("\u83b7\u53d6PDA\u754c\u9762\u7ed3\u675f\uff1a" + ja.toString()));
            return ja.toString();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return ja.toString();
        }
    }

    public String getBarcodeRule(Context ctx, Object[] argumentArg) throws BOSException {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        try {
            OrgSwitchFacadeFactory.getLocalInstance((Context)ctx).orgSwitch(user.getDefOrgUnit().getId().toString());
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException("\u7528\u6237\u65e0\u7f3a\u7701\u7ec4\u7ec7");
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("name"));
        coll.add(new SelectorItemInfo("detailsXML"));
        view.setSelector(coll);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("cu.number", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getNumber()));
        filterInfo.getFilterItems().add(new FilterItemInfo("barcodeType.barcodeType", (Object)0));
        view.setFilter(filterInfo);
        BarcodeRuleCollection ruleCol = BarcodeRuleFactory.getLocalInstance(ctx).getBarcodeRuleCollection(view);
        JSONArray ja = new JSONArray();
        int size = ruleCol.size();
        for (int i = 0; i < size; ++i) {
            BarcodeRuleInfo ruleInfo = ruleCol.get(i);
            if (ruleInfo.getDetailsXML() == null) continue;
            JSONObject jo = new JSONObject();
            BarcodePDARuleInfo newRuleInfo = new BarcodePDARuleInfo();
            newRuleInfo.setXmlName(ruleInfo.getName());
            if (ruleInfo.getDetailsXML() != null) {
                newRuleInfo.setDetailsXML(ruleInfo.getDetailsXML());
            }
            jo = JSONObject.fromObject((Object)newRuleInfo);
            ja.add((Object)jo);
        }
        return this.packageReturnXml(ja.toString());
    }

    private void requestLicenseOrReleaseLicense(Context ctx, Object[] argumentArg) throws BOSException, EASBizException {
        try {
            String sessionID = argumentArg[0].toString();
            boolean flag = Boolean.valueOf(argumentArg[1].toString());
            BarcodeLicenseUtils.requestLicenseOrReleaseLicense(ctx, flag, sessionID);
        }
        catch (LicenseException e) {
            throw new BarcodeWSException(new NumericExceptionSubItem("", e.fillInStackTrace().getMessage()));
        }
    }

    protected String checkEXP(Context ctx, Object[] argumentArg) throws EASBizException, BOSException {
        String bosType = argumentArg[0].toString();
        String materialNumber = argumentArg[1].toString();
        String souNumber = argumentArg[2].toString();
        String transacNumber = argumentArg[3].toString();
        String mfgStr = argumentArg[4].toString();
        StringBuffer msgStr = new StringBuffer();
        StringBuffer msgError = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date mfg = null;
        try {
            mfg = sdf.parse(mfgStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            mfg = new Date();
        }
        String materialID = null;
        MaterialInfo materialInfo = null;
        if (materialNumber != null) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selColl = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("id"));
            selColl.add(new SelectorItemInfo("baseUnit.id"));
            view.setSelector(selColl);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)materialNumber, CompareType.EQUALS));
            view.setFilter(filter);
            MaterialCollection materialCol = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
            if (materialCol.size() > 0) {
                materialID = materialCol.get(0).getId().toString();
                materialInfo = materialCol.get(0);
            }
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("id"));
        coll.add(new SelectorItemInfo("storeTypePre.id"));
        coll.add(new SelectorItemInfo("storeTypePre.number"));
        coll.add(new SelectorItemInfo("storeTypePre.name"));
        coll.add(new SelectorItemInfo("storeStatePre.id"));
        coll.add(new SelectorItemInfo("storeStatePre.number"));
        coll.add(new SelectorItemInfo("storeStatePre.name"));
        viewInfo.setSelector(coll);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)transacNumber));
        viewInfo.setFilter(filterInfo);
        TransactionTypeCollection ttiCol = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeCollection(viewInfo);
        TransactionTypeInfo typeInfo = null;
        if (ttiCol.size() > 0) {
            typeInfo = ttiCol.get(0);
        }
        viewInfo = new EntityViewInfo();
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)souNumber));
        viewInfo.setFilter(filterInfo);
        StorageOrgUnitCollection orgUnitCol = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(viewInfo);
        String souID = null;
        StorageOrgUnitInfo sou = null;
        if (orgUnitCol.size() > 0) {
            sou = orgUnitCol.get(0);
            souID = orgUnitCol.get(0).getId().toString();
        }
        if (materialInfo == null || sou == null) {
            throw new BarcodeWSException(BarcodeWSException.ARGUMENTERROR);
        }
        MaterialInventoryInfo inwentoryInfo = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(materialID, souID);
        if (!inwentoryInfo.isIsPeriodValid() && !StringUtils.isEmpty((String)mfgStr)) {
            throw new BarcodeWSException(BarcodeWSException.CHECKPERIOD);
        }
        int periodValid = inwentoryInfo.getPeriodValid();
        TimeUnitEnum timeUnitEnum = inwentoryInfo.getPeriodValidUnit();
        Date exp = null;
        if (timeUnitEnum != null) {
            int unit = timeUnitEnum.getValue();
            Calendar calendar = this.getMFGCalerdar(mfg, unit, periodValid);
            exp = calendar.getTime();
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity(BOSObjectType.create((String)bosType));
        try {
            String className = entity.getBusinessImplName() + "Info";
            Class<?> invBillBaseInfo = Class.forName(className);
            InvBillBaseInfo editData = null;
            Object object = invBillBaseInfo.newInstance();
            if (object instanceof InvBillBaseInfo) {
                editData = (InvBillBaseInfo)object;
                msgError.append(this.checkEXP(ctx, mfg, exp, typeInfo, sou, materialInfo, editData, inwentoryInfo.isIsPeriodValid(), inwentoryInfo));
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new BarcodeWSException(BarcodeWSException.ARGUMENTERROR);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new BarcodeWSException(BarcodeWSException.ARGUMENTERROR);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new BarcodeWSException(BarcodeWSException.ARGUMENTERROR);
        }
        if (msgError.length() > 0) {
            msgStr.append("<msg value='").append(msgError.toString()).append("'/>").append("\n");
        }
        msgStr.append("<").append("exp").append(" value='").append(sdf.format(exp)).append("'/>");
        return this.packageReturnXml(msgStr.toString());
    }

    public Calendar getMFGCalerdar(Date mfg, int unit, int unitValue) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        if (mfg != null) {
            calendar.setTime(mfg);
            if (unit == 1) {
                calendar.add(1, unitValue);
            } else if (unit == 2) {
                calendar.add(2, unitValue);
            } else if (unit == 3) {
                calendar.add(5, unitValue);
            }
            return calendar;
        }
        calendar.setTime(new Date());
        return calendar;
    }

    protected String checkEXP(Context ctx, Date mfg, Date exp, TransactionTypeInfo tti, StorageOrgUnitInfo sou, MaterialInfo materialInfo, InvBillBaseInfo editData, boolean uncheckEXP, MaterialInventoryInfo materialInventory) throws EASBizException, BOSException {
        Calendar c;
        if (mfg == null || exp == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        if (exp.before(mfg) && !exp.equals(mfg)) {
            throw new BarcodeWSException(BarcodeWSException.EXPBEFOREMFG);
        }
        Date now = new Date();
        Date now2 = new Date(now.getYear(), now.getMonth(), now.getDate());
        Date newMfg = new Date(mfg.getYear(), mfg.getMonth(), mfg.getDate());
        boolean beforeNow = exp.before(now2) && !exp.equals(now2);
        boolean afterNow = newMfg.after(now2) && !newMfg.equals(now2);
        boolean ischecked = false;
        if (!uncheckEXP) {
            return null;
        }
        Date bizDate = editData.getBizDate();
        if (null == bizDate) {
            bizDate = new Date();
            editData.setBizDate(bizDate);
        }
        Date compareBizDate = new Date(bizDate.getTime() + 3600000L);
        if (sou != null && materialInfo != null && editData != null && (editData instanceof PurReceivalBillInfo || editData instanceof PurInWarehsBillInfo || editData instanceof OtherInWarehsBillInfo || editData instanceof MoveInWarehsBillInfo || editData instanceof ManufactureRecBillInfo) && !ischecked) {
            c = Calendar.getInstance();
            c.setTime(exp);
            if (materialInventory != null && materialInventory.isIsPeriodValid()) {
                int InWarehsAhead = materialInventory.getInWarehsAhead();
                if (materialInventory.getAheadUnit().equals((Object)TimeUnitEnum.YEAR)) {
                    c.add(1, -InWarehsAhead);
                } else if (materialInventory.getAheadUnit().equals((Object)TimeUnitEnum.MONTH)) {
                    c.add(2, -InWarehsAhead);
                } else if (materialInventory.getAheadUnit().equals((Object)TimeUnitEnum.DAY)) {
                    c.add(5, -InWarehsAhead);
                }
                if (c.getTime().before(compareBizDate)) {
                    String msg = this.getMassege(ctx, resource, "EXPVALID");
                    return msg;
                }
            }
        }
        if (sou != null && materialInfo != null && editData != null && (editData instanceof SaleIssueBillInfo || editData instanceof MaterialRequestBillInfo || editData instanceof OtherIssueBillInfo || editData instanceof MoveIssueBillInfo || editData instanceof MaterialReqBillInfo) && !ischecked) {
            c = Calendar.getInstance();
            c.setTime(exp);
            if (materialInventory != null && materialInventory.isIsPeriodValid()) {
                int outWarehsAhead = materialInventory.getOutWarehsAhead();
                if (materialInventory.getAheadUnit().equals((Object)TimeUnitEnum.YEAR)) {
                    c.add(1, -outWarehsAhead);
                } else if (materialInventory.getAheadUnit().equals((Object)TimeUnitEnum.MONTH)) {
                    c.add(2, -outWarehsAhead);
                } else if (materialInventory.getAheadUnit().equals((Object)TimeUnitEnum.DAY)) {
                    c.add(5, -outWarehsAhead);
                }
                if (c.getTime().before(compareBizDate)) {
                    String msg = this.getMassege(ctx, resource, "EXPVALID");
                    return msg;
                }
            }
        }
        return "";
    }

    public String setLotData(Context ctx, Object[] argumentArg) throws EASBizException, BOSException {
        String bosType = argumentArg[0].toString();
        String materialNumber = argumentArg[1].toString();
        String souNumber = argumentArg[2].toString();
        String transacNumber = argumentArg[3].toString();
        String lot = argumentArg[4].toString();
        StringBuffer msgStr = new StringBuffer();
        StringBuffer msgError = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String materialID = null;
        MaterialInfo materialInfo = null;
        if (materialNumber != null) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selColl = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("id"));
            selColl.add(new SelectorItemInfo("baseUnit.id"));
            view.setSelector(selColl);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)materialNumber, CompareType.EQUALS));
            view.setFilter(filter);
            MaterialCollection materialCol = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
            if (materialCol.size() > 0) {
                materialID = materialCol.get(0).getId().toString();
                materialInfo = materialCol.get(0);
            }
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("id"));
        coll.add(new SelectorItemInfo("storeTypePre.id"));
        coll.add(new SelectorItemInfo("storeTypePre.number"));
        coll.add(new SelectorItemInfo("storeTypePre.name"));
        coll.add(new SelectorItemInfo("storeStatePre.id"));
        coll.add(new SelectorItemInfo("storeStatePre.number"));
        coll.add(new SelectorItemInfo("storeStatePre.name"));
        viewInfo.setSelector(coll);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)transacNumber));
        viewInfo.setFilter(filterInfo);
        TransactionTypeCollection ttiCol = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeCollection(viewInfo);
        TransactionTypeInfo typeInfo = null;
        if (ttiCol.size() > 0) {
            typeInfo = ttiCol.get(0);
        }
        viewInfo = new EntityViewInfo();
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)souNumber));
        viewInfo.setFilter(filterInfo);
        StorageOrgUnitCollection orgUnitCol = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(viewInfo);
        String souID = null;
        StorageOrgUnitInfo sou = null;
        if (orgUnitCol.size() > 0) {
            sou = orgUnitCol.get(0);
            souID = orgUnitCol.get(0).getId().toString();
        }
        if (materialInfo == null || sou == null) {
            throw new BarcodeWSException(BarcodeWSException.ARGUMENTERROR);
        }
        DateOfMinDurabilityInfo dod = this.getDurability(ctx, materialID, souID, lot);
        if (dod == null) {
            return this.packageReturnXml(msgStr.toString());
        }
        Timestamp mfg = dod.getMfg();
        Timestamp exp = dod.getExp();
        MaterialInventoryInfo inwentoryInfo = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(materialID, souID);
        if (inwentoryInfo.isIsPeriodValid()) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
            EntityObjectInfo entity = loader.getEntity(BOSObjectType.create((String)bosType));
            try {
                String msgErrorStr;
                String className = entity.getBusinessImplName() + "Info";
                Class<?> invBillBaseInfo = Class.forName(className);
                InvBillBaseInfo editData = null;
                Object object = invBillBaseInfo.newInstance();
                if (object instanceof InvBillBaseInfo && (msgErrorStr = this.checkEXP(ctx, mfg, exp, typeInfo, sou, materialInfo, editData = (InvBillBaseInfo)object, inwentoryInfo.isIsPeriodValid(), inwentoryInfo)) != null && !"".equals(msgErrorStr)) {
                    msgError.append(msgErrorStr);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new BarcodeWSException(BarcodeWSException.ARGUMENTERROR);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                throw new BarcodeWSException(BarcodeWSException.ARGUMENTERROR);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new BarcodeWSException(BarcodeWSException.ARGUMENTERROR);
            }
        }
        if (msgError.length() > 0) {
            msgStr.append("<msg value='").append(msgError.toString()).append("'/>").append("\n");
        }
        msgStr.append("<").append("mfg").append(" value='").append(sdf.format(mfg)).append("'/>").append("\n");
        msgStr.append("<").append("exp").append(" value='").append(sdf.format(exp)).append("'/>");
        return this.packageReturnXml(msgStr.toString());
    }

    public DateOfMinDurabilityInfo getDurability(Context ctx, String materialID, String souID, String lot) throws EASBizException, BOSException {
        if (materialID == null || souID == null || lot == null) {
            return null;
        }
        if (this.getMapDurability() == null) {
            this.mapDurability = new HashMap(0);
        }
        if (!this.getMapDurability().containsKey(materialID + souID + lot) || this.getMapDurability().get(materialID + souID + lot) == null) {
            StringBuffer oql = new StringBuffer();
            oql.append("select id,material,storageOrgUnit,lot,mfg,exp where ").append("storageOrgUnit = '").append(souID).append("' and ").append("material =  '").append(materialID).append("' and ").append("lot = '").append(lot).append("'");
            IDateOfMinDurability ido = DateOfMinDurabilityFactory.getLocalInstance((Context)ctx);
            DateOfMinDurabilityCollection doc = ido.getDateOfMinDurabilityCollection(oql.toString());
            if (doc.size() > 0) {
                this.putDurability(materialID, souID, lot, doc.get(0));
            }
        }
        return (DateOfMinDurabilityInfo)this.getMapDurability().get(materialID + souID + lot);
    }

    public void putDurability(String materialID, String souID, String lot, DateOfMinDurabilityInfo dod) {
        if (materialID == null || souID == null || lot == null) {
            return;
        }
        this.getMapDurability().put(materialID + souID + lot, dod);
    }

    public String getFTPMessage(Context ctx, Object[] argumentArg) throws BOSException {
        StringBuffer ftpStr = new StringBuffer();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("simpleName"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("host"));
        sic.add(new SelectorItemInfo("userName"));
        sic.add(new SelectorItemInfo("rootPath"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("port"));
        sic.add(new SelectorItemInfo("password"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.appendFilterItem("status", (Object)"1");
        view.setFilter(filterInfo);
        FtpConfigCollection ftpCol = FtpConfigFactory.getLocalInstance(ctx).getFtpConfigCollection(view);
        if (ftpCol.size() > 0) {
            FtpConfigInfo ftpConfigInfo = ftpCol.get(0);
            ftpStr.append("<ftpServer host='").append(ftpConfigInfo.getHost()).append("'");
            ftpStr.append(" port='").append(ftpConfigInfo.getPort()).append("'");
            ftpStr.append(" userName='").append(ftpConfigInfo.getUserName()).append("'");
            try {
                ftpStr.append(" password='").append(CryptoTean.decrypt((String)ftpConfigInfo.getUserName(), (String)ftpConfigInfo.getPassword())).append("'");
                ftpStr.append(" rootPath='").append(ftpConfigInfo.getRootPath()).append("'").append("/>");
            }
            catch (CryptException e1) {
                e1.printStackTrace();
            }
        }
        return this.packageReturnXml(ftpStr.toString());
    }

    protected String getMaterialMessageList(Context ctx, Object[] argumentArg) throws EASBizException, BOSException {
        if (argumentArg.length < -1) {
            throw new BarcodeWSException(BarcodeWSException.BARCOEDNULLDATA);
        }
        String barcode = argumentArg[0].toString();
        String configId = argumentArg[1].toString();
        String flag = argumentArg[2].toString();
        StringBuffer materialID = new StringBuffer();
        String locationNumber = null;
        if ("0".equals(flag)) {
            BarcodePDAScanning pdaScanning = new BarcodePDAScanning();
            BarcodeConfigInfo configInfo = BarcodeConfigFactory.getLocalInstance(ctx).getBarcodeConfigInfo((IObjectPK)new ObjectUuidPK(configId));
            if (configInfo == null) {
                return null;
            }
            String srcBosType = configInfo.getSrcBosType();
            String destBosType = configInfo.getDestBosType();
            String paramValue = BarcodeClientUtils.getParamValueStr(ctx);
            ArrayList<BarcodeAnalysisResult> barcodeResultList = new ArrayList<BarcodeAnalysisResult>();
            CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            pdaScanning.executeBarcode(ctx, barcode, null, srcBosType, destBosType, paramValue, ctrlUnitInfo, barcodeResultList, true);
            if (barcodeResultList.size() == 0) {
                throw new BarcodeWSException(BarcodeWSException.BARCODENULL);
            }
            int size = barcodeResultList.size();
            for (int i = 0; i < size; ++i) {
                BarcodeAnalysisResult analysisResult = (BarcodeAnalysisResult)barcodeResultList.get(i);
                if (materialID.length() > 0) {
                    materialID.append(",").append(analysisResult.getMaterialID());
                    continue;
                }
                materialID.append(analysisResult.getMaterialID());
            }
        } else if (argumentArg.length > 3) {
            locationNumber = argumentArg[3].toString();
        }
        StringBuffer detailsXml = new StringBuffer();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("warehouse.id"));
        sic.add(new SelectorItemInfo("warehouse.name"));
        sic.add(new SelectorItemInfo("warehouse.number"));
        sic.add(new SelectorItemInfo("location.id"));
        sic.add(new SelectorItemInfo("location.name"));
        sic.add(new SelectorItemInfo("location.number"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.model"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("assistUnit.id"));
        sic.add(new SelectorItemInfo("assistUnit.number"));
        sic.add(new SelectorItemInfo("assistUnit.name"));
        sic.add(new SelectorItemInfo("curStoreQty"));
        view.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        if ("0".equals(flag) && materialID.length() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID.toString(), CompareType.INCLUDE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("warehouse.number", (Object)barcode, CompareType.INCLUDE));
            if (locationNumber != null && !"".equals(locationNumber)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("location.number", (Object)locationNumber, CompareType.EQUALS));
            }
        }
        OrgUnitCollection coll = OrgUnitUtils.getAuthOrgByPermItem(ctx, OrgType.Storage, "inventory");
        String permissionCuStr = OrgUnitUtils.toStringList(coll, "number");
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.number", (Object)permissionCuStr, CompareType.INCLUDE));
        FilterInfo qtyfilterInfo = new FilterInfo();
        qtyfilterInfo.getFilterItems().add(new FilterItemInfo("baseQty", (Object)BigDecimal.ZERO, CompareType.NOTEQUALS));
        qtyfilterInfo.getFilterItems().add(new FilterItemInfo("lockBaseQty", (Object)BigDecimal.ZERO, CompareType.NOTEQUALS));
        qtyfilterInfo.getFilterItems().add(new FilterItemInfo("curStoreQty", (Object)BigDecimal.ZERO, CompareType.NOTEQUALS));
        qtyfilterInfo.getFilterItems().add(new FilterItemInfo("curStoreAssistQty", (Object)BigDecimal.ZERO, CompareType.NOTEQUALS));
        qtyfilterInfo.setMaskString("(#0 or #1 or #2 or #3)");
        filterInfo.mergeFilter(qtyfilterInfo, "and");
        view.setFilter(filterInfo);
        logger.info((Object)("\u67e5\u8be2\u5e93\u5b58sql" + view.toString()));
        InventoryCollection inventoryCol = InventoryFactory.getLocalInstance((Context)ctx).getInventoryCollection(view);
        if (inventoryCol.size() > 0) {
            BarcodeConfigInfo configInfo = BarcodeConfigFactory.getLocalInstance(ctx).getBarcodeConfigInfo((IObjectPK)new ObjectUuidPK(configId));
            IBarcodeScanning barcodeScanning = BarcodeScanningFactory.getLocalInstance(ctx);
            BarcodeConfigXML xmlInfo = BarcodeXMLHelper.toBarcodeConfigXML(configInfo.getDetailsXML());
            String bosType = "";
            int size = xmlInfo.getDetails().size();
            for (int i = 0; i < size; ++i) {
                BarcodeConfigXMLDetail xmlDetail = xmlInfo.getDetails().get(i);
                String parentBosType = xmlDetail.getBosType();
                List<BarcodeConfigXMLProperty> xmlPropertys = xmlDetail.getProperties();
                if (parentBosType != null && !"".equals(parentBosType)) {
                    bosType = "b_" + xmlDetail.getEntityName() + "_" + xmlDetail.getBosType();
                }
                detailsXml.append("<").append(bosType).append("> \n");
                int m = inventoryCol.size();
                for (int k = 0; k < m; ++k) {
                    IObjectValue entryValue = inventoryCol.getObject(k);
                    detailsXml.append("<Row>").append("\n");
                    this.getLinkedPropertyXML(ctx, xmlPropertys, entryValue, barcodeScanning, detailsXml, configInfo.getDestBosType());
                    detailsXml.append("</Row>").append("\n");
                }
                detailsXml.append("</").append(bosType).append(">\n");
            }
        }
        StringBuffer xmlStr = new StringBuffer();
        xmlStr.append("<SrcBillInfo>").append("\n");
        xmlStr.append(detailsXml).append("\n");
        xmlStr.append("</SrcBillInfo>").append("\n");
        return this.packageReturnXml(xmlStr.toString());
    }

    @Override
    protected byte[] _uploadData(Context ctx, String argumentStr) throws BOSException, EASBizException {
        String[] argumenArg = argumentStr.split(",");
        String deviceid = argumenArg[0];
        if (deviceid != null && !"".equals(deviceid)) {
            try {
                BarcodeLicenseUtils.checkLicense(ctx, true, null, deviceid);
            }
            catch (LicenseException e) {
                throw new BarcodeWSException(new NumericExceptionSubItem("", e.fillInStackTrace().getMessage()));
            }
        }
        this.initContext(ctx);
        EntityViewInfo view = null;
        FilterInfo filter = null;
        ScanTaskBillFactory.getLocalInstance(ctx).exportData(null, null);
        AttachmentServerManager serverManager = new AttachmentServerManager(ctx);
        CompanyOrgUnitInfo companyOrgUniInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        logger.info((Object)("uploadData \u8d22\u52a1\u7ec4\u7ec7" + companyOrgUniInfo.getName()));
        if (companyOrgUniInfo != null) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyOrgUniInfo.getId()));
            view.setFilter(filter);
            SynDataBaseCollection synCol = SynDataBaseFactory.getLocalInstance(ctx).getSynDataBaseCollection(view);
            if (synCol.size() > 0) {
                SynDataBaseInfo synDateBaseInfo = synCol.get(0);
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("boId", (Object)synDateBaseInfo.getId()));
                view.setFilter(filter);
                String[] attachID = BoAttchAssoFactory.getLocalInstance((Context)ctx).getAttchIDsByBoID(synDateBaseInfo.getId().toString());
                StringBuffer str = new StringBuffer();
                int size = attachID.length;
                for (int i = 0; i < size; ++i) {
                    if (str.length() > 0) {
                        str.append(",").append(attachID[i]);
                        continue;
                    }
                    str.append(attachID[i]);
                }
                view = new EntityViewInfo();
                filter = new FilterInfo();
                if (str.length() > 0) {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)str.toString(), CompareType.INCLUDE));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("attachID", (Object)"synBaseData"));
                }
                view.setFilter(filter);
            } else {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("attachID", (Object)"synBaseData"));
                view.setFilter(filter);
            }
        } else {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("attachID", (Object)"synBaseData"));
            view.setFilter(filter);
        }
        AttachmentCollection attaInfoCol = AttachmentFactory.getLocalInstance((Context)ctx).getAttachmentCollection(view);
        if (attaInfoCol.size() == 0) {
            return new byte[0];
        }
        AttachmentInfo attaInfo = attaInfoCol.get(0);
        byte[] dataByte = serverManager.download(attaInfo.getId().toString());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(bos);
            gzip.write(dataByte);
            gzip.finish();
            gzip.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public String getAssisUnitByMaterial(Context ctx, Object[] argumentArg) throws BOSException, EASBizException {
        if (argumentArg.length < -1) {
            return null;
        }
        String materialNumber = argumentArg[0].toString();
        StringBuffer valueStr = new StringBuffer();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("assistUnit.*"));
        view.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)materialNumber, CompareType.EQUALS));
        view.setFilter(filterInfo);
        MaterialCollection mCol = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
        if (mCol.size() > 0) {
            MaterialInfo minfo = mCol.get(0);
            if (minfo != null && minfo.getAssistUnit() != null) {
                valueStr.append("<FID value='").append(minfo.getAssistUnit().getId().toString()).append("'/>").append("\n");
                valueStr.append("<assistUnit_number value='").append(minfo.getAssistUnit().getNumber()).append("'/>").append("\n");
                valueStr.append("<assistUnit_name value='").append(minfo.getAssistUnit().getName()).append("'/>").append("\n");
                valueStr.append("<FCoefficient value='").append(minfo.getAssistUnit().getCoefficient().toString()).append("'/>").append("\n");
            }
        } else {
            throw new BarcodeWSException(BarcodeWSException.ARGUMENTERROR);
        }
        return this.packageReturnXml(valueStr.toString());
    }

    public String unzip(String compressedStr) throws IOException {
        int n;
        if (compressedStr == null || compressedStr.length() == 0) {
            return compressedStr;
        }
        byte[] bytes = Base64Decoder.decode((String)compressedStr);
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        GZIPInputStream ungzip = new GZIPInputStream(in);
        byte[] buffer = new byte[256];
        while ((n = ungzip.read(buffer)) >= 0) {
            out.write(buffer, 0, n);
        }
        return out.toString("UTF-8");
    }
}

