/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.pda.encoding.Cipher;
import com.kingdee.eas.barcode.pda.encoding.Hash;
import com.kingdee.eas.barcode.scm.LiceControlCollection;
import com.kingdee.eas.barcode.scm.LiceControlFactory;
import com.kingdee.eas.barcode.scm.LiceControlInfo;
import com.kingdee.eas.barcode.scm.app.LicenseCache;
import com.kingdee.eas.barcode.scm.util.Json;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Util2 {
    private static final int DEFAULT_USERS = 0;

    public static boolean isValid(String json, String key) {
        try {
            String hash = Hash.SHA.hash(json);
            String unhash = Cipher.RSA.decrypt(key, Util2.getKey());
            return hash.equals(unhash);
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getKey() {
        URL url = Util2.class.getClassLoader().getResource("uwplat/db/util/public_key.txt");
        InputStreamReader r = null;
        try {
            String key;
            r = new InputStreamReader(url.openStream());
            StringBuilder sb = new StringBuilder();
            int c = r.read();
            while (c >= 0) {
                sb.append((char)c);
                c = r.read();
            }
            String string = key = sb.toString();
            return string;
        }
        catch (Exception e) {
            String string = "16967345823423927743229910964115981985952840117538650672311766295932440074642671656889161566468261761286828973599881765873262825977593729654621163823834289132533386568065841002445512494908440898859692639751453303965715717610190491467425654269016809160731335793136078026230004054609070515761743152415993105551779222511532932440753334415660402729911163184045338168272505779725870985569976258280293289271342174454330834522779715185749598258274177954340697197939925319680295291282550945188392717420852911317896750917451994655652153839959529446896461105506180659825535453609572748095557426208818747050585833969662538855033,65537";
            return string;
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to close input stream.");
                }
            }
        }
    }

    public static Map<String, Object> getLisense(Context ctx) {
        Map<String, Object> lisense;
        try {
            lisense = Util2.readLisense(ctx);
        }
        catch (Exception e) {
            lisense = null;
        }
        if (lisense == null) {
            lisense = Util2.generateTempLisense();
        }
        return lisense;
    }

    private static Map<String, Object> generateTempLisense() {
        HashMap<String, Object> lisense = new HashMap<String, Object>();
        lisense.put("connections", 1);
        lisense.put("users", 0);
        lisense.put("env_type", "development");
        lisense.put("expire", "2018-12-31 23:59:59");
        return lisense;
    }

    private static Map<String, Object> readLisense(Context ctx) throws Exception {
        String key;
        String licenseStr = null;
        if (StringUtils.isEmpty((String)LicenseCache.getDataJson(ctx))) {
            String runtime = LiceControlFactory.getLocalInstance(ctx).getMetaRumTime();
            if (runtime == null) {
                return null;
            }
            LiceControlCollection coll = LiceControlFactory.getLocalInstance(ctx).getLiceControlCollection("where number='" + runtime + "'");
            if (coll.size() == 0) {
                return null;
            }
            licenseStr = coll.get(0).getData_json();
            LicenseCache.setLicenseInfo(ctx, licenseStr);
        } else {
            licenseStr = LicenseCache.getDataJson(ctx);
        }
        Map license = (Map)Json.toObject(licenseStr);
        if (license == null) {
            return null;
        }
        String json = (String)license.get("json");
        if (!Util2.isValid(json, key = (String)license.get("key"))) {
            return null;
        }
        Map cfg = (Map)Json.toObject(json);
        Date expire = DateTimeUtils.parseDate((String)((String)cfg.get("expire")));
        if (expire.before(new Date())) {
            cfg.put("connections", 0);
            cfg.put("users", 0);
            cfg.put("env_type", "development");
            return cfg;
        }
        String serverId = LiceControlFactory.getLocalInstance(ctx).getMachineCode();
        String servers = (String)cfg.get("server");
        boolean matched = false;
        if (serverId.equals(servers)) {
            matched = true;
        }
        if (!matched) {
            return null;
        }
        return cfg;
    }

    private static String getMetaRuntime(Context ctx) throws Exception {
        LiceControlInfo info = LiceControlFactory.getLocalInstance(ctx).getLiceControlInfo((IObjectPK)new ObjectUuidPK(""));
        if (info == null) {
            info = new LiceControlInfo();
            info.setId(BOSUuid.read((String)""));
            info.setNumber("meta.runtime");
            info.setName(Util2.genRunTimeId());
            info.setDescription("");
            IObjectPK pk = LiceControlFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
            info.setId(BOSUuid.read((String)pk.toString()));
        }
        return info.getName();
    }

    private static String genRunTimeId() {
        return Uuid.randomUUID().toString();
    }
}

