/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.FaStockTakeRecEntryInfo;
import com.kingdee.eas.barcode.scm.FaStockTakeRecFactory;
import com.kingdee.eas.barcode.scm.FaStockTakeRecInfo;
import com.kingdee.eas.barcode.scm.IFaStockTakeRec;
import com.kingdee.eas.barcode.scm.util.UWDateHelper;
import com.kingdee.eas.basedata.assistant.AddressCollection;
import com.kingdee.eas.basedata.assistant.AddressFactory;
import com.kingdee.eas.basedata.assistant.IAddress;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaStocktakingBillInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingTaskBillFactory;
import com.kingdee.eas.fi.fa.manage.FaStocktakingTaskBillInfo;
import com.kingdee.eas.fi.fa.manage.IFaStocktakingTaskBill;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CreactNewFaStockTakeRecExec
implements SyncExec {
    private static Logger logger = Logger.getLogger((String)CreactNewFaStockTakeRecExec.class.getName());

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        IObjectPK pk = null;
        BacodeMainReturn rv = new BacodeMainReturn();
        String newReqTime = UWDateHelper.FORMAT_TIME.format(new Date());
        try {
            pk = this.createFaStockTakeRec(ctx, params);
            if (pk != null) {
                rv.setMsg("\u5355\u636e\u3010" + params.getParams().get("GUUID").toString() + "\u3011\u751f\u6210\u6210\u529f\uff01");
                rv.setDefSucc(newReqTime);
            }
        }
        catch (Exception e) {
            rv.setInnerError(e.getMessage());
            logger.warn((Object)e);
        }
        return rv;
    }

    private IObjectPK createFaStockTakeRec(Context ctx, BarcodeMainParam params) throws BOSException, EASBizException {
        List entrys;
        IObjectPK pk = null;
        FaStockTakeRecInfo info = new FaStockTakeRecInfo();
        info.setNumber(params.getParams().get("GUUID") != null ? params.getParams().get("GUUID").toString() : null);
        String sFSTTBID = params.getParams().get("FaStockTTBID") != null ? params.getParams().get("FaStockTTBID").toString() : null;
        FaStocktakingTaskBillInfo tinfo = null;
        if (sFSTTBID != null && sFSTTBID.length() > 0) {
            if (BOSUuid.read((String)sFSTTBID).getType().toString().equals(new FaStocktakingBillInfo().getBOSType().toString())) {
                String sql = "select ftaskbillid from T_FA_StocktakingBill where fid='" + sFSTTBID + "'";
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                try {
                    if (rowSet.next()) {
                        sFSTTBID = rowSet.getString("ftaskbillid");
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            IFaStocktakingTaskBill iFSTTB = FaStocktakingTaskBillFactory.getLocalInstance((Context)ctx);
            tinfo = iFSTTB.getFaStocktakingTaskBillInfo((IObjectPK)new ObjectUuidPK(sFSTTBID));
        }
        if (tinfo == null) {
            logger.error((Object)"\u76d8\u70b9\u4efb\u52a1\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new BOSException("\u76d8\u70b9\u4efb\u52a1\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        info.setFaStockTTB(tinfo);
        List list = entrys = params.getParams().get("entrys") != null ? (List)params.getParams().get("entrys") : null;
        if (entrys != null) {
            HashSet<String> barcodeSet = new HashSet<String>();
            String barcode = null;
            BigDecimal qty = null;
            String tmp = null;
            AddressCollection ac = null;
            AdminOrgUnitCollection oc = null;
            PersonCollection pc = null;
            IAddress IAD = AddressFactory.getLocalInstance((Context)ctx);
            IAdminOrgUnit IAO = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            IPerson IPS = PersonFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = null;
            FilterInfo filter = null;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("name");
            sic.add("number");
            sic.add("id");
            int j = 0;
            FaStockTakeRecEntryInfo einfo = new FaStockTakeRecEntryInfo();
            for (int i = 0; i < entrys.size(); ++i) {
                Map map = (Map)entrys.get(i);
                barcode = map.get("barcode") != null ? map.get("barcode").toString() : null;
                BigDecimal bigDecimal = qty = map.get("qty") != null ? new BigDecimal(map.get("qty").toString()) : null;
                if (barcodeSet.contains(barcode)) continue;
                barcodeSet.add(barcode);
                einfo = new FaStockTakeRecEntryInfo();
                einfo.setBarcode(barcode);
                if (qty == null || qty.compareTo(BigDecimal.ZERO) == 0) {
                    logger.error((Object)("\u7b2c" + (i + 1) + "\u884c\u626b\u63cf\u6570\u91cf\u6709\u8bef\uff0c\u5fc5\u987b\u4e3a\u975e0\u7684\u6570\u503c\uff01"));
                    throw new BOSException("\u7b2c" + (i + 1) + "\u884c\u626b\u63cf\u6570\u91cf\u6709\u8bef\uff0c\u5fc5\u987b\u4e3a\u975e0\u7684\u6570\u503c\uff01");
                }
                einfo.setQty(qty);
                einfo.setIsDeleted(false);
                einfo.setIsUpdated(false);
                String string = tmp = map.get("adrnum") != null ? map.get("adrnum").toString() : null;
                if (null != tmp && tmp.length() > 0) {
                    view = new EntityViewInfo();
                    filter = new FilterInfo();
                    ac = null;
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)tmp, CompareType.EQUALS));
                    view.setFilter(filter);
                    view.setSelector(sic);
                    ac = IAD.getAddressCollection(view);
                    if (null != ac && ac.size() > 0) {
                        einfo.setAdress(ac.get(0));
                    }
                }
                String string2 = tmp = map.get("admindept_num") != null ? map.get("admindept_num").toString() : null;
                if (null != tmp && tmp.length() > 0) {
                    view = new EntityViewInfo();
                    filter = new FilterInfo();
                    oc = null;
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)tmp, CompareType.EQUALS));
                    view.setFilter(filter);
                    view.setSelector(sic);
                    oc = IAO.getAdminOrgUnitCollection(view);
                    if (null != oc && oc.size() > 0) {
                        einfo.setAdminDept(oc.get(0));
                    }
                }
                String string3 = tmp = map.get("admindept_keeper_num") != null ? map.get("admindept_keeper_num").toString() : null;
                if (null != tmp && tmp.length() > 0) {
                    view = new EntityViewInfo();
                    filter = new FilterInfo();
                    pc = null;
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)tmp, CompareType.EQUALS));
                    view.setFilter(filter);
                    view.setSelector(sic);
                    pc = IPS.getPersonCollection(view);
                    if (null != pc && pc.size() > 0) {
                        einfo.setKeeper(pc.get(0));
                    }
                }
                String string4 = tmp = map.get("usedept_num") != null ? map.get("usedept_num").toString() : null;
                if (null != tmp && tmp.length() > 0) {
                    view = new EntityViewInfo();
                    filter = new FilterInfo();
                    oc = null;
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)tmp, CompareType.EQUALS));
                    view.setFilter(filter);
                    view.setSelector(sic);
                    oc = IAO.getAdminOrgUnitCollection(view);
                    if (null != oc && oc.size() > 0) {
                        einfo.setUseDept(oc.get(0));
                    }
                }
                String string5 = tmp = map.get("us_person_num") != null ? map.get("us_person_num").toString() : null;
                if (null != tmp && tmp.length() > 0) {
                    view = new EntityViewInfo();
                    filter = new FilterInfo();
                    pc = null;
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)tmp, CompareType.EQUALS));
                    view.setFilter(filter);
                    view.setSelector(sic);
                    pc = IPS.getPersonCollection(view);
                    if (null != pc && pc.size() > 0) {
                        einfo.setUsePerson(pc.get(0));
                    }
                }
                tmp = map.get("remark") != null ? map.get("remark").toString() : null;
                einfo.setNote(tmp);
                info.getEntry().add(einfo);
                ++j;
            }
        }
        if (info.getEntry().isEmpty()) {
            logger.error((Object)"\u626b\u63cf\u8bb0\u5f55\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new BOSException("\u626b\u63cf\u8bb0\u5f55\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        info.setFICompany(ContextUtil.getCurrentFIUnit((Context)ctx));
        info.setActor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setBizDate(new Date());
        IFaStockTakeRec iFST = FaStockTakeRecFactory.getLocalInstance(ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        if (iFST.exists(filterInfo)) {
            logger.error((Object)("\u5df2\u7ecf\u751f\u6210\u5355\u636e\u3010" + info.getNumber() + "\u3011,\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\uff01"));
            throw new BOSException("\u5df2\u7ecf\u751f\u6210\u5355\u636e\u3010" + info.getNumber() + "\u3011,\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\uff01");
        }
        pk = iFST.submit((CoreBaseInfo)info);
        return pk;
    }
}

