/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.barcode.fa.manage.FAExBaseStatusEnum;
import com.kingdee.eas.barcode.fa.manage.RepairBillEntryInfo;
import com.kingdee.eas.barcode.fa.manage.RepairBillFactory;
import com.kingdee.eas.barcode.fa.manage.RepairBillInfo;
import com.kingdee.eas.barcode.pda.app.biz.FaAssetBaseAddExec;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.scm.BarcodeDossierInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgUnitFacade;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.util.BASE64Decoder;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaRepairAddExec
extends FaAssetBaseAddExec {
    private static Logger logger = Logger.getLogger((String)FaRepairAddExec.class.getName());

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        BacodeMainReturn rv = new BacodeMainReturn();
        try {
            String openid;
            Map json = params.getParams();
            RepairBillInfo info = new RepairBillInfo();
            String number = json.get("number") == null ? null : json.get("number").toString();
            String assetNum = json.get("assetnum") == null ? null : json.get("assetnum").toString();
            String assetName = json.get("assetname") == null ? null : json.get("assetname").toString();
            String barCode = json.get("barcode") == null ? null : json.get("barcode").toString();
            String description = json.get("description") == null ? null : json.get("description").toString();
            List pics = json.get("pics") == null ? null : (List)json.get("pics");
            String operator = json.get("operator") == null ? null : json.get("operator").toString();
            String filing_address = json.get("filing_address") == null ? null : (String)json.get("filing_address");
            String string = openid = json.get("openid") == null ? null : json.get("openid").toString();
            if (operator != null) {
                UserInfo user;
                if (!operator.startsWith("YZJ")) {
                    try {
                        user = UserFactory.getLocalInstance((Context)ctx).getUserInfoByNumber(operator);
                        if (user == null) {
                            rv.setMsg("ERP:\u64cd\u4f5c\u7528\u6237" + operator + "\u4e0d\u5b58\u5728\u4e8eEAS\u4e2d");
                        }
                        info.setOperator(user);
                    }
                    catch (Exception e) {
                        if (openid != null) {
                            UserInfo user2 = this.getUsByOpenId(ctx, openid);
                            info.setOperator(user2);
                        }
                    }
                } else if (openid != null) {
                    user = this.getUsByOpenId(ctx, openid);
                    info.setOperator(user);
                } else {
                    rv.setMsg("ERP:\u670d\u52a1\u5668\u9519\u8bef,\u672a\u4f20\u5165OPENID\u4fe1\u606f");
                }
            }
            info.setNumber(number);
            info.setAssetName(assetName);
            info.setAssetNum(assetNum);
            info.setBarCode(barCode);
            info.setDescription(description);
            info.setBizDate(new Date());
            if (!StringUtils.isEmpty((String)filing_address)) {
                if (filing_address.length() > 255) {
                    filing_address.substring(0, 254);
                }
                info.setLocation(filing_address);
            }
            if (assetName == null) {
                try {
                    BarcodeDossierInfo barInfo = this.getFaCardByAssetNum(ctx, barCode);
                    if (barInfo != null) {
                        if (barInfo.getFaCurCard() != null) {
                            info.setAssetNum(barInfo.getFaCurCard().getNumber());
                            info.setAssetName(barInfo.getFaCurCard().getAssetName());
                            info.setFaCurCard(barInfo.getFaCurCard());
                            info.setSpecs(barInfo.getFaCurCard().getSpecs());
                            info.setMeasureUnit(barInfo.getFaCurCard().getMeasureUnit());
                        } else {
                            rv.setMsg("ERP:\u6761\u7801\u503c" + barCode + "\u975e\u56fa\u5b9a\u8d44\u4ea7\u6761\u7801,\u65e0\u6cd5\u4fdd\u5b58");
                        }
                    } else {
                        rv.setMsg("ERP:\u6761\u7801\u503c" + barCode + "\u65e0\u6cd5\u5728\u6761\u7801\u6863\u6848\u4e2d\u627e\u5230");
                    }
                }
                catch (BOSException e) {
                    logger.error((Object)"\u751f\u6210\u62a5\u5907\u5355\u9519\u8bef=EAS\u67e5\u8be2\u6761\u7801\u51fa\u9519", (Throwable)e);
                    rv.setMsg("ERP:EAS\u67e5\u8be2\u6761\u7801\u51fa\u9519" + e.getMessage());
                }
            }
            if (pics != null) {
                for (int i = 0; i < pics.size(); ++i) {
                    RepairBillEntryInfo entry = new RepairBillEntryInfo();
                    Map map = (Map)pics.get(i);
                    entry.setFileName(map.get("fileName") == null ? null : map.get("fileName").toString());
                    entry.setName(map.get("name") == null ? null : map.get("name").toString());
                    Object picObj = map.get("pic");
                    if (picObj != null) {
                        byte[] buffer = new BASE64Decoder().decodeBuffer(picObj.toString());
                        entry.setFile(buffer);
                    }
                    info.getEntries().add(entry);
                }
            }
            info.setBaseStatus(FAExBaseStatusEnum.SUBMIT);
            info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            try {
                FullOrgUnitInfo def = info.getOperator().getDefOrgUnit();
                INewOrgUnitFacade iNOU = NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx);
                OrgUnitInfo fiInfo = iNOU.getDelegateUnit(def.getId().toString(), OrgType.Company);
                if (fiInfo instanceof CompanyOrgUnitInfo) {
                    info.setCompany((CompanyOrgUnitInfo)fiInfo);
                }
                info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            RepairBillFactory.getLocalInstance(ctx).addnew(info);
            rv.setMsg("SUCCESS");
            rv.setDefSucc();
            return rv;
        }
        catch (Exception e) {
            logger.error((Object)"\u751f\u6210\u62a5\u5907\u5355\u9519\u8bef", (Throwable)e);
            rv.setMsg("ERP:" + e.getMessage());
            return rv;
        }
    }
}

