/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.pda.app.sync.SyncExecAbsFactory;
import com.kingdee.eas.barcode.pda.app.sync.SyncExecUtil;
import com.kingdee.eas.barcode.pda.app.sync.SyncSelectOrg4UserExec;
import com.kingdee.eas.barcode.scm.app.LicenseCache;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class CheckSyncExecFactory
implements SyncExecAbsFactory {
    private static Logger logger = Logger.getLogger((String)CheckSyncExecFactory.class.getName());

    private CheckSyncExecFactory() {
    }

    public static CheckSyncExecFactory getInstance() {
        return SingletonInstance.INSTANCE;
    }

    @Override
    public SyncExec getSyncExec(String type) {
        if ("select_org_4_user".equalsIgnoreCase(type)) {
            return new SyncSelectOrg4UserExec();
        }
        return null;
    }

    @Override
    public BacodeMainReturn preCheck(Context ctx, BarcodeMainParam params) {
        String orgid = (String)params.getParams().get("orgid");
        if (orgid == null) {
            BacodeMainReturn rv = SyncExecUtil.checkFALicense(ctx, params);
            if (rv != null) {
                rv = SyncExecUtil.checkSCMLicense(ctx, params);
            }
            if (rv != null) {
                try {
                    LicenseCache.checkLicense(ctx, (String)params.getParams().get("_deviceid"));
                    rv = null;
                }
                catch (LicenseException e) {
                    rv.setCode("-10");
                    rv.setMsg(e.getMessage());
                }
                return rv;
            }
            rv = CheckSyncExecFactory.checkChanged(ctx, params);
            return rv;
        }
        return null;
    }

    public static BacodeMainReturn checkChanged(Context ctx, BarcodeMainParam params) {
        BacodeMainReturn rv = new BacodeMainReturn();
        if (!StringUtils.isEmpty((String)((String)params.getParams().get("_deviceid")))) {
            try {
                LicenseCache.checkPDA(ctx, (String)params.getParams().get("_deviceid"));
                return null;
            }
            catch (LicenseException e) {
                rv.setCode("-2");
                rv.setMsg("\u7528\u6237\u8bbe\u5907\u53f7\u5df2\u53d8\u52a8,\u6216\u7b2c\u4e00\u6b21\u4f7f\u7528");
            }
        } else {
            rv.setCode("-5");
            rv.setMsg("\u672a\u4f20\u5165\u8bbe\u5907\u53f7");
        }
        if ("0".equalsIgnoreCase(rv.getCode())) {
            return null;
        }
        return rv;
    }

    private static boolean checkEquipment(Context ctx, String equKey) throws BOSException, EASBizException, SQLException {
        UserInfo us = ContextUtil.getCurrentUserInfo((Context)ctx);
        String sql = "select FUserID,FCondition  from  CT_BD_Equipment where FUserID='" + us.getId().toString() + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet.size() > 0) {
            while (rowSet.next()) {
                String condition = rowSet.getString("FCondition");
                if (condition.equals(equKey)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static class SingletonInstance {
        private static final CheckSyncExecFactory INSTANCE = new CheckSyncExecFactory();

        private SingletonInstance() {
        }
    }
}

