/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTMappingUtil;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.runtime.BotUtil;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.scm.BarcodeDossierCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.BarcodeDossierInfo;
import com.kingdee.eas.barcode.scm.BarcodeStateEnum;
import com.kingdee.eas.barcode.scm.BarcodeTaskPropertyCollection;
import com.kingdee.eas.barcode.scm.BarcodeTaskPropertyFactory;
import com.kingdee.eas.barcode.scm.BarcodeTaskPropertyKdtEntryCollection;
import com.kingdee.eas.barcode.scm.BarcodeTaskPropertyKdtEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodeUploadFacadeFactory;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.BcTaskBillCollection;
import com.kingdee.eas.barcode.scm.BcTaskBillEntryBarcodeEntryCollection;
import com.kingdee.eas.barcode.scm.BcTaskBillEntryBarcodeEntryInfo;
import com.kingdee.eas.barcode.scm.BcTaskBillEntryCollection;
import com.kingdee.eas.barcode.scm.BcTaskBillEntryInfo;
import com.kingdee.eas.barcode.scm.BcTaskBillFactory;
import com.kingdee.eas.barcode.scm.BcTaskBillInfo;
import com.kingdee.eas.barcode.scm.BcTaskBillStatusEnum;
import com.kingdee.eas.barcode.scm.IBarcodeDossier;
import com.kingdee.eas.barcode.scm.IBcTaskBill;
import com.kingdee.eas.barcode.scm.IIndBarcodeBack;
import com.kingdee.eas.barcode.scm.IndBarcodeBackCollection;
import com.kingdee.eas.barcode.scm.IndBarcodeBackFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeBackInfo;
import com.kingdee.eas.barcode.scm.ReserveAreaEntryCollection;
import com.kingdee.eas.barcode.scm.ReserveAreaEntryFactory;
import com.kingdee.eas.barcode.scm.ReserveAreaEntryInfo;
import com.kingdee.eas.barcode.scm.StockingStatusEnum;
import com.kingdee.eas.barcode.scm.barcodeUseTypeEmum;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.RIEnum;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.DataDirectionEnum;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreFlagEnum;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.IStockTransferBill;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.MoveLocationBillEntryInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillException;
import com.kingdee.eas.scm.im.inv.StockTransferBillFactory;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CreateEASBillUtil {
    private static Logger logger = Logger.getLogger((String)CreateEASBillUtil.class.getName());
    public static final String SRCBILLID = "sourceBillId";
    public static final String SRCBILLENTRYID = "sourceBillEntryId";
    public static final String REWRITE_EASID = "FEASID";
    public static final String REWRITE_EASBILLNUMBER = "FEASBILLNUMBER";
    public static final String REWRITE_ISUPLOADED = "FISUPLOAD";
    public static final String REWRITE_TABLE = "TABLE_NAME";
    public static final String SCANNING_RECODEID = "scanningRecodeId";
    public static final String SCANNING_TABLENAME = "scanningTableName";
    public static final String MANUFACTUREORDER_BOSTYPE = "1D0D80DD";
    public static final String PRODUCTIONORDER_BOSTYPE = "1F66774E";
    public static final String SUBCONTRACTORDER_BOSTYPE = "F99EE589";
    public static final String MATERIALREQBILL_BOSTYPE = "500AB75E";
    public static final String SALEORDER_BOSTYPE = "C48A423A";
    public static final String POSTREQUISITION_BOSTYPE = "9CA9D08F";
    public static final String STOCKTRANSFERBILL_BOSTYPE = "2239F30A";

    public static String creatSCMBillByBcTask(Context ctx, BarcodeMainParam params) throws BOSException, EASBizException {
        String number = null;
        String sbtIDs = params.getParams().get("BTIDs") != null ? params.getParams().get("BTIDs").toString() : null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("srcBosType"));
        sic.add(new SelectorItemInfo("qty"));
        sic.add(new SelectorItemInfo("actqty"));
        sic.add(new SelectorItemInfo("finqty"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("targetBosType"));
        sic.add(new SelectorItemInfo("targetBillId"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("botp.id"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.material.number"));
        sic.add(new SelectorItemInfo("entrys.barcodeEntrys.*"));
        sic.add(new SelectorItemInfo("barTaskRules.isCheckMode"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sbtIDs, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"4", CompareType.EQUALS));
        view.setFilter(filter);
        IBcTaskBill iBTB = BcTaskBillFactory.getLocalInstance(ctx);
        BcTaskBillCollection bcol = iBTB.getBcTaskBillCollection(view);
        BcTaskBillInfo btbinfo = null;
        String sNum = null;
        boolean isHaveEntry = false;
        if (null != bcol && bcol.size() > 0) {
            String srcBosType = null;
            String bosType = null;
            String botpId = null;
            for (int i = 0; i < bcol.size(); ++i) {
                btbinfo = bcol.get(i);
                if (null != btbinfo.getTargetBillId() && btbinfo.getTargetBillId().toString().length() > 0) {
                    if (null != sNum && sNum.length() > 0) {
                        sNum = sNum + "," + btbinfo.getNumber();
                        continue;
                    }
                    sNum = btbinfo.getNumber();
                    continue;
                }
                srcBosType = btbinfo.getSrcBosType();
                bosType = btbinfo.getTargetBosType();
                String string = botpId = null != btbinfo.getBotp() ? btbinfo.getBotp().getId().toString() : null;
                if (!isHaveEntry && null != btbinfo.getEntrys() && btbinfo.getEntrys().size() > 0) {
                    isHaveEntry = true;
                }
                if (btbinfo.getBarTaskRules() == null || !btbinfo.getBarTaskRules().isIsCheckMode()) continue;
                srcBosType = null;
            }
            if (null != sNum && sNum.length() > 0) {
                logger.error((Object)("\u5355\u53f7\u4e3a" + sNum + "\u7684\u4efb\u52a1\u5df2\u7ecf\u751f\u6210\u5355\u636e\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210\uff01"));
                throw new BOSException("\u5355\u53f7\u4e3a" + sNum + "\u7684\u4efb\u52a1\u5df2\u7ecf\u751f\u6210\u5355\u636e\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210\uff01");
            }
            if (null != srcBosType && null == botpId) {
                logger.error((Object)("\u5355\u53f7\u4e3a" + sNum + "\u7684\u4efb\u52a1\u65e0\u5bf9\u5e94\u7684\u5355\u636e\u8f6c\u6362\u89c4\u5219\uff0c\u65e0\u6cd5\u751f\u6210\u76ee\u6807\u5355\uff01"));
                throw new BOSException("\u5355\u53f7\u4e3a" + sNum + "\u7684\u4efb\u52a1\u65e0\u5bf9\u5e94\u7684\u5355\u636e\u8f6c\u6362\u89c4\u5219\uff0c\u65e0\u6cd5\u751f\u6210\u76ee\u6807\u5355\uff01");
            }
            if (isHaveEntry) {
                number = CreateEASBillUtil.uploadBarcodeBill(ctx, bcol, srcBosType, bosType, botpId);
            }
        }
        return number;
    }

    protected static String uploadBarcodeBill(Context ctx, BcTaskBillCollection taskCol, String srcBosType, String bosType, String botpId) throws BOSException, EASBizException {
        long time = System.currentTimeMillis();
        logger.info((Object)(" uploadBarcodeBill begin\uff1a" + time));
        if (taskCol == null || taskCol.size() == 0) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"66_BarcodeUploadFacadeControllerBean", (Locale)ctx.getLocale())));
        }
        boolean isBotp = false;
        if (botpId != null && !"".equals(botpId.trim())) {
            if (srcBosType == null || "".equals(srcBosType.trim())) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"67_BarcodeUploadFacadeControllerBean", (Locale)ctx.getLocale())));
            }
            isBotp = true;
        }
        EntityObjectInfo entity = BarcodeUtils.getEntityByBosType(bosType);
        try {
            IObjectCollection easBills = CreateEASBillUtil.getNewObjectCollection(ctx, entity);
            ArrayList<BOTRelationCollection> botReltes = new ArrayList<BOTRelationCollection>();
            HashMap relationMap = new HashMap();
            IObjectValue easBill = null;
            if (isBotp) {
                boolean ispass;
                StockTransferBillInfo bill;
                BOTMappingInfo mappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo(" where id = '" + botpId + "'");
                String entryName = BOTMappingUtil.getDestEntriesName((BOTMappingInfo)mappingInfo);
                String[] srcBillId = new String[taskCol.size()];
                ArrayList<String> srcBillEntryId = new ArrayList<String>();
                for (int i = 0; i < taskCol.size(); ++i) {
                    BcTaskBillInfo btbinfo = taskCol.get(i);
                    srcBillId[i] = btbinfo.getSrcId().toString();
                    if (null != btbinfo.getSrcItemId()) {
                        srcBillEntryId.add(btbinfo.getSrcItemId().toString());
                        continue;
                    }
                    srcBillEntryId.add(btbinfo.getSrcId().toString());
                }
                List rt = BotUtil.getSrcBillPropList((BOTMappingInfo)mappingInfo);
                SelectorItemCollection sic = new SelectorItemCollection();
                int size = rt.size();
                for (int j = 0; j < size; ++j) {
                    sic.add(new SelectorItemInfo(rt.get(j).toString()));
                }
                IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
                BTPTransformResult btpResult = iBTPManager.transformForBotp(srcBillId, new String[]{BOTMappingUtil.getSrcEntriesName((BOTMappingInfo)mappingInfo)}, srcBillEntryId, sic, bosType, (IObjectPK)new ObjectUuidPK(mappingInfo.getId().toString()), srcBosType);
                IObjectCollection destBills = btpResult.getBills();
                BOTRelationCollection botRelationColl = btpResult.getBOTRelationCollection();
                if (destBills != null && destBills.size() > -1) {
                    MaterialReqBillInfo tmpinfo;
                    easBill = destBills.getObject(0);
                    if (MATERIALREQBILL_BOSTYPE.endsWith(bosType) && (MANUFACTUREORDER_BOSTYPE.endsWith(srcBosType) || PRODUCTIONORDER_BOSTYPE.endsWith(srcBosType) || SUBCONTRACTORDER_BOSTYPE.endsWith(srcBosType)) && null != easBill && easBill instanceof MaterialReqBillInfo && null != (tmpinfo = (MaterialReqBillInfo)easBill).getEntry() && tmpinfo.getEntry().size() > 0) {
                        MaterialReqBillEntryCollection tmpec = (MaterialReqBillEntryCollection)tmpinfo.getEntry().clone();
                        MaterialReqBillEntryCollection ec = new MaterialReqBillEntryCollection();
                        tmpinfo.getEntry().clear();
                        String tmpeid = null;
                        for (int j = 0; j < srcBillEntryId.size(); ++j) {
                            tmpeid = (String)srcBillEntryId.get(j);
                            if (null == tmpeid || tmpeid.length() <= 0) continue;
                            for (int i = 0; i < tmpec.size(); ++i) {
                                if (null == tmpec.get(i) || null == tmpec.get(i).getSourceBillEntryId() || !tmpeid.equalsIgnoreCase(tmpec.get(i).getSourceBillEntryId().toString())) continue;
                                tmpinfo.getEntry().add(tmpec.get(i));
                            }
                        }
                    }
                    CreateEASBillUtil.fillScanningToEasData(ctx, entity, taskCol, easBill, relationMap, "botp", srcBosType);
                    BOTRelationInfo botRelationInfo = botRelationColl.get(0);
                    CreateEASBillUtil.resetBotRelation(easBill, entryName, botRelationInfo);
                    botReltes.add(botRelationColl);
                }
                CreateEASBillUtil.fillNullFields(easBill, entity);
                if (STOCKTRANSFERBILL_BOSTYPE.endsWith(bosType) && (SALEORDER_BOSTYPE.endsWith(srcBosType) || POSTREQUISITION_BOSTYPE.endsWith(srcBosType)) && (bill = (StockTransferBillInfo)easBill) != null && bill.getId() != null && (ispass = CreateEASBillUtil.checkAutoTransferForLot(ctx, bill.getId().toString()))) {
                    StockTransferBillEntryCollection coll = bill.getEntry();
                    for (int i = 0; i < coll.size(); ++i) {
                        LocationInfo location;
                        LocationInfo location2;
                        StockTransferBillEntryInfo entry = coll.get(i);
                        int seq = entry.getSeq();
                        WarehouseInfo issueHouse = entry.getIssueWarehouse();
                        if (issueHouse == null) {
                            throw new StockTransferBillException(StockTransferBillException.ISSUEHOUSE_CANNOT_BE_NULL, new Object[]{seq});
                        }
                        if (issueHouse.isHasLocation() && ((location2 = entry.getIssueLocation()) == null || location2.getId() == null)) {
                            throw new StockTransferBillException(StockTransferBillException.ISSUELOCATION_CANNOT_BE_NULL, new Object[]{seq});
                        }
                        WarehouseInfo receiptWarehouse = entry.getReceiptWarehouse();
                        if (receiptWarehouse == null) {
                            throw new StockTransferBillException(StockTransferBillException.RECEHOUSE_CANNOT_BE_NULL, new Object[]{seq});
                        }
                        if (receiptWarehouse.isHasLocation() && ((location = entry.getReceiptLocation()) == null || location.getId() == null)) {
                            throw new StockTransferBillException(StockTransferBillException.RECELOCATION_CANNOT_BE_NULL, new Object[]{seq});
                        }
                        StoreTypeInfo storeType = entry.getStoreType();
                        if (CreateEASBillUtil.isAboutCustomerStore(storeType) && entry.getCustomer() == null) {
                            throw new StockTransferBillException(StockTransferBillException.CUSTOMER_CANNOT_BE_NOT, new Object[]{seq});
                        }
                        if (!CreateEASBillUtil.isAboutSupplierStore(storeType) || entry.getSupplier() != null) continue;
                        throw new StockTransferBillException(StockTransferBillException.SUPPLIER_CANNOT_BE_NOT, new Object[]{seq});
                    }
                }
                easBills.addObject(easBill);
            } else {
                BcTaskBillInfo btinfo;
                easBill = CreateEASBillUtil.getNewObjectValue(ctx, entity);
                EntityViewInfo viewInfo = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("entityField"));
                sic.add(new SelectorItemInfo("KdtEntry.id"));
                sic.add(new SelectorItemInfo("KdtEntry.fullName"));
                sic.add(new SelectorItemInfo("KdtEntry.name"));
                sic.add(new SelectorItemInfo("KdtEntry.isLinkProperty"));
                sic.add(new SelectorItemInfo("KdtEntry.isHeader"));
                sic.add(new SelectorItemInfo("KdtEntry.entryBosType"));
                sic.add(new SelectorItemInfo("KdtEntry.objectType"));
                viewInfo.setSelector(sic);
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
                viewInfo.setFilter(filterInfo);
                BarcodeTaskPropertyCollection bctpc = BarcodeTaskPropertyFactory.getLocalInstance(ctx).getBarcodeTaskPropertyCollection(viewInfo);
                HashMap<String, String> headmap = new HashMap<String, String>();
                HashMap<String, String> entrymap = new HashMap<String, String>();
                String sEntryBosType = null;
                String sEntryName = null;
                BarcodeTaskPropertyKdtEntryCollection bctpec = null;
                if (null != bctpc && bctpc.size() > 0) {
                    BarcodeTaskPropertyKdtEntryInfo peinfo = null;
                    for (int i = 0; i < bctpc.size(); ++i) {
                        bctpec = bctpc.get(i).getKdtEntry();
                        if (null == bctpec || bctpec.size() <= 0) continue;
                        for (int j = 0; j < bctpec.size(); ++j) {
                            peinfo = bctpec.get(j);
                            if (!bosType.equals(peinfo.getObjectType())) continue;
                            String[] pp = peinfo.getFullName().split("\\.");
                            if (peinfo.isIsHeader()) {
                                if (headmap.containsKey(pp[0])) continue;
                                headmap.put(pp[0], bctpc.get(i).getEntityField());
                                continue;
                            }
                            if (null == peinfo.getEntryBosType()) continue;
                            if (null == sEntryBosType) {
                                sEntryBosType = peinfo.getEntryBosType();
                                sEntryName = pp[0];
                            }
                            if (entrymap.containsKey(pp[1])) continue;
                            entrymap.put(pp[1], bctpc.get(i).getEntityField());
                        }
                    }
                }
                if ((btinfo = taskCol.get(0)).getBarTaskRules() == null) {
                    for (Map.Entry ee : headmap.entrySet()) {
                        easBill.put(ee.getKey().toString(), btinfo.get(ee.getValue().toString()));
                    }
                    if (easBill instanceof PurInWarehsBillInfo) {
                        easBill.put("bizType", (Object)BizTypeFactory.getLocalInstance((Context)ctx).getBizTypeInfo("where number = '110'"));
                    }
                    if (entrymap.size() > 0 && null != sEntryBosType) {
                        EntityObjectInfo eentity = BarcodeUtils.getEntityByBosType(sEntryBosType);
                        IObjectValue einfo = CreateEASBillUtil.getNewObjectValue(ctx, eentity);
                        einfo.put("id", (Object)BOSUuid.create(sEntryBosType));
                        for (Map.Entry ee : entrymap.entrySet()) {
                            einfo.put(ee.getKey().toString(), btinfo.get(ee.getValue().toString()));
                        }
                        if (easBill instanceof PurInWarehsBillInfo) {
                            einfo.put("invUpdateType", (Object)InvUpdateTypeFactory.getLocalInstance((Context)ctx).getInvUpdateTypeInfo("where number = '001'"));
                        }
                        ((IObjectCollection)easBill.get(sEntryName)).addObject(einfo);
                    }
                    CreateEASBillUtil.fillScanningToEasData(ctx, entity, taskCol, easBill, entrymap, "new", "");
                } else {
                    ObjectUuidPK objpk = new ObjectUuidPK(btinfo.getSrcId());
                    IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
                    easBill = iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk);
                    CreateEASBillUtil.fillScanningToEasData(ctx, entity, taskCol, easBill, entrymap, "check", "");
                }
                CreateEASBillUtil.fillNullFields(easBill, entity);
                easBills.addObject(easBill);
            }
            time = System.currentTimeMillis() - time;
            logger.info((Object)(" uploadBarcodeBill end\uff1a" + time));
            String numbers = BarcodeUploadFacadeFactory.getLocalInstance(ctx).uploadEasBill(easBills, botReltes, bosType, relationMap);
            if (STOCKTRANSFERBILL_BOSTYPE.endsWith(bosType) && (SALEORDER_BOSTYPE.endsWith(srcBosType) || POSTREQUISITION_BOSTYPE.endsWith(srcBosType)) && null != numbers && numbers.length() > 0) {
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)numbers, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
                ev.setFilter(filter);
                IStockTransferBill iSTB = StockTransferBillFactory.getLocalInstance((Context)ctx);
                StockTransferBillCollection rcol = iSTB.getStockTransferBillCollection(ev);
                if (null != rcol && rcol.size() > 0) {
                    String[] tmp = null;
                    for (int i = 0; i < rcol.size(); ++i) {
                        StockTransferBillInfo info = rcol.get(i);
                        if (null == info || null == info.getId()) continue;
                        try {
                            tmp = iSTB.autoTransfer(info);
                        }
                        catch (Exception e) {
                            if (info != null) {
                                if (info.getBaseStatus() == BillBaseStatusEnum.AUDITED) {
                                    iSTB.unAudit((IObjectPK)new ObjectUuidPK(info.getId()));
                                }
                                iSTB.delete((IObjectPK)new ObjectUuidPK(info.getId()));
                            }
                            e.printStackTrace();
                            throw new BOSException((Throwable)e);
                        }
                        if (null == tmp || tmp.length <= 0) continue;
                        for (int j = 0; j < tmp.length; ++j) {
                            if (null == tmp[j] || tmp[j].length() <= 0) continue;
                            numbers = numbers + "," + tmp[j];
                        }
                    }
                }
            }
            return numbers;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    public static void fillScanningToEasData(Context ctx, EntityObjectInfo entity, BcTaskBillCollection taskCol, IObjectValue easValue, Map relationMap, String way, String srcBosType) throws EASBizException, BOSException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        block236: {
            BOSUuid bid;
            block234: {
                boolean isReserved;
                block235: {
                    if (taskCol == null || taskCol.size() <= 0) {
                        return;
                    }
                    bid = null;
                    if (easValue.get("id") == null) {
                        bid = BOSUuid.create((String)easValue.getBOSType().toString());
                        easValue.put("id", (Object)bid);
                    } else {
                        bid = (BOSUuid)easValue.get("id");
                    }
                    String sBosType = easValue.getBOSType().toString();
                    isReserved = false;
                    if (STOCKTRANSFERBILL_BOSTYPE.endsWith(sBosType) && (SALEORDER_BOSTYPE.endsWith(srcBosType) || POSTREQUISITION_BOSTYPE.endsWith(srcBosType))) {
                        isReserved = true;
                    }
                    if (!"botp".equals(way)) break block234;
                    if (!(easValue instanceof InvBillBaseInfo)) break block235;
                    InvBillBaseInfo invBill = (InvBillBaseInfo)easValue;
                    String souID = null;
                    if (null != invBill.get("storageOrgUnit")) {
                        if (invBill.get("storageOrgUnit") instanceof FullOrgUnitInfo) {
                            StorageOrgUnitInfo storageOrgUnit = new StorageOrgUnitInfo();
                            FullOrgUnitInfo fullOrgUnitInfo = (FullOrgUnitInfo)invBill.get("storageOrgUnit");
                            fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(fullOrgUnitInfo.getId()));
                            storageOrgUnit.setId(fullOrgUnitInfo.getId());
                            storageOrgUnit.setName(fullOrgUnitInfo.getName());
                            storageOrgUnit.setNumber(fullOrgUnitInfo.getNumber());
                            souID = storageOrgUnit.getId().toString();
                            invBill.setStorageOrgUnit(storageOrgUnit);
                        } else {
                            souID = invBill.getStorageOrgUnit().getId().toString();
                        }
                    } else {
                        StorageOrgUnitInfo sounit = ContextUtil.getCurrentStorageUnit((Context)ctx);
                        invBill.setStorageOrgUnit(sounit);
                        if (null != sounit) {
                            souID = sounit.getId().toString();
                        }
                    }
                    String entryName = invBill.getEntryName();
                    String entryBostype = invBill.getEntries().getObject(0).getBOSType().toString();
                    EntityObjectInfo eEntity = BarcodeUtils.getEntityByBosType(entryBostype);
                    IObjectCollection ecol = CreateEASBillUtil.getNewObjectCollection(ctx, eEntity);
                    ecol = invBill.getEntries();
                    IObjectCollection tmpecol = CreateEASBillUtil.getNewObjectCollection(ctx, eEntity);
                    BcTaskBillEntryInfo bteinfo = null;
                    IObjectValue tmpeinfo = null;
                    CoreBaseCollection backCol = new CoreBaseCollection();
                    CoreBaseCollection barcodeDossierCol = new CoreBaseCollection();
                    CoreBaseCollection bctCol = new CoreBaseCollection();
                    String transferNumber = null;
                    if (easValue.get("transactionType") != null && easValue.get("transactionType") instanceof TransactionTypeInfo) {
                        transferNumber = ((TransactionTypeInfo)easValue.get("transactionType")).getNumber();
                    }
                    int iUpdateType = 0;
                    iUpdateType = CreateEASBillUtil.getInOrOutBill(ctx, easValue.getBOSType().toString(), transferNumber);
                    int seq = null != ecol ? ecol.size() : 0;
                    BigDecimal actQty = BigDecimal.ZERO;
                    boolean isBarcode = false;
                    for (int i = 0; i < taskCol.size(); ++i) {
                        BcTaskBillInfo btbinfo = taskCol.get(i);
                        String sNum = btbinfo.getNumber();
                        String smaterialNum = null;
                        if (null != btbinfo.getMaterial() && null != invBill.getStorageOrgUnit()) {
                            String smaterialID = btbinfo.getMaterial().getId().toString();
                            smaterialNum = btbinfo.getMaterial().getNumber();
                            MaterialInventoryInfo matinvInfo = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(smaterialID, souID);
                            if (null != matinvInfo && matinvInfo.isIsBarcode()) {
                                isBarcode = true;
                            }
                        }
                        boolean isDeliver = false;
                        if (null != btbinfo.getStockingStatus() && StockingStatusEnum.CHECKREP.equals((Object)btbinfo.getStockingStatus())) {
                            isDeliver = true;
                        }
                        for (int j = 0; j < ecol.size(); ++j) {
                            BcTaskBillEntryCollection btecol;
                            InvBillBaseEntryInfo einfo = (InvBillBaseEntryInfo)ecol.getObject(j);
                            String tmpsrceid = null;
                            tmpsrceid = null != btbinfo.getSrcItemId() ? btbinfo.getSrcItemId().toString() : btbinfo.getSrcId().toString();
                            if (!einfo.getSourceBillId().equalsIgnoreCase(btbinfo.getSrcId().toString()) || !einfo.getSourceBillEntryId().equalsIgnoreCase(tmpsrceid) || (btecol = btbinfo.getEntrys()).size() <= 0) continue;
                            bteinfo = btecol.get(0);
                            if (einfo.getMaterial() == null || bteinfo.getMaterial() == null || !einfo.getMaterial().getId().toString().equalsIgnoreCase(bteinfo.getMaterial().getId().toString())) continue;
                            if (null != bteinfo.getAsstAttr()) {
                                einfo.setAssistProperty(bteinfo.getAsstAttr());
                            } else {
                                einfo.setAssistProperty(btbinfo.getAsstAttr());
                            }
                            if (null != bteinfo.getLot()) {
                                einfo.setLot(bteinfo.getLot());
                            } else {
                                einfo.setLot(btbinfo.getLot());
                            }
                            if (null != bteinfo.getMgf()) {
                                einfo.setMfg(bteinfo.getMgf());
                            } else {
                                einfo.setMfg(btbinfo.getMgf());
                            }
                            if (null != bteinfo.getExp()) {
                                einfo.setExp(bteinfo.getExp());
                            } else {
                                einfo.setExp(btbinfo.getExp());
                            }
                            if (null != bteinfo.getUnit()) {
                                einfo.setUnit(bteinfo.getUnit());
                            } else {
                                einfo.setUnit(btbinfo.getBaseUnit());
                            }
                            if (null != bteinfo.getWarehouse()) {
                                einfo.setWarehouse(bteinfo.getWarehouse());
                            } else {
                                einfo.setWarehouse(btbinfo.getWarehouse());
                            }
                            if (null != bteinfo.getLocation()) {
                                einfo.setLocation(bteinfo.getLocation());
                            } else if (isDeliver) {
                                einfo.setLocation(null);
                            } else {
                                einfo.setLocation(btbinfo.getLocation());
                            }
                            if (null != bteinfo.getProject()) {
                                einfo.setProject(bteinfo.getProject());
                            } else {
                                einfo.setProject(btbinfo.getProject());
                            }
                            if (null != bteinfo.getTrackNumber()) {
                                einfo.setTrackNumber(bteinfo.getTrackNumber());
                            } else {
                                einfo.setTrackNumber(btbinfo.getTrackNumber());
                            }
                            einfo.setQty(bteinfo.getQty());
                            actQty = actQty.add(bteinfo.getQty());
                            if (isBarcode) {
                                if (null == bteinfo.getBarcodeEntrys() || null != bteinfo.getBarcodeEntrys() && bteinfo.getBarcodeEntrys().size() <= 0) {
                                    throw new EASBizException(new NumericExceptionSubItem("", "\u7269\u6599\u3010" + smaterialNum + "\u3011\u5df2\u542f\u7528\u6761\u7801\u7ba1\u7406,\u4f46" + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"66_BarcodeUploadFacadeControllerBean", (Locale)ctx.getLocale())));
                                }
                                CreateEASBillUtil.setBack(ctx, bteinfo, easValue, (IObjectValue)einfo, backCol, barcodeDossierCol, iUpdateType);
                            }
                            bteinfo.setTargetBillItemId(einfo.getId().toString());
                            for (int k = 1; k < btecol.size(); ++k) {
                                bteinfo = btecol.get(k);
                                tmpeinfo = CreateEASBillUtil.getNewObjectValue(ctx, eEntity);
                                tmpeinfo.putAll((IObjectValue)einfo);
                                tmpeinfo.put("id", (Object)BOSUuid.create((String)tmpeinfo.getBOSType().toString()));
                                tmpeinfo.put("seq", (Object)seq);
                                ++seq;
                                if (null != bteinfo.getAsstAttr()) {
                                    tmpeinfo.put("assistProperty", (Object)bteinfo.getAsstAttr());
                                } else {
                                    tmpeinfo.put("assistProperty", (Object)btbinfo.getAsstAttr());
                                }
                                if (null != bteinfo.getLot()) {
                                    tmpeinfo.put("lot", (Object)bteinfo.getLot());
                                } else {
                                    tmpeinfo.put("lot", (Object)btbinfo.getLot());
                                }
                                if (null != bteinfo.getMgf()) {
                                    tmpeinfo.put("mfg", (Object)bteinfo.getMgf());
                                } else {
                                    tmpeinfo.put("mfg", (Object)btbinfo.getMgf());
                                }
                                if (null != bteinfo.getExp()) {
                                    tmpeinfo.put("exp", (Object)bteinfo.getExp());
                                } else {
                                    tmpeinfo.put("exp", (Object)btbinfo.getExp());
                                }
                                if (null != bteinfo.getUnit()) {
                                    tmpeinfo.put("unit", (Object)bteinfo.getUnit());
                                } else {
                                    tmpeinfo.put("unit", (Object)btbinfo.getBaseUnit());
                                }
                                if (null != bteinfo.getWarehouse()) {
                                    tmpeinfo.put("warehouse", (Object)bteinfo.getWarehouse());
                                } else {
                                    tmpeinfo.put("warehouse", (Object)btbinfo.getWarehouse());
                                }
                                if (null != bteinfo.getLocation()) {
                                    tmpeinfo.put("location", (Object)bteinfo.getLocation());
                                } else if (isDeliver) {
                                    tmpeinfo.put("location", null);
                                } else {
                                    tmpeinfo.put("location", (Object)btbinfo.getLocation());
                                }
                                if (null != bteinfo.getProject()) {
                                    tmpeinfo.put("project", (Object)bteinfo.getProject());
                                } else {
                                    tmpeinfo.put("project", (Object)btbinfo.getProject());
                                }
                                if (null != bteinfo.getTrackNumber()) {
                                    tmpeinfo.put("trackNumber", (Object)bteinfo.getTrackNumber());
                                } else {
                                    tmpeinfo.put("trackNumber", (Object)btbinfo.getTrackNumber());
                                }
                                tmpeinfo.put("qty", (Object)bteinfo.getQty());
                                actQty = actQty.add(bteinfo.getQty());
                                tmpecol.addObject(tmpeinfo);
                                if (isBarcode) {
                                    if (null == bteinfo.getBarcodeEntrys() || null != bteinfo.getBarcodeEntrys() && bteinfo.getBarcodeEntrys().size() <= 0) {
                                        throw new EASBizException(new NumericExceptionSubItem("", "\u7269\u6599\u3010" + smaterialNum + "\u3011\u5df2\u542f\u7528\u6761\u7801\u7ba1\u7406,\u4f46" + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"66_BarcodeUploadFacadeControllerBean", (Locale)ctx.getLocale())));
                                    }
                                    CreateEASBillUtil.setBack(ctx, bteinfo, easValue, tmpeinfo, backCol, barcodeDossierCol, iUpdateType);
                                }
                                bteinfo.setTargetBillItemId(tmpeinfo.get("id").toString());
                            }
                        }
                        if (null != tmpecol && tmpecol.size() > 0) {
                            ecol.addObjectCollection(tmpecol);
                        }
                        btbinfo.setTargetBillId(bid);
                        BigDecimal finishQty = actQty.add(btbinfo.getFinqty() != null ? btbinfo.getFinqty() : BigDecimal.ZERO);
                        BigDecimal tQty = btbinfo.getQty() != null ? btbinfo.getQty() : BigDecimal.ZERO;
                        btbinfo.setFinqty(finishQty);
                        btbinfo.setStatus(BcTaskBillStatusEnum.FINISH);
                        actQty = BigDecimal.ZERO;
                        bctCol.add((CoreBaseInfo)btbinfo);
                    }
                    easValue.put("taskcol", (Object)bctCol);
                    if (backCol.size() > 0) {
                        easValue.put("barcodeBack", (Object)backCol);
                        easValue.put("barcodeDossierCol", (Object)barcodeDossierCol);
                    }
                    easValue.put("entryName", (Object)entryName);
                    easValue.put("bosType", (Object)entity.getBOSType().toString());
                    break block236;
                }
                if (!isReserved) break block236;
                StockTransferBillInfo STBill = (StockTransferBillInfo)easValue;
                String souID = null;
                if (null == STBill.getIssueStorageOrgUnit()) {
                    StorageOrgUnitInfo sounit = ContextUtil.getCurrentStorageUnit((Context)ctx);
                    STBill.setIssueStorageOrgUnit(sounit);
                    if (null != sounit) {
                        souID = sounit.getId().toString();
                    }
                } else {
                    souID = STBill.getIssueStorageOrgUnit().getId().toString();
                }
                if (null == STBill.getReceiptStorageOrgUnit()) {
                    STBill.setReceiptStorageOrgUnit(STBill.getIssueStorageOrgUnit());
                }
                String entryName = STBill.getEntryName();
                String entryBostype = STBill.getEntries().getObject(0).getBOSType().toString();
                EntityObjectInfo eEntity = BarcodeUtils.getEntityByBosType(entryBostype);
                IObjectCollection ecol = CreateEASBillUtil.getNewObjectCollection(ctx, eEntity);
                ecol = STBill.getEntries();
                IObjectCollection tmpecol = CreateEASBillUtil.getNewObjectCollection(ctx, eEntity);
                BcTaskBillEntryInfo bteinfo = null;
                IObjectValue tmpeinfo = null;
                CoreBaseCollection backCol = new CoreBaseCollection();
                CoreBaseCollection barcodeDossierCol = new CoreBaseCollection();
                CoreBaseCollection bctCol = new CoreBaseCollection();
                int seq = null != ecol ? ecol.size() : 0;
                BigDecimal actQty = BigDecimal.ZERO;
                boolean isBarcode = false;
                for (int i = 0; i < taskCol.size(); ++i) {
                    BcTaskBillInfo btbinfo = taskCol.get(i);
                    String sNum = btbinfo.getNumber();
                    String smaterialNum = null;
                    if (null != btbinfo.getMaterial() && null != STBill.getIssueStorageOrgUnit()) {
                        String smaterialID = btbinfo.getMaterial().getId().toString();
                        smaterialNum = btbinfo.getMaterial().getNumber();
                        MaterialInventoryInfo matinvInfo = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(smaterialID, souID);
                        if (null != matinvInfo && matinvInfo.isIsBarcode()) {
                            isBarcode = true;
                        }
                    }
                    for (int j = 0; j < ecol.size(); ++j) {
                        BcTaskBillEntryCollection btecol;
                        StockTransferBillEntryInfo einfo = (StockTransferBillEntryInfo)ecol.getObject(j);
                        String tmpsrceid = null;
                        tmpsrceid = null != btbinfo.getSrcItemId() ? btbinfo.getSrcItemId().toString() : btbinfo.getSrcId().toString();
                        if (!einfo.getSourceBillId().equalsIgnoreCase(btbinfo.getSrcId().toString()) || !einfo.getSourceBillEntryId().equalsIgnoreCase(tmpsrceid) || (btecol = btbinfo.getEntrys()).size() <= 0) continue;
                        bteinfo = btecol.get(0);
                        if (einfo.getMaterial() == null || bteinfo.getMaterial() == null || !einfo.getMaterial().getId().toString().equalsIgnoreCase(bteinfo.getMaterial().getId().toString())) continue;
                        if (null != bteinfo.getAsstAttr()) {
                            einfo.setAssistProperty(bteinfo.getAsstAttr());
                        } else {
                            einfo.setAssistProperty(btbinfo.getAsstAttr());
                        }
                        if (null != bteinfo.getLot()) {
                            einfo.setLot(bteinfo.getLot());
                        } else {
                            einfo.setLot(btbinfo.getLot());
                        }
                        if (null != bteinfo.getMgf()) {
                            einfo.setMfg(bteinfo.getMgf());
                        } else {
                            einfo.setMfg(btbinfo.getMgf());
                        }
                        if (null != bteinfo.getExp()) {
                            einfo.setExp(bteinfo.getExp());
                        } else {
                            einfo.setExp(btbinfo.getExp());
                        }
                        if (null != bteinfo.getUnit()) {
                            einfo.setUnit(bteinfo.getUnit());
                        } else {
                            einfo.setUnit(btbinfo.getBaseUnit());
                        }
                        WarehouseInfo tmpw = null;
                        LocationInfo tmpl = null;
                        WarehouseInfo tmpa = null;
                        tmpw = null != bteinfo.getWarehouse() ? bteinfo.getWarehouse() : btbinfo.getWarehouse();
                        tmpl = null != bteinfo.getLocation() ? bteinfo.getLocation() : btbinfo.getLocation();
                        einfo.setIssueWarehouse(tmpw);
                        einfo.setIssueLocation(tmpl);
                        tmpa = CreateEASBillUtil.getReserveArea(ctx, tmpw, tmpl);
                        if (null == tmpa) {
                            String tmp = null;
                            if (null != tmpw && null != tmpw.getName()) {
                                tmp = "\u4ed3\u5e93[" + tmpw.getName() + "] ";
                            }
                            if (null != tmpl && null != tmpl.getName()) {
                                tmp = "\u5e93\u4f4d[" + tmpl.getName() + "] ";
                            }
                            throw new EASBizException(new NumericExceptionSubItem("", tmp + "\u672a\u914d\u7f6e\u5bf9\u5e94\u7684\u5907\u8d27\u533a\u57df"));
                        }
                        einfo.setReceiptWarehouse(tmpa);
                        if (null != bteinfo.getProject()) {
                            einfo.setProject(bteinfo.getProject());
                        } else {
                            einfo.setProject(btbinfo.getProject());
                        }
                        if (null != bteinfo.getTrackNumber()) {
                            einfo.setTrackNumber(bteinfo.getTrackNumber());
                        } else {
                            einfo.setTrackNumber(btbinfo.getTrackNumber());
                        }
                        einfo.setQty(bteinfo.getQty());
                        actQty = actQty.add(bteinfo.getQty());
                        if (isBarcode) {
                            if (null == bteinfo.getBarcodeEntrys() || null != bteinfo.getBarcodeEntrys() && bteinfo.getBarcodeEntrys().size() <= 0) {
                                throw new EASBizException(new NumericExceptionSubItem("", "\u7269\u6599\u3010" + smaterialNum + "\u3011\u5df2\u542f\u7528\u6761\u7801\u7ba1\u7406,\u4f46" + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"66_BarcodeUploadFacadeControllerBean", (Locale)ctx.getLocale())));
                            }
                            CreateEASBillUtil.setBack(ctx, bteinfo, easValue, (IObjectValue)einfo, backCol, barcodeDossierCol, 4);
                        }
                        bteinfo.setTargetBillItemId(einfo.getId().toString());
                        for (int k = 1; k < btecol.size(); ++k) {
                            bteinfo = btecol.get(k);
                            tmpeinfo = CreateEASBillUtil.getNewObjectValue(ctx, eEntity);
                            tmpeinfo.putAll((IObjectValue)einfo);
                            tmpeinfo.put("id", (Object)BOSUuid.create((String)tmpeinfo.getBOSType().toString()));
                            tmpeinfo.put("seq", (Object)seq);
                            ++seq;
                            if (null != bteinfo.getAsstAttr()) {
                                tmpeinfo.put("assistProperty", (Object)bteinfo.getAsstAttr());
                            } else {
                                tmpeinfo.put("assistProperty", (Object)btbinfo.getAsstAttr());
                            }
                            if (null != bteinfo.getLot()) {
                                tmpeinfo.put("lot", (Object)bteinfo.getLot());
                            } else {
                                tmpeinfo.put("lot", (Object)btbinfo.getLot());
                            }
                            if (null != bteinfo.getMgf()) {
                                tmpeinfo.put("mfg", (Object)bteinfo.getMgf());
                            } else {
                                tmpeinfo.put("mfg", (Object)btbinfo.getMgf());
                            }
                            if (null != bteinfo.getExp()) {
                                tmpeinfo.put("exp", (Object)bteinfo.getExp());
                            } else {
                                tmpeinfo.put("exp", (Object)btbinfo.getExp());
                            }
                            if (null != bteinfo.getUnit()) {
                                tmpeinfo.put("unit", (Object)bteinfo.getUnit());
                            } else {
                                tmpeinfo.put("unit", (Object)btbinfo.getBaseUnit());
                            }
                            WarehouseInfo tmpw2 = null;
                            LocationInfo tmpl2 = null;
                            WarehouseInfo tmpa2 = null;
                            tmpw2 = null != bteinfo.getWarehouse() ? bteinfo.getWarehouse() : btbinfo.getWarehouse();
                            tmpl2 = null != bteinfo.getLocation() ? bteinfo.getLocation() : btbinfo.getLocation();
                            tmpeinfo.put("issueWarehouse", (Object)tmpw2);
                            tmpeinfo.put("issueLocation", (Object)tmpl2);
                            tmpa2 = CreateEASBillUtil.getReserveArea(ctx, tmpw2, tmpl2);
                            if (null == tmpa2) {
                                String tmp = null;
                                if (null != tmpw2 && null != tmpw2.getName()) {
                                    tmp = "\u4ed3\u5e93[" + tmpw2.getName() + "] ";
                                }
                                if (null != tmpl2 && null != tmpl2.getName()) {
                                    tmp = "\u5e93\u4f4d[" + tmpl2.getName() + "] ";
                                }
                                throw new EASBizException(new NumericExceptionSubItem("", tmp + "\u672a\u914d\u7f6e\u5bf9\u5e94\u7684\u5907\u8d27\u533a\u57df"));
                            }
                            tmpeinfo.put("receiptWarehouse", (Object)tmpa2);
                            if (null != bteinfo.getWarehouse()) {
                                tmpeinfo.put("warehouse", (Object)bteinfo.getWarehouse());
                            } else {
                                tmpeinfo.put("warehouse", (Object)btbinfo.getWarehouse());
                            }
                            if (null != bteinfo.getLocation()) {
                                tmpeinfo.put("location", (Object)bteinfo.getLocation());
                            } else {
                                tmpeinfo.put("location", (Object)btbinfo.getLocation());
                            }
                            if (null != bteinfo.getProject()) {
                                tmpeinfo.put("project", (Object)bteinfo.getProject());
                            } else {
                                tmpeinfo.put("project", (Object)btbinfo.getProject());
                            }
                            if (null != bteinfo.getTrackNumber()) {
                                tmpeinfo.put("trackNumber", (Object)bteinfo.getTrackNumber());
                            } else {
                                tmpeinfo.put("trackNumber", (Object)btbinfo.getTrackNumber());
                            }
                            tmpeinfo.put("qty", (Object)bteinfo.getQty());
                            actQty = actQty.add(bteinfo.getQty());
                            tmpecol.addObject(tmpeinfo);
                            if (isBarcode) {
                                if (null == bteinfo.getBarcodeEntrys() || null != bteinfo.getBarcodeEntrys() && bteinfo.getBarcodeEntrys().size() <= 0) {
                                    throw new EASBizException(new NumericExceptionSubItem("", "\u7269\u6599\u3010" + smaterialNum + "\u3011\u5df2\u542f\u7528\u6761\u7801\u7ba1\u7406,\u4f46" + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"66_BarcodeUploadFacadeControllerBean", (Locale)ctx.getLocale())));
                                }
                                CreateEASBillUtil.setBack(ctx, bteinfo, easValue, tmpeinfo, backCol, barcodeDossierCol, 4);
                            }
                            bteinfo.setTargetBillItemId(tmpeinfo.get("id").toString());
                        }
                    }
                    if (null != tmpecol && tmpecol.size() > 0) {
                        ecol.addObjectCollection(tmpecol);
                    }
                    btbinfo.setTargetBillId(bid);
                    BigDecimal finishQty = actQty.add(btbinfo.getFinqty() != null ? btbinfo.getFinqty() : BigDecimal.ZERO);
                    BigDecimal tQty = btbinfo.getQty() != null ? btbinfo.getQty() : BigDecimal.ZERO;
                    btbinfo.setFinqty(finishQty);
                    btbinfo.setStatus(BcTaskBillStatusEnum.FINISH);
                    actQty = BigDecimal.ZERO;
                    bctCol.add((CoreBaseInfo)btbinfo);
                }
                easValue.put("taskcol", (Object)bctCol);
                if (backCol.size() > 0) {
                    easValue.put("barcodeBack", (Object)backCol);
                    easValue.put("barcodeDossierCol", (Object)barcodeDossierCol);
                }
                easValue.put("entryName", (Object)entryName);
                easValue.put("bosType", (Object)entity.getBOSType().toString());
                break block236;
            }
            if ("new".equals(way)) {
                if (easValue instanceof InvBillBaseInfo) {
                    InvBillBaseInfo invBill = (InvBillBaseInfo)easValue;
                    String souID = null;
                    if (null != invBill.get("storageOrgUnit")) {
                        if (invBill.get("storageOrgUnit") instanceof FullOrgUnitInfo) {
                            StorageOrgUnitInfo storageOrgUnit = new StorageOrgUnitInfo();
                            FullOrgUnitInfo fullOrgUnitInfo = (FullOrgUnitInfo)invBill.get("storageOrgUnit");
                            fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(fullOrgUnitInfo.getId()));
                            storageOrgUnit.setId(fullOrgUnitInfo.getId());
                            storageOrgUnit.setName(fullOrgUnitInfo.getName());
                            storageOrgUnit.setNumber(fullOrgUnitInfo.getNumber());
                            souID = storageOrgUnit.getId().toString();
                            invBill.setStorageOrgUnit(storageOrgUnit);
                        } else {
                            souID = invBill.getStorageOrgUnit().getId().toString();
                        }
                    } else {
                        StorageOrgUnitInfo sounit = ContextUtil.getCurrentStorageUnit((Context)ctx);
                        invBill.setStorageOrgUnit(sounit);
                        if (null != sounit) {
                            souID = sounit.getId().toString();
                        }
                    }
                    String entryName = invBill.getEntryName();
                    String entryBostype = invBill.getEntries().getObject(0).getBOSType().toString();
                    EntityObjectInfo eEntity = BarcodeUtils.getEntityByBosType(entryBostype);
                    IObjectCollection ecol = CreateEASBillUtil.getNewObjectCollection(ctx, eEntity);
                    ecol = invBill.getEntries();
                    IObjectCollection tmpecol = CreateEASBillUtil.getNewObjectCollection(ctx, eEntity);
                    BcTaskBillEntryInfo bteinfo = null;
                    IObjectValue tmpeinfo = null;
                    CoreBaseCollection backCol = new CoreBaseCollection();
                    CoreBaseCollection barcodeDossierCol = new CoreBaseCollection();
                    CoreBaseCollection bctCol = new CoreBaseCollection();
                    String transferNumber = null;
                    if (easValue.get("transactionType") != null && easValue.get("transactionType") instanceof TransactionTypeInfo) {
                        transferNumber = ((TransactionTypeInfo)easValue.get("transactionType")).getNumber();
                    }
                    int iUpdateType = 0;
                    iUpdateType = CreateEASBillUtil.getInOrOutBill(ctx, easValue.getBOSType().toString(), transferNumber);
                    int seq = null != ecol ? ecol.size() : 0;
                    BigDecimal actQty = BigDecimal.ZERO;
                    boolean isBarcode = false;
                    for (int i = 0; i < taskCol.size(); ++i) {
                        BcTaskBillInfo btbinfo = taskCol.get(i);
                        String sNum = btbinfo.getNumber();
                        for (int j = 0; j < ecol.size(); ++j) {
                            InvBillBaseEntryInfo einfo = (InvBillBaseEntryInfo)ecol.getObject(j);
                            BcTaskBillEntryCollection btecol = btbinfo.getEntrys();
                            if (btecol.size() <= 0) continue;
                            bteinfo = btecol.get(0);
                            String smaterialNum = null;
                            if (bteinfo.getMaterial() == null) continue;
                            if (null != bteinfo.getMaterial() && null != invBill.getStorageOrgUnit()) {
                                String smaterialID = bteinfo.getMaterial().getId().toString();
                                smaterialNum = bteinfo.getMaterial().getNumber();
                                MaterialInventoryInfo matinvInfo = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(smaterialID, souID);
                                isBarcode = null != matinvInfo && matinvInfo.isIsBarcode();
                            }
                            einfo.setMaterial(bteinfo.getMaterial());
                            einfo.setStorageOrgUnit(invBill.getStorageOrgUnit());
                            if (null != bteinfo.getAsstAttr()) {
                                einfo.setAssistProperty(bteinfo.getAsstAttr());
                            } else {
                                einfo.setAssistProperty(btbinfo.getAsstAttr());
                            }
                            if (einfo instanceof MoveLocationBillEntryInfo) {
                                einfo.put("receiptLocation", (Object)bteinfo.getInLocation());
                            }
                            if (null != bteinfo.getLot()) {
                                einfo.setLot(bteinfo.getLot());
                            } else {
                                einfo.setLot(btbinfo.getLot());
                            }
                            if (null != bteinfo.getMgf()) {
                                einfo.setMfg(bteinfo.getMgf());
                            } else {
                                einfo.setMfg(btbinfo.getMgf());
                            }
                            if (null != bteinfo.getExp()) {
                                einfo.setExp(bteinfo.getExp());
                            } else {
                                einfo.setExp(btbinfo.getExp());
                            }
                            if (null != bteinfo.getUnit()) {
                                einfo.setUnit(bteinfo.getUnit());
                            } else {
                                einfo.setUnit(btbinfo.getBaseUnit());
                            }
                            if (null != bteinfo.getWarehouse()) {
                                einfo.setWarehouse(bteinfo.getWarehouse());
                            } else {
                                einfo.setWarehouse(btbinfo.getWarehouse());
                            }
                            if (null != bteinfo.getLocation()) {
                                einfo.setLocation(bteinfo.getLocation());
                            } else {
                                einfo.setLocation(btbinfo.getLocation());
                            }
                            if (null != bteinfo.getProject()) {
                                einfo.setProject(bteinfo.getProject());
                            } else {
                                einfo.setProject(btbinfo.getProject());
                            }
                            if (null != bteinfo.getTrackNumber()) {
                                einfo.setTrackNumber(bteinfo.getTrackNumber());
                            } else {
                                einfo.setTrackNumber(btbinfo.getTrackNumber());
                            }
                            einfo.setQty(bteinfo.getQty());
                            actQty = actQty.add(bteinfo.getQty());
                            if (isBarcode) {
                                if (null == bteinfo.getBarcodeEntrys() || null != bteinfo.getBarcodeEntrys() && bteinfo.getBarcodeEntrys().size() <= 0) {
                                    throw new EASBizException(new NumericExceptionSubItem("", "\u7269\u6599\u3010" + smaterialNum + "\u3011\u5df2\u542f\u7528\u6761\u7801\u7ba1\u7406,\u4f46" + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"66_BarcodeUploadFacadeControllerBean", (Locale)ctx.getLocale())));
                                }
                                CreateEASBillUtil.setBack(ctx, bteinfo, easValue, (IObjectValue)einfo, backCol, barcodeDossierCol, iUpdateType);
                            }
                            bteinfo.setTargetBillItemId(einfo.getId().toString());
                            for (int k = 1; k < btecol.size(); ++k) {
                                bteinfo = btecol.get(k);
                                tmpeinfo = CreateEASBillUtil.getNewObjectValue(ctx, eEntity);
                                tmpeinfo.putAll((IObjectValue)einfo);
                                tmpeinfo.put("id", (Object)BOSUuid.create((String)tmpeinfo.getBOSType().toString()));
                                tmpeinfo.put("seq", (Object)seq);
                                ++seq;
                                smaterialNum = null;
                                if (null != bteinfo.getMaterial() && null != invBill.getStorageOrgUnit()) {
                                    String smaterialID = bteinfo.getMaterial().getId().toString();
                                    smaterialNum = bteinfo.getMaterial().getNumber();
                                    MaterialInventoryInfo matinvInfo = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(smaterialID, souID);
                                    isBarcode = null != matinvInfo && matinvInfo.isIsBarcode();
                                }
                                tmpeinfo.put("material", (Object)bteinfo.getMaterial());
                                tmpeinfo.put("storageOrgUnit", (Object)invBill.getStorageOrgUnit());
                                if (null != bteinfo.getAsstAttr()) {
                                    tmpeinfo.put("assistProperty", (Object)bteinfo.getAsstAttr());
                                } else {
                                    tmpeinfo.put("assistProperty", (Object)btbinfo.getAsstAttr());
                                }
                                if (null != bteinfo.getLot()) {
                                    tmpeinfo.put("lot", (Object)bteinfo.getLot());
                                } else {
                                    tmpeinfo.put("lot", (Object)btbinfo.getLot());
                                }
                                if (null != bteinfo.getMgf()) {
                                    tmpeinfo.put("mfg", (Object)bteinfo.getMgf());
                                } else {
                                    tmpeinfo.put("mfg", (Object)btbinfo.getMgf());
                                }
                                if (einfo instanceof MoveLocationBillEntryInfo) {
                                    einfo.put("receiptLocation", (Object)bteinfo.getInLocation());
                                }
                                if (null != bteinfo.getExp()) {
                                    tmpeinfo.put("exp", (Object)bteinfo.getExp());
                                } else {
                                    tmpeinfo.put("exp", (Object)btbinfo.getExp());
                                }
                                if (null != bteinfo.getUnit()) {
                                    tmpeinfo.put("unit", (Object)bteinfo.getUnit());
                                } else {
                                    tmpeinfo.put("unit", (Object)btbinfo.getBaseUnit());
                                }
                                if (null != bteinfo.getWarehouse()) {
                                    tmpeinfo.put("warehouse", (Object)bteinfo.getWarehouse());
                                } else {
                                    tmpeinfo.put("warehouse", (Object)btbinfo.getWarehouse());
                                }
                                if (null != bteinfo.getLocation()) {
                                    tmpeinfo.put("location", (Object)bteinfo.getLocation());
                                } else {
                                    tmpeinfo.put("location", (Object)btbinfo.getLocation());
                                }
                                if (null != bteinfo.getProject()) {
                                    tmpeinfo.put("project", (Object)bteinfo.getProject());
                                } else {
                                    tmpeinfo.put("project", (Object)btbinfo.getProject());
                                }
                                if (null != bteinfo.getTrackNumber()) {
                                    tmpeinfo.put("trackNumber", (Object)bteinfo.getTrackNumber());
                                } else {
                                    tmpeinfo.put("trackNumber", (Object)btbinfo.getTrackNumber());
                                }
                                tmpeinfo.put("qty", (Object)bteinfo.getQty());
                                actQty = actQty.add(bteinfo.getQty());
                                tmpecol.addObject(tmpeinfo);
                                if (isBarcode) {
                                    if (null == bteinfo.getBarcodeEntrys() || null != bteinfo.getBarcodeEntrys() && bteinfo.getBarcodeEntrys().size() <= 0) {
                                        throw new EASBizException(new NumericExceptionSubItem("", "\u7269\u6599\u3010" + smaterialNum + "\u3011\u5df2\u542f\u7528\u6761\u7801\u7ba1\u7406,\u4f46" + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"66_BarcodeUploadFacadeControllerBean", (Locale)ctx.getLocale())));
                                    }
                                    CreateEASBillUtil.setBack(ctx, bteinfo, easValue, tmpeinfo, backCol, barcodeDossierCol, iUpdateType);
                                }
                                bteinfo.setTargetBillItemId(tmpeinfo.get("id").toString());
                            }
                        }
                        if (null != tmpecol && tmpecol.size() > 0) {
                            ecol.addObjectCollection(tmpecol);
                        }
                        btbinfo.setTargetBillId(bid);
                        BigDecimal finishQty = actQty.add(btbinfo.getFinqty() != null ? btbinfo.getFinqty() : BigDecimal.ZERO);
                        BigDecimal tQty = btbinfo.getQty() != null ? btbinfo.getQty() : BigDecimal.ZERO;
                        btbinfo.setFinqty(finishQty);
                        btbinfo.setStatus(BcTaskBillStatusEnum.FINISH);
                        actQty = BigDecimal.ZERO;
                        bctCol.add((CoreBaseInfo)btbinfo);
                    }
                    easValue.put("taskcol", (Object)bctCol);
                    if (backCol.size() > 0) {
                        easValue.put("barcodeBack", (Object)backCol);
                        easValue.put("barcodeDossierCol", (Object)barcodeDossierCol);
                    }
                    easValue.put("entryName", (Object)entryName);
                    easValue.put("bosType", (Object)entity.getBOSType().toString());
                }
            } else if ("check".equals(way)) {
                InvBillBaseInfo invBill = (InvBillBaseInfo)easValue;
                String souID = null;
                if (null != invBill.get("storageOrgUnit")) {
                    if (invBill.get("storageOrgUnit") instanceof FullOrgUnitInfo) {
                        StorageOrgUnitInfo storageOrgUnit = new StorageOrgUnitInfo();
                        FullOrgUnitInfo fullOrgUnitInfo = (FullOrgUnitInfo)invBill.get("storageOrgUnit");
                        fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(fullOrgUnitInfo.getId()));
                        storageOrgUnit.setId(fullOrgUnitInfo.getId());
                        storageOrgUnit.setName(fullOrgUnitInfo.getName());
                        storageOrgUnit.setNumber(fullOrgUnitInfo.getNumber());
                        souID = storageOrgUnit.getId().toString();
                        invBill.setStorageOrgUnit(storageOrgUnit);
                    } else {
                        souID = invBill.getStorageOrgUnit().getId().toString();
                    }
                } else {
                    StorageOrgUnitInfo sounit = ContextUtil.getCurrentStorageUnit((Context)ctx);
                    invBill.setStorageOrgUnit(sounit);
                    if (null != sounit) {
                        souID = sounit.getId().toString();
                    }
                }
                String entryName = invBill.getEntryName();
                String entryBostype = invBill.getEntries().getObject(0).getBOSType().toString();
                EntityObjectInfo eEntity = BarcodeUtils.getEntityByBosType(entryBostype);
                IObjectCollection ecol = CreateEASBillUtil.getNewObjectCollection(ctx, eEntity);
                ecol = invBill.getEntries();
                IObjectCollection tmpecol = CreateEASBillUtil.getNewObjectCollection(ctx, eEntity);
                BcTaskBillEntryInfo bteinfo = null;
                IObjectValue tmpeinfo = null;
                CoreBaseCollection backCol = new CoreBaseCollection();
                CoreBaseCollection barcodeDossierCol = new CoreBaseCollection();
                CoreBaseCollection bctCol = new CoreBaseCollection();
                String transferNumber = null;
                if (easValue.get("transactionType") != null && easValue.get("transactionType") instanceof TransactionTypeInfo) {
                    transferNumber = ((TransactionTypeInfo)easValue.get("transactionType")).getNumber();
                }
                int iUpdateType = 0;
                iUpdateType = CreateEASBillUtil.getInOrOutBill(ctx, easValue.getBOSType().toString(), transferNumber);
                int seq = null != ecol ? ecol.size() : 0;
                BigDecimal actQty = BigDecimal.ZERO;
                boolean isBarcode = false;
                ArrayList<String> invBillBaseEntryId = new ArrayList<String>();
                for (int i = 0; i < taskCol.size(); ++i) {
                    BcTaskBillInfo btbinfo = taskCol.get(i);
                    String sNum = btbinfo.getNumber();
                    String smaterialNum = null;
                    if (null != btbinfo.getMaterial() && null != invBill.getStorageOrgUnit()) {
                        String smaterialID = btbinfo.getMaterial().getId().toString();
                        smaterialNum = btbinfo.getMaterial().getNumber();
                        MaterialInventoryInfo matinvInfo = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(smaterialID, souID);
                        if (null != matinvInfo && matinvInfo.isIsBarcode()) {
                            isBarcode = true;
                        }
                    }
                    boolean isDeliver = false;
                    if (null != btbinfo.getStockingStatus() && StockingStatusEnum.CHECKREP.equals((Object)btbinfo.getStockingStatus())) {
                        isDeliver = true;
                    }
                    for (int j = 0; j < ecol.size(); ++j) {
                        InvBillBaseEntryInfo einfo = (InvBillBaseEntryInfo)ecol.getObject(j);
                        if (!einfo.getId().toString().equalsIgnoreCase(btbinfo.getSrcItemId().toString())) continue;
                        BcTaskBillEntryCollection btecol = btbinfo.getEntrys();
                        if (btecol.size() > 0) {
                            bteinfo = btecol.get(0);
                            einfo.setMaterial(bteinfo.getMaterial());
                            if (null != bteinfo.getAsstAttr()) {
                                einfo.setAssistProperty(bteinfo.getAsstAttr());
                            } else {
                                einfo.setAssistProperty(btbinfo.getAsstAttr());
                            }
                            if (null != bteinfo.getLot()) {
                                einfo.setLot(bteinfo.getLot());
                            } else {
                                einfo.setLot(btbinfo.getLot());
                            }
                            if (null != bteinfo.getMgf()) {
                                einfo.setMfg(bteinfo.getMgf());
                            } else {
                                einfo.setMfg(btbinfo.getMgf());
                            }
                            if (null != bteinfo.getExp()) {
                                einfo.setExp(bteinfo.getExp());
                            } else {
                                einfo.setExp(btbinfo.getExp());
                            }
                            if (null != bteinfo.getUnit()) {
                                einfo.setUnit(bteinfo.getUnit());
                            } else {
                                einfo.setUnit(btbinfo.getBaseUnit());
                            }
                            if (null != bteinfo.getWarehouse()) {
                                einfo.setWarehouse(bteinfo.getWarehouse());
                            } else {
                                einfo.setWarehouse(btbinfo.getWarehouse());
                            }
                            if (null != bteinfo.getLocation()) {
                                einfo.setLocation(bteinfo.getLocation());
                            } else if (isDeliver) {
                                einfo.setLocation(null);
                            } else {
                                einfo.setLocation(btbinfo.getLocation());
                            }
                            if (null != bteinfo.getProject()) {
                                einfo.setProject(bteinfo.getProject());
                            } else {
                                einfo.setProject(btbinfo.getProject());
                            }
                            if (null != bteinfo.getTrackNumber()) {
                                einfo.setTrackNumber(bteinfo.getTrackNumber());
                            } else {
                                einfo.setTrackNumber(btbinfo.getTrackNumber());
                            }
                            einfo.setQty(bteinfo.getQty());
                            actQty = actQty.add(bteinfo.getQty());
                            if (isBarcode) {
                                if (null == bteinfo.getBarcodeEntrys() || null != bteinfo.getBarcodeEntrys() && bteinfo.getBarcodeEntrys().size() <= 0) {
                                    throw new EASBizException(new NumericExceptionSubItem("", "\u7269\u6599\u3010" + smaterialNum + "\u3011\u5df2\u542f\u7528\u6761\u7801\u7ba1\u7406,\u4f46" + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"66_BarcodeUploadFacadeControllerBean", (Locale)ctx.getLocale())));
                                }
                                CreateEASBillUtil.setBack(ctx, bteinfo, easValue, (IObjectValue)einfo, backCol, barcodeDossierCol, iUpdateType);
                            }
                            bteinfo.setTargetBillItemId(einfo.getId().toString());
                            invBillBaseEntryId.add(einfo.getId().toString());
                        }
                        for (int k = 1; k < btecol.size(); ++k) {
                            bteinfo = btecol.get(k);
                            tmpeinfo = CreateEASBillUtil.getNewObjectValue(ctx, eEntity);
                            tmpeinfo.putAll((IObjectValue)einfo);
                            tmpeinfo.put("id", (Object)BOSUuid.create((String)tmpeinfo.getBOSType().toString()));
                            tmpeinfo.put("seq", (Object)seq);
                            ++seq;
                            tmpeinfo.put("material", (Object)bteinfo.getMaterial());
                            if (null != bteinfo.getAsstAttr()) {
                                tmpeinfo.put("assistProperty", (Object)bteinfo.getAsstAttr());
                            } else {
                                tmpeinfo.put("assistProperty", (Object)btbinfo.getAsstAttr());
                            }
                            if (null != bteinfo.getLot()) {
                                tmpeinfo.put("lot", (Object)bteinfo.getLot());
                            } else {
                                tmpeinfo.put("lot", (Object)btbinfo.getLot());
                            }
                            if (null != bteinfo.getMgf()) {
                                tmpeinfo.put("mfg", (Object)bteinfo.getMgf());
                            } else {
                                tmpeinfo.put("mfg", (Object)btbinfo.getMgf());
                            }
                            if (null != bteinfo.getExp()) {
                                tmpeinfo.put("exp", (Object)bteinfo.getExp());
                            } else {
                                tmpeinfo.put("exp", (Object)btbinfo.getExp());
                            }
                            if (null != bteinfo.getUnit()) {
                                tmpeinfo.put("unit", (Object)bteinfo.getUnit());
                            } else {
                                tmpeinfo.put("unit", (Object)btbinfo.getBaseUnit());
                            }
                            if (null != bteinfo.getWarehouse()) {
                                tmpeinfo.put("warehouse", (Object)bteinfo.getWarehouse());
                            } else {
                                tmpeinfo.put("warehouse", (Object)btbinfo.getWarehouse());
                            }
                            if (null != bteinfo.getLocation()) {
                                tmpeinfo.put("location", (Object)bteinfo.getLocation());
                            } else if (isDeliver) {
                                tmpeinfo.put("location", null);
                            } else {
                                tmpeinfo.put("location", (Object)btbinfo.getLocation());
                            }
                            if (null != bteinfo.getProject()) {
                                tmpeinfo.put("project", (Object)bteinfo.getProject());
                            } else {
                                tmpeinfo.put("project", (Object)btbinfo.getProject());
                            }
                            if (null != bteinfo.getTrackNumber()) {
                                tmpeinfo.put("trackNumber", (Object)bteinfo.getTrackNumber());
                            } else {
                                tmpeinfo.put("trackNumber", (Object)btbinfo.getTrackNumber());
                            }
                            tmpeinfo.put("qty", (Object)bteinfo.getQty());
                            actQty = actQty.add(bteinfo.getQty());
                            tmpecol.addObject(tmpeinfo);
                            if (isBarcode) {
                                if (null == bteinfo.getBarcodeEntrys() || null != bteinfo.getBarcodeEntrys() && bteinfo.getBarcodeEntrys().size() <= 0) {
                                    throw new EASBizException(new NumericExceptionSubItem("", "\u7269\u6599\u3010" + smaterialNum + "\u3011\u5df2\u542f\u7528\u6761\u7801\u7ba1\u7406,\u4f46" + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"66_BarcodeUploadFacadeControllerBean", (Locale)ctx.getLocale())));
                                }
                                CreateEASBillUtil.setBack(ctx, bteinfo, easValue, tmpeinfo, backCol, barcodeDossierCol, iUpdateType);
                            }
                            bteinfo.setTargetBillItemId(tmpeinfo.get("id").toString());
                            invBillBaseEntryId.add(tmpeinfo.get("id").toString());
                        }
                    }
                    if (null != tmpecol && tmpecol.size() > 0) {
                        ecol.addObjectCollection(tmpecol);
                    }
                    btbinfo.setTargetBillId(bid);
                    BigDecimal finishQty = actQty.add(btbinfo.getFinqty() != null ? btbinfo.getFinqty() : BigDecimal.ZERO);
                    BigDecimal tQty = btbinfo.getQty() != null ? btbinfo.getQty() : BigDecimal.ZERO;
                    btbinfo.setFinqty(finishQty);
                    btbinfo.setStatus(BcTaskBillStatusEnum.FINISH);
                    actQty = BigDecimal.ZERO;
                    bctCol.add((CoreBaseInfo)btbinfo);
                }
                easValue.put("taskcol", (Object)bctCol);
                if (backCol.size() > 0) {
                    easValue.put("barcodeBack", (Object)backCol);
                    easValue.put("barcodeDossierCol", (Object)barcodeDossierCol);
                }
                easValue.put("entryName", (Object)entryName);
                easValue.put("bosType", (Object)entity.getBOSType().toString());
                for (int j = 0; j < ecol.size(); ++j) {
                    InvBillBaseEntryInfo einfo = (InvBillBaseEntryInfo)ecol.getObject(j);
                    if (invBillBaseEntryId.contains(einfo.get("id").toString())) continue;
                    ecol.removeObject((IObjectValue)einfo);
                }
            }
        }
    }

    private static WarehouseInfo getReserveArea(Context ctx, WarehouseInfo winfo, LocationInfo linfo) throws EASBizException, BOSException {
        WarehouseInfo revArea = null;
        if (null == winfo && null == linfo) {
            return revArea;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("warehouse", (Object)winfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("location", null == linfo ? linfo : linfo.getId().toString()));
        ev.setFilter(filter);
        ReserveAreaEntryCollection rcol = ReserveAreaEntryFactory.getLocalInstance(ctx).getReserveAreaEntryCollection(ev);
        if (null != rcol && rcol.size() > 0) {
            ReserveAreaEntryInfo einfo = rcol.get(0);
            revArea = einfo.getReserveWarehs();
        }
        return revArea;
    }

    private static void setBack(Context ctx, BcTaskBillEntryInfo bteinfo, IObjectValue easValue, IObjectValue entry, CoreBaseCollection backCol, CoreBaseCollection barcodeDossierCol, int iUpdateType) throws EASBizException, BOSException {
        BcTaskBillEntryBarcodeEntryCollection barcol = bteinfo.getBarcodeEntrys();
        BcTaskBillEntryBarcodeEntryInfo barinfo = null;
        for (int l = 0; l < barcol.size(); ++l) {
            barinfo = barcol.get(l);
            IndBarcodeBackInfo backInfo = new IndBarcodeBackInfo();
            backInfo.setId(BOSUuid.create((BOSObjectType)backInfo.getBOSType()));
            backInfo.setNumber(backInfo.getId().toString());
            backInfo.setName(barinfo.getBarcode());
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("useType"));
            sic.add(new SelectorItemInfo("barcodeState"));
            sic.add(new SelectorItemInfo("qty"));
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("barRule.id"));
            sic.add(new SelectorItemInfo("barRule.Entry.id"));
            sic.add(new SelectorItemInfo("barRule.Entry.name"));
            sic.add(new SelectorItemInfo("barRule.Entry.type"));
            sic.add(new SelectorItemInfo("barRule.Entry.*"));
            viewInfo.setSelector(sic);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)barinfo.getBarcode(), CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            BarcodeDossierCollection dossiercol = null;
            BigDecimal barcodeQty = BigDecimal.ZERO;
            try {
                dossiercol = BarcodeDossierFactory.getLocalInstance(ctx).getBarcodeDossierCollection(viewInfo);
                if (dossiercol.size() > 0) {
                    BarcodeDossierInfo dossierInfo = dossiercol.get(0);
                    barcodeQty = dossierInfo.getQty();
                    if (2 == iUpdateType) {
                        if (!barcodeUseTypeEmum.ordinary.equals((Object)dossierInfo.getUseType())) {
                            if (entry.get("warehouse") != null && entry.get("warehouse") instanceof WarehouseInfo) {
                                dossierInfo.put("warehouse", ((WarehouseInfo)entry.get("warehouse")).getNumber());
                            }
                            if (entry.get("location") != null && entry.get("location") instanceof LocationInfo) {
                                dossierInfo.put("location", ((LocationInfo)entry.get("location")).getNumber());
                            }
                            if (barinfo.getQty() != null && barcodeUseTypeEmum.deductible.equals((Object)dossierInfo.getUseType()) && BarcodeStateEnum.InWarehoued.equals((Object)dossierInfo.getBarcodeState())) {
                                dossierInfo.put("qty", barcodeQty.add(barinfo.getQty()));
                            }
                            dossierInfo.put("barcodeState", 2);
                            barcodeDossierCol.add((CoreBaseInfo)dossierInfo);
                        }
                    } else if (3 == iUpdateType) {
                        if (!barcodeUseTypeEmum.ordinary.equals((Object)dossierInfo.getUseType())) {
                            if (barinfo.getQty() != null && barcodeUseTypeEmum.deductible.equals((Object)dossierInfo.getUseType())) {
                                dossierInfo.put("qty", barcodeQty.subtract(barinfo.getQty()));
                            }
                            dossierInfo.put("barcodeState", 3);
                            barcodeDossierCol.add((CoreBaseInfo)dossierInfo);
                        }
                    } else if (4 == iUpdateType && !barcodeUseTypeEmum.ordinary.equals((Object)dossierInfo.getUseType())) {
                        if (entry.get("receiptWarehouse") != null && entry.get("receiptWarehouse") instanceof WarehouseInfo) {
                            dossierInfo.put("warehouse", ((WarehouseInfo)entry.get("receiptWarehouse")).getNumber());
                        }
                        if (entry.get("location") != null && entry.get("receiptLocation") instanceof LocationInfo) {
                            dossierInfo.put("location", ((LocationInfo)entry.get("receiptLocation")).getNumber());
                        }
                        dossierInfo.put("barcodeState", 2);
                        barcodeDossierCol.add((CoreBaseInfo)dossierInfo);
                    }
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (barinfo.getQty() == null) {
                backInfo.setBarcodeQty(barcodeQty);
            } else {
                backInfo.setBarcodeQty(barinfo.getQty());
            }
            backInfo.setBizDate(new Date());
            backInfo.setBillType(CreateEASBillUtil.getBillType(ctx, easValue.getBOSType().toString()));
            if (easValue.get("bizType") != null) {
                backInfo.setBizType((BizTypeInfo)easValue.get("bizType"));
            }
            backInfo.setRowNum(entry.get("id") == null ? "" : entry.get("id").toString());
            backInfo.setCreateTime(CreateEASBillUtil.getTime());
            backInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            backInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            backCol.addObject((IObjectValue)backInfo);
        }
    }

    private static Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private static BillTypeInfo getBillType(Context ctx, String bosType) throws EASBizException, BOSException {
        BillTypeInfo billType = null;
        try {
            billType = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo("where bosType='" + bosType + "'");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return billType;
    }

    protected static void resetBotRelation(IObjectValue easBill, String entryName, BOTRelationInfo botRelationInfo) {
        IObjectCollection billBaseEntries = (IObjectCollection)easBill.get(entryName);
        BOTRelationEntryCollection newRelationEntries = new BOTRelationEntryCollection();
        for (int j = 0; j < billBaseEntries.size(); ++j) {
            IObjectValue objValue = billBaseEntries.getObject(j);
            String srcEntryId = objValue.getString(SRCBILLENTRYID);
            BOTRelationEntryInfo botEntryInfo = CreateEASBillUtil.getBotEntryBySrcEntryId(botRelationInfo, srcEntryId);
            botEntryInfo.setDestEntryID(objValue.getString("id"));
            if (botEntryInfo == null) continue;
            newRelationEntries.add(botEntryInfo);
        }
        botRelationInfo.remove("relationEntries");
        botRelationInfo.put("relationEntries", (Object)newRelationEntries);
    }

    private static BOTRelationEntryInfo getBotEntryBySrcEntryId(BOTRelationInfo botRelationInfo, String srcEntryId) {
        for (int i = 0; i < botRelationInfo.getRelationEntries().size(); ++i) {
            BOTRelationEntryInfo entry = botRelationInfo.getRelationEntries().get(i);
            if (srcEntryId == null || !srcEntryId.equals(entry.getSrcEntryID())) continue;
            BOTRelationEntryInfo newEntryInfo = new BOTRelationEntryInfo();
            newEntryInfo.putAll((IObjectValue)entry);
            newEntryInfo.put("id", (Object)BOSUuid.create((String)entry.getBOSType().toString()));
            return newEntryInfo;
        }
        return null;
    }

    private static void fillNullFields(IObjectValue easBill, EntityObjectInfo entity) {
        for (int i = 0; i < entity.getEntityProperties().size(); ++i) {
            PropertyInfo pp = entity.getEntityProperties().get(i);
            String dataType = (String)pp.get("dataType");
            String field = pp.getName();
            if (dataType == null || easBill.get(field) != null) continue;
            if ("BigDecimal".equals(dataType)) {
                easBill.setBigDecimal(field, new BigDecimal("0.00"));
                continue;
            }
            if ("Boolean".equals(dataType) || !"Integer".equals(dataType)) continue;
            easBill.setInt(field, 0);
        }
    }

    public ICoreBase getInterface(Context ctx, EntityObjectInfo entity) throws BOSException {
        return (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)entity.getType());
    }

    public static IObjectValue getNewObjectValue(Context ctx, EntityObjectInfo entity) {
        IObjectValue result = null;
        try {
            result = (IObjectValue)Class.forName(entity.getObjectValueClassRuntime()).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static IObjectCollection getNewObjectCollection(Context ctx, EntityObjectInfo entity) {
        IObjectCollection result = null;
        try {
            result = (IObjectCollection)Class.forName(entity.getObjectCollectionClassRuntime()).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static boolean isAboutCustomerStore(StoreTypeInfo storeTypeInfo) {
        StoreFlagEnum storeFlag = storeTypeInfo == null ? null : storeTypeInfo.getStoreFlag();
        int storeFlagValue = storeFlag == null ? -1 : storeFlag.getValue();
        return storeFlagValue == 3 || storeFlagValue == 4;
    }

    private static boolean isAboutSupplierStore(StoreTypeInfo storeTypeInfo) {
        StoreFlagEnum storeFlag = storeTypeInfo == null ? null : storeTypeInfo.getStoreFlag();
        int storeFlagValue = storeFlag == null ? -1 : storeFlag.getValue();
        return storeFlagValue == 2 || storeFlagValue == 5;
    }

    protected static boolean checkAutoTransferForLot(Context ctx, String billID) throws BOSException, EASBizException {
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select billentry.fseq as seq");
        selectSql.append(",invIssue.FISLOTNUMBER as isssueIsLotNumber,invIssue.FISPERIODVALID as issueIsPeriod\r\n");
        selectSql.append(",invIssue.FISTRACKINGNUMBER as issueIsTrack ,invIssue.FISPROJECTNUMBER as issueIsProject\r\n");
        selectSql.append(",invRec.FISLOTNUMBER as recIsLotNumber,invRec.FISPERIODVALID as recIsPeriod\r\n");
        selectSql.append(",invRec.FISTRACKINGNUMBER as recIsTrack ,invRec.FISPROJECTNUMBER as recIsProject\r\n");
        StringBuffer fromSql = new StringBuffer();
        fromSql.append("from t_im_stocktransferbill bill\r\n");
        fromSql.append("inner join t_im_stocktransferbillentry billentry\r\n");
        fromSql.append("on bill.fid = billentry.FPARENTID\r\n");
        fromSql.append("left join t_bd_materialinventory invIssue\r\n");
        fromSql.append("on (billentry.FMATERIALID = invIssue.FMATERIALID\r\n");
        fromSql.append("and bill.FISSUESTORAGEORGUNITID = invIssue.FORGUNIT)\r\n");
        fromSql.append("left join t_bd_materialinventory invRec\r\n");
        fromSql.append("on (billentry.FMATERIALID = invRec.FMATERIALID\r\n");
        fromSql.append("and bill.FRECEIPTSTORAGEORGUNITID = invRec.FORGUNIT)\r\n");
        fromSql.append("where bill.FID = '" + billID + "'");
        String orderBy = " order by billentry.FSEQ asc ";
        StringBuffer lotNullSql = new StringBuffer();
        lotNullSql.append("select billentry.fseq as seq ");
        lotNullSql.append(fromSql);
        lotNullSql.append(" and invIssue.FISLOTNUMBER = 1\r\n");
        lotNullSql.append(" and invRec.FISLOTNUMBER = 1 and billentry.FLOT is null\r\n");
        lotNullSql.append(orderBy);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.append(fromSql).append(orderBy).toString());
        StringBuffer errorStr = new StringBuffer();
        String[][] fileds = new String[][]{{"isssueIsLotNumber", "recIsLotNumber"}, {"issueIsPeriod", "recIsPeriod"}, {"issueIsTrack", "recIsTrack"}, {"issueIsProject", "recIsProject"}};
        NumericExceptionSubItem[] exception = new NumericExceptionSubItem[]{StockTransferBillException.MOVEINOUTORGNOTSAMEATLOT, StockTransferBillException.MOVEINOUTORGNOTSAMEATPERIOD, StockTransferBillException.MOVEINOUTORGNOTSAMEATTRACK, StockTransferBillException.MOVEINOUTORGNOTSAMEATPROJECT};
        try {
            for (int i = 0; i < fileds.length; ++i) {
                if (!rs.isFirst()) {
                    rs.beforeFirst();
                }
                if ((errorStr = CreateEASBillUtil.getErrorStr((ResultSet)rs, fileds[i][0], fileds[i][1])).length() == 0) continue;
                throw new StockTransferBillException(exception[i], new Object[]{errorStr.toString()});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            KsqlUtil.cleanup((ResultSet)rs);
        }
        rs = DbUtil.executeQuery((Context)ctx, (String)lotNullSql.toString());
        int tag = 0;
        try {
            while (rs.next()) {
                if (tag != 0) {
                    errorStr.append(",");
                }
                errorStr.append(rs.getInt("Seq"));
                ++tag;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            KsqlUtil.cleanup((ResultSet)rs);
        }
        if (errorStr.length() == 0) {
            return true;
        }
        throw new StockTransferBillException(StockTransferBillException.LOTNUMCANNOTBENULL, new Object[]{errorStr.toString()});
    }

    private static StringBuffer getErrorStr(ResultSet rs, String issueField, String recField) throws SQLException {
        StringBuffer errorStr = new StringBuffer();
        while (rs.next()) {
            if (rs.getInt(issueField) == rs.getInt(recField)) continue;
            if (errorStr.length() > 0) {
                errorStr.append(",");
            }
            errorStr.append(rs.getInt("seq"));
        }
        return errorStr;
    }

    public static void doAfterDel(Context ctx, String sId, String sNum, int invType) throws BOSException, EASBizException {
        IIndBarcodeBack iIBB = IndBarcodeBackFactory.getLocalInstance(ctx);
        IndBarcodeBackCollection bc = iIBB.getIndBarcodeBackCollection("where num = '" + sNum + "' ");
        if (bc.size() > 0) {
            IObjectPK[] pkc = new IObjectPK[bc.size()];
            IndBarcodeBackInfo binfo = null;
            StringBuffer barcodeStr = new StringBuffer();
            String barcode = null;
            for (int i = 0; i < bc.size(); ++i) {
                binfo = bc.get(i);
                if (null != binfo) {
                    pkc[i] = new ObjectUuidPK(binfo.getId().toString());
                    barcode = binfo.getName();
                    if (barcodeStr.length() > 0) {
                        barcodeStr.append(",").append(barcode);
                    } else {
                        barcodeStr.append(barcode);
                    }
                }
                binfo = null;
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)barcodeStr.toString(), CompareType.INCLUDE));
            view.setFilter(filterInfo);
            IBarcodeDossier iIBD = BarcodeDossierFactory.getLocalInstance(ctx);
            BarcodeDossierCollection barcodeCol = iIBD.getBarcodeDossierCollection(view);
            BarcodeDossierInfo bdinfo = null;
            String bdnum = null;
            HashMap<String, BarcodeDossierInfo> bdMap = new HashMap<String, BarcodeDossierInfo>();
            for (int i = 0; i < barcodeCol.size(); ++i) {
                bdinfo = barcodeCol.get(i);
                bdnum = bdinfo.getNumber();
                if (bdMap.containsKey(bdnum)) continue;
                bdMap.put(bdnum, bdinfo);
            }
            binfo = null;
            CoreBaseCollection bdc = new CoreBaseCollection();
            for (int i = 0; i < bc.size(); ++i) {
                binfo = bc.get(i);
                if (null == binfo) continue;
                pkc[i] = new ObjectUuidPK(binfo.getId().toString());
                barcode = binfo.getName();
                bdinfo = (BarcodeDossierInfo)bdMap.get(barcode);
                if (null == bdinfo || null == bdinfo.getUseType()) continue;
                if (barcodeUseTypeEmum.single.equals((Object)bdinfo.getUseType())) {
                    if (2 == invType) {
                        bdinfo.setBarcodeState(null);
                    } else {
                        bdinfo.setBarcodeState(BarcodeStateEnum.InWarehoued);
                    }
                    bdc.add((CoreBaseInfo)bdinfo);
                    continue;
                }
                if (!barcodeUseTypeEmum.single.equals((Object)bdinfo.getUseType())) continue;
                if (2 == invType) {
                    bdinfo.setBarcodeState(null);
                    bdinfo.setQty(bdinfo.getQty().add(binfo.getBarcodeQty().negate()));
                    if (bdinfo.getQty().equals(BigDecimal.ZERO)) {
                        // empty if block
                    }
                } else {
                    bdinfo.setBarcodeState(BarcodeStateEnum.InWarehoued);
                    bdinfo.setQty(bdinfo.getQty().add(binfo.getBarcodeQty()));
                }
                bdc.add((CoreBaseInfo)bdinfo);
            }
            if (bdc.size() > 0) {
                iIBD.update(bdc);
            }
            iIBB.delete(pkc);
            StringBuffer delSql = new StringBuffer();
            delSql.append("select FID from T_SCM_BcTaskBill where FTargetBillId='").append(sId).append("' ");
            try {
                IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)delSql.toString());
                if (null != rs && rs.size() > 0) {
                    IObjectPK[] idc = new IObjectPK[rs.size()];
                    int i = 0;
                    while (rs.next()) {
                        idc[i] = new ObjectUuidPK(rs.getString("FID"));
                        ++i;
                    }
                    IBcTaskBill iBT = BcTaskBillFactory.getLocalInstance(ctx);
                    iBT.delete(idc);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static int getInOrOutBill(Context ctx, String bosType, String transferNumber) {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection seleCol = new SelectorItemCollection();
        seleCol.add(new SelectorItemInfo("id"));
        seleCol.add(new SelectorItemInfo("number"));
        seleCol.add(new SelectorItemInfo("name"));
        seleCol.add(new SelectorItemInfo("riType.dataDirection"));
        seleCol.add(new SelectorItemInfo("riType.bizDirection"));
        seleCol.add(new SelectorItemInfo("riType.*"));
        view.setSelector(seleCol);
        FilterInfo transfilterInfo = new FilterInfo();
        transfilterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)transferNumber));
        view.setFilter(transfilterInfo);
        TransactionTypeInfo typeInfo = null;
        try {
            TransactionTypeCollection tyleCol = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeCollection(view);
            if (tyleCol.size() > 0) {
                typeInfo = tyleCol.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (typeInfo == null) {
            return 1;
        }
        if (typeInfo != null) {
            if (DataDirectionEnum.positive.equals((Object)typeInfo.getRiType().getDataDirection()) && RIEnum.Receive.equals((Object)typeInfo.getRiType().getRI()) || DataDirectionEnum.navitive.equals((Object)typeInfo.getRiType().getDataDirection()) && RIEnum.Issue.equals((Object)typeInfo.getRiType().getRI())) {
                return 2;
            }
            if (DataDirectionEnum.positive.equals((Object)typeInfo.getRiType().getDataDirection()) && RIEnum.Issue.equals((Object)typeInfo.getRiType().getRI()) || DataDirectionEnum.navitive.equals((Object)typeInfo.getRiType().getDataDirection()) && RIEnum.Receive.equals((Object)typeInfo.getRiType().getRI())) {
                return 3;
            }
        }
        return 1;
    }
}

