/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.Context;
import com.kingdee.eas.barcode.pda.app.biz.CreactNewFaStockTakeRecExec;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.CheckSyncExecFactory;
import com.kingdee.eas.barcode.pda.app.sync.SynCheckHead;
import com.kingdee.eas.barcode.pda.app.sync.SynCheckList;
import com.kingdee.eas.barcode.pda.app.sync.SynPdaMenuExec;
import com.kingdee.eas.barcode.pda.app.sync.SyncDownEasDbExec;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.pda.app.sync.SyncExecAbsFactory;
import com.kingdee.eas.barcode.pda.app.sync.SyncExecUtil;
import com.kingdee.eas.barcode.scm.app.LicenseCache;
import com.kingdee.eas.base.license.LicenseException;

public class FASyncExecFactory
implements SyncExecAbsFactory {
    private FASyncExecFactory() {
    }

    public static FASyncExecFactory getInstance() {
        return SingletonInstance.INSTANCE;
    }

    @Override
    public SyncExec getSyncExec(String type) {
        if ("select_SynCheck_head".equalsIgnoreCase(type)) {
            return new SynCheckHead();
        }
        if ("select_SynCheck_List".equalsIgnoreCase(type)) {
            return new SynCheckList();
        }
        if ("add_faStockTakeRec".equalsIgnoreCase(type)) {
            return new CreactNewFaStockTakeRecExec();
        }
        if ("down_easdb".equalsIgnoreCase(type)) {
            return new SyncDownEasDbExec();
        }
        if ("get_pda_menu".equalsIgnoreCase(type)) {
            return new SynPdaMenuExec();
        }
        return null;
    }

    @Override
    public BacodeMainReturn preCheck(Context ctx, BarcodeMainParam params) {
        BacodeMainReturn rev = SyncExecUtil.checkFALicense(ctx, params);
        if (rev != null) {
            try {
                LicenseCache.checkLicense(ctx, (String)params.getParams().get("_deviceid"));
                rev = null;
            }
            catch (LicenseException e) {
                rev.setCode("-10");
                rev.setMsg(e.getMessage());
            }
            return rev;
        }
        if (rev == null) {
            rev = SyncExecUtil.guidCheck(ctx, params);
        }
        if (rev == null) {
            rev = CheckSyncExecFactory.checkChanged(ctx, params);
        }
        return rev;
    }

    private static class SingletonInstance {
        private static final FASyncExecFactory INSTANCE = new FASyncExecFactory();

        private SingletonInstance() {
        }
    }
}

