/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.BarcodeConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodeConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeConfigXML;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLDetail;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLProperty;
import com.kingdee.eas.barcode.scm.BarcodeDossierCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierEntryCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.BarcodeDossierInfo;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeXMLHelper;
import com.kingdee.eas.barcode.scm.util.UWDateHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCardDAPVoucherSumInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaCurFacilityInfo;
import com.kingdee.eas.fi.fa.manage.FaCurInitDataInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class QueryDossierExec
implements SyncExec {
    private static Logger logger = Logger.getLogger((String)QueryDossierExec.class.getName());

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        Object revlist = null;
        BacodeMainReturn rv = new BacodeMainReturn();
        String newReqTime = UWDateHelper.FORMAT_TIME.format(new Date());
        try {
            revlist = this.getDossier(ctx, params);
            rv.setDefSucc(newReqTime);
            rv.setInfo(revlist);
        }
        catch (Exception e) {
            rv.setInnerError(e.getMessage());
            logger.warn((Object)e);
        }
        return rv;
    }

    private Object getDossier(Context ctx, BarcodeMainParam params) throws Exception {
        BarcodeDossierCollection coll;
        BarcodeDossierInfo info;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("number");
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("barRule.*"));
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("template.entrys.name"));
        sic.add(new SelectorItemInfo("template.entrys.value"));
        sic.add(new SelectorItemInfo("template.entrys.displayName.*"));
        sic.add("entrys.seq");
        sic.add("entrys.name");
        sic.add("entrys.value");
        sic.add("entrys.displayName.name");
        view.setSelector(sic);
        String number = (String)params.getParams().get("number");
        if (!StringUtils.isEmpty((String)number)) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        }
        BarcodeDossierInfo barcodeDossierInfo = info = (coll = BarcodeDossierFactory.getLocalInstance(ctx).getBarcodeDossierCollection(view)).size() == 0 ? null : coll.get(0);
        if (info == null) {
            return null;
        }
        if (params.getParams().get("id") == null) {
            BarcodeDossierEntryCollection entrys = null;
            BarcodeDossierEntryInfo entry = null;
            Object maxNum = null;
            ArrayList<Map> items = new ArrayList<Map>();
            HashMap<String, String> tempNum = new HashMap<String, String>();
            tempNum.put("title", "\u6761\u7801");
            tempNum.put("value", info.getNumber());
            items.add(tempNum);
            entrys = info.getEntrysByTemplate();
            int entrysize = entrys.size();
            for (int j = 0; j < entrysize; ++j) {
                entry = entrys.get(j);
                items.add(this.createDossierRow(entry));
            }
            HashMap<String, Serializable> revMap = new HashMap<String, Serializable>();
            if (info.getBarRule() != null) {
                revMap.put("isasset", Boolean.valueOf(info.getBarRule().isFacard()));
            }
            revMap.put("_maxnum", (Serializable)maxNum);
            revMap.put("_info", items);
            return revMap;
        }
        BarcodePDAViewConfigInfo barcodePDAViewConfigInfo = BarcodePDAViewConfigFactory.getLocalInstance(ctx).getBarcodePDAViewConfigInfo((IObjectPK)new ObjectStringPK(params.getParams().get("id").toString()));
        BarcodeConfigInfo barcodeConfigInfo = barcodePDAViewConfigInfo.getScanConfig();
        BarcodeConfigInfo barcodeConfig = BarcodeConfigFactory.getLocalInstance(ctx).getBarcodeConfigInfo((IObjectPK)new ObjectStringPK(barcodeConfigInfo.getId().toString()));
        BarcodeConfigXML configXml = BarcodeXMLHelper.toBarcodeConfigXML(barcodeConfig.getDetailsXML());
        List<BarcodeConfigXMLDetail> detailList = configXml.getDetails();
        ArrayList<Map> items = new ArrayList<Map>();
        HashMap<String, String> tempNum = new HashMap<String, String>();
        tempNum.put("title", "\u6761\u7801");
        tempNum.put("value", info.getNumber());
        items.add(tempNum);
        System.out.println(info.getFaCurCard().toString());
        FaCurCardInfo faCurCardInfo = FaCurCardFactory.getLocalInstance((Context)ctx).getFaCurCardInfo((IObjectPK)new ObjectStringPK(info.getFaCurCard().toString()));
        for (int i = 0; i < detailList.size(); ++i) {
            BarcodeConfigXMLDetail xmlDetail = detailList.get(i);
            List<BarcodeConfigXMLProperty> propertyList = xmlDetail.getProperties();
            for (int j = 0; j < propertyList.size(); ++j) {
                FaCurCostCenterInfo faCurCostCenterInfo;
                BarcodeConfigXMLProperty xmlProperty = propertyList.get(j);
                if (faCurCardInfo.getFaCurCardSum().get(0) != null && faCurCardInfo.getFaCurCardSum().get(0).getBOSType().equals((Object)xmlDetail.getBosType())) {
                    FaCardDAPVoucherSumInfo faCardDAPVoucherSumInfo = faCurCardInfo.getFaCurCardSum().get(0);
                    items.add(this.createDossierRows((IObjectValue)faCardDAPVoucherSumInfo, xmlProperty, ctx));
                    continue;
                }
                if (faCurCardInfo.getFaCurFacility().get(0) != null && faCurCardInfo.getFaCurFacility().get(0).getBOSType().equals((Object)xmlDetail.getBosType())) {
                    FaCurFacilityInfo faCurFacilityInfo = faCurCardInfo.getFaCurFacility().get(0);
                    items.add(this.createDossierRows((IObjectValue)faCurFacilityInfo, xmlProperty, ctx));
                    continue;
                }
                if (faCurCardInfo.getFaCurCostCenter().get(0) != null && faCurCardInfo.getFaCurCostCenter().get(0).getBOSType().equals((Object)xmlDetail.getBosType())) {
                    faCurCostCenterInfo = faCurCardInfo.getFaCurCostCenter().get(0);
                    items.add(this.createDossierRows((IObjectValue)faCurCostCenterInfo, xmlProperty, ctx));
                    continue;
                }
                if (faCurCardInfo.getFaCurDepartment().get(0) != null && faCurCardInfo.getFaCurDepartment().get(0).getBOSType().equals((Object)xmlDetail.getBosType())) {
                    FaCurDepartmentInfo faCurDepartmentInfo = faCurCardInfo.getFaCurDepartment().get(0);
                    items.add(this.createDossierRows((IObjectValue)faCurDepartmentInfo, xmlProperty, ctx));
                    continue;
                }
                if (faCurCardInfo.getFaCurInitData().get(0) != null && faCurCardInfo.getFaCurInitData().get(0).getBOSType().equals((Object)xmlDetail.getBosType())) {
                    FaCurInitDataInfo FaCurInitDataInfo2 = faCurCardInfo.getFaCurInitData().get(0);
                    items.add(this.createDossierRows((IObjectValue)FaCurInitDataInfo2, xmlProperty, ctx));
                    continue;
                }
                if (faCurCardInfo.getFaCurCostCenter().get(0) != null && faCurCardInfo.getFaCurCostCenter().get(0).getBOSType().equals((Object)xmlDetail.getBosType())) {
                    faCurCostCenterInfo = faCurCardInfo.getFaCurCostCenter().get(0);
                    if (faCurCostCenterInfo.getFaCurAsstActComposit() == null || !faCurCostCenterInfo.getFaCurAsstActComposit().get(0).getBOSType().equals((Object)xmlDetail.getBosType())) continue;
                    items.add(this.createDossierRows((IObjectValue)faCurCostCenterInfo, xmlProperty, ctx));
                    continue;
                }
                items.add(this.createDossierRows((IObjectValue)faCurCardInfo, xmlProperty, ctx));
            }
        }
        HashMap<String, ArrayList<Map>> revMap = new HashMap<String, ArrayList<Map>>();
        revMap.put("_info", items);
        return revMap;
    }

    private Map createDossierRow(BarcodeDossierEntryInfo entry) {
        HashMap<String, String> row = new HashMap<String, String>();
        row.put("title", entry.getDisplayName().getName());
        row.put("value", entry.getValue());
        return row;
    }

    private Map createDossierRows(IObjectValue obj, BarcodeConfigXMLProperty xmlProperty, Context ctx) throws EASBizException, BOSException {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("title", xmlProperty.getAlias());
        if (xmlProperty.isLinkedProperty()) {
            if (obj.get(xmlProperty.getName()) != null) {
                IObjectValue objectValue = (IObjectValue)this.getIObjectValueById(ctx, ((IObjectValue)obj.get(xmlProperty.getName())).getString("id"));
                row.put("value", objectValue.getString("name"));
            } else {
                row.put("value", obj.get(xmlProperty.getName()));
            }
        } else {
            row.put("value", obj.get(xmlProperty.getName()));
        }
        return row;
    }

    protected Object getIObjectValueById(Context ctx, String id) throws BOSException, EASBizException {
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)id, (boolean)true);
        ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("name");
        sic.add("number");
        sic.add("id");
        CoreBaseInfo value = null;
        try {
            if (iCoreBase.exists((IObjectPK)new ObjectUuidPK(id))) {
                value = iCoreBase.getValue((IObjectPK)new ObjectUuidPK(id), sic);
            }
        }
        catch (EASBizException e) {
            throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
        }
        return value;
    }
}

