/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.BarcodeConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodeConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeConfigXML;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLDetail;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLProperty;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigCollection;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigEntryCollection;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningPropertyInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningRecodeInfo;
import com.kingdee.eas.barcode.scm.BarcodeXMLHelper;
import com.kingdee.eas.barcode.scm.util.UWDateHelper;
import com.kingdee.eas.base.form.ide.utils.EntityObjectInfoHelp;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class SynCheckHead
implements SyncExec {
    private static Logger logger = Logger.getLogger((String)SynCheckHead.class.getName());

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        BacodeMainReturn rv = new BacodeMainReturn();
        String newReqTime = UWDateHelper.FORMAT_TIME.format(new java.util.Date());
        rv.setLastupdatetime(newReqTime);
        rv.setDefSucc();
        try {
            rv.setInfo(this.getScanTaskBillCol(ctx, params));
        }
        catch (EASBizException e) {
            e.printStackTrace();
            rv.setCode("0");
            rv.setMsg(e.getMessage());
        }
        catch (BOSException e) {
            e.printStackTrace();
            rv.setCode("0");
            rv.setMsg(e.getMessage());
        }
        catch (SQLException e) {
            e.printStackTrace();
            rv.setCode("0");
            rv.setMsg(e.getMessage());
        }
        return rv;
    }

    private JSONArray getScanTaskBillCol(Context ctx, BarcodeMainParam params) throws BOSException, SQLException, EASBizException {
        BarcodeConfigInfo barcodeConfigInfo = null;
        String pdaid = (String)params.getParams().get("id");
        BarcodePDAViewConfigInfo barcodePDAViewConfigInfo = BarcodePDAViewConfigFactory.getLocalInstance(ctx).getBarcodePDAViewConfigInfo((IObjectPK)new ObjectStringPK(pdaid));
        barcodeConfigInfo = barcodePDAViewConfigInfo.getScanConfig();
        barcodeConfigInfo = BarcodeConfigFactory.getLocalInstance(ctx).getBarcodeConfigInfo((IObjectPK)new ObjectStringPK(barcodeConfigInfo.getId().toString()));
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(new java.util.Date());
        String src = " select    bill.fcreatorid as creator,bill.fcreatetime  as createtime,bill.flastupdateuserid as lastupdateuser,bill.flastupdatetime  as lastupdatetime , bill.fbizdate  as bizdate ,bill.fbegindate as begindate,bill.fenddate as  enddate,bill.fcompanyid as company,bill.fvoucher as voucher,  ";
        src = src + "  bill.FTaskBillID as taskBill ,bill.FOperatorID as operator ,bill.fnumber as number , bill.fid  as fid,bill.fhandlerid as  handler,";
        src = src + "  bill.fhaseffected as haseffected,bill.fauditorid as auditor,bill.faudittime as audittime , bill.fstocktakingstatus as stocktakingstatus   from  T_FA_StocktakingBill bill left join  T_FA_StocktakingTaskBill task on  bill.ftaskbillid=task.fid  where task.fstocktakingstatus=3  ";
        if (ContextUtil.getCurrentFIUnit((Context)ctx) != null) {
            src = src + " and  task.fcompanyid='" + ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString() + "' ";
        }
        src = src + "  and    to_char(task.fenddate,'yyyy-mm-dd')  >='" + dateString + "' ";
        src = src + "  order by  task.fnumber  desc ";
        System.out.println(src);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)src);
        Map<String, Map<String, BarcodePDAViewConfigEntryInfo>> barcodepdaEntryInfoMap = null;
        HashMap<String, String> defalutConfigMap = null;
        if (rowSet.size() > 0) {
            defalutConfigMap = new HashMap<String, String>();
            barcodepdaEntryInfoMap = this.getBarcodePdaConfigMap(ctx, defalutConfigMap, pdaid);
        }
        JSONArray allArray = new JSONArray();
        while (rowSet.next()) {
            JSONObject taskBillObj = this.scanTaskBillRow(ctx, rowSet, barcodepdaEntryInfoMap, barcodeConfigInfo);
            allArray.add((Object)taskBillObj);
        }
        return allArray;
    }

    private Map<String, Map<String, BarcodePDAViewConfigEntryInfo>> getBarcodePdaConfigMap(Context ctx, Map<String, String> defalutConfigMap, String pdaid) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)pdaid, CompareType.EQUALS));
        view.setFilter(filterInfo);
        view.setSelector(this.getSelectors());
        BarcodePDAViewConfigCollection barcodePdaCol = BarcodePDAViewConfigFactory.getLocalInstance(ctx).getBarcodePDAViewConfigCollection(view);
        LinkedHashMap<String, Map<String, BarcodePDAViewConfigEntryInfo>> barcodepdaConfigMap = new LinkedHashMap<String, Map<String, BarcodePDAViewConfigEntryInfo>>();
        int size = barcodePdaCol.size();
        for (int i = 0; i < size; ++i) {
            BarcodePDAViewConfigInfo barcodePdaInfo = barcodePdaCol.get(i);
            String scanConfigId = barcodePdaInfo.getScanConfig().getId().toString();
            BarcodePDAViewConfigEntryCollection barcodePDAViewCol = barcodePdaInfo.getEntitys();
            LinkedHashMap<String, BarcodePDAViewConfigEntryInfo> configEntryMap = new LinkedHashMap<String, BarcodePDAViewConfigEntryInfo>();
            int m = barcodePDAViewCol.size();
            for (int j = 0; j < m; ++j) {
                BarcodePDAViewConfigEntryInfo configEntryInfo = barcodePDAViewCol.get(j);
                configEntryMap.put(configEntryInfo.getColumnCode(), configEntryInfo);
            }
            if (barcodePdaInfo.getDefualtSolution() != null) {
                defalutConfigMap.put(scanConfigId, barcodePdaInfo.getDefualtSolution().getId().toString());
            }
            barcodepdaConfigMap.put(scanConfigId, configEntryMap);
        }
        return barcodepdaConfigMap;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = System.getProperty("selector.all");
        if (StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        sic.add(new SelectorItemInfo("entitys.*"));
        sic.add(new SelectorItemInfo("entitys.name"));
        sic.add(new SelectorItemInfo("entitys.pdaTitle"));
        sic.add(new SelectorItemInfo("entitys.consleType"));
        sic.add(new SelectorItemInfo("entitys.columnType"));
        sic.add(new SelectorItemInfo("entitys.scanSeq"));
        sic.add(new SelectorItemInfo("entitys.columnCode"));
        sic.add(new SelectorItemInfo("entitys.isView"));
        sic.add(new SelectorItemInfo("entitys.entryType"));
        sic.add(new SelectorItemInfo("entitys.proEventStr"));
        sic.add(new SelectorItemInfo("entitys.isEdit"));
        sic.add(new SelectorItemInfo("entitys.bosTypeStr"));
        sic.add(new SelectorItemInfo("entitys.parentBosTypeStr"));
        sic.add(new SelectorItemInfo("entitys.entryName"));
        sic.add(new SelectorItemInfo("entitys.specialColStr"));
        sic.add(new SelectorItemInfo("entitys.isListView"));
        sic.add(new SelectorItemInfo("entitys.tableName"));
        sic.add(new SelectorItemInfo("entitys.filedName"));
        sic.add(new SelectorItemInfo("entitys.LinkTableName"));
        sic.add(new SelectorItemInfo("entitys.fullName"));
        sic.add(new SelectorItemInfo("entitys.isSetDefault"));
        sic.add(new SelectorItemInfo("tableName"));
        sic.add(new SelectorItemInfo("offline"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("scanConfig.*"));
        } else {
            sic.add(new SelectorItemInfo("scanConfig.id"));
            sic.add(new SelectorItemInfo("scanConfig.number"));
            sic.add(new SelectorItemInfo("scanConfig.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("defualtSolution.*"));
        } else {
            sic.add(new SelectorItemInfo("defualtSolution.id"));
            sic.add(new SelectorItemInfo("defualtSolution.number"));
            sic.add(new SelectorItemInfo("defualtSolution.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("CU.*"));
        } else {
            sic.add(new SelectorItemInfo("CU.id"));
            sic.add(new SelectorItemInfo("CU.number"));
            sic.add(new SelectorItemInfo("CU.name"));
        }
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("scanConfig.*"));
        sic.add(new SelectorItemInfo("entitys.fullName"));
        return sic;
    }

    private JSONObject scanTaskBillRow(Context ctx, IRowSet rows, Map<String, Map<String, BarcodePDAViewConfigEntryInfo>> barcodepdaEntryInfoMap, BarcodeConfigInfo barcodeConfigInfo) throws SQLException, EASBizException, BOSException {
        JSONObject taskBillObj = new JSONObject();
        Map<String, BarcodePDAViewConfigEntryInfo> barcodeEntryInfoMap = barcodepdaEntryInfoMap.get(barcodeConfigInfo.getId().toString());
        BarcodeConfigXML configXml = BarcodeXMLHelper.toBarcodeConfigXML(barcodeConfigInfo.getDetailsXML());
        Object o = this.getRecodesList(ctx, configXml, rows);
        if (o != null) {
            List recodesList = (List)o;
            if (recodesList.size() > 0) {
                JSONObject billObject = this.loadScanRecods(ctx, recodesList, barcodeEntryInfoMap);
                taskBillObj.put((Object)"_bill", (Object)billObject);
            } else {
                return null;
            }
        }
        return taskBillObj;
    }

    protected JSONObject loadScanRecods(Context ctx, List<BarcodeScanningRecodeInfo> recodesList, Map<String, BarcodePDAViewConfigEntryInfo> barcodeEntryInfoMap) {
        JSONObject billObj = new JSONObject();
        JSONArray rowsArray = new JSONArray();
        JSONObject itemProObj = new JSONObject();
        JSONObject spcObj = new JSONObject();
        if (recodesList.size() == 0 || recodesList.get(0).getProperties() == null) {
            return null;
        }
        for (int i = 0; recodesList.size() > i; ++i) {
            BarcodeScanningRecodeInfo scaningRecodeInfo = recodesList.get(i);
            Iterator<String> it = scaningRecodeInfo.getProperties().keySet().iterator();
            JSONObject rowsObj = new JSONObject();
            while (it.hasNext()) {
                String temp = it.next();
                BarcodeScanningPropertyInfo property = scaningRecodeInfo.getProperties().get(temp);
                if (property.getKey().equals("id")) continue;
                BarcodeConfigXMLProperty xmlProperty = null;
                xmlProperty = property.getBcxmlProperty() == null ? new BarcodeConfigXMLProperty() : property.getBcxmlProperty();
                Object value = property.getValue();
                if (value == null || "".equals(value)) {
                    value = "";
                }
                if (value instanceof BigDecimal) {
                    if (value == null || "".equals(value) || BigDecimal.ZERO.compareTo(new BigDecimal(value.toString())) == 0) {
                        value = BigDecimal.ZERO;
                    }
                    BigDecimal qty = (BigDecimal)value;
                    value = new BigDecimal(qty.stripTrailingZeros().toPlainString());
                }
                billObj.put((Object)property.getKey(), (Object)value.toString());
                if (i != 0) continue;
                itemProObj.put((Object)property.getKey(), (Object)this.getJsonStr(ctx, property.getKey(), property.getValue(), xmlProperty, false, true, barcodeEntryInfoMap));
                billObj.put((Object)property.getKey(), (Object)this.getJsonStr(ctx, property.getKey(), property.getValue(), xmlProperty, true, true, barcodeEntryInfoMap));
            }
            rowsArray.add((Object)rowsObj);
        }
        billObj.put((Object)"_itemproperties", (Object)itemProObj);
        return billObj;
    }

    protected Object getRecodesList(Context ctx, Object xml, IRowSet rows) throws BOSException, EASBizException {
        BarcodeConfigXML xmlInfo = (BarcodeConfigXML)xml;
        List<BarcodeConfigXMLDetail> detailList = xmlInfo.getDetails();
        for (int i = 0; i < detailList.size(); ++i) {
            BarcodeConfigXMLDetail xmlDetail = detailList.get(i);
            EntityObjectInfo eo = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)xmlDetail.getBosType()));
            if (xmlDetail.getParentBosType() != null) continue;
            String bosType = xmlDetail.getBosType();
            List<BarcodeConfigXMLProperty> propertyList = xmlDetail.getProperties();
            ArrayList<BarcodeScanningRecodeInfo> recodesList = new ArrayList<BarcodeScanningRecodeInfo>();
            try {
                BarcodeScanningRecodeInfo recodeInfo = this.createRecodesInfo(ctx, propertyList, rows, bosType);
                recodesList.add(recodeInfo);
            }
            catch (Exception e) {
                throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
            }
            return recodesList;
        }
        return null;
    }

    private BarcodeScanningRecodeInfo createRecodesInfo(Context ctx, List<BarcodeConfigXMLProperty> propertyList, IRowSet rowSet, String bosType) throws SQLException, ParseException {
        BarcodeScanningRecodeInfo recodeInfo = new BarcodeScanningRecodeInfo();
        recodeInfo.setFid(rowSet.getString("fid"));
        TreeMap<String, BarcodeScanningPropertyInfo> propertyMap = new TreeMap<String, BarcodeScanningPropertyInfo>();
        boolean hasNumberFiled = false;
        for (int j = 0; j < propertyList.size(); ++j) {
            BarcodeScanningPropertyInfo proInfo = new BarcodeScanningPropertyInfo();
            BarcodeConfigXMLProperty xmlPro = propertyList.get(j);
            String key = xmlPro.getName();
            if (xmlPro.isLinkedProperty()) {
                proInfo.setKey(key + "_number");
                IObjectValue objectValue = null;
                if (rowSet.getString(key) != null) {
                    try {
                        objectValue = (IObjectValue)this.getIObjectValueById(ctx, rowSet.getString(key));
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                    proInfo.setValue(objectValue.get("number"));
                } else {
                    proInfo.setValue(null);
                }
                proInfo.setBcxmlProperty(xmlPro);
                propertyMap.put(key + "_number", proInfo);
                proInfo = new BarcodeScanningPropertyInfo();
                proInfo.setKey(key + "_name");
                if (rowSet.getString(key) != null) {
                    proInfo.setValue(objectValue.get("name"));
                } else {
                    proInfo.setValue(null);
                }
                propertyMap.put(key + "_name", proInfo);
                continue;
            }
            if (key.equals("number")) {
                hasNumberFiled = true;
            }
            Object value = rowSet.getObject(key);
            if (xmlPro.getDataType().equals("Date") && value != null) {
                value = Date.valueOf(value.toString().substring(0, 10));
            }
            if (xmlPro.getDataType().equals("Boolean") && value != null) {
                value = !value.equals("false");
            }
            if (xmlPro.getDataType().equals("Integer") && value != null) {
                value = Integer.valueOf(rowSet.getString(key));
            }
            proInfo.setKey(key);
            proInfo.setValue(value);
            proInfo.setBcxmlProperty(xmlPro);
            propertyMap.put(key, proInfo);
        }
        propertyMap.put("fid", this.getCommonProInfo(rowSet, "fid"));
        recodeInfo.setProperties(propertyMap);
        return recodeInfo;
    }

    protected Object getIObjectValueById(Context ctx, String id) throws BOSException, EASBizException {
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)id, (boolean)true);
        ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("name");
        sic.add("number");
        sic.add("id");
        CoreBaseInfo value = null;
        try {
            if (iCoreBase.exists((IObjectPK)new ObjectUuidPK(id))) {
                value = iCoreBase.getValue((IObjectPK)new ObjectUuidPK(id), sic);
            }
        }
        catch (EASBizException e) {
            throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
        }
        return value;
    }

    private BarcodeScanningPropertyInfo getCommonProInfo(IRowSet rowSet, String key) throws SQLException {
        BarcodeScanningPropertyInfo proInfo = new BarcodeScanningPropertyInfo();
        proInfo.setKey(key);
        proInfo.setValue(rowSet.getObject(key));
        proInfo.setBcxmlProperty(new BarcodeConfigXMLProperty());
        return proInfo;
    }

    private JSONObject getJsonStr(Context ctx, String propertyName, Object value, BarcodeConfigXMLProperty xmlProperty, boolean isShowVal, boolean isLimit, Map<String, BarcodePDAViewConfigEntryInfo> barcodeEntryInfoMap) {
        if (value == null) {
            value = "";
        }
        JSONObject jsonObj = new JSONObject();
        if (isShowVal) {
            if (value != null && !"".equals(value)) {
                jsonObj.put((Object)"val", (Object)value.toString());
            } else {
                jsonObj.put((Object)"val", (Object)"");
            }
        }
        if (xmlProperty != null && xmlProperty.getAlias() == null) {
            xmlProperty.setAlias(propertyName);
        }
        if (isLimit && xmlProperty != null) {
            StringBuffer limitStr = new StringBuffer();
            String key = propertyName;
            if (!xmlProperty.isLinkedProperty() && xmlProperty.getFullName() != null) {
                key = xmlProperty.getFullName();
            }
            if (key != null && barcodeEntryInfoMap != null && barcodeEntryInfoMap != null && barcodeEntryInfoMap.containsKey(key)) {
                BarcodePDAViewConfigEntryInfo configEntryInfo = barcodeEntryInfoMap.get(key);
                limitStr.append(configEntryInfo.isIsView() ? "1" : "0");
                limitStr.append(configEntryInfo.isIsEdit() ? "1" : "0");
                limitStr.append("0");
                limitStr.append("0");
                limitStr.append(xmlProperty.isScanQty() ? "1" : "0");
                jsonObj.put((Object)"alias", (Object)configEntryInfo.getPdaTitle());
            } else {
                if (key.indexOf("_name") != -1 && !key.equals("creator_name")) {
                    limitStr.append("0");
                    limitStr.append("0");
                } else {
                    limitStr.append("1");
                    limitStr.append("1");
                }
                limitStr.append("0");
                limitStr.append("0");
                limitStr.append(xmlProperty.isScanQty() ? "1" : "0");
                jsonObj.put((Object)"alias", (Object)(xmlProperty != null ? xmlProperty.getAlias() : ""));
            }
            jsonObj.put((Object)"limit", (Object)limitStr.toString());
        }
        return jsonObj;
    }
}

