/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.BcTaskBillFactory;
import com.kingdee.eas.barcode.scm.util.UWDateHelper;
import com.kingdee.eas.common.EASBizException;
import java.util.Date;
import net.sf.json.JSONArray;
import org.apache.log4j.Logger;

public class SynDeleteTask
implements SyncExec {
    private static Logger logger = Logger.getLogger((String)SynDeleteTask.class.getName());

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        Object revlist = null;
        BacodeMainReturn rv = new BacodeMainReturn();
        String newReqTime = UWDateHelper.FORMAT_TIME.format(new Date());
        try {
            long time = System.currentTimeMillis();
            logger.info((Object)(" SynDeleteTask begin\uff1a" + time));
            rv = this.deleteTask(ctx, params);
            time = System.currentTimeMillis() - time;
            logger.info((Object)(" SynDeleteTask end,totalTime=\uff1a" + time));
        }
        catch (Exception e) {
            rv.setInnerError(e.getMessage());
            System.out.println(e.getMessage());
            logger.warn((Object)e);
        }
        return rv;
    }

    private BacodeMainReturn deleteTask(Context ctx, BarcodeMainParam params) {
        BacodeMainReturn rv = new BacodeMainReturn();
        if (params.getParams().containsKey("_taskids") && params.getParams().get("_taskids") != null) {
            Object[] taskid = ((JSONArray)params.getParams().get("_taskids")).toArray();
            ObjectStringPK[] pkList = new ObjectStringPK[taskid.length];
            for (int i = 0; taskid.length > i; ++i) {
                pkList[i] = new ObjectStringPK(taskid[i].toString());
            }
            if (pkList != null && pkList.length > 0) {
                try {
                    BcTaskBillFactory.getLocalInstance(ctx).delete((IObjectPK[])pkList);
                    rv.setCode("1");
                    rv.setMsg("\u5220\u9664\u6210\u529f\uff01");
                    return rv;
                }
                catch (EASBizException e) {
                    rv.setCode("0");
                    rv.setMsg("\u5220\u9664\u5931\u8d25\uff01");
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    rv.setCode("0");
                    rv.setMsg("\u5220\u9664\u5931\u8d25\uff01");
                    e.printStackTrace();
                }
            }
        }
        if (rv == null) {
            rv.setCode("1");
            rv.setMsg("\u6ca1\u6709\u8bb0\u5f55\u5220\u9664\uff01");
        }
        return rv;
    }
}

