/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.BarcodeConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigCollection;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.util.UWDateHelper;
import com.kingdee.eas.base.form.ide.utils.EntityObjectInfoHelp;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.common.EASBizException;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class SynPdaMenuExec
implements SyncExec {
    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        BacodeMainReturn rv = new BacodeMainReturn();
        String newReqTime = UWDateHelper.FORMAT_TIME.format(new Date());
        rv.setLastupdatetime(newReqTime);
        rv.setDefSucc();
        try {
            rv.setInfo(this.getScanTaskBillCol(ctx, params));
        }
        catch (EASBizException e) {
            e.printStackTrace();
            rv.setCode("0");
            rv.setMsg(e.getMessage());
        }
        catch (BOSException e) {
            e.printStackTrace();
            rv.setCode("0");
            rv.setMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            rv.setCode("0");
            rv.setMsg(e.getMessage());
        }
        return rv;
    }

    private JSONArray getScanTaskBillCol(Context ctx, BarcodeMainParam params) throws BOSException, SQLException, EASBizException, LicenseException {
        String uiClssName = "com.kingdee.eas.barcode.scm.client.BarcodePDAViewConfigListUI";
        ILicenseSrvAgent iILicenseSrvAgent = LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
        HashMap map = new HashMap();
        String[] licenseNameArg = new String[]{"BARCODE_PDA", "BARCODE_FA"};
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("scanConfig.*"));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        BarcodePDAViewConfigCollection barcodePDAViewConfigColl = BarcodePDAViewConfigFactory.getLocalInstance(ctx).getBarcodePDAViewConfigCollection(view);
        JSONArray allArray = new JSONArray();
        if (barcodePDAViewConfigColl.size() > 0) {
            for (int i = 0; barcodePDAViewConfigColl.size() > i; ++i) {
                BarcodePDAViewConfigInfo barcodePDAViewConfigInfo = barcodePDAViewConfigColl.get(i);
                BarcodeConfigInfo barcodeConfigInfo = barcodePDAViewConfigInfo.getScanConfig();
                EntityObjectInfo eo = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)barcodeConfigInfo.getDestBosType()));
                JSONObject taskBillObj = null;
                if (eo == null || eo.getFullName().indexOf("com.kingdee.eas.fi.fa") == -1) continue;
                taskBillObj = this.scanTaskBillRow(ctx, barcodePDAViewConfigInfo, barcodeConfigInfo);
                allArray.add((Object)taskBillObj);
            }
        }
        return allArray;
    }

    private JSONObject scanTaskBillRow(Context ctx, BarcodePDAViewConfigInfo barcodePDAViewConfigInfo, BarcodeConfigInfo barcodeConfigInfo) throws SQLException, EASBizException, BOSException {
        JSONObject taskBillObj = new JSONObject();
        taskBillObj.put((Object)"billid", (Object)barcodePDAViewConfigInfo.getId().toString());
        String bosType = barcodePDAViewConfigInfo.getMenuType();
        EntityObjectInfo entityObjectInfo = BarcodeUtils.getEntityByBosType(bosType);
        if (entityObjectInfo != null) {
            taskBillObj.put((Object)"menutype", (Object)entityObjectInfo.getAlias());
        } else {
            taskBillObj.put((Object)"menutype", null);
        }
        if (barcodeConfigInfo.getBotMapping() != null) {
            taskBillObj.put((Object)"botpid", (Object)barcodeConfigInfo.getBotMapping().getId().toString());
        } else {
            taskBillObj.put((Object)"botpid", null);
        }
        taskBillObj.put((Object)"barconfigname", (Object)barcodeConfigInfo.getName());
        taskBillObj.put((Object)"barconfignumber", (Object)barcodeConfigInfo.getNumber());
        taskBillObj.put((Object)"srcbostype", (Object)barcodeConfigInfo.getSrcBosType());
        taskBillObj.put((Object)"destbostype", (Object)barcodeConfigInfo.getDestBosType());
        taskBillObj.put((Object)"srcalias", (Object)barcodeConfigInfo.getSrcAlias());
        taskBillObj.put((Object)"destalias", (Object)barcodeConfigInfo.getDestAlias());
        taskBillObj.put((Object)"verifymode", (Object)barcodeConfigInfo.isVerifyMode());
        taskBillObj.put((Object)"completecheck", (Object)barcodeConfigInfo.isCompleteCheck());
        taskBillObj.put((Object)"ismatchbill", (Object)barcodeConfigInfo.isIsMatchBill());
        taskBillObj.put((Object)"iswholescan", (Object)barcodeConfigInfo.isIsWholeScan());
        return taskBillObj;
    }
}

