/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.util.UWDateHelper;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SynSelectBaseData
implements SyncExec {
    private static Logger logger = Logger.getLogger((String)SynSelectBaseData.class.getName());

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        Object revlist = null;
        BacodeMainReturn rv = new BacodeMainReturn();
        String newReqTime = UWDateHelper.FORMAT_TIME.format(new Date());
        try {
            long time = System.currentTimeMillis();
            logger.info((Object)(" SynSelectBaseData begin\uff1a" + time));
            revlist = this.getSelectBaseData(ctx, params);
            time = System.currentTimeMillis() - time;
            logger.info((Object)(" SynSelectBaseData end,totalTime=\uff1a" + time));
            rv.setDefSucc(newReqTime);
            rv.setInfo(revlist);
        }
        catch (Exception e) {
            rv.setInnerError(e.getMessage());
            logger.warn((Object)e);
        }
        return rv;
    }

    private Object getSelectBaseData(Context ctx, BarcodeMainParam params) throws EASBizException, BOSException {
        String bostype = (String)params.getParams().get("bostype");
        BOSObjectType bOSObjectType = new BOSObjectType(bostype);
        ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bOSObjectType);
        EntityViewInfo view = new EntityViewInfo();
        ArrayList baseData = new ArrayList();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("name");
        sic.add("number");
        sic.add("id");
        FilterInfo filter = new FilterInfo();
        if ("80EF7DED".equals(bostype)) {
            FilterInfo filterPerson = new FilterInfo();
            if (params.getParams().containsKey("obscure") && !StringUtils.isEmpty((String)((String)params.getParams().get("obscure")))) {
                String likeSelect = (String)params.getParams().get("obscure");
                filterPerson.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + likeSelect + "%"), CompareType.LIKE));
                filterPerson.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + likeSelect + "%"), CompareType.LIKE));
                filterPerson.setMaskString(" #0 or #1 ");
            }
            MetaDataPK personQueryPK = new MetaDataPK("com.kingdee.eas.basedata.person.app", "PersonQuery");
            filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)(ContextUtil.getCurrentAdminUnit((Context)ctx).getLongNumber() + "%"), CompareType.LIKE));
            filter.mergeFilter(filterPerson, "and");
            view.setFilter(filter);
            view.setSelector(sic);
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)personQueryPK);
            exec.setObjectView(view);
            IRowSet rowSet = exec.executeQuery();
            HashMap<String, String> coreBaseMap = null;
            try {
                while (rowSet.next()) {
                    coreBaseMap = new HashMap<String, String>();
                    coreBaseMap.put("name", rowSet.getString("name"));
                    coreBaseMap.put("id", rowSet.getString("id"));
                    coreBaseMap.put("number", rowSet.getString("number"));
                    baseData.add(coreBaseMap);
                }
                return baseData;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else if ("BA8AD747".equals(bostype)) {
            MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.scm.im.inv", "BarcodeInventoryQuery");
            EntityViewInfo viewInfo = this.createInventoryFilter(ctx, params);
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
            exec.setObjectView(viewInfo);
            exec.option().isIgnoreOrder = false;
            exec.option().isAutoIgnoreZero = true;
            exec.option().isAutoTranslateBoolean = true;
            exec.option().isAutoTranslateEnum = true;
            exec.option().topCount = 100;
            exec.option().isIgnoreRowCount = true;
            exec.option().pageCount = 50;
            exec.option().isIgnorePermissionCheck = true;
            IRowSet rowSet = exec.executeQuery();
            HashMap<String, Object> coreBaseMap = null;
            try {
                while (rowSet.next()) {
                    coreBaseMap = new HashMap<String, Object>();
                    coreBaseMap.put("number", rowSet.getString("lot"));
                    coreBaseMap.put("name", rowSet.getBigDecimal("curMatStoreQty").setScale(4, 5));
                    coreBaseMap.put("warehouse", rowSet.getString("warehouse.name"));
                    coreBaseMap.put("warehouse_number", rowSet.getString("warehouse.number"));
                    coreBaseMap.put("location_number", rowSet.getString("location.number"));
                    coreBaseMap.put("location", rowSet.getString("location.name"));
                    coreBaseMap.put("asstAttr_number", rowSet.getString("assistProperty.number"));
                    coreBaseMap.put("asstAttr", rowSet.getString("assistProperty.name"));
                    coreBaseMap.put("projectNo_number", rowSet.getString("project.number"));
                    coreBaseMap.put("projectNo", rowSet.getString("project.name"));
                    coreBaseMap.put("trackNo_number", rowSet.getString("trackNumber.number"));
                    coreBaseMap.put("trackNo", rowSet.getString("trackNumber.name"));
                    if (rowSet.getDate("DateOfMinDurability.mfg") != null) {
                        coreBaseMap.put("proDate", UWDateHelper.FORMAT_DAY.format(rowSet.getDate("DateOfMinDurability.mfg")));
                    } else {
                        coreBaseMap.put("proDate", null);
                    }
                    if (rowSet.getDate("DateOfMinDurability.exp") != null) {
                        coreBaseMap.put("untilDate", UWDateHelper.FORMAT_DAY.format(rowSet.getDate("DateOfMinDurability.exp")));
                    } else {
                        coreBaseMap.put("untilDate", null);
                    }
                    baseData.add(coreBaseMap);
                }
                return baseData;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            String likeSelect = "";
            if (params.getParams().containsKey("obscure") && !StringUtils.isEmpty((String)((String)params.getParams().get("obscure")))) {
                likeSelect = (String)params.getParams().get("obscure");
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + likeSelect + "%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + likeSelect + "%"), CompareType.LIKE));
                filter.setMaskString(" #0 or #1 ");
            }
            FilterInfo filters = new FilterInfo();
            if ("BF0C040E".equals(bostype) || "37C67DFC".equals(bostype) || "4409E7F0".equals(bostype)) {
                StringBuffer sb = new StringBuffer();
                if ("BF0C040E".equals(bostype)) {
                    sb.append(" select   customer.fid as id,max(customer.fnumber) as number,max(customer.fname_l2) as name from   T_BD_Customer  customer  \n");
                    sb.append(" left join  T_BD_CustomerSaleInfo customersaleinfo on customer.fid=customersaleinfo.FCUSTOMERID \n");
                    sb.append(" left join  T_BD_CustomerCompanyInfo customercompanyinfo on customer.fid=customercompanyinfo.FCUSTOMERID  \n");
                    if (!StringUtils.isEmpty((String)likeSelect)) {
                        sb.append("  where ( customersaleinfo.FSALEORGID='").append(ContextUtil.getCurrentPurchaseUnit((Context)ctx).getId().toString()).append("'");
                        sb.append("  or  customercompanyinfo.FCOMORGID='").append(ContextUtil.getCurrentPurchaseUnit((Context)ctx).getId().toString()).append("'  and  customer.FUSEDSTATUS=1  and  customer.FEFFECTEDSTATUS=2  \n");
                        sb.append(" ) and ( customer.fname_l2  like '%").append(likeSelect).append("%'   \n");
                        sb.append("  or  customer.fnumber like '%").append(likeSelect).append("%'  )  \n");
                    } else {
                        sb.append("  where customersaleinfo.FSALEORGID='").append(ContextUtil.getCurrentPurchaseUnit((Context)ctx).getId().toString()).append("'");
                        sb.append("  or  customercompanyinfo.FCOMORGID='").append(ContextUtil.getCurrentPurchaseUnit((Context)ctx).getId().toString()).append("'  and  customer.FUSEDSTATUS=1  and  customer.FEFFECTEDSTATUS=2  \n");
                    }
                    sb.append(" group by  customer.fid ");
                } else if ("37C67DFC".equals(bostype)) {
                    sb.append(" select   supplier.fid as id,max(supplier.fnumber) as number,max(supplier.fname_l2) as name from   T_BD_Supplier  supplier \n");
                    sb.append(" left join  T_BD_SupplierPurchaseInfo supplierPurchaseInfo on supplier.fid=supplierPurchaseInfo.FSUPPLIERID \n");
                    sb.append(" left join  T_BD_SupplierCompanyInfo supplierCompanyInfo on supplier.fid=supplierCompanyInfo.FSUPPLIERID  \n");
                    if (!StringUtils.isEmpty((String)likeSelect)) {
                        sb.append(" where ( supplierPurchaseInfo.FPURCHASEORGID='").append(ContextUtil.getCurrentPurchaseUnit((Context)ctx).getId().toString()).append("'");
                        sb.append("  or  supplierCompanyInfo.FCOMORGID='").append(ContextUtil.getCurrentPurchaseUnit((Context)ctx).getId().toString()).append("'   and  supplier.fusedstatus=1  and  supplier.feffectedstatus=2  \n");
                        sb.append(" ) and  ( supplier.fname_l2  like '%").append(likeSelect).append("%'   \n");
                        sb.append("  or   supplier.fnumber like '%").append(likeSelect).append("%'  ) \n");
                    } else {
                        sb.append(" where  supplierPurchaseInfo.FPURCHASEORGID='").append(ContextUtil.getCurrentPurchaseUnit((Context)ctx).getId().toString()).append("'");
                        sb.append("  or  supplierCompanyInfo.FCOMORGID='").append(ContextUtil.getCurrentPurchaseUnit((Context)ctx).getId().toString()).append("'   and  supplier.fusedstatus=1  and  supplier.feffectedstatus=2  \n");
                    }
                    sb.append(" group by  supplier.fid ");
                } else if ("4409E7F0".equals(bostype)) {
                    sb.append(" select material.fname_l2 as name,material.fnumber as number,material.fid as id,materialinventory.fisperiodvalid as isperiodvalid,materialinventory.fperiodvalid as periodvalid,materialinventory.fperiodvalidunit  as  periodvalidunit from  T_BD_Material   material  \n");
                    sb.append(" left  join  T_BD_MaterialInventory materialinventory on  materialinventory.fmaterialid=material.fid \n");
                    sb.append("  where   (materialinventory.fstatus=1  and forgunit='").append(ContextUtil.getCurrentStorageUnit((Context)ctx).getId().toString()).append("'  \n");
                    if (params.getParams().containsKey("_ismaterial") && ((Boolean)params.getParams().get("_ismaterial")).booleanValue()) {
                        sb.append("  and   material.fnumber='").append(likeSelect).append("')   \n");
                    } else if (!StringUtils.isEmpty((String)likeSelect)) {
                        sb.append(" ) and   ( material.fname_l2  like '%").append(likeSelect).append("%'   \n");
                        sb.append("  or   material.fnumber like '%").append(likeSelect).append("%' )   \n");
                    } else {
                        sb.append("  )  \n ");
                    }
                }
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                HashMap<String, Object> coreBaseMap = null;
                try {
                    while (rowSet.next()) {
                        coreBaseMap = new HashMap<String, Object>();
                        if ("4409E7F0".equals(bostype)) {
                            coreBaseMap.put("isperiodvalid", rowSet.getBoolean("isperiodvalid"));
                            coreBaseMap.put("periodvalid", rowSet.getInt("periodvalid"));
                            if (rowSet.getInt("periodvalidunit") == 1) {
                                coreBaseMap.put("periodvalidunit", 1);
                            } else if (rowSet.getInt("periodvalidunit") == 2) {
                                coreBaseMap.put("periodvalidunit", 2);
                            } else if (rowSet.getInt("periodvalidunit") == 3) {
                                coreBaseMap.put("periodvalidunit", 5);
                            }
                        }
                        coreBaseMap.put("name", rowSet.getString("name"));
                        coreBaseMap.put("id", rowSet.getString("id"));
                        coreBaseMap.put("number", rowSet.getString("number"));
                        baseData.add(coreBaseMap);
                    }
                    return baseData;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            } else if ("A8E556C9".equals(bostype)) {
                filters.getFilterItems().add(new FilterItemInfo("adminCU", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()));
            } else if ("BBE9F8AE".equals(bostype)) {
                filters.getFilterItems().add(new FilterItemInfo("storageOrg", (Object)ContextUtil.getCurrentStorageUnit((Context)ctx).getId().toString()));
                filters.getFilterItems().add(new FilterItemInfo("whState", (Object)"1"));
            } else if ("6A6435BE".equals(bostype)) {
                filters.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(ContextUtil.getCurrentAdminUnit((Context)ctx).getLongNumber() + "%"), CompareType.LIKE));
            } else if ("205FF86A".equals(bostype)) {
                if (params.getParams().containsKey("warehousenumber") && !StringUtils.isEmpty((String)((String)params.getParams().get("warehousenumber")))) {
                    String warehousenumber = (String)params.getParams().get("warehousenumber");
                    WarehouseCollection WarehouseColl = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseCollection(" where  number='" + warehousenumber + "'");
                    if (WarehouseColl != null && WarehouseColl.size() > 0 && !WarehouseColl.get(0).isHasLocation()) {
                        return null;
                    }
                    filters.getFilterItems().add(new FilterItemInfo("Warehouse.number", (Object)warehousenumber));
                }
                filters.getFilterItems().add(new FilterItemInfo("State", (Object)"1"));
            } else if ("2407435C".equals(bostype) || "B008DCA7".equals(bostype)) {
                filters.getFilterItems().add(new FilterItemInfo("status", (Object)1));
            } else if ("00B2050E".equals(bostype)) {
                filters.getFilterItems().add(new FilterItemInfo("adminCU", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()));
                filters.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4));
            } else if ("086E983D".equals(bostype)) {
                filters.getFilterItems().add(new FilterItemInfo("adminCU", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()));
                filters.getFilterItems().add(new FilterItemInfo("status", (Object)10));
            }
            filter.mergeFilter(filters, "and");
            view.setFilter(filter);
            view.setSelector(sic);
            CoreBaseCollection value = null;
            try {
                value = iCoreBase.getCollection(view);
            }
            catch (Exception e) {
                throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
            }
            HashMap<String, Object> coreBaseMap = null;
            if (value != null && value.size() > 0) {
                for (int i = 0; value.size() > i; ++i) {
                    coreBaseMap = new HashMap<String, Object>();
                    CoreBaseInfo coreBaseInfo = value.get(i);
                    coreBaseMap.put("name", coreBaseInfo.get("name"));
                    coreBaseMap.put("id", coreBaseInfo.get("id"));
                    coreBaseMap.put("number", coreBaseInfo.get("number"));
                    baseData.add(coreBaseMap);
                }
            }
        }
        return baseData;
    }

    private EntityViewInfo createInventoryFilter(Context ctx, BarcodeMainParam params) throws BOSException, EASBizException {
        StorageOrgUnitInfo sounit;
        String sounum;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        boolean l = false;
        StringBuffer sbl = new StringBuffer();
        if (params.getParams().containsKey("mtnum") && !BarcodeUtils.isObjectEmpty(params.getParams().get("mtnum")).booleanValue()) {
            filter.getFilterItems().add(new FilterItemInfo("material.number", (Object)((String)params.getParams().get("mtnum")), CompareType.EQUALS));
        }
        if (params.getParams().containsKey("warehouse_number") && !BarcodeUtils.isObjectEmpty(params.getParams().get("warehouse_number")).booleanValue()) {
            filter.getFilterItems().add(new FilterItemInfo("warehouse.number", (Object)((String)params.getParams().get("warehouse_number")), CompareType.EQUALS));
        }
        if (params.getParams().containsKey("obscure") && !StringUtils.isEmpty((String)((String)params.getParams().get("obscure")))) {
            String likeSelect = (String)params.getParams().get("obscure");
            filter.getFilterItems().add(new FilterItemInfo("lot", (Object)("%" + likeSelect + "%"), CompareType.LIKE));
        }
        if (filter.getFilterItems().size() == 0) {
            filter.getFilterItems().add(new FilterItemInfo("material.number", (Object)"----------------", CompareType.EQUALS));
        }
        if (StringUtils.isEmpty((String)(sounum = "")) && null != (sounit = ContextUtil.getCurrentStorageUnit((Context)ctx))) {
            sounum = sounit.getNumber();
        }
        if (!StringUtils.isEmpty((String)sounum)) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.number", (Object)sounum, CompareType.EQUALS));
        }
        view.setFilter(filter);
        return view;
    }
}

