/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.barcode.pda.app.TaskAnalysis;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.CreateEasyModeEASBillUtil;
import com.kingdee.eas.barcode.pda.app.sync.SynAbsTask;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.BarcodeSubmitFacadeFactory;
import com.kingdee.eas.barcode.scm.BarcodeTaskRulesCollection;
import com.kingdee.eas.barcode.scm.BarcodeTaskRulesFactory;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.BcTaskBillEntryBarcodeEntryCollection;
import com.kingdee.eas.barcode.scm.BcTaskBillEntryCollection;
import com.kingdee.eas.barcode.scm.BcTaskBillEntryInfo;
import com.kingdee.eas.barcode.scm.BcTaskBillInfo;
import com.kingdee.eas.barcode.scm.BcTaskBillStatusEnum;
import com.kingdee.eas.barcode.scm.IBcTaskBill;
import com.kingdee.eas.barcode.scm.IReserveAreaEntry;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetCollection;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetFactory;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetInfo;
import com.kingdee.eas.barcode.scm.PDAOnlyMessageInfo;
import com.kingdee.eas.barcode.scm.ReserveAreaEntryCollection;
import com.kingdee.eas.barcode.scm.StockingStatusEnum;
import com.kingdee.eas.barcode.scm.app.BarcodeServerUtils;
import com.kingdee.eas.barcode.scm.app.MoveBillCache;
import com.kingdee.eas.barcode.scm.app.MoveBillCacheManager;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.control.ProductionOrderCollection;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class SynTaskSubmit
extends SynAbsTask
implements SyncExec {
    private static Logger logger = Logger.getLogger((String)SynTaskSubmit.class.getName());
    public static final String STOCKTRANSFERBILL_BOSTYPE = "2239F30A";
    public static final String PRODUCTIONORDER_BOSTYPE = "1F66774E";
    public static final String FINISHEDRPT_BOSTYPE = "F2901DDD";
    public static final String ManufactureRecBill_BOSTYPE = "FA1292B4";
    public static final String SALEISSUEBILL_BOSTYPE = "CC3E933B";

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        BacodeMainReturn rv;
        block6: {
            rv = new BacodeMainReturn();
            String guuid = null;
            if (params.getParams().containsKey("_guid")) {
                guuid = params.getParams().get("_guid").toString();
            }
            try {
                long time = System.currentTimeMillis();
                logger.info((Object)(" SynTaskSubmit begin\uff1a" + time));
                String sub = BarcodeServerUtils.temPCheckReaptBill(ctx, guuid);
                if (!StringUtils.isEmpty((String)sub) && "submit".equals(sub)) {
                    rv.setDupTimeErrorWithRunning();
                    rv.setMsg("\u8c03\u7528EAS\u63a5\u53e3\u5931\u8d25,\u5355\u636e\u6b63\u5728\u63d0\u4ea4\u4e2d\u3002\u3002\u3002");
                } else {
                    rv = this.createTaskSubmit(ctx, params, guuid);
                }
                time = System.currentTimeMillis() - time;
                logger.info((Object)(" SynTaskSubmit end,totalTime=\uff1a" + time));
            }
            catch (Exception e) {
                PDAOnlyMessageInfo pdaOnlyInfo;
                rv.setInnerError(e.getMessage());
                e.printStackTrace();
                logger.warn((Object)e);
                if (guuid == null) break block6;
                MoveBillCache moveBillcache = MoveBillCacheManager.getCacheInfo(guuid);
                if (moveBillcache != null && moveBillcache.getValue() != null && !(pdaOnlyInfo = (PDAOnlyMessageInfo)moveBillcache.getValue()).isIsFlag()) {
                    MoveBillCacheManager.clearOnly(guuid);
                }
                logger.info((Object)("\u5355\u636e\u751f\u6210\u5931\u8d25\uff0c\u6e05\u7a7a\u7f13\u5b58 MoveBillCacheManager \u4e2d\u7684 " + guuid));
            }
        }
        return rv;
    }

    private BacodeMainReturn createTaskSubmit(Context ctx, BarcodeMainParam params, String guuid) throws EASBizException, BOSException {
        BacodeMainReturn rv = BarcodeSubmitFacadeFactory.getLocalInstance(ctx).submitBarcodeBill(params.getParams(), this);
        return rv;
    }

    protected Object getModelIObjectValueByNumberhead(Context ctx, String number, String bostype, String warehouseNumber) throws EASBizException, BOSException {
        BOSObjectType newBostype = new BOSObjectType(bostype);
        ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)newBostype);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("name");
        sic.add("number");
        sic.add("id");
        CoreBaseInfo value = null;
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        if (!StringUtils.isEmpty((String)warehouseNumber)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("Warehouse.number", (Object)warehouseNumber));
        }
        view.setFilter(filterInfo);
        try {
            CoreBaseCollection coll = iCoreBase.getCollection(view);
            if (coll.size() > 0) {
                value = coll.get(0);
            }
        }
        catch (BOSException e) {
            throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
        }
        return value;
    }

    private void setvalue(Context ctx, TaskAnalysis taskAnalysisInfo, Map groupdatasMap, IObjectValue bcTaskBillInfo) throws EASBizException, BOSException {
        String key = "";
        if (taskAnalysisInfo.isLinkProperty()) {
            Map materialMap;
            key = taskAnalysisInfo.getName() + "_" + taskAnalysisInfo.getPropertyname();
            if (groupdatasMap.get(key) != null && "number".equals(taskAnalysisInfo.getPropertyname()) && !BarcodeUtils.isObjectEmpty((materialMap = (Map)groupdatasMap.get(key)).get("val")).booleanValue()) {
                Object value = this.getModelIObjectValueByNumberhead(ctx, (String)materialMap.get("val"), (String)materialMap.get("bostype"), "");
                bcTaskBillInfo.put(taskAnalysisInfo.getTaskname(), value);
            }
        } else {
            key = taskAnalysisInfo.getName();
            if (groupdatasMap.get(key) != null) {
                bcTaskBillInfo.put(taskAnalysisInfo.getTaskname(), StringUtils.isEmpty((String)((String)groupdatasMap.get(key))) ? null : groupdatasMap.get(key));
            }
        }
    }

    private BacodeMainReturn generateProduction(Context ctx, BacodeMainReturn rv, String productionOrder, List<BcTaskBillInfo> BcTaskBillList) throws BOSException, EASBizException {
        ProductionOrderCollection ProductionOrderColl = ProductionOrderFactory.getLocalInstance((Context)ctx).getProductionOrderCollection(" where number='" + productionOrder + "'");
        ProductionOrderInfo productionOrderInfo = ProductionOrderColl.get(0);
        if (productionOrderInfo.getBaseStatus() != BillBaseStatusEnum.RELEASED) {
            throw new EASBizException(new NumericExceptionSubItem("", "\u6d41\u7a0b\u751f\u4ea7\u8ba2\u5355\uff1a" + productionOrderInfo.getNumber() + "\u4e0d\u662f\u4e0b\u8fbe\u72b6\u6001\u4e0d\u80fd\u63d0\u4ea4\uff01"));
        }
        IndubarodeParamsetCollection paramCol = IndubarodeParamsetFactory.getLocalInstance(ctx).getIndubarodeParamsetCollection();
        IndubarodeParamsetInfo indubarodeParamsetInfo = paramCol.get(0);
        boolean isSimpleMode = indubarodeParamsetInfo.isIsSimpleMode();
        if (isSimpleMode && indubarodeParamsetInfo.getProcess() != null && indubarodeParamsetInfo.getProStorage() != null) {
            BOTMappingInfo bOTPProcess = indubarodeParamsetInfo.getProcess();
            bOTPProcess = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo((IObjectPK)new ObjectUuidPK(bOTPProcess.getId()), this.getSelectorItemCollection());
            BOTMappingInfo bOTPProStorage = indubarodeParamsetInfo.getProStorage();
            bOTPProStorage = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo((IObjectPK)new ObjectUuidPK(bOTPProStorage.getId()), this.getSelectorItemCollection());
            if (!PRODUCTIONORDER_BOSTYPE.equalsIgnoreCase(bOTPProcess.getSrcEntityName()) || !FINISHEDRPT_BOSTYPE.equalsIgnoreCase(bOTPProcess.getDestEntityName())) {
                throw new EASBizException(new NumericExceptionSubItem("", "\u6b64\u89c4\u5219\u4e0d\u7b26\u5408\u6d41\u7a0b\u751f\u6210\u8ba2\u5355-\u6d41\u7a0b\u5b8c\u5de5\u6c47\u62a5\u5355\u89c4\u5219\uff01"));
            }
            if (!FINISHEDRPT_BOSTYPE.equalsIgnoreCase(bOTPProStorage.getSrcEntityName()) || !ManufactureRecBill_BOSTYPE.equalsIgnoreCase(bOTPProStorage.getDestEntityName())) {
                throw new EASBizException(new NumericExceptionSubItem("", "\u6b64\u89c4\u5219\u4e0d\u7b26\u5408\u6d41\u7a0b\u5b8c\u5de5\u6c47\u62a5\u5355-\u751f\u4ea7\u5165\u5e93\u89c4\u5219\uff01"));
            }
        }
        String number = CreateEasyModeEASBillUtil.creatEasyModeBcTask(ctx, productionOrderInfo, BcTaskBillList.get(0), indubarodeParamsetInfo);
        rv.setCode("1");
        rv.setMsg(number + "\u63d0\u4ea4\u6210\u529f\uff01");
        return rv;
    }

    private SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection SelectorItemCollection2 = new SelectorItemCollection();
        SelectorItemCollection2.add(new SelectorItemInfo("srcEntityName"));
        SelectorItemCollection2.add(new SelectorItemInfo("destEntityName"));
        SelectorItemCollection2.add(new SelectorItemInfo("*"));
        return SelectorItemCollection2;
    }

    private IObjectPK choiceModel(Context ctx, BcTaskBillInfo bcTaskBillInfoSend, IBcTaskBill iBcTaskBill, IReserveAreaEntry iReserveAreaEntry) throws EASBizException, BOSException {
        BcTaskBillInfo BcTaskBillInfoChoice = (BcTaskBillInfo)bcTaskBillInfoSend.clone();
        this.checkOrUpdate(ctx, bcTaskBillInfoSend, iReserveAreaEntry, false);
        bcTaskBillInfoSend.setStockingStatus(StockingStatusEnum.CHECKREP);
        TransactionTypeInfo transactionTypeInfo = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeInfo(" where number='010' ");
        BizTypeInfo bizTypeInfo = BizTypeFactory.getLocalInstance((Context)ctx).getBizTypeInfo(" where number='210' ");
        bcTaskBillInfoSend.setTransactionType(transactionTypeInfo);
        bcTaskBillInfoSend.setBizType(bizTypeInfo);
        bcTaskBillInfoSend.setChoiceTask(bcTaskBillInfoSend.getId().toString());
        bcTaskBillInfoSend.setId(null);
        bcTaskBillInfoSend.setStatus(BcTaskBillStatusEnum.TAKE);
        bcTaskBillInfoSend.setTargetBosType(SALEISSUEBILL_BOSTYPE);
        bcTaskBillInfoSend.setDestNumber(null);
        bcTaskBillInfoSend.setFinqty(new BigDecimal(0));
        bcTaskBillInfoSend.setTargetBillId(null);
        BarcodeTaskRulesCollection BarcodeTaskRulesColl = BarcodeTaskRulesFactory.getLocalInstance(ctx).getBarcodeTaskRulesCollection(" where  srcBosType='" + bcTaskBillInfoSend.getSrcBosType() + "'  and  desBosType='" + SALEISSUEBILL_BOSTYPE + "' ");
        if (BarcodeTaskRulesColl == null || BarcodeTaskRulesColl.size() <= 0) {
            throw new EASBizException(new NumericExceptionSubItem("", "\u53d1\u8d27\u4efb\u52a1\u5355\u636e\u8f6c\u6362\u89c4\u5219\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4efb\u52a1\u751f\u6210\u5355\u636e\u89c4\u5219\uff01"));
        }
        bcTaskBillInfoSend.setBotp(BarcodeTaskRulesColl.get(0).getDocumentRules());
        this.checkOrUpdate(ctx, bcTaskBillInfoSend, iReserveAreaEntry, true);
        bcTaskBillInfoSend.setNumber("FH-" + bcTaskBillInfoSend.getSrcNumber() + this.getTime());
        if (bcTaskBillInfoSend.getEntrys().size() > 0) {
            for (int i = 0; i < bcTaskBillInfoSend.getEntrys().size(); ++i) {
                bcTaskBillInfoSend.getEntrys().get(i).setId(null);
                if (bcTaskBillInfoSend.getEntrys().get(i).getBarcodeEntrys().size() <= 0) continue;
                for (int y = 0; y < bcTaskBillInfoSend.getEntrys().get(i).getBarcodeEntrys().size(); ++y) {
                    bcTaskBillInfoSend.getEntrys().get(i).getBarcodeEntrys().get(y).setId(null);
                }
            }
        }
        IObjectPK pk = iBcTaskBill.save((CoreBaseInfo)bcTaskBillInfoSend);
        BcTaskBillInfoChoice.setChoiceTask(pk.toString());
        iBcTaskBill.save((CoreBaseInfo)BcTaskBillInfoChoice);
        return pk;
    }

    private void checkOrUpdate(Context ctx, BcTaskBillInfo bcTaskBillInfoSend, IReserveAreaEntry iReserveAreaEntry, boolean isCheckOrUpdate) throws EASBizException, BOSException {
        BcTaskBillEntryCollection bcTaskBillEntryColl = bcTaskBillInfoSend.getEntrys();
        if (bcTaskBillEntryColl != null && bcTaskBillEntryColl.size() > 0) {
            boolean isTwoSelect = true;
            FilterInfo filterInfo = new FilterInfo();
            for (int i = 0; bcTaskBillEntryColl.size() > i; ++i) {
                ReserveAreaEntryCollection reserveAreaEntryColl;
                BcTaskBillEntryInfo bcTaskBillEntryInfo = bcTaskBillEntryColl.get(i);
                WarehouseInfo warehouseInfo = bcTaskBillEntryInfo.getWarehouse();
                LocationInfo locationInfo = bcTaskBillEntryInfo.getLocation();
                filterInfo = new FilterInfo();
                if (warehouseInfo != null && locationInfo != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("storageUnit.id", (Object)bcTaskBillInfoSend.getOrg().getId().toString()));
                    filterInfo.getFilterItems().add(new FilterItemInfo("warehouse.id", (Object)warehouseInfo.getId().toString()));
                    filterInfo.getFilterItems().add(new FilterItemInfo("location.id", (Object)locationInfo.getId().toString()));
                    if (iReserveAreaEntry.exists(filterInfo)) {
                        if (!isCheckOrUpdate) continue;
                        reserveAreaEntryColl = iReserveAreaEntry.getReserveAreaEntryCollection(" where storageUnit.id='" + bcTaskBillInfoSend.getOrg().getId().toString() + "' and warehouse.id='" + warehouseInfo.getId().toString() + "' and location.id='" + locationInfo.getId().toString() + "'");
                        bcTaskBillEntryInfo.setWarehouse(reserveAreaEntryColl.get(0).getReserveWarehs());
                        bcTaskBillEntryInfo.setLocation(null);
                        isTwoSelect = false;
                    }
                }
                if (!isTwoSelect) continue;
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("storageUnit.id", (Object)bcTaskBillInfoSend.getOrg().getId().toString()));
                filterInfo.getFilterItems().add(new FilterItemInfo("warehouse.id", (Object)warehouseInfo.getId().toString()));
                if (iReserveAreaEntry.exists(filterInfo)) {
                    if (!isCheckOrUpdate) continue;
                    reserveAreaEntryColl = iReserveAreaEntry.getReserveAreaEntryCollection(" where storageUnit.id='" + bcTaskBillInfoSend.getOrg().getId().toString() + "' and warehouse.id='" + warehouseInfo.getId().toString() + "'");
                    bcTaskBillEntryInfo.setWarehouse(reserveAreaEntryColl.get(0).getReserveWarehs());
                    bcTaskBillEntryInfo.setLocation(null);
                    continue;
                }
                throw new EASBizException(new NumericExceptionSubItem("", "\u5f53\u524d\u4ed3\u5e93\uff1a" + warehouseInfo.getName() + " \u4e0d\u5728\u5907\u8d27\u533a\u57df\u5185\uff01\uff01\uff01"));
            }
        }
    }

    private BigDecimal isDeductionBarcode(BcTaskBillEntryCollection bcTaskBillEntryColl, List barcodedatas, boolean bool) {
        BigDecimal smqty = new BigDecimal("0");
        int n = bcTaskBillEntryColl.size();
        for (int y = 0; y < n; ++y) {
            if (bcTaskBillEntryColl.get(y) == null) continue;
            BcTaskBillEntryInfo bcTaskBillEntryInfoSend = bcTaskBillEntryColl.get(y);
            BigDecimal qty = new BigDecimal("0");
            BcTaskBillEntryBarcodeEntryCollection bcTaskBillEntryBarcodeEntryColl = bcTaskBillEntryInfoSend.getBarcodeEntrys();
            int p = bcTaskBillEntryBarcodeEntryColl.size();
            for (int t = 0; t < p; ++t) {
                if (bcTaskBillEntryBarcodeEntryColl.get(t) == null) continue;
                boolean isRemove = true;
                if (barcodedatas != null && barcodedatas.size() > 0) {
                    int m = barcodedatas.size();
                    for (int b = 0; m > b; ++b) {
                        JSONObject barcodedatasMap = JSONObject.fromObject(barcodedatas.get(b));
                        if (BarcodeUtils.isObjectEmpty(barcodedatasMap.get("barcode")).booleanValue()) continue;
                        if (bool) {
                            if (!barcodedatasMap.get("barcode").toString().equals(bcTaskBillEntryBarcodeEntryColl.get(t).getBarcode())) continue;
                            BigDecimal subtractQty = new BigDecimal(barcodedatasMap.get("qty").toString());
                            bcTaskBillEntryBarcodeEntryColl.get(t).setQty(bcTaskBillEntryBarcodeEntryColl.get(t).getQty().subtract(subtractQty));
                            qty = qty.add(subtractQty);
                            bcTaskBillEntryInfoSend.setQty(bcTaskBillEntryInfoSend.getQty().subtract(subtractQty));
                            continue;
                        }
                        if (!barcodedatasMap.get("barcode").toString().equals(bcTaskBillEntryBarcodeEntryColl.get(t).getBarcode())) continue;
                        qty = qty.add(new BigDecimal(barcodedatasMap.get("qty").toString()));
                        isRemove = false;
                        break;
                    }
                }
                if (!bool && isRemove) {
                    bcTaskBillEntryBarcodeEntryColl.remove(bcTaskBillEntryBarcodeEntryColl.get(t));
                    --t;
                    if (bcTaskBillEntryBarcodeEntryColl.size() == 0) {
                        bcTaskBillEntryColl.remove(bcTaskBillEntryInfoSend);
                        --y;
                    }
                }
                if (!bool || bcTaskBillEntryBarcodeEntryColl.get(t).getQty().compareTo(BigDecimal.ZERO) != 0) continue;
                bcTaskBillEntryBarcodeEntryColl.remove(bcTaskBillEntryBarcodeEntryColl.get(t));
                --t;
                if (bcTaskBillEntryBarcodeEntryColl.size() != 0) continue;
                bcTaskBillEntryColl.remove(bcTaskBillEntryInfoSend);
                --y;
            }
            if (bcTaskBillEntryInfoSend == null) continue;
            if (bool) {
                bcTaskBillEntryInfoSend.setQty(bcTaskBillEntryInfoSend.getQty().subtract(qty));
                smqty = smqty.add(bcTaskBillEntryInfoSend.getQty());
                continue;
            }
            if (!bcTaskBillEntryColl.contains(bcTaskBillEntryInfoSend)) continue;
            bcTaskBillEntryInfoSend.setQty(qty);
            smqty = smqty.add(bcTaskBillEntryInfoSend.getQty());
        }
        return smqty;
    }
}

