/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterCollection;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterEntryCollection;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterEntryInfo;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterInfo;
import com.kingdee.eas.barcode.scm.util.UWDateHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SyncBarCodeMasterExec
implements SyncExec {
    private static Logger logger = Logger.getLogger((String)SyncBarCodeMasterExec.class.getName());

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        Object revlist = null;
        BacodeMainReturn rv = new BacodeMainReturn();
        String newReqTime = UWDateHelper.FORMAT_TIME.format(new Date());
        try {
            revlist = this.getBarcodeMaster(ctx, params);
            rv.setDefSucc(newReqTime);
            rv.setInfo(revlist);
        }
        catch (Exception e) {
            rv.setInnerError(e.getMessage());
            logger.warn((Object)e);
        }
        return rv;
    }

    private Object getBarcodeMaster(Context ctx, BarcodeMainParam params) throws BOSException {
        IndBarcodeMasterCollection coll = IndBarcodeMasterFactory.getLocalInstance(ctx).getIndBarcodeMasterCollection();
        IndBarcodeMasterInfo info = null;
        ArrayList allIndMater = new ArrayList();
        IndBarcodeMasterEntryCollection entrys = null;
        IndBarcodeMasterEntryInfo entry = null;
        int count = coll.size();
        for (int i = 0; i < count; ++i) {
            info = coll.get(i);
            HashMap<String, Object> indRow = new HashMap<String, Object>();
            indRow.put("number", info.getRuleNumber());
            indRow.put("name", info.getRuleName());
            indRow.put("status", "" + info.getStatus().getValue());
            indRow.put("comment", info.getComment());
            ArrayList<Map> items = new ArrayList<Map>();
            entrys = info.getEntry();
            int entrysize = entrys.size();
            for (int j = 0; j < entrysize; ++j) {
                entry = entrys.get(j);
                items.add(this.createMasterRow(entry));
            }
            indRow.put("items", items);
            allIndMater.add(indRow);
        }
        return allIndMater;
    }

    private Map createMasterRow(IndBarcodeMasterEntryInfo entry) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("index", entry.getSeq());
        row.put("name", entry.getName());
        row.put("type", entry.getType().getValue());
        row.put("length", entry.getLength());
        row.put("ischek", entry.isIsCheck());
        row.put("ishide", entry.isIsHide());
        row.put("dcode", entry.isDCode());
        row.put("tp_filed", entry.isTpField());
        row.put("tdpt", (Object)entry.getTdPt());
        return row;
    }
}

