/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.scm.BarcodeDossierTemplateCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierTemplateEntryCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierTemplateEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodeDossierTemplateFactory;
import com.kingdee.eas.barcode.scm.BarcodeDossierTemplateInfo;
import com.kingdee.eas.barcode.scm.util.UWDateHelper;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SyncDossierTemplateExec
implements SyncExec {
    private static Logger logger = Logger.getLogger((String)SyncDossierTemplateExec.class.getName());

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        String newReqTime = UWDateHelper.FORMAT_TIME.format(new Date());
        BacodeMainReturn rv = new BacodeMainReturn();
        try {
            Object tempInfo = this.getDossierTemplate(ctx, params);
            rv.setDefSucc(newReqTime);
            rv.setInfo(tempInfo);
        }
        catch (ParseException e) {
            logger.warn((Object)e);
            rv.setParamsError();
        }
        catch (Exception e) {
            logger.warn((Object)e);
            rv.setInnerError(e.getMessage());
        }
        return rv;
    }

    private Object getDossierTemplate(Context ctx, BarcodeMainParam params) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("codeinfo");
        sic.add("codemd5");
        sic.add("barRule.ruleNumber");
        sic.add("entrys.seq");
        sic.add("entrys.name");
        sic.add("entrys.value");
        sic.add("entrys.displayName.name");
        view.setSelector(sic);
        String rows = (String)params.getParams().get("rows");
        String lastupdatetime = (String)params.getParams().get("lastupdatetime");
        String minnumber = (String)params.getParams().get("number");
        if (!StringUtils.isEmpty((String)lastupdatetime)) {
            filter.getFilterItems().add(new FilterItemInfo("lastupdatetime", (Object)UWDateHelper.tryParseDateStr(lastupdatetime), CompareType.GREATER));
        }
        if (!StringUtils.isEmpty((String)minnumber)) {
            filter.getFilterItems().add(new FilterItemInfo("codemd5", (Object)minnumber, CompareType.GREATER));
        } else {
            logger.warn((Object)"no param number");
        }
        view.setTopCount(rows == null ? 100 : Integer.valueOf(rows));
        view.getSorter().add(new SorterItemInfo("codemd5"));
        BarcodeDossierTemplateCollection coll = BarcodeDossierTemplateFactory.getLocalInstance(ctx).getBarcodeDossierTemplateCollection(view);
        BarcodeDossierTemplateInfo info = null;
        ArrayList allDosTemplate = new ArrayList();
        BarcodeDossierTemplateEntryCollection entrys = null;
        BarcodeDossierTemplateEntryInfo entry = null;
        String maxmd5 = null;
        int count = coll.size();
        for (int i = 0; i < count; ++i) {
            info = coll.get(i);
            maxmd5 = info.getCodemd5();
            HashMap<String, Object> indRow = new HashMap<String, Object>();
            indRow.put("code_info", "" + info.getCodeinfo());
            indRow.put("code_md5", maxmd5);
            indRow.put("barcodemaster", info.getBarRule().getRuleNumber());
            ArrayList<Map> items = new ArrayList<Map>();
            entrys = info.getEntrys();
            int entrysize = entrys.size();
            for (int j = 0; j < entrysize; ++j) {
                entry = entrys.get(j);
                items.add(this.createDosTempRow(entry));
            }
            indRow.put("items", items);
            allDosTemplate.add(indRow);
        }
        HashMap<String, Object> revMap = new HashMap<String, Object>();
        revMap.put("_maxnum", maxmd5);
        revMap.put("_info", allDosTemplate);
        return revMap;
    }

    private Map createDosTempRow(BarcodeDossierTemplateEntryInfo entry) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("index", entry.getSeq());
        row.put("name", entry.getName());
        row.put("value", entry.getValue());
        row.put("display_name_id", entry.getDisplayName().getName());
        return row;
    }
}

