/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.barcode.pda.BarcodeLicenseUtils;
import com.kingdee.eas.barcode.pda.app.biz.CreactNewFaStockTakeRecExec;
import com.kingdee.eas.barcode.pda.app.biz.FaRepairAddExec;
import com.kingdee.eas.barcode.pda.app.biz.FaScrappedAddExec;
import com.kingdee.eas.barcode.pda.app.biz.FaStockAddExec;
import com.kingdee.eas.barcode.pda.app.sync.BASSyncExecFactory;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.CheckSyncExecFactory;
import com.kingdee.eas.barcode.pda.app.sync.FASyncExecFactory;
import com.kingdee.eas.barcode.pda.app.sync.QueryDossierExec;
import com.kingdee.eas.barcode.pda.app.sync.SCMSyncExecFactory;
import com.kingdee.eas.barcode.pda.app.sync.SynCheckHead;
import com.kingdee.eas.barcode.pda.app.sync.SynCheckList;
import com.kingdee.eas.barcode.pda.app.sync.SynNewEquipment;
import com.kingdee.eas.barcode.pda.app.sync.SynPdaMenuExec;
import com.kingdee.eas.barcode.pda.app.sync.SynTaskCreatebillExec;
import com.kingdee.eas.barcode.pda.app.sync.SyncAnalyticdossierExec;
import com.kingdee.eas.barcode.pda.app.sync.SyncBarCodeMasterExec;
import com.kingdee.eas.barcode.pda.app.sync.SyncBarcodeRuleExec;
import com.kingdee.eas.barcode.pda.app.sync.SyncCreateNewTaskExec;
import com.kingdee.eas.barcode.pda.app.sync.SyncDossierExec;
import com.kingdee.eas.barcode.pda.app.sync.SyncDossierTemplateExec;
import com.kingdee.eas.barcode.pda.app.sync.SyncDownEasDbExec;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.barcode.pda.app.sync.SyncExecAbsFactory;
import com.kingdee.eas.barcode.pda.app.sync.SyncGetCurrUserOrgsExec;
import com.kingdee.eas.barcode.pda.app.sync.SyncNoExec;
import com.kingdee.eas.barcode.pda.app.sync.SyncOfflineDataExec;
import com.kingdee.eas.barcode.pda.app.sync.SyncQueryIndHisExec;
import com.kingdee.eas.barcode.pda.app.sync.SyncQueryInventoryExec;
import com.kingdee.eas.barcode.pda.app.sync.SyncScanTaskBillExec;
import com.kingdee.eas.barcode.pda.app.sync.SyncSelectOrg4UserExec;
import com.kingdee.eas.barcode.pda.app.sync.SyncUserExec;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetInfo;
import com.kingdee.eas.barcode.scm.app.BarcodeServerUtils;
import com.kingdee.eas.barcode.scm.util.BarcodeClientUtils;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.agent.LicenseSrvAgent;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.license.server.LicenseMemoryPool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;

public class SyncExecUtil {
    public static SyncExecAbsFactory getSyncExecFactory(String type) {
        ArrayList<SyncExecAbsFactory> factoryList = new ArrayList<SyncExecAbsFactory>();
        factoryList.add(BASSyncExecFactory.getInstance());
        factoryList.add(CheckSyncExecFactory.getInstance());
        factoryList.add(FASyncExecFactory.getInstance());
        factoryList.add(SCMSyncExecFactory.getInstance());
        for (SyncExecAbsFactory fact : factoryList) {
            SyncExec exec = fact.getSyncExec(type);
            if (exec == null) continue;
            return fact;
        }
        return null;
    }

    public static BacodeMainReturn checkFALicense(Context ctx, BarcodeMainParam params) {
        try {
            IndubarodeParamsetInfo indubarodeParamsetInfo = BarcodeClientUtils.getParamValue(ctx);
            int days = indubarodeParamsetInfo.getDays();
            if (days == -99) {
                return null;
            }
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        String uiClssName = "com.kingdee.eas.barcode.scm.client.BarcodePDAViewConfigListUI";
        LicenseUserInfo user = BarcodeLicenseUtils.createLicenseUserInfo(ctx);
        BacodeMainReturn rv = new BacodeMainReturn();
        try {
            int licenselcFlag = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).requestLicenseByUserAndSubSystem(user, "PRO_BOSRUNTIME");
            System.out.println(licenselcFlag + "---------------------\u56fa\u5b9a\u8d44\u4ea7license \u68c0\u67e5-----------------");
            switch (licenselcFlag) {
                case 4: {
                    rv.setCode("-10");
                    rv.setMsg(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_Invalid"));
                    return rv;
                }
                case 2: {
                    rv.setCode("-10");
                    rv.setMsg(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_NO_SURPLUS"));
                    return rv;
                }
            }
        }
        catch (LicenseException e) {
            rv.setCode("-10");
            rv.setMsg(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_NO_SURPLUS"));
        }
        return null;
    }

    public static BacodeMainReturn checkSCMLicense(Context ctx, BarcodeMainParam params) {
        try {
            IndubarodeParamsetInfo indubarodeParamsetInfo = BarcodeClientUtils.getParamValue(ctx);
            int days = indubarodeParamsetInfo.getDays();
            if (days == -99) {
                return null;
            }
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        String uiClssName = "com.kingdee.eas.barcode.scm.client.BarcodePDAViewConfigListUI";
        LicenseMemoryPool.getInstance().getSubSystemNameByModule("");
        LicenseUserInfo user = BarcodeLicenseUtils.createLicenseUserInfo(ctx);
        BacodeMainReturn rv = new BacodeMainReturn();
        try {
            LicenseSrvAgent iILicenseSrvAgent = new LicenseSrvAgent();
            int licenselcFlag = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).requestLicenseByUserAndSubSystem(user, "BARCODE_PDA");
            System.out.println(licenselcFlag + "------------SCM license--------------------------");
            switch (licenselcFlag) {
                case 4: {
                    rv.setCode("-10");
                    rv.setMsg(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_Invalid"));
                    return rv;
                }
                case 2: {
                    rv.setCode("-10");
                    rv.setMsg(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_NO_SURPLUS"));
                    return rv;
                }
            }
        }
        catch (LicenseException e) {
            rv.setCode("-10");
            rv.setMsg(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_NO_SURPLUS"));
        }
        return null;
    }

    public static BacodeMainReturn guidCheck(Context ctx, BarcodeMainParam params) {
        String guuid = params.getGuid();
        if (params.getParams().containsKey("_guid")) {
            guuid = params.getParams().get("_guid").toString();
        }
        if (!StringUtils.isEmpty((String)params.getGuid())) {
            BacodeMainReturn rv;
            block7: {
                rv = new BacodeMainReturn();
                try {
                    String billNumber = BarcodeServerUtils.checkReaptBill(ctx, guuid);
                    if (billNumber != null && !"submit".equals(billNumber)) {
                        rv.setDupTimeError();
                        rv.setMsg("\u8c03\u7528EAS\u63a5\u53e3\u5931\u8d25,\u5df2\u7ecf\u751f\u6210\u5355\u636e\u3010" + billNumber + "\u3011,\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\u3002");
                        break block7;
                    }
                    if (billNumber != null && "submit".equals(billNumber)) {
                        rv.setDupTimeErrorWithRunning();
                        rv.setMsg("\u8c03\u7528EAS\u63a5\u53e3\u5931\u8d25,\u5355\u636e\u6b63\u5728\u63d0\u4ea4\u4e2d\u3002\u3002\u3002");
                        break block7;
                    }
                    return null;
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    rv.setInnerError("GUID \u68c0\u67e5\u51fa\u9519:" + e.getMessage());
                }
                catch (BOSException e) {
                    e.printStackTrace();
                    rv.setInnerError("GUID \u68c0\u67e5\u51fa\u9519:" + e.getMessage());
                }
            }
            return rv;
        }
        return null;
    }

    private static SyncExec getSyncExec(String type) {
        if ("getUnSync_User".equalsIgnoreCase(type)) {
            return new SyncUserExec();
        }
        if ("get_unsync_barcode_master".equalsIgnoreCase(type)) {
            return new SyncBarCodeMasterExec();
        }
        if ("getUnSync_dossier_template".equalsIgnoreCase(type)) {
            return new SyncDossierTemplateExec();
        }
        if ("getUnSync_dossier".equalsIgnoreCase(type)) {
            return new SyncDossierExec();
        }
        if ("queryBarcodeHistory".equalsIgnoreCase(type)) {
            return new SyncQueryIndHisExec();
        }
        if ("queryInvetory".equalsIgnoreCase(type)) {
            return new SyncQueryInventoryExec();
        }
        if ("query_dossier".equalsIgnoreCase(type)) {
            return new QueryDossierExec();
        }
        if ("add_fastock".equalsIgnoreCase(type)) {
            return new FaStockAddExec();
        }
        if ("add_farepair".equalsIgnoreCase(type)) {
            return new FaRepairAddExec();
        }
        if ("add_fascrapped".equalsIgnoreCase(type)) {
            return new FaScrappedAddExec();
        }
        if ("get_tasklist".equalsIgnoreCase(type)) {
            return new SyncScanTaskBillExec();
        }
        if ("get_AnalyticRule".equalsIgnoreCase(type)) {
            return new SyncBarcodeRuleExec();
        }
        if ("getA_analyticdossier".equalsIgnoreCase(type)) {
            return new SyncAnalyticdossierExec();
        }
        if ("task_createbill".equalsIgnoreCase(type)) {
            return new SynTaskCreatebillExec();
        }
        if ("create_task_by_source".equalsIgnoreCase(type)) {
            return new SyncCreateNewTaskExec();
        }
        if ("get_user_orgrange".equalsIgnoreCase(type)) {
            return new SyncGetCurrUserOrgsExec();
        }
        if ("select_org_4_user".equalsIgnoreCase(type)) {
            return new SyncSelectOrg4UserExec();
        }
        if ("select_SynCheck_head".equalsIgnoreCase(type)) {
            return new SynCheckHead();
        }
        if ("select_SynCheck_List".equalsIgnoreCase(type)) {
            return new SynCheckList();
        }
        if ("get_pda_menu".equalsIgnoreCase(type)) {
            return new SynPdaMenuExec();
        }
        if ("get_OfflineData".equalsIgnoreCase(type)) {
            return new SyncOfflineDataExec();
        }
        if ("add_faStockTakeRec".equalsIgnoreCase(type)) {
            return new CreactNewFaStockTakeRecExec();
        }
        if ("down_easdb".equalsIgnoreCase(type)) {
            return new SyncDownEasDbExec();
        }
        if ("new_equipment".equalsIgnoreCase(type)) {
            return new SynNewEquipment();
        }
        return new SyncNoExec();
    }
}

