/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.app.sync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.barcode.pda.app.sync.BacodeMainReturn;
import com.kingdee.eas.barcode.pda.app.sync.BarcodeMainParam;
import com.kingdee.eas.barcode.pda.app.sync.SyncExec;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SyncSelectOrg4UserExec
implements SyncExec {
    private static Logger logger = Logger.getLogger((String)SyncSelectOrg4UserExec.class.getName());

    @Override
    public BacodeMainReturn execute(Context ctx, BarcodeMainParam params) {
        BacodeMainReturn rv = new BacodeMainReturn();
        try {
            Map<String, String> revMap = this.selectOrg(ctx, params);
            if (revMap != null) {
                rv.setDefSucc();
                rv.setInfo(revMap);
            } else {
                rv.setParamsError2();
            }
        }
        catch (Exception e) {
            rv.setInnerError(e.getMessage());
            logger.warn((Object)e);
        }
        return rv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, String> selectOrg(Context ctx, BarcodeMainParam params) throws BOSException, EASBizException, SQLException {
        String orgid = (String)params.getParams().get("orgid");
        HashMap<String, String> revMap = new HashMap<String, String>();
        if (orgid == null) {
            UserInfo us = ContextUtil.getCurrentUserInfo((Context)ctx);
            if (us == null || us.getDefOrgUnit() == null) return null;
            orgid = us.getDefOrgUnit().getId().toString();
            revMap.put("id", orgid);
            revMap.put("name", us.getDefOrgUnit().getName());
            CtrlUnitInfo ctrlUnitInfo = this.getGroupUnit(ctx);
            revMap.put("groupname", ctrlUnitInfo.getName());
            revMap.put("groupnumber", ctrlUnitInfo.getNumber());
            revMap.put("groupid", ctrlUnitInfo.getId().toString());
        } else {
            FullOrgUnitInfo org = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
            if (org == null) {
                return null;
            }
            revMap.put("id", orgid);
            revMap.put("name", org.getName());
        }
        OrgSwitchFacadeFactory.getLocalInstance((Context)ctx).orgSwitch(orgid);
        return revMap;
    }

    private CtrlUnitInfo getGroupUnit(Context ctx) throws EASBizException, BOSException {
        CtrlUnitInfo ctrlUnitInfo = null;
        if (ContextUtil.getCurrentCtrlUnit((Context)ctx).isIsLeaf()) {
            if (ContextUtil.getCurrentCtrlUnit((Context)ctx).getParent() != null && ContextUtil.getCurrentCtrlUnit((Context)ctx).getParent().getId() != null) {
                String ctrlUnitid = ContextUtil.getCurrentCtrlUnit((Context)ctx).getParent().getId().toString();
                ctrlUnitInfo = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectStringPK(ctrlUnitid));
            }
        } else {
            return ContextUtil.getCurrentCtrlUnit((Context)ctx);
        }
        return ctrlUnitInfo;
    }
}

