/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.encoding;

import com.kingdee.eas.barcode.pda.encoding.Base64;
import com.kingdee.eas.barcode.pda.encoding.Hex;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public abstract class Encoding {
    public static final Encoding HEX = new Hex();
    public static final Encoding BASE64 = new Base64();
    private static final char[] digitals = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public final String encode(String s) {
        byte[] tmp = Encoding.stringToUtf8(s);
        byte[] encoded = this.encode(tmp);
        return Encoding.utf8ToString(encoded);
    }

    public static byte[] stringToUtf8(String s) {
        try {
            if (s == null) {
                s = "";
            }
            return s.getBytes("UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("Encoding.stringToUtf8() failed!", e);
        }
    }

    public static String utf8ToString(byte[] utf8) {
        try {
            return new String(utf8, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("Encoding.utf8ToString() failed!", e);
        }
    }

    public static StringBuilder xmlEncode(String s) {
        return Encoding.xmlEncode(s, new StringBuilder());
    }

    public static StringBuilder xmlEncode(String s, StringBuilder sb) {
        if (s == null) {
            return sb;
        }
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\'': {
                    sb.append("&#39;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&#34;");
                    continue block7;
                }
                case '<': {
                    sb.append("&#60;");
                    continue block7;
                }
                case '>': {
                    sb.append("&#62;");
                    continue block7;
                }
                case '&': {
                    sb.append("&#38;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb;
    }

    public final String decode(String s) {
        byte[] tmp = Encoding.stringToUtf8(s);
        byte[] decoded = this.decode(tmp);
        return Encoding.utf8ToString(decoded);
    }

    public abstract byte[] encode(byte[] var1);

    public abstract byte[] decode(byte[] var1);

    public static boolean isQName(String s) {
        if (s.length() == 0) {
            return false;
        }
        char c = s.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            c = s.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_') continue;
            return false;
        }
        return true;
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return "";
        }
        byte[] bytes = Encoding.toBytes(obj);
        return new String(HEX.encode(bytes));
    }

    public static Object fromBytes(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        try {
            ObjectInputStream ois = new ObjectInputStream(bis);
            return ois.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toBytes(Object o) {
        if (o == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.flush();
            oos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    public static Object fromString(String e) {
        if (e == null || e.length() == 0) {
            return null;
        }
        byte[] bytes = HEX.decode(e.getBytes());
        return Encoding.fromBytes(bytes);
    }

    public static String int2hex(int i) {
        StringBuilder sb = new StringBuilder();
        while (i != 0) {
            int j = i & 0xF;
            sb.append(digitals[j]);
            i >>>= 4;
        }
        return sb.toString();
    }

    public static String encodeHTML(String s) {
        StringBuilder html = new StringBuilder(s.length() + 64);
        block11: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    html.append("&lt;");
                    continue block11;
                }
                case '>': {
                    html.append("&gt;");
                    continue block11;
                }
                case '\'': {
                    html.append("&apos;");
                    continue block11;
                }
                case '\"': {
                    html.append("&quot;");
                    continue block11;
                }
                case '&': {
                    html.append("&amp;");
                    continue block11;
                }
                case '\r': {
                    continue block11;
                }
                case '\n': {
                    html.append("<br>");
                    continue block11;
                }
                case ' ': {
                    html.append("&nbsp;");
                    continue block11;
                }
                case '\t': {
                    html.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                    continue block11;
                }
                default: {
                    html.append(c);
                }
            }
        }
        return html.toString();
    }
}

