/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.encoding;

public class TEA {
    private static char[] B64 = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_', '-'};
    private static int[] SN = new int[256];

    private static String base64Encode(String s) {
        StringBuilder sb = new StringBuilder();
        int c = 0;
        int r = 0;
        int j = s.length();
        for (int i = 0; i < j; ++i) {
            c = (c << 16) + s.charAt(i);
            r += 16;
            while (r >= 6) {
                sb.append(B64[c >> r - 6 & 0x3F]);
                r -= 6;
            }
        }
        if (r > 0) {
            sb.append(B64[c << 6 - r & 0x3F]);
        }
        return sb.toString();
    }

    private static String base64Decode(String s) {
        StringBuilder sb = new StringBuilder();
        int c = 0;
        int r = 0;
        int j = s.length();
        for (int i = 0; i < j; ++i) {
            c = (c << 6) + SN[s.charAt(i)];
            r += 6;
            while (r >= 16) {
                sb.append((char)(c >> r - 16));
                r -= 16;
            }
        }
        return sb.toString();
    }

    private static int[] stringToIntegers(String s) {
        int[] l = new int[(int)Math.ceil((double)s.length() / 2.0)];
        int j = s.length();
        for (int i = 0; i < l.length; ++i) {
            l[i] = s.charAt(i + i);
            if (i + i + 1 >= j) continue;
            int n = i;
            l[n] = l[n] + (s.charAt(i + i + 1) << 16);
        }
        return l;
    }

    private static String integersToString(int[] l) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < l.length; ++i) {
            sb.append((char)l[i]);
            sb.append((char)(l[i] >> 16));
        }
        return sb.toString();
    }

    public static String TEAencrypt(String plaintext, String password) {
        int[] v = TEA.stringToIntegers(plaintext);
        int[] k = TEA.stringToIntegers(password);
        int n = v.length;
        int z = v[n - 1];
        int y = v[0];
        int delta = -1640531527;
        int sum = 0;
        for (int q = (int)Math.floor(6 + 52 / n); q > 0; --q) {
            int mx;
            int e = (sum += delta) >>> 2 & 3;
            int p = 0;
            while (p < n - 1) {
                y = v[p + 1];
                mx = (z >>> 5 ^ y << 2) + (y >>> 3 ^ z << 4 ^ (sum ^ y)) + (k[p & 3 ^ e] ^ z);
                int n2 = p++;
                int n3 = v[n2] + mx;
                v[n2] = n3;
                z = n3;
            }
            y = v[0];
            mx = (z >>> 5 ^ y << 2) + (y >>> 3 ^ z << 4 ^ (sum ^ y)) + (k[p & 3 ^ e] ^ z);
            int n4 = n - 1;
            v[n4] = v[n4] + mx;
            z = v[n - 1];
        }
        return TEA.base64Encode(TEA.integersToString(v));
    }

    public static String TEAdecrypt(String ciphertext, String password) {
        int[] v = TEA.stringToIntegers(TEA.base64Decode(ciphertext));
        int[] k = TEA.stringToIntegers(password);
        int n = v.length;
        int z = v[n - 1];
        int y = v[0];
        int delta = -1640531527;
        int q = (int)Math.floor(6 + 52 / n);
        for (int sum = q * delta; sum != 0; sum -= delta) {
            int mx;
            int e = sum >>> 2 & 3;
            int p = n - 1;
            while (p > 0) {
                z = v[p - 1];
                mx = (z >>> 5 ^ y << 2) + (y >>> 3 ^ z << 4 ^ (sum ^ y)) + (k[p & 3 ^ e] ^ z);
                int n2 = p--;
                int n3 = v[n2] - mx;
                v[n2] = n3;
                y = n3;
            }
            z = v[n - 1];
            mx = (z >>> 5 ^ y << 2) + (y >>> 3 ^ z << 4 ^ (sum ^ y)) + (k[p & 3 ^ e] ^ z);
            y = v[0] = v[0] - mx;
        }
        return TEA.integersToString(v);
    }

    public static void main(String[] args) {
        String e = TEA.TEAencrypt("Hello, TEA!", "Hello,TEA!");
        String d = TEA.TEAdecrypt(e, "Hello,TEA!");
        System.out.println("e=" + e + "\nd=" + d);
    }

    static {
        for (int i = 0; i < B64.length; ++i) {
            TEA.SN[TEA.B64[i]] = i;
        }
    }
}

