/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.barcode.scm.BarcodeConfigCollection;
import com.kingdee.eas.barcode.scm.BarcodeConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeDefaultSolutionInfo;
import com.kingdee.eas.barcode.scm.BarcodePDAMainMenuXmlFactory;
import com.kingdee.eas.barcode.scm.BarcodePDAMainMenuXmlInfo;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigEntryCollection;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetCollection;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetFactory;
import com.kingdee.eas.barcode.scm.client.BarcodePDAViewConfigListUI;
import com.kingdee.eas.barcode.scm.util.PropertiesUtil;
import com.kingdee.eas.portal.web.util.Md5Util;
import com.kingdee.eas.util.client.EASResource;
import java.util.ArrayList;

public class BarcodePDAConfigXmlUntil {
    private static final String XMLHEADER = "<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?>";
    private static final String XMLATTR = "\" TextColor=\"White\" TextFont=\"Arial, 12pt, style=Bold\" TextX=\"60\" TextY=\"15\"";
    private static final String XMLOTHER = " EventString=\"UWBC.UWMakerCE|UWBC.UWMakerCE.Maker|FromShowDialog|";

    public static String getPdaMainMenuXml() throws BOSException {
        int i;
        StringBuffer xmlStr = new StringBuffer();
        IndubarodeParamsetCollection indParamCol = IndubarodeParamsetFactory.getRemoteInstance().getIndubarodeParamsetCollection();
        String size = "240,320";
        if (indParamCol != null && indParamCol.size() > 0 && indParamCol.get(0) != null && indParamCol.get(0).getPdaViewSize() != null) {
            String sizeNum = indParamCol.get(0).getPdaViewSize().getValue();
            sizeNum = "1".equals(sizeNum) ? "320,320" : size;
        }
        xmlStr.append(XMLHEADER);
        xmlStr.append("<UWRoot><MenuInfo Size=\"" + size + "\">");
        xmlStr.append("<StockScan Name=\"StockScan\" Text=\"" + EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)"washRoom") + XMLATTR + ">");
        BarcodeConfigCollection col = BarcodePDAViewConfigListUI.getBarcodeConfigCollectionIsPda();
        ArrayList<EntityObjectInfo> bosTypes = new ArrayList<EntityObjectInfo>();
        if (col != null && col.size() > 0) {
            for (i = 0; i < col.size(); ++i) {
                BarcodeConfigInfo binfo = col.get(i);
                String desBosType = binfo.getDestBosType();
                EntityObjectInfo entry = BarcodeUtils.getEntityByBosType(desBosType);
                if (bosTypes.indexOf(entry) != -1) continue;
                bosTypes.add(entry);
            }
        }
        for (i = 0; i < bosTypes.size(); ++i) {
            EntityObjectInfo ei = (EntityObjectInfo)bosTypes.get(i);
            String bosString = ei.getType().toString();
            String alice = ei.getAlias();
            xmlStr.append("<B").append(bosString).append(" Name=\"B" + bosString).append("\"").append(" Text=\"" + alice).append(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)"scan")).append(XMLATTR).append(">");
            for (int j = 0; j < col.size(); ++j) {
                BarcodeConfigInfo binfo = col.get(j);
                String bosString2 = binfo.getDestBosType();
                String name = binfo.getName();
                String scanCode = binfo.getNumber();
                if (!bosString2.equals(bosString)) continue;
                xmlStr.append("<F").append(scanCode).append(" Name=\"F" + scanCode).append("\"").append(" Text=\"" + name).append(XMLATTR).append(XMLOTHER).append(scanCode).append(".xml\" />");
            }
            xmlStr.append("</B").append(bosString).append(">");
        }
        xmlStr.append("</StockScan></MenuInfo></UWRoot>");
        return xmlStr.toString();
    }

    public static String getPdaMenuItemXml(BarcodePDAViewConfigInfo bPdaInfo, String cacheXml) throws BOSException {
        StringBuffer xmlStr = new StringBuffer();
        IndubarodeParamsetCollection indParamCol = IndubarodeParamsetFactory.getRemoteInstance().getIndubarodeParamsetCollection();
        BarcodePDAViewConfigEntryCollection bcoll = bPdaInfo.getEntitys();
        String scanTypeName = bPdaInfo.getScanConfig().getName();
        String configId = bPdaInfo.getScanConfig().getId().toString();
        String sizeNum = "";
        if (indParamCol != null && indParamCol.size() > 0 && indParamCol.get(0) != null && indParamCol.get(0).getPdaViewSize() != null) {
            sizeNum = indParamCol.get(0).getPdaViewSize().getValue();
        }
        boolean viewSize = !sizeNum.equals("1");
        String defaulSolutionId = "";
        BarcodeDefaultSolutionInfo bbdsi = bPdaInfo.getDefualtSolution();
        if (bbdsi != null) {
            defaulSolutionId = bbdsi.getId().toString();
        }
        if (bcoll == null || bcoll.size() <= 0) {
            return null;
        }
        String eventStringBtn = BarcodePDAConfigXmlUntil.getEventStringBtn();
        xmlStr.append(XMLHEADER);
        xmlStr.append("<UWUI>");
        xmlStr.append("<Form>").append("<EventStringBtnOK Value=\"").append(eventStringBtn).append("|btnOK_Click\"/>").append("<EventStringBtnList Value=\"").append(eventStringBtn).append("|btnList_Click\"/>").append("<EventStringBtnReturn Value=\"").append(eventStringBtn).append("|btnReturn_Click\"/>").append("<lblTitleString Value=\"").append(scanTypeName).append("\"/>").append("<Tag Value=\"" + configId + "\" />").append("<defaultSolution Value=\"" + defaulSolutionId + "\" />").append("<offline Value=\"" + bPdaInfo.isOffline() + "\" />").append("<isCheckMode Value=\"" + bPdaInfo.getScanConfig().isVerifyMode() + "\" />").append("<isCompleteCheck Value=\"" + bPdaInfo.getScanConfig().isCompleteCheck() + "\" />").append("<isMatchBill Value=\"" + bPdaInfo.getScanConfig().isIsMatchBill() + "\" />").append("<isWholeScan Value=\"" + bPdaInfo.getScanConfig().isIsWholeScan() + "\" />").append("</Form>");
        xmlStr.append("<Controls>");
        int len = bcoll.size();
        bcoll = BarcodePDAConfigXmlUntil.sortTable(bcoll);
        int m = 0;
        for (int i = 0; i < len; ++i) {
            BarcodePDAViewConfigEntryInfo binfo = bcoll.get(i);
            Boolean colView = binfo.isIsView();
            Boolean colListView = binfo.isIsListView();
            String colCode = binfo.getColumnCode();
            String pdaName = binfo.getPdaTitle();
            String conType = binfo.getConsleType().getValue();
            String proEvent = binfo.getProEventStr();
            String specialCol = binfo.getSpecialColStr() == null ? "" : binfo.getSpecialColStr();
            String entryName = binfo.getEntryName() == null || "".equals(binfo.getEntryName()) ? "" : binfo.getEntryName() + "_";
            int entryNum = binfo.getEntryType();
            Boolean enable = binfo.isIsEdit();
            Boolean setDefaultVal = binfo.isIsSetDefault();
            String bosTypeStr = binfo.getBosTypeStr() == null ? "" : binfo.getBosTypeStr();
            String parentBosTypeStr = binfo.getParentBosTypeStr();
            if (colView.booleanValue()) {
                String size = viewSize ? "240,50" : "320,50";
                String location = "0," + m * 50;
                xmlStr.append("<Control Type=\"UWBC.UW").append(conType).append("CE.dll\" TypeName=\"").append(conType).append("\">");
                xmlStr.append("<Name Type=\"String\" Value=\"").append(colCode).append("\"/>");
                xmlStr.append("<Entry Type=\"int\" Value=\"").append(entryNum).append("\"/>");
                xmlStr.append("<SpecilCol Type=\"string\" Value=\"").append(specialCol).append("\"/>");
                xmlStr.append("<Caption Type=\"String\" Value=\"").append(pdaName).append("\"/>");
                xmlStr.append("<KeyPressCommand Type=\"String\" Value=\"").append(eventStringBtn).append("|" + proEvent + "\"/>");
                xmlStr.append("<Size Type=\"Size\" Value=\"").append(size).append("\"/>");
                xmlStr.append("<Location Type=\"Point\" Value=\"").append(location).append("\"/>");
                xmlStr.append("<Visible Type=\"bool\" Value=\"").append(colView).append("\"/>");
                xmlStr.append("<ListVisible Type=\"bool\" Value=\"").append(colListView).append("\"/>");
                xmlStr.append("<Enabled Type=\"bool\" Value=\"" + enable + "\"/>");
                xmlStr.append("<SetDefaultVal Type=\"bool\" Value=\"" + setDefaultVal + "\"/>");
                xmlStr.append("<TabIndex Type=\"int\" Value=\"" + i + "\"/>");
                xmlStr.append("<bosType Type=\"string\" Value=\"" + entryName + bosTypeStr + "\"/>");
                xmlStr.append("<parentBosType Type=\"string\" Value=\"" + parentBosTypeStr + "\"/>");
                xmlStr.append("<fieldName Type=\"string\" Value=\"" + binfo.getFiledName() + "\"/>");
                xmlStr.append("<tableName Type=\"string\" Value=\"" + binfo.getTableName() + "\"/>");
                xmlStr.append("<linktableName Type=\"string\" Value=\"" + binfo.getLinkTableName() + "\"/>");
                xmlStr.append("<fullName Type=\"string\" Value=\"" + binfo.getFullName() + "\"/>");
                xmlStr.append("</Control>");
                ++m;
                continue;
            }
            xmlStr.append("<Control Type=\"UWBC.UW").append(conType).append("CE.dll\" TypeName=\"").append(conType).append("\">");
            xmlStr.append("<Name Type=\"String\" Value=\"").append(colCode).append("\"/>");
            xmlStr.append("<Entry Type=\"int\" Value=\"").append(entryNum).append("\"/>");
            xmlStr.append("<SpecilCol Type=\"string\" Value=\"").append(specialCol).append("\"/>");
            xmlStr.append("<Caption Type=\"String\" Value=\"").append(pdaName).append("\"/>");
            xmlStr.append("<KeyPressCommand Type=\"String\" Value=\"").append(eventStringBtn).append("|" + proEvent + "\"/>");
            xmlStr.append("<Visible Type=\"bool\" Value=\"").append(colView).append("\"/>");
            xmlStr.append("<ListVisible Type=\"bool\" Value=\"").append(colListView).append("\"/>");
            xmlStr.append("<Enabled Type=\"bool\" Value=\"" + enable + "\"/>");
            xmlStr.append("<SetDefaultVal Type=\"bool\" Value=\"" + setDefaultVal + "\"/>");
            xmlStr.append("<TabIndex Type=\"int\" Value=\"" + i + "\"/>");
            xmlStr.append("<bosType Type=\"string\" Value=\"" + entryName + bosTypeStr + "\"/>");
            xmlStr.append("<parentBosType Type=\"string\" Value=\"" + parentBosTypeStr + "\"/>");
            xmlStr.append("<fieldName Type=\"string\" Value=\"" + binfo.getFiledName() + "\"/>");
            xmlStr.append("<tableName Type=\"string\" Value=\"" + binfo.getTableName() + "\"/>");
            xmlStr.append("<linktableName Type=\"string\" Value=\"" + binfo.getLinkTableName() + "\"/>");
            xmlStr.append("<fullName Type=\"string\" Value=\"" + binfo.getFullName() + "\"/>");
            xmlStr.append("</Control>");
        }
        xmlStr.append(cacheXml);
        xmlStr.append("</Controls>");
        xmlStr.append("</UWUI>");
        return xmlStr.toString();
    }

    public static BarcodePDAViewConfigEntryCollection sortTable(BarcodePDAViewConfigEntryCollection bcoll) {
        int len = bcoll.size();
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < len; ++j) {
                BarcodePDAViewConfigEntryInfo binfo = bcoll.get(i);
                if (i >= j) continue;
                Integer bi = binfo.getScanSeq();
                BarcodePDAViewConfigEntryInfo b = bcoll.get(j);
                Integer ai = bcoll.get(j).getScanSeq();
                if (bi - ai <= 0) continue;
                bcoll.changeIndex(j, i);
            }
        }
        return bcoll;
    }

    public static boolean isInt(String s) {
        if (s == null) {
            return false;
        }
        try {
            Integer.parseInt(s);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void genPdaMainMenuByBarcodeConfig() throws BOSException {
        BarcodePDAMainMenuXmlInfo bmminfo = new BarcodePDAMainMenuXmlInfo();
        String mainXml = BarcodePDAConfigXmlUntil.getPdaMainMenuXml();
        String md5Code = Md5Util.encode((String)mainXml);
        bmminfo.setMainMenuXml(mainXml);
        bmminfo.setMd5Vlaue(md5Code);
        IObjectPK[] a = BarcodePDAMainMenuXmlFactory.getRemoteInstance().getPKList();
        BarcodePDAMainMenuXmlFactory.getRemoteInstance().delete(a);
        IObjectPK i = BarcodePDAMainMenuXmlFactory.getRemoteInstance().addnew(bmminfo);
    }

    public static String getSpecialColXml(BarcodePDAViewConfigEntryCollection cachCol) {
        if (cachCol == null || cachCol.size() < 1) {
            return "";
        }
        StringBuffer xmlStr = new StringBuffer();
        for (int i = 0; i < cachCol.size(); ++i) {
            BarcodePDAViewConfigEntryInfo be = cachCol.get(i);
            String colCode = be.getColumnCode();
            String pdaName = be.getPdaTitle();
            String conType = be.getConsleType().getValue();
            String proEvent = be.getProEventStr();
            String specialCol = be.getSpecialColStr() == null ? "" : be.getSpecialColStr();
            int entryNum = be.getEntryType();
            String bosTypeStr = be.getBosTypeStr() == null ? "" : be.getBosTypeStr();
            String parentBosTypeStr = be.getParentBosTypeStr();
            String eventStringBtn = BarcodePDAConfigXmlUntil.getEventStringBtn();
            xmlStr.append("<Control Type=\"UWBC.UW").append(conType).append("CE.dll\" TypeName=\"").append(conType).append("\">");
            xmlStr.append("<Name Type=\"String\" Value=\"").append(colCode).append("\"/>");
            xmlStr.append("<Entry Type=\"int\" Value=\"").append(entryNum).append("\"/>");
            xmlStr.append("<SpecilCol Type=\"string\" Value=\"").append(specialCol).append("\"/>");
            xmlStr.append("<Caption Type=\"String\" Value=\"").append(pdaName).append("\"/>");
            xmlStr.append("<KeyPressCommand Type=\"String\" Value=\"").append(eventStringBtn).append("|" + proEvent + "\"/>");
            xmlStr.append("<Visible Type=\"bool\" Value=\"false\"/>");
            xmlStr.append("<Enabled Type=\"bool\" Value=\"false\"/>");
            xmlStr.append("<bosType Type=\"string\" Value=\"" + bosTypeStr + "\"/>");
            xmlStr.append("<parentBosType Type=\"string\" Value=\"" + parentBosTypeStr + "\"/>");
            xmlStr.append("</Control>");
        }
        return xmlStr.toString();
    }

    private static String getEventStringBtn() {
        String enventsName = PropertiesUtil.readPropertiesFile();
        String eventStringBtn = "UWBCAssemblies.EASActions.Actions|UWBCAssemblies.EASActions.Actions." + enventsName;
        return eventStringBtn;
    }
}

