/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm;

import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import java.util.HashMap;
import java.util.Map;

public class BarcodePrintBillTypeUtil {
    private static Map<String, BOSObjectType> btypes = new HashMap<String, BOSObjectType>();
    private static Map<String, BOSObjectType> etypes = new HashMap<String, BOSObjectType>();

    public static BOSObjectType getBillBosType(int billType) {
        BOSObjectType bosType = btypes.get(billType + "");
        if (bosType != null) {
            return bosType;
        }
        if (billType == 0) {
            bosType = new PurOrderInfo().getBOSType();
        } else if (billType == 1) {
            bosType = new PurInWarehsBillInfo().getBOSType();
        } else if (billType == 2) {
            bosType = new MaterialRequestBillInfo().getBOSType();
        } else if (billType == 3) {
            bosType = new MaterialReqBillInfo().getBOSType();
        } else if (billType == 4) {
            bosType = new StockTransferBillInfo().getBOSType();
        } else if (billType == 5) {
            bosType = new SaleIssueBillInfo().getBOSType();
        }
        btypes.put(billType + "", bosType);
        return bosType;
    }

    public static BOSObjectType getBillEntryBosType(int billType) {
        BOSObjectType bosType = etypes.get(billType + "");
        if (bosType != null) {
            return bosType;
        }
        if (billType == 0) {
            bosType = new PurOrderEntryInfo().getBOSType();
        } else if (billType == 1) {
            bosType = new PurInWarehsEntryInfo().getBOSType();
        } else if (billType == 2) {
            bosType = new MaterialRequestBillEntryInfo().getBOSType();
        } else if (billType == 3) {
            bosType = new MaterialReqBillEntryInfo().getBOSType();
        } else if (billType == 4) {
            bosType = new StockTransferBillEntryInfo().getBOSType();
        } else if (billType == 5) {
            bosType = new SaleIssueEntryInfo().getBOSType();
        }
        etypes.put(billType + "", bosType);
        return bosType;
    }
}

