/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLProperty;
import com.kingdee.eas.barcode.scm.util.Json;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BarcodeUtils {
    public static IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(null);
    public static final String QRCODE_VERSION = "1.2";
    public static final String QRCODE_VERSION_NAME = "vs";
    public static final String QRCODE_DICT_ID = "8r0AAAAMlqhYhbIe";
    public static final String PROPERTY_FULLNAME_KEY = "fullName";
    public static final String PROPERTY_SEQNO_KEY = "sequenceNumber";
    public static final String PROPERTY_FULLALIAS_KEY = "fullAlias";
    public static final String PROPERTY_LINKEDBOSTYPE = "linkedBosType";
    public static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat SIMPLE_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final String COUNTINGTABLE_BOSTYPE = "D9D2CA5D";
    public static Map entityMap = new HashMap();

    public static EntityObjectInfo getEntityByBosType(String bosType) {
        if (entityMap.get(bosType) != null) {
            return (EntityObjectInfo)entityMap.get(bosType);
        }
        EntityObjectInfo entity = loader.getEntity(BOSObjectType.create((String)bosType));
        if (entity != null) {
            entityMap.put(bosType, entity);
            return entity;
        }
        return null;
    }

    public static String toJson(Context ctx, Object obj) {
        try {
            if (ctx == null) {
                ctx = ContextUtils.getContextFromSession();
            }
            return JSONUtils.convertObjectToJson((Context)ctx, (Object)obj);
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, EntityObjectInfo> getEntryName(EntityObjectInfo entity) {
        HashMap<String, EntityObjectInfo> map = new HashMap<String, EntityObjectInfo>();
        PropertyCollection headProColl = entity.getProperties();
        for (PropertyInfo property : headProColl) {
            RelationshipInfo relation;
            if (!(property instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)property).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries"))) continue;
            if (relation.getClientObject().getFullName().equals(entity.getFullName()) && (relation.getSupplierCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                map.put(property.getName(), relation.getSupplierObject());
                continue;
            }
            if (!relation.getSupplierObject().getFullName().equals(entity.getFullName()) || relation.getClientCardinality() != CardinalityType.ONE_TO_UNBOUNDED && relation.getClientCardinality() != CardinalityType.ZERO_TO_UNBOUNDED) continue;
            map.put(property.getName(), relation.getClientObject());
        }
        return map;
    }

    public static boolean isEntryProperty(EntityObjectInfo parent, PropertyInfo property) {
        RelationshipInfo relation;
        return !(parent == null || property == null || !(property instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)property).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries")) || !relation.getClientObject().getFullName().equals(parent.getFullName()) || relation.getSupplierCardinality() != CardinalityType.ONE_TO_UNBOUNDED && relation.getSupplierCardinality() != CardinalityType.ZERO_TO_UNBOUNDED);
    }

    public static EntityObjectInfo getEntityByProperty(EntityObjectInfo parent, PropertyInfo property) {
        RelationshipInfo relation;
        EntityObjectInfo result = null;
        if (parent != null && property != null && property instanceof LinkPropertyInfo && ((relation = ((LinkPropertyInfo)property).getRelationship()).getType() == RelationshipType.COMPOSITION || Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries"))) && relation.getClientObject().getFullName().equals(parent.getFullName()) && (relation.getSupplierCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
            return relation.getSupplierObject();
        }
        return result;
    }

    public static PropertyInfo getSeqNoPropertyInfo() {
        PropertyInfo seqProperty = new PropertyInfo();
        seqProperty.setName(PROPERTY_SEQNO_KEY);
        seqProperty.setAlias(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"81_BarcodeUtils"));
        seqProperty.put("dataType", (Object)"String");
        return seqProperty;
    }

    public static PropertyInfo getPropertyByMuch(String property, EntityObjectInfo entity) {
        if (entity == null) {
            return null;
        }
        if (property.equals(PROPERTY_SEQNO_KEY)) {
            return BarcodeUtils.getSeqNoPropertyInfo();
        }
        PropertyInfo propertyInfo = entity.getPropertyByName(property);
        if (property.indexOf(".") > -1) {
            String[] ss = property.split("\\.");
            propertyInfo = entity.getPropertyByName(ss[0]);
            EntityObjectInfo entry = BarcodeUtils.getEntityByProperty(entity, propertyInfo);
            property = property.substring(property.indexOf(".") + 1, property.length());
            return BarcodeUtils.getPropertyByMuch(property, entry);
        }
        return (PropertyInfo)propertyInfo.clone();
    }

    public static Object getEnum(List emList, String value) {
        for (int i = 0; i < emList.size(); ++i) {
            com.kingdee.util.enums.Enum e = (com.kingdee.util.enums.Enum)emList.get(i);
            String compare1 = e.getName();
            String compare2 = e.getAlias();
            String compare3 = null;
            if (e instanceof IntEnum) {
                compare3 = ((IntEnum)e).getValue() + "";
            }
            if (value == null || !value.equals(compare1) && !value.equals(compare2) && !value.equals(compare3)) continue;
            return emList.get(i);
        }
        return null;
    }

    public static Object getValue(IObjectValue easValue, PropertyInfo propertyInfo, String key) {
        String dataType = propertyInfo.getString("dataType");
        Object value = easValue.get(key);
        if (value != null) {
            if (propertyInfo instanceof LinkPropertyInfo) {
                return easValue.get("number");
            }
            if ("Enum".equals(dataType)) {
                return ((com.kingdee.util.enums.Enum)value).getName();
            }
            if ("Boolean".equals(dataType)) {
                return value;
            }
            if ("Date".equals(dataType) || "TimeStamp".equals(dataType)) {
                String date = null;
                try {
                    date = SIMPLE_DATE_FORMAT.format(value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return date;
            }
            if ("BigDeciaml".equals(dataType)) {
                return new BigDecimal(value.toString());
            }
            if ("Integer".equals(dataType)) {
                return Integer.parseInt(value.toString());
            }
            return value;
        }
        return null;
    }

    public static Object getValue(IObjectValue easValue, BarcodeConfigXMLProperty property, String key) {
        String dataType = property.getDataType();
        Object value = easValue.get(key);
        if (value != null) {
            if (property.isLinkedProperty()) {
                return easValue.get("number");
            }
            if ("Enum".equals(dataType)) {
                return ((com.kingdee.util.enums.Enum)value).getName();
            }
            if ("Boolean".equals(dataType)) {
                return value;
            }
            if ("Date".equals(dataType) || "TimeStamp".equals(dataType)) {
                String date = null;
                try {
                    date = SIMPLE_DATE_FORMAT.format(value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return date;
            }
            if ("BigDeciaml".equals(dataType)) {
                return new BigDecimal(value.toString());
            }
            if ("Integer".equals(dataType)) {
                return Integer.parseInt(value.toString());
            }
            return value;
        }
        return null;
    }

    public static void putValue(IObjectValue easValue, PropertyInfo propertyInfo, String key, Object value) {
        String dataType = propertyInfo.getString("dataType");
        if (value == null) {
            easValue.put(key, null);
        } else if ("Enum".equals(dataType)) {
            if (value instanceof Enum) {
                easValue.put(key, value);
            } else {
                String enumClass = (String)propertyInfo.get("metadataRef");
                if (enumClass != null) {
                    List emList = EnumUtils.getEnumList((String)enumClass);
                    easValue.put(key, BarcodeUtils.getEnum(emList, value.toString()));
                }
            }
        } else if ("Boolean".equals(dataType)) {
            if (value instanceof Boolean) {
                easValue.put(key, value);
            } else if ("1".equals(value.toString()) || "true".equalsIgnoreCase(value.toString()) || EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"82_BarcodeUtils").equals(value.toString())) {
                easValue.put(key, (Object)Boolean.TRUE);
            } else {
                easValue.put(key, (Object)Boolean.FALSE);
            }
        } else if ("Date".equals(dataType) || "TimeStamp".equals(dataType)) {
            if (value instanceof Date) {
                easValue.put(key, value);
            } else {
                try {
                    Date date = SIMPLE_DATE_FORMAT.parse(value.toString());
                    easValue.put(key, (Object)date);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        } else if ("BigDecimal".equals(dataType)) {
            if (value instanceof BigDecimal) {
                easValue.put(key, value);
            } else {
                try {
                    easValue.put(key, (Object)new BigDecimal(value.toString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if ("Integer".equals(dataType)) {
            if (value instanceof Integer) {
                easValue.put(key, value);
            } else {
                try {
                    easValue.put(key, (Object)Integer.parseInt(value.toString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            easValue.put(key, value);
        }
    }

    public static String unicodeEncode(String str) {
        str = str == null ? "" : str;
        StringBuffer sb = new StringBuffer(1000);
        sb.setLength(0);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            sb.append("\\u");
            int j = c >>> 8;
            String tmp = Integer.toHexString(j);
            if (tmp.length() == 1) {
                sb.append("0");
            }
            sb.append(tmp);
            j = c & 0xFF;
            tmp = Integer.toHexString(j);
            if (tmp.length() == 1) {
                sb.append("0");
            }
            sb.append(tmp);
        }
        return new String(sb);
    }

    public static String unicodeDecode(String strText) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < strText.length()) {
            char c = strText.charAt(i);
            if (c == '\\' && i + 1 != strText.length() && strText.charAt(i + 1) == 'u') {
                sb.append((char)Integer.parseInt(strText.substring(i + 2, i + 6), 16));
                i += 6;
                continue;
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static Map<String, String> getInitQrCodeMap() {
        LinkedHashMap<String, String> revMap = new LinkedHashMap<String, String>();
        revMap.put(QRCODE_VERSION_NAME, QRCODE_VERSION);
        return revMap;
    }

    public static String getQrCodeVersionPreStr() {
        return "vs:1.2";
    }

    public static String getQrCode(String sourceQrCode, String barcode) throws UnsupportedEncodingException {
        return BarcodeUtils.getQrCode(true, sourceQrCode, barcode);
    }

    public static String getQrCode(boolean isTDPrint, String sourceQrCode, String barcode) throws UnsupportedEncodingException {
        int prelen = BarcodeUtils.getQrCodeVersionPreStr().length();
        if (sourceQrCode.length() > 0) {
            return "";
        }
        String preVersion = sourceQrCode.substring(0, prelen);
        String sourceVersion = preVersion.split(":")[1];
        sourceVersion = "1.3";
        if (sourceVersion.equals(QRCODE_VERSION)) {
            sourceQrCode = Base64.encodeString((String)BarcodeUtils.joinBarcode2Qr(barcode, sourceQrCode.substring(prelen)));
        } else if (sourceVersion.equals("1.3")) {
            if (isTDPrint) {
                sourceQrCode = new String(BarcodeUtils.joinBarcode2Qr(barcode, sourceQrCode.substring(prelen)).getBytes("UTF-8"), "ISO-8859-1");
            } else {
                sourceQrCode = sourceQrCode.substring(prelen);
                sourceQrCode = BarcodeUtils.joinBarcode2Qr(barcode, sourceQrCode);
            }
        }
        String s = new String(("vs:" + sourceVersion + "" + sourceQrCode).getBytes(), "GB2312");
        s = "vs:" + sourceVersion + "" + sourceQrCode;
        System.out.println(s + "");
        return s;
    }

    private static String joinBarcode2Qr(String barcode, String qrcodeStr) {
        if (!qrcodeStr.startsWith("{")) {
            qrcodeStr = "{" + qrcodeStr + "}";
        }
        Map objMap = (Map)Json.toObject(qrcodeStr);
        objMap.put("number", barcode);
        return Json.toString(objMap, true);
    }

    public static Object getModelIObjectValueByIdhead(Context ctx, String id, String model) throws BOSException, EASBizException {
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)id, (boolean)true);
        SelectorItemCollection sic = new SelectorItemCollection();
        ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
        sic.add("name");
        sic.add("number");
        sic.add("id");
        if (!StringUtils.isEmpty((String)model)) {
            sic.add(model);
        }
        CoreBaseInfo value = null;
        try {
            if (iCoreBase.exists((IObjectPK)new ObjectUuidPK(id))) {
                value = iCoreBase.getValue((IObjectPK)new ObjectUuidPK(id), sic);
            }
        }
        catch (EASBizException e) {
            throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
        }
        return value;
    }

    public static Boolean isObjectEmpty(Object obj) {
        String str = "";
        if (obj != null && obj.toString() == null) {
            return false;
        }
        str = obj == null ? "" : obj.toString();
        return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)str);
    }
}

