/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.barcode.scm.BarcodeException;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;

public class DataBasePermissionUtil {
    public static void chekcPermission(Context ctx, IObjectPK orgPK, String permItemName) throws EASBizException, BOSException {
        IPermission iPer = null;
        IPermItem iPerItem = null;
        IFullOrgUnit iFullOrgUnit = null;
        if (ctx == null) {
            iPer = PermissionFactory.getRemoteInstance();
            iPerItem = PermItemFactory.getRemoteInstance();
            iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        } else {
            iPer = PermissionFactory.getLocalInstance((Context)ctx);
            iPerItem = PermItemFactory.getLocalInstance((Context)ctx);
            iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        }
        String userId = DataBasePermissionUtil.getUserId(ctx);
        ObjectUuidPK userPK = new ObjectUuidPK(userId);
        boolean hasPermission = iPer.hasFunctionPermission((IObjectPK)userPK, orgPK, permItemName);
        if (!hasPermission) {
            PermItemInfo permItemInfo = iPerItem.getPermItemInfo("where number = '" + permItemName + "'");
            FullOrgUnitInfo fullOrgUnitInfo = iFullOrgUnit.getFullOrgUnitInfo(orgPK);
            Object[] object = new Object[]{fullOrgUnitInfo.getName(), permItemInfo.getAlias()};
            throw new PermissionException(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION, object);
        }
    }

    private static String getUserId(Context ctx) {
        if (ctx == null) {
            return SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        }
        return ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
    }

    public static void checkDataCu(Context ctx, IObjectPK orgPK) throws BarcodeException {
        String currCuId = DataBasePermissionUtil.getCurrCuId(ctx);
        if (!currCuId.equals(orgPK.toString())) {
            throw new BarcodeException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"203_DataBasePermissionUtil")));
        }
    }

    private static String getCurrCuId(Context ctx) {
        if (ctx == null) {
            return SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        }
        return ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
    }
}

