/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.barcode.scm.BarcodeConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeConfigXML;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLDetail;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLProperty;
import com.kingdee.eas.barcode.scm.BarcodeXMLHelper;
import com.kingdee.eas.barcode.scm.DataBasePermissionUtil;
import com.kingdee.eas.barcode.scm.ScanTaskBillFactory;
import com.kingdee.eas.barcode.scm.app.AbstractBarcodeConfigControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BarcodeConfigControllerBean
extends AbstractBarcodeConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.barcode.app.BarcodeConfigControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.verify(model, ctx);
        IObjectPK pk = super._submit(ctx, model);
        BarcodeConfigXML xmlInfo = BarcodeXMLHelper.toBarcodeConfigXML(model.getString("detailsXML"));
        try {
            this.updataDataBaseTable(ctx, xmlInfo);
            this.updataScanTaskBaseTable(ctx, xmlInfo);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return pk;
    }

    private void updataDataBaseTable(Context ctx, BarcodeConfigXML xmlInfo) throws BOSException, SQLException {
        for (int i = 0; i < xmlInfo.getDetails().size(); ++i) {
            this.updateDetailTable(ctx, xmlInfo.getDetails().get(i));
        }
        this.createSequenceNoTableSql(ctx, xmlInfo);
        this.createBarcodeTableSql(ctx, xmlInfo);
    }

    private void updataScanTaskBaseTable(Context ctx, BarcodeConfigXML xmlInfo) throws BOSException, SQLException {
        for (int i = 0; i < xmlInfo.getDetails().size(); ++i) {
            this.updateSTDetailTable(ctx, xmlInfo.getDetails().get(i));
        }
        this.createSTSequenceNoTableSql(ctx, xmlInfo);
        this.createSTBarcodeTableSql(ctx, xmlInfo);
    }

    private void updateDetailTable(Context ctx, BarcodeConfigXMLDetail detail) throws BOSException, SQLException {
        String bosType = detail.getBosType();
        String tableName = "T_BC_" + bosType;
        boolean isExists = this.isExistsTable(ctx, tableName);
        Map<String, String> fields = null;
        fields = this.getConfigDetailFieldsNoDupl(ctx, detail, isExists);
        if (fields.size() == 0) {
            return;
        }
        this.updateTableColums(ctx, tableName, isExists, fields);
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"4_BarcodeConfigControllerBean", (Locale)ctx.getLocale()) + tableName + "#"));
    }

    private void updateSTDetailTable(Context ctx, BarcodeConfigXMLDetail detail) throws BOSException, SQLException {
        String bosType = detail.getBosType();
        String tableName = "T_ST_" + bosType;
        boolean isExists = this.isExistsTable(ctx, tableName);
        Map<String, String> fields = null;
        fields = this.getSTConfigDetailFieldsNoDupl(ctx, detail, isExists);
        if (fields.size() == 0) {
            return;
        }
        this.updateTableColums(ctx, tableName, isExists, fields);
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"4_BarcodeConfigControllerBean", (Locale)ctx.getLocale()) + tableName + "#"));
    }

    private Map<String, String> getCommonFields() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("FID", "VARCHAR(44)");
        result.put("FPARENTID", "VARCHAR(44)");
        result.put("FBOSTYPE", "VARCHAR(44)");
        result.put("FPARENTBOSTYPE", "VARCHAR(44)");
        result.put("FENTITYNAME", "NVARCHAR(80)");
        result.put("FENTITYALIAS", "NVARCHAR(80)");
        result.put("FSRCBILLID", "VARCHAR(44)");
        result.put("FSRCENTRYID", "VARCHAR(44)");
        result.put("FSRCQTY", "NUMERIC(28,14)");
        result.put("FDIFQTY", "NUMERIC(28,14)");
        result.put("FDIFSPLITQTY", "NUMERIC(28,14)");
        result.put("FSPLITQTY", "NUMERIC(28,14)");
        result.put("FSPLITTEDQTY", "NUMERIC(28,14)");
        result.put("FDESTBILLID", "VARCHAR(44)");
        result.put("FSCANNINGID", "VARCHAR(44)");
        result.put("FEASID", "VARCHAR(44)");
        result.put("FEASBILLNUMBER", "NVARCHAR(255)");
        result.put("FSEQ", "int");
        result.put("FISUPLOAD", "int default 0");
        result.put("FSRCSCANENTRYID", "VARCHAR(44)");
        return result;
    }

    private Map<String, String> getBarcodeFields() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("FBarcodeScanningID".toUpperCase(), "VARCHAR(44)");
        result.put("FParentID".toUpperCase(), "VARCHAR(44)");
        result.put("FParentBosType".toUpperCase(), "VARCHAR(20)");
        result.put("FBarcode".toUpperCase(), " NVARCHAR(255)");
        result.put("FBarcodeRuleId".toUpperCase(), "VARCHAR(44)");
        return result;
    }

    private Map<String, String> getSTConfigDetailFieldsNoDupl(Context ctx, BarcodeConfigXMLDetail detail, boolean isTableExists) throws BOSException, SQLException {
        HashSet<String> existSet = new HashSet<String>();
        if (isTableExists) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT KSQL_COL_NAME FROM KSQL_USERCOLUMNS WHERE KSQL_TABNAME='T_ST_" + detail.getBosType() + "'"));
            while (rs.next()) {
                existSet.add(rs.getString("KSQL_COL_NAME").toUpperCase());
            }
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.putAll(this.getCommonFields());
        map.keySet().removeAll(existSet);
        for (int i = 0; i < detail.getProperties().size(); ++i) {
            String name;
            BarcodeConfigXMLProperty property = detail.getProperties().get(i);
            if (property.isLinkedProperty()) {
                name = property.getName().toUpperCase() + "_NUMBER";
                if (!existSet.contains(name)) {
                    map.put(name, "NVARCHAR(255)");
                }
                if (existSet.contains(name = property.getName().toUpperCase() + "_NAME")) continue;
                map.put(name, "NVARCHAR(255)");
                continue;
            }
            name = property.getName().toUpperCase();
            if (existSet.contains(name)) continue;
            String dataType = property.getDataType();
            if (dataType != null && property.getDataType().equals("BigDecimal")) {
                map.put(name, "NUMERIC(28,14)");
                continue;
            }
            if (dataType != null && property.getDataType().equals("TimeStamp")) {
                map.put(name, "DateTime");
                continue;
            }
            if (dataType != null && property.getDataType().equals("Date")) {
                map.put(name, "DateTime");
                continue;
            }
            map.put(name, "NVARCHAR(255)");
        }
        return map;
    }

    private Map<String, String> getConfigDetailFieldsNoDupl(Context ctx, BarcodeConfigXMLDetail detail, boolean isTableExists) throws BOSException, SQLException {
        HashSet<String> existSet = new HashSet<String>();
        if (isTableExists) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT KSQL_COL_NAME FROM KSQL_USERCOLUMNS WHERE KSQL_TABNAME='T_BC_" + detail.getBosType() + "'"));
            while (rs.next()) {
                existSet.add(rs.getString("KSQL_COL_NAME").toUpperCase());
            }
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.putAll(this.getCommonFields());
        map.keySet().removeAll(existSet);
        for (int i = 0; i < detail.getProperties().size(); ++i) {
            String name;
            BarcodeConfigXMLProperty property = detail.getProperties().get(i);
            if (property.isLinkedProperty()) {
                name = property.getName().toUpperCase() + "_NUMBER";
                if (!existSet.contains(name)) {
                    map.put(name, "NVARCHAR(255)");
                }
                if (existSet.contains(name = property.getName().toUpperCase() + "_NAME")) continue;
                map.put(name, "NVARCHAR(255)");
                continue;
            }
            name = property.getName().toUpperCase();
            if (existSet.contains(name)) continue;
            String dataType = property.getDataType();
            if (dataType != null && property.getDataType().equals("BigDecimal")) {
                map.put(name, "NUMERIC(28,14)");
                continue;
            }
            if (dataType != null && property.getDataType().equals("TimeStamp")) {
                map.put(name, "DateTime");
                continue;
            }
            if (dataType != null && property.getDataType().equals("Date")) {
                map.put(name, "DateTime");
                continue;
            }
            map.put(name, "NVARCHAR(255)");
        }
        return map;
    }

    private void createSequenceNoTableSql(Context ctx, BarcodeConfigXML xmlInfo) throws BOSException, SQLException {
        String tableName = "T_BC_" + xmlInfo.getDestBosType() + "_SEQNO";
        if (this.isExistsTable(ctx, tableName)) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE TABLE " + tableName + " (");
        sb.append("FBarcodeScanningID VARCHAR(44),FParentID VARCHAR(44),FParentBosType VARCHAR(20),FSequenceNo NVARCHAR(80)");
        sb.append(")");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"5_BarcodeConfigControllerBean", (Locale)ctx.getLocale()) + tableName + "#"));
    }

    private void createSTSequenceNoTableSql(Context ctx, BarcodeConfigXML xmlInfo) throws BOSException, SQLException {
        String tableName = "T_ST_" + xmlInfo.getDestBosType() + "_SEQNO";
        if (this.isExistsTable(ctx, tableName)) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE TABLE " + tableName + " (");
        sb.append("FBarcodeScanningID VARCHAR(44),FParentID VARCHAR(44),FParentBosType VARCHAR(20),FSequenceNo NVARCHAR(80)");
        sb.append(")");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"5_BarcodeConfigControllerBean", (Locale)ctx.getLocale()) + tableName + "#"));
    }

    private void createBarcodeTableSql(Context ctx, BarcodeConfigXML xmlInfo) throws BOSException, SQLException {
        String tableName = "T_BC_" + xmlInfo.getDestBosType() + "_BARCODE";
        boolean isExistsTable = this.isExistsTable(ctx, tableName);
        HashSet<String> existSet = new HashSet<String>();
        if (isExistsTable) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT KSQL_COL_NAME FROM KSQL_USERCOLUMNS WHERE KSQL_TABNAME='" + tableName.toUpperCase() + "'"));
            while (rs.next()) {
                existSet.add(rs.getString("KSQL_COL_NAME").toUpperCase());
            }
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.putAll(this.getBarcodeFields());
        map.keySet().removeAll(existSet);
        if (map.size() == 0) {
            return;
        }
        this.updateTableColums(ctx, tableName, isExistsTable, map);
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"6_BarcodeConfigControllerBean", (Locale)ctx.getLocale()) + tableName + "#"));
    }

    private void createSTBarcodeTableSql(Context ctx, BarcodeConfigXML xmlInfo) throws BOSException, SQLException {
        String tableName = "T_ST_" + xmlInfo.getDestBosType() + "_BARCODE";
        boolean isExistsTable = this.isExistsTable(ctx, tableName);
        HashSet<String> existSet = new HashSet<String>();
        if (isExistsTable) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT KSQL_COL_NAME FROM KSQL_USERCOLUMNS WHERE KSQL_TABNAME='" + tableName.toUpperCase() + "'"));
            while (rs.next()) {
                existSet.add(rs.getString("KSQL_COL_NAME").toUpperCase());
            }
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.putAll(this.getBarcodeFields());
        map.keySet().removeAll(existSet);
        if (map.size() == 0) {
            return;
        }
        this.updateTableColums(ctx, tableName, isExistsTable, map);
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"6_BarcodeConfigControllerBean", (Locale)ctx.getLocale()) + tableName + "#"));
    }

    protected void updateTableColums(Context ctx, String tableName, boolean isExistsTable, Map<String, String> columns) throws BOSException {
        if (columns.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        if (isExistsTable) {
            sql.append("ALTER TABLE " + tableName + " ADD ");
        } else {
            sql.append("CREATE TABLE " + tableName + " (");
        }
        Set<String> set = columns.keySet();
        Iterator<String> it = set.iterator();
        int count = 0;
        while (it.hasNext()) {
            if (count != 0) {
                sql.append(",");
            }
            ++count;
            String key = it.next();
            sql.append(key + " " + columns.get(key));
        }
        if (!isExistsTable) {
            sql.append(")");
        }
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private boolean isExistsTable(Context ctx, String tablename) throws BOSException, SQLException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select 1 from KSQL_USERTABLES WHERE KSQL_TABNAME='" + tablename + "'"));
        return rs.next();
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._addnew(ctx, model);
        BarcodeConfigInfo info = (BarcodeConfigInfo)model;
        BarcodeConfigXML xmlInfo = BarcodeXMLHelper.toBarcodeConfigXML(info.getDetailsXML());
        xmlInfo.setId(pk.toString());
        xmlInfo.setLastUpdateTime(info.getLastUpdateTime().toString());
        xmlInfo.setCu(info.getCU().getNumber());
        info.setDetailsXML(BarcodeXMLHelper.barcodeConfigXMLToXML(xmlInfo));
        this._update(ctx, pk, (IObjectValue)info);
        return pk;
    }

    protected void verify(IObjectValue model, Context ctx) throws EASBizException, BOSException {
        BarcodeConfigInfo info = (BarcodeConfigInfo)model;
        if (info.getNumber() == null || "".equals(info.getNumber().trim())) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"7_BarcodeConfigControllerBean", (Locale)ctx.getLocale())));
        }
        if (info.getName() == null || "".equals(info.getName().trim())) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"8_BarcodeConfigControllerBean", (Locale)ctx.getLocale())));
        }
        if (info.getDestBosType() == null || "".equals(info.getDestBosType().trim())) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"9_BarcodeConfigControllerBean", (Locale)ctx.getLocale())));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"10_BarcodeConfigControllerBean", (Locale)ctx.getLocale())));
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)info.getName()));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"212_bc_name_verify", (Locale)ctx.getLocale())));
        }
        boolean hasScanQty = false;
        if (info.getDetailsXML() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"213_not_config_detail")));
        }
        BarcodeConfigXML xmlInfo = BarcodeXMLHelper.toBarcodeConfigXML(info.getDetailsXML());
        if (xmlInfo != null) {
            List<BarcodeConfigXMLDetail> deXmls = xmlInfo.getDetails();
            for (int i = 0; i < deXmls.size(); ++i) {
                List<BarcodeConfigXMLProperty> dXml = deXmls.get(i).getProperties();
                if (dXml == null) continue;
                for (int j = 0; j < dXml.size(); ++j) {
                    hasScanQty = hasScanQty || dXml.get(j).isScanQty();
                }
            }
        }
        if (!hasScanQty) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"214_not_scanQty")));
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BarcodeConfigInfo info = (BarcodeConfigInfo)this._getValue(ctx, pk);
        ObjectUuidPK orgPK = new ObjectUuidPK(info.getCU().getId().toString());
        DataBasePermissionUtil.chekcPermission(ctx, (IObjectPK)orgPK, "barcodeConfig_delete");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("barcodeConfig.id", (Object)pk));
        if (ScanTaskBillFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"exsitConfig")));
        }
        super._delete(ctx, pk);
        DbUtil.execute((Context)ctx, (String)("delete from T_BC_BarcodeDefaultSolution where FBarcodeConfigID='" + pk.toString() + "'"));
    }

    @Override
    protected void _setDefaultSolution(Context ctx) throws BOSException {
    }
}

