/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.barcode.scm.BarcodeDictCollection;
import com.kingdee.eas.barcode.scm.BarcodeDictEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodeDictFactory;
import com.kingdee.eas.barcode.scm.BarcodeDictInfo;
import com.kingdee.eas.barcode.scm.StatusEnum;
import com.kingdee.eas.barcode.scm.app.AbstractBarcodeDictControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BarcodeDictControllerBean
extends AbstractBarcodeDictControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.barcode.app.BarcodeDictControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.verify(model, ctx);
        BarcodeDictInfo info = (BarcodeDictInfo)model;
        if (info.getStatus().getValue() == 1) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"11_BarcodeDictControllerBean", (Locale)ctx.getLocale())));
        }
        return super._submit(ctx, model);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BarcodeDictInfo info = (BarcodeDictInfo)model;
        if (info.getStatus().getValue() != 1) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"12_BarcodeDictControllerBean", (Locale)ctx.getLocale())));
        }
        info.setStatus(StatusEnum.INACTIVE);
        super._cancel(ctx, pk, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    protected void verify(IObjectValue model, Context ctx) throws EASBizException, BOSException {
        BarcodeDictInfo info = (BarcodeDictInfo)model;
        if (info.getNumber() == null || "".equals(info.getNumber().trim())) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"13_BarcodeDictControllerBean", (Locale)ctx.getLocale())));
        }
        if (info.getName() == null || "".equals(info.getName().trim())) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"14_BarcodeDictControllerBean", (Locale)ctx.getLocale())));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        view.setFilter(filter);
        BarcodeDictCollection coll = BarcodeDictFactory.getLocalInstance(ctx).getBarcodeDictCollection(view);
        if (coll != null && coll.size() >= 1) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"15_BarcodeDictControllerBean", (Locale)ctx.getLocale())));
        }
        HashSet<String> checkSet = new HashSet<String>();
        for (int i = 0; i < info.getDetails().size(); ++i) {
            BarcodeDictEntryInfo entry = info.getDetails().get(i);
            String barcode = entry.getBarcode();
            String number = entry.getNumber();
            String name = entry.getName();
            if (barcode == null || "".equals(barcode.trim()) || number == null || "".equals(number.trim()) || name == null || "".equals(name.trim())) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"16_BarcodeDictControllerBean", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"17_BarcodeDictControllerBean", (Locale)ctx.getLocale())));
            }
            barcode = barcode.trim();
            number = number.trim();
            name = name.trim();
            if (checkSet.contains(barcode)) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"16_BarcodeDictControllerBean", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"18_BarcodeDictControllerBean", (Locale)ctx.getLocale())));
            }
            checkSet.add(barcode);
            entry.setBarcode(barcode);
            entry.setNumber(number);
            entry.setName(name);
        }
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BarcodeDictInfo info = (BarcodeDictInfo)model;
        if (info.getStatus().getValue() == 1) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"19_BarcodeDictControllerBean", (Locale)ctx.getLocale())));
        }
        info.setStatus(StatusEnum.ACTIVE);
        super._cancelCancel(ctx, pk, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BarcodeDictInfo info = (BarcodeDictInfo)this._getValue(ctx, pk);
        if (info.getStatus().getValue() == 1) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"20_BarcodeDictControllerBean", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        BarcodeDictInfo info = (BarcodeDictInfo)super._getValue(ctx, pk, sic);
        return info.getNumber();
    }
}

