/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.barcode.scm.BarcodeDictEntryCollection;
import com.kingdee.eas.barcode.scm.BarcodeDictEntryFactory;
import com.kingdee.eas.barcode.scm.BarcodeDictEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodeDictFactory;
import com.kingdee.eas.barcode.scm.BarcodeDictInfo;
import com.kingdee.eas.barcode.scm.StatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;

public class BarcodeDictImport
extends AbstractDataTransmission {
    private BarcodeDictEntryCollection oldDicEntryColl = new BarcodeDictEntryCollection();
    private boolean isImportFirstRow = true;
    private Set barcodeSet = new HashSet();
    public static int startRowIndex = 0;
    private BarcodeDictInfo barcodeDict = new BarcodeDictInfo();
    private ICoreBase bizBase = null;
    private String bosType = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return BarcodeDictFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo == null || !(coreBaseInfo instanceof BarcodeDictInfo) && !(coreBaseInfo instanceof BarcodeDictEntryInfo)) {
            return;
        }
        try {
            if (coreBaseInfo instanceof BarcodeDictInfo) {
                this.getController(ctx).submit(coreBaseInfo).toString();
            } else {
                BarcodeDictEntryFactory.getLocalInstance(ctx).submit(coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public int getSubmitType() {
        return 1;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Object id = ctx.get((Object)"id");
        if (ctx.get((Object)"entity") != null && this.bosType == null) {
            EntityObjectInfo entity = (EntityObjectInfo)ctx.get((Object)"entity");
            this.bosType = entity.getType().toString();
            this.bizBase = this.getBizObjectController(entity, ctx);
        }
        this.verify(hsData, ctx, this.bosType);
        BarcodeDictEntryInfo entryInfo = new BarcodeDictEntryInfo();
        this.buildEntry(ctx, hsData, this.bizBase, entryInfo);
        try {
            if (this.isImportFirstRow) {
                startRowIndex = 0;
                String entityAlais = null;
                if (ctx.get((Object)"entity") != null) {
                    EntityObjectInfo entity = (EntityObjectInfo)ctx.get((Object)"entity");
                    entityAlais = entity.getAlias();
                }
                if (id != null && !id.equals("")) {
                    this.barcodeDict = BarcodeDictFactory.getLocalInstance(ctx).getBarcodeDictInfo((IObjectPK)new ObjectUuidPK(id.toString()));
                    int model = (Integer)this.getContextParameter().get("DATATASKMODE");
                    if (model == 16) {
                        this.oldDicEntryColl = this.barcodeDict.getDetails();
                        startRowIndex = this.oldDicEntryColl.get(this.oldDicEntryColl.size() - 1).getSeq();
                    } else if (model == 8) {
                        BarcodeDictEntryFactory.getLocalInstance(ctx).delete("where parent.id = '" + id.toString() + "'");
                    }
                } else {
                    this.barcodeDict = new BarcodeDictInfo();
                    this.barcodeDict.setNumber(ctx.get((Object)"number").toString());
                    this.barcodeDict.setName(ctx.get((Object)"name").toString());
                    this.barcodeDict.setEntityAlias(entityAlais);
                    this.barcodeDict.setEntityBosType(this.bosType);
                    this.barcodeDict.setStatus(StatusEnum.SAVED);
                    this.barcodeDict.getDetails().add(entryInfo);
                    this.isImportFirstRow = false;
                    return this.barcodeDict;
                }
                this.isImportFirstRow = false;
            }
            entryInfo.setParent(this.barcodeDict);
            entryInfo.setSeq(++startRowIndex);
            if (this.oldDicEntryColl.size() > 0) {
                for (int i = 0; i < this.oldDicEntryColl.size(); ++i) {
                    BarcodeDictEntryInfo enInfo = this.oldDicEntryColl.get(i);
                    String oldBarcode = enInfo.getBarcode();
                    if (!oldBarcode.equals(entryInfo.getBarcode())) continue;
                    entryInfo.setId(enInfo.getId());
                    entryInfo.setSeq(enInfo.getSeq());
                }
            }
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return entryInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildEntry(Context ctx, Hashtable hsData, ICoreBase bizBase, BarcodeDictEntryInfo entryInfo) throws TaskExternalException {
        for (int i = 0; i < hsData.size(); ++i) {
            Hashtable lineData = (Hashtable)hsData.get(new Integer(i));
            Object bizNumber = ((DataToken)lineData.get((Object)"FDetails_number")).data;
            entryInfo.setBarcode(((DataToken)lineData.get((Object)"FDetails_barcode")).data.toString());
            if (bizBase != null) {
                IObjectValue value = this.getBizObject(bizNumber.toString(), bizBase);
                if (value == null) throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"21_BarcodeDictImport", (Locale)ctx.getLocale()) + bizNumber + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"22_BarcodeDictImport", (Locale)ctx.getLocale()));
                entryInfo.setNumber(value.getString("number"));
                entryInfo.setName(value.getString("name"));
            } else {
                entryInfo.setNumber(bizNumber.toString());
                entryInfo.setName(((DataToken)lineData.get((Object)"FDetails_name")).data.toString());
            }
            Object remark1 = ((DataToken)lineData.get((Object)"FDetails_remark1")).data;
            entryInfo.setRemark1(remark1 == null ? null : remark1.toString());
            Object remark2 = ((DataToken)lineData.get((Object)"FDetails_remark2")).data;
            entryInfo.setRemark2(remark2 == null ? null : remark2.toString());
        }
    }

    private void verify(Hashtable hsData, Context ctx, String bosType) throws TaskExternalException {
        for (int i = 0; i < hsData.size(); ++i) {
            Hashtable lineData = (Hashtable)hsData.get(new Integer(i));
            Object barcode = ((DataToken)lineData.get((Object)"FDetails_barcode")).data;
            if (barcode == null || barcode.toString().equals("")) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"23_BarcodeDictImport", (Locale)ctx.getLocale()));
            }
            Object bizNumber = ((DataToken)lineData.get((Object)"FDetails_number")).data;
            if (bizNumber == null || bizNumber.toString().equals("")) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"24_BarcodeDictImport", (Locale)ctx.getLocale()));
            }
            Object bizName = ((DataToken)lineData.get((Object)"FDetails_name")).data;
            if (bosType == null && (bizName == null || bizName.equals(""))) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"25_BarcodeDictImport", (Locale)ctx.getLocale()));
            }
            if (this.barcodeSet.contains(barcode)) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"26_BarcodeDictImport", (Locale)ctx.getLocale()) + barcode + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"27_BarcodeDictImport", (Locale)ctx.getLocale()));
            }
            this.barcodeSet.add(barcode);
        }
    }

    private ICoreBase getBizObjectController(EntityObjectInfo entity, Context ctx) throws TaskExternalException {
        try {
            return (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)entity.getType());
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    private IObjectValue getBizObject(String bizNumber, ICoreBase bizBase) throws TaskExternalException {
        try {
            CoreBaseCollection coll = bizBase.getCollection("where number = '" + bizNumber + "'");
            if (coll != null && coll.size() > 0) {
                return coll.get(0);
            }
            return null;
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            this.putStringValue(result, "FDetails_barcode", rs.getString("details.barcode"));
            this.putStringValue(result, "FDetails_number", rs.getString("details.number"));
            this.putStringValue(result, "FDetails_name", rs.getString("details.name"));
            this.putStringValue(result, "FDetails_remark1", rs.getString("details.remark1"));
            this.putStringValue(result, "FDetails_remark2", rs.getString("details.remark2"));
        }
        catch (SQLException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    protected void putStringValue(Hashtable<String, String> result, String key, String value) {
        if (value != null && !value.equals("")) {
            result.put(key, value);
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ctx.get((Object)"id").toString()));
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.barcode.scm.app.BarcodeDictExportQuery";
    }

    public String getMainField() {
        return "FDetails_barcode";
    }
}

