/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.pda.app.sync.SynDeleteTask;
import com.kingdee.eas.barcode.scm.BarcodeDossierEntryCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierEntryFactory;
import com.kingdee.eas.barcode.scm.BarcodeDossierEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodeDossierInfo;
import com.kingdee.eas.barcode.scm.BarcodeDossierTemplateCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierTemplateEntryCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierTemplateFactory;
import com.kingdee.eas.barcode.scm.app.AbstractBarcodeDossierControllerBean;
import com.kingdee.eas.barcode.scm.app.BarcodeServerUtils;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BarcodeDossierControllerBean
extends AbstractBarcodeDossierControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.scm.app.BarcodeDossierControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UserInfo userInfo = this.getUserInfo(ctx);
        ObjectBaseInfo objectBaseInfo = null;
        objectBaseInfo = (ObjectBaseInfo)model;
        Object pk = null;
        objectBaseInfo.setCU(this.getCU(ctx, objectBaseInfo));
        if (objectBaseInfo.getCreator() == null) {
            objectBaseInfo.setCreator(userInfo);
        }
        Timestamp createtime = this.getTime();
        if (objectBaseInfo.getCreateTime() == null) {
            objectBaseInfo.setCreateTime(createtime);
        }
        objectBaseInfo.setLastUpdateUser(userInfo);
        objectBaseInfo.setLastUpdateTime(createtime);
        this._checkNumberBlank(ctx, null, model);
        this._checkNumberDup(ctx, null, model);
        BarcodeDossierInfo dossierInfo = (BarcodeDossierInfo)model;
        int size = dossierInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            BarcodeDossierEntryInfo entryInfo = dossierInfo.getEntrys().get(i);
            if (!"barcodeQ".equals(entryInfo.getName())) continue;
            if (entryInfo.getValue() == null) {
                dossierInfo.setQty(new BigDecimal("1"));
                break;
            }
            dossierInfo.setQty(new BigDecimal(entryInfo.getValue()));
            break;
        }
        return super._addnew(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BarcodeDossierInfo dossierInfo = (BarcodeDossierInfo)model;
        SynDeleteTask tt = new SynDeleteTask();
        tt.execute(ctx, null);
        int size = dossierInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            BarcodeDossierEntryInfo entryInfo = dossierInfo.getEntrys().get(i);
            if (!"barcodeQ".equals(entryInfo.getName())) continue;
            if (entryInfo.getValue() == null) {
                dossierInfo.setQty(new BigDecimal("1"));
                break;
            }
            dossierInfo.setQty(new BigDecimal(entryInfo.getValue()));
            break;
        }
        return super._save(ctx, model);
    }

    private UserInfo getUserInfo(Context ctx) throws BOSException {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    protected boolean _checkNumberBlank(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo coreBillBaseInfo = (CoreBillBaseInfo)model;
        String number = coreBillBaseInfo.getNumber();
        if (number == null || number.equals("")) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"\u6761\u7801\u503c"});
        }
        return true;
    }

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo coreBillBaseInfo = (CoreBillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)coreBillBaseInfo.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (coreBillBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)coreBillBaseInfo.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1");
        }
        if (FilterUtility.hasFilterItem((FilterInfo)this.getFilterForCheckNumber(coreBillBaseInfo))) {
            filter.mergeFilter(this.getFilterForCheckNumber(coreBillBaseInfo), "AND");
        }
        if (super._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", "\u5df2\u5b58\u5728\u6761\u7801\u503c\u4e3a\u3010" + coreBillBaseInfo.getString("number") + "\u3011\u7684\u4e3b\u6863"));
        }
        return true;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        SorterItemCollection sorterCol = new SorterItemCollection();
        SorterItemInfo sorterInfo = new SorterItemInfo("entrys.seq");
        sorterInfo.setSortType(SortType.ASCEND);
        sorterCol.add(sorterInfo);
        return super._getValue(ctx, pk, selector, sorterCol);
    }

    @Override
    protected void _updateBatchPrinted(Context ctx, Map argumentMap) throws BOSException, EASBizException {
        StringBuffer barcodeStr = new StringBuffer();
        for (String key : argumentMap.keySet()) {
            String value = argumentMap.get(key).toString();
            if (barcodeStr.length() > 0) {
                barcodeStr.append("','").append(key);
                continue;
            }
            barcodeStr.append(key);
        }
        if (barcodeStr.length() > 0) {
            StringBuffer updateSql = new StringBuffer();
            updateSql.append(" update CT_IND_BarcodeDossier set CFIsPrint=1 where fnumber in('" + barcodeStr.toString() + "')");
            DbUtil.execute((Context)ctx, (String)updateSql.toString());
        }
    }

    @Override
    protected void _updateBarcodeStatus(Context ctx, String barcode, int isInit, String destBosType, String transTypeNumber) throws BOSException, EASBizException {
        if (barcode == null) {
            return;
        }
        if (isInit == 1) {
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update CT_IND_BarcodeDossier set CFIsScan=1");
            updateSql.append(" ,CFBarcodeState=").append(BarcodeServerUtils.getInOrOutBill(ctx, destBosType, transTypeNumber)).append("\n");
            updateSql.append(" where fnumber in('").append(barcode).append("')");
            DbUtil.execute((Context)ctx, (String)updateSql.toString());
        } else if (isInit == 2) {
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update CT_IND_BarcodeDossier set CFIsScan=0");
            updateSql.append(" where fnumber in('").append(barcode).append("')");
            DbUtil.execute((Context)ctx, (String)updateSql.toString());
        } else if (isInit == 3) {
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update CT_IND_BarcodeDossier set CFIsScan=0 ").append("\t\n");
            updateSql.append(" where fnumber in (select fname_l2 from CT_IND_IndBarcodeBack  ").append("\t\n");
            updateSql.append(" where cfnum in('").append(barcode).append("'))").append("\t\n");
            DbUtil.execute((Context)ctx, (String)updateSql.toString());
            updateSql = new StringBuffer();
            updateSql.append("update CT_IND_BarcodeDossier set CFIsScan=0 ").append("\t\n");
            updateSql.append(" where fnumber in (").append("\t\n");
            updateSql.append(" select package.fpacakgeBarcode from T_BC_PackageBarcode package").append("\t\n");
            updateSql.append(" left join T_BC_PackageBarcodeEntry entry on package.fid=entry.fparentid").append("\t\n");
            updateSql.append(" where entry.fbarcode in (").append("\t\n");
            updateSql.append(" select fname_l2 from CT_IND_IndBarcodeBack where ").append("\t\n");
            updateSql.append(" cfnum in('").append(barcode).append("')))").append("\t\n");
            DbUtil.execute((Context)ctx, (String)updateSql.toString());
        }
    }

    @Override
    protected Map<String, Object> _getBillEntrysColl(Context ctx, Set billids, Set templateIds) throws BOSException, EASBizException {
        HashMap<String, Object> revMap = new HashMap<String, Object>();
        revMap.put("BILL_ENTRY", this.getBillEntrysColl(ctx, billids));
        revMap.put("TEMPLATE_ENTRY", this.getMoreTemplateColl(ctx, templateIds));
        return revMap;
    }

    private Map<String, BarcodeDossierTemplateEntryCollection> getMoreTemplateColl(Context ctx, Set templateIds) throws BOSException {
        if (templateIds == null || templateIds.size() == 0) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)templateIds, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("entrys.id"));
        view.getSelector().add(new SelectorItemInfo("entrys.name"));
        view.getSelector().add(new SelectorItemInfo("entrys.value"));
        view.getSelector().add(new SelectorItemInfo("entrys.displayName.id"));
        view.getSelector().add(new SelectorItemInfo("entrys.displayName.name"));
        BarcodeDossierTemplateCollection coll = BarcodeDossierTemplateFactory.getLocalInstance(ctx).getBarcodeDossierTemplateCollection(view);
        HashMap<String, BarcodeDossierTemplateEntryCollection> templateIdEntryMap = new HashMap<String, BarcodeDossierTemplateEntryCollection>();
        BOSUuid key = null;
        int count = coll.size();
        for (int i = 0; i < count; ++i) {
            key = coll.get(i).getId();
            templateIdEntryMap.put(key.toString(), coll.get(i).getEntrys());
        }
        return templateIdEntryMap;
    }

    private Map<String, BarcodeDossierEntryCollection> getBillEntrysColl(Context ctx, Set ids) throws BOSException {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)ids, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("value"));
        view.getSelector().add(new SelectorItemInfo("parent"));
        view.getSelector().add(new SelectorItemInfo("displayName.id"));
        view.getSelector().add(new SelectorItemInfo("displayName.name"));
        BarcodeDossierEntryCollection coll = BarcodeDossierEntryFactory.getLocalInstance(ctx).getBarcodeDossierEntryCollection(view);
        HashMap<String, BarcodeDossierEntryCollection> billEntryMap = new HashMap<String, BarcodeDossierEntryCollection>();
        BOSUuid key = null;
        int count = coll.size();
        for (int i = 0; i < count; ++i) {
            key = coll.get(i).getParent().getId();
            BarcodeDossierEntryCollection tmpcoll = (BarcodeDossierEntryCollection)((Object)billEntryMap.get(key.toString()));
            if (tmpcoll == null) {
                tmpcoll = new BarcodeDossierEntryCollection();
            }
            tmpcoll.add(coll.get(i));
            billEntryMap.put(key.toString(), tmpcoll);
        }
        return billEntryMap;
    }

    @Override
    public Map _getFilterDataByExtends(Context ctx, String ruleId, Map values, Map types, Map others) throws BOSException, EASBizException {
        HashMap m = new HashMap();
        HashMap<String, String> id2codes = new HashMap<String, String>();
        if (values != null && values.size() > 0) {
            Set names = values.keySet();
            StringBuilder sql = new StringBuilder("/*dialect*/");
            ArrayList<Object> args = new ArrayList<Object>();
            for (Object name : names) {
                sql.append("(");
                sql.append("\tselect t2.FID as dossierid,t2.FNumber as code from CT_IND_BarcodeDossierEntry t1 inner join CT_IND_BarcodeDossier t2 on t1.FParentID = t2.FID where t1.CFDisplayNameID = ? and t1.CFvalue  like ? and t2.CFBarRuleID = ?");
                sql.append(" union");
                sql.append("\tselect t2.FID as dossierid,t2.FNumber as code from CT_SCM_BarcodeDTE  t1 inner join CT_IND_BarcodeDossier t2  on t1.FParentID = t2.CFTemplateID  where t1.CFDisplayNameID = ? and t1.CFvalue  like ? and t2.CFBarRuleID = ?");
                sql.append(")");
                sql.append(" intersect ");
                args.add(name);
                args.add("%" + values.get(name) + "%");
                args.add(ruleId);
                args.add(name);
                args.add("%" + values.get(name) + "%");
                args.add(ruleId);
            }
            sql.delete(sql.lastIndexOf("intersect"), sql.length());
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])args.toArray());
            if (rows != null) {
                try {
                    while (rows.next()) {
                        String dossierid = rows.getObject("dossierid").toString();
                        String code = rows.getString("code");
                        id2codes.put(dossierid, code);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        m.put("id2codes", id2codes);
        return m;
    }

    @Override
    public Map _getIdsAndTemplateIdsAndCode(Context ctx, String ruleId, Set codes) throws BOSException {
        HashMap<String, String> id2codes = new HashMap<String, String>();
        HashMap<String, String> template2codes = new HashMap<String, String>();
        String sql = "select FID,CFTemplateID,FNumber from CT_IND_BarcodeDossier where CFBarRuleID = '" + ruleId + "'";
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rows != null && rows.size() > 0) {
                while (rows.next()) {
                    String id = rows.getObject("FID").toString();
                    String templateid = rows.getObject("CFTemplateID").toString();
                    String code = rows.getString("FNumber");
                    if (codes != null && codes.contains(code)) {
                        id2codes.put(id, code);
                        template2codes.put(templateid, code);
                    }
                    if (codes != null) continue;
                    id2codes.put(id, code);
                    template2codes.put(templateid, code);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap<String, HashMap<String, String>> m = new HashMap<String, HashMap<String, String>>();
        m.put("ids_map", id2codes);
        m.put("templateids_map", template2codes);
        return m;
    }
}

