/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.scm.AttUsingModeEnum;
import com.kingdee.eas.barcode.scm.BarcodeBillCustColInfo;
import com.kingdee.eas.barcode.scm.BarcodeBillUIConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeDossierCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierEntryCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.BarcodeDossierInfo;
import com.kingdee.eas.barcode.scm.BarcodeDossierTemplateCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierTemplateEntryCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierTemplateEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodeDossierTemplateFactory;
import com.kingdee.eas.barcode.scm.BarcodeDossierTemplateInfo;
import com.kingdee.eas.barcode.scm.BarcodeExcelData;
import com.kingdee.eas.barcode.scm.BarcodeGenResult;
import com.kingdee.eas.barcode.scm.BarcodeGenerateParamInfo;
import com.kingdee.eas.barcode.scm.BarcodeGenerateParams;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.FormtEnum;
import com.kingdee.eas.barcode.scm.IBarcodeDossier;
import com.kingdee.eas.barcode.scm.IBarcodeDossierTemplate;
import com.kingdee.eas.barcode.scm.IIndBarcodeMaster;
import com.kingdee.eas.barcode.scm.IIndBarcodeRule;
import com.kingdee.eas.barcode.scm.IIndBarcodeSetup;
import com.kingdee.eas.barcode.scm.IndBarCodeCountMsgCollection;
import com.kingdee.eas.barcode.scm.IndBarCodeCountMsgFactory;
import com.kingdee.eas.barcode.scm.IndBarCodeCountMsgInfo;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterEntryCollection;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterEntryFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterEntryInfo;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterInfo;
import com.kingdee.eas.barcode.scm.IndBarcodeRuleEntryCollection;
import com.kingdee.eas.barcode.scm.IndBarcodeRuleEntryInfo;
import com.kingdee.eas.barcode.scm.IndBarcodeRuleFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeRuleInfo;
import com.kingdee.eas.barcode.scm.IndBarcodeRuleSNFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupCollection;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupEntryCollection;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupEntryInfo;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupInfo;
import com.kingdee.eas.barcode.scm.PropertyTypeEnum;
import com.kingdee.eas.barcode.scm.app.AbstractBarcodeFacadeControllerBean;
import com.kingdee.eas.barcode.scm.util.Json;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class BarcodeFacadeControllerBean
extends AbstractBarcodeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.scm.app.BarcodeFacadeControllerBean");
    private final BOSObjectType barcodeBosType = new BarcodeDossierInfo().getBOSType();
    private int barcodeMaxLength = -1;
    public static Map<String, BigDecimal> barcodeBigMap = new HashMap<String, BigDecimal>();
    private final String liNumPart = "li";

    @Override
    protected BarcodeBillUIConfigInfo _getBillUIConfigInfo(Context ctx, String billType) throws BOSException, EASBizException {
        if (billType == null) {
            logger.debug((Object)" no billType provided !");
            return null;
        }
        IndBarcodeSetupInfo indBarcodeSetupInfo = this.getBillIndBarcodeSetup(ctx, billType);
        if (indBarcodeSetupInfo == null) {
            logger.error((Object)" no indBarcodeSetup !");
            return null;
        }
        IndBarcodeSetupEntryCollection setupEntries = indBarcodeSetupInfo.getEntry();
        if (setupEntries == null || setupEntries.size() == 0) {
            logger.error((Object)" indBarcodeSetup, no entries !");
            return null;
        }
        BarcodeBillUIConfigInfo billUIConfigInfo = new BarcodeBillUIConfigInfo();
        billUIConfigInfo.setBarcodeMasterId(indBarcodeSetupInfo.getMaster().getId().toString());
        billUIConfigInfo.setBarcodeSetupInfo(indBarcodeSetupInfo);
        ArrayList<BarcodeBillCustColInfo> cols = new ArrayList<BarcodeBillCustColInfo>();
        String propName = null;
        String propAlias = null;
        IndBarcodeSetupEntryInfo setupEntryInfo = null;
        int n = setupEntries.size();
        for (int i = 0; i < n; ++i) {
            setupEntryInfo = setupEntries.get(i);
            propName = setupEntryInfo.getFullName();
            BarcodeBillCustColInfo col = new BarcodeBillCustColInfo();
            if (propName != null) {
                col.setPropertyName(propName);
            }
            IndBarcodeMasterEntryInfo masterEntry = setupEntryInfo.getProperty();
            propAlias = masterEntry.getName();
            PropertyTypeEnum propType = masterEntry.getType();
            logger.debug((Object)(" name: " + propName + ", alias: " + propAlias + ", type:" + (Object)((Object)propType)));
            col.setDisplayName(propAlias);
            col.setPropertyId(masterEntry.getId().toString());
            if (propType != null) {
                col.setDataType(Integer.parseInt(propType.getValue()));
            }
            col.setHide(masterEntry.isIsHide());
            if (masterEntry.getTdPt() != null) {
                col.setDtProprety(masterEntry.getTdPt().getValue());
            }
            col.setEdit(setupEntryInfo.isEdit());
            cols.add(col);
        }
        billUIConfigInfo.setCustCols(cols);
        return billUIConfigInfo;
    }

    @Override
    protected BarcodeGenResult _geneateBarcodes(Context ctx, BarcodeGenerateParams barcodeGenParam) throws BOSException, EASBizException {
        int i;
        if (barcodeGenParam == null || barcodeGenParam.getParamList().size() == 0 || barcodeGenParam.getBarcodeRuleId() == null || barcodeGenParam.getIndBarcodeSetupId() == null) {
            logger.error((Object)"param is null, or no rule, no bills");
            return null;
        }
        logger.debug((Object)(" barcodeGenParam: " + barcodeGenParam));
        long time = System.currentTimeMillis();
        EntityObjectInfo entityObject = barcodeGenParam.getEntity();
        if (entityObject == null) {
            logger.error((Object)("billType value invalid " + entityObject));
            return null;
        }
        boolean isBaseData = barcodeGenParam.isBaseData();
        boolean isSaveBarcode = barcodeGenParam.isSave();
        StorageOrgUnitInfo storageInfo = barcodeGenParam.getOrgUnitInfo();
        BOSObjectType billBosType = entityObject.getType();
        String IndBarcodeSetupId = barcodeGenParam.getIndBarcodeSetupId();
        BOSObjectType entryBosType = null;
        if (barcodeGenParam.getEntrtyEntity() == null) {
            entryBosType = BOSObjectType.create((String)"ED498839");
        }
        if (entryBosType == null && barcodeGenParam.getEntrtyEntity() != null) {
            entryBosType = barcodeGenParam.getEntrtyEntity().getType();
        }
        if (entryBosType == null && !isBaseData) {
            logger.error((Object)"billType cannot find bostype ");
            return null;
        }
        IndBarcodeSetupInfo indBarcodeSetupInfo = this.getBillIndBarcodeSetup(ctx, IndBarcodeSetupId);
        if (indBarcodeSetupInfo == null) {
            logger.error((Object)(entryBosType + " has no barcode setup ,"));
            return null;
        }
        if (indBarcodeSetupInfo.getEntry() == null || indBarcodeSetupInfo.getEntry().size() == 0) {
            logger.error((Object)" barcode setup without entries !!");
            return null;
        }
        String barcodeRuleId = barcodeGenParam.getBarcodeRuleId();
        String updateLocalSql = "update  T_IND_IndBarcodeRuleSN set CFNumber=CFNumber where CFRuleId='" + barcodeRuleId + "'";
        DbUtil.execute((Context)ctx, (String)updateLocalSql.toString());
        IIndBarcodeRule iRule = IndBarcodeRuleFactory.getLocalInstance(ctx);
        String rOql = "select *, Entry.*,Entry.parent.flowBasis where id = '" + barcodeRuleId + "'";
        IndBarcodeRuleInfo ruleInfo = iRule.getIndBarcodeRuleInfo(rOql);
        if (ruleInfo == null) {
            logger.error((Object)" ruleId invalid");
            return null;
        }
        if (ruleInfo.getEntry() == null || ruleInfo.getEntry().size() == 0) {
            logger.error((Object)(" rule without entries, id: " + barcodeRuleId));
            return null;
        }
        BarcodeGenResult genRslt = new BarcodeGenResult();
        int status = 0;
        String msg = null;
        IBarcodeDossier iBarcode = BarcodeDossierFactory.getLocalInstance(ctx);
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        int maxLength = this.getBarcodeMaxLength(loader);
        ICoreBase iBill = null;
        ICoreBase oBill = null;
        String oqlSel = "";
        if (entryBosType != null) {
            iBill = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)entryBosType);
        }
        if (billBosType != null) {
            oBill = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)billBosType);
        }
        oqlSel = this.getBillSelect1(loader, billBosType, entryBosType, indBarcodeSetupInfo, ruleInfo, isBaseData);
        CoreBaseInfo billInfo = null;
        boolean fCheckDupl = indBarcodeSetupInfo.isIsBarcodeRepeat();
        boolean fDebug = logger.isDebugEnabled();
        if (fDebug) {
            logger.debug((Object)(" indBarcodeSetupInfo: " + indBarcodeSetupInfo));
            logger.debug((Object)(" ruleInfo: " + ruleInfo));
            logger.debug((Object)(" fCheckDupl: " + fCheckDupl));
            logger.debug((Object)(" maxLength: " + maxLength));
        }
        BarcodeDossierCollection barcodes = new BarcodeDossierCollection();
        CoreBaseCollection barcodeDossierCol = new CoreBaseCollection();
        List<BarcodeGenerateParamInfo> params = barcodeGenParam.getParamList();
        StringBuffer updateStr = new StringBuffer();
        BarcodeGenerateParamInfo paramInfo = null;
        int barCt = -1;
        IndBarcodeRuleEntryInfo liEntryInfo = null;
        Map<String, IndBarCodeCountMsgInfo> countMsgMap = null;
        if (indBarcodeSetupInfo.isControlQty()) {
            countMsgMap = this.getControlQtyMap(ctx, params);
        }
        String srcBillId = null;
        ArrayList<String> pkList = new ArrayList<String>();
        int n = params.size();
        for (i = 0; i < n; ++i) {
            IndBarCodeCountMsgInfo codeCountMsgInfo;
            paramInfo = params.get(i);
            barCt = paramInfo.getBarcodeCount();
            if (barCt <= 0) {
                logger.error((Object)" generate barcode, invalid billEntryId");
                msg = "\u6761\u7801\u751f\u6210\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0";
                genRslt.addMessage(msg);
                status = 2;
                continue;
            }
            if (countMsgMap != null && countMsgMap.containsKey(paramInfo.getEntryId()) && (codeCountMsgInfo = countMsgMap.get(paramInfo.getEntryId())).getUnCount() != null && new BigDecimal(barCt).abs().compareTo(codeCountMsgInfo.getUnCount().abs()) > 0) {
                msg = "\u5df2\u542f\u7528\u63a7\u5236\u6761\u7801\u751f\u6210\u6570\u91cf\uff0c\u73b0\u5df2\u8d85\u8fc7\u6761\u7801\u53ef\u751f\u6210\u6570\u91cf\uff0c\u6761\u7801\u751f\u6210\u5931\u8d25\uff01";
                genRslt.addMessage(msg);
                status = 1;
                continue;
            }
            logger.debug((Object)(" barCt: " + barCt));
            logger.debug((Object)(" billEntryId: " + paramInfo.getEntryId()));
            IObjectValue billInfo1 = null;
            String entrykey = null;
            if (!isBaseData) {
                billInfo1 = this.getBillInfo(oBill, paramInfo.getBillId(), paramInfo.getBillId(), oqlSel);
                srcBillId = paramInfo.getEntryId();
                Map<String, EntityObjectInfo> entryEntityObjectMap = this.getEntryEntityObjectInfo(loader.getEntity(billBosType));
                entrykey = null;
                for (Map.Entry<String, EntityObjectInfo> entry0 : entryEntityObjectMap.entrySet()) {
                    if (!loader.getEntity(entryBosType).equals((Object)entry0.getValue())) continue;
                    entrykey = entry0.getKey();
                    break;
                }
                IObjectCollection ecol = (IObjectCollection)billInfo1.get(entrykey);
                for (int j = 0; j < ecol.size(); ++j) {
                    if (!ecol.getObject(j).getString("id").endsWith(srcBillId)) continue;
                    billInfo = ((IObjectCollection)billInfo1.get(entrykey)).getObject(j);
                    break;
                }
            } else {
                billInfo = oBill.getValue(oqlSel + " where id='" + paramInfo.getBillId() + "'");
                srcBillId = paramInfo.getBillId();
                billInfo1 = billInfo;
            }
            if (billInfo == null) {
                logger.error((Object)" generate barcode, invalid billEntryId");
                msg = "\u53c2\u6570\u503c\u65e0\u6548\uff0c" + paramInfo.getEntryId();
                genRslt.addMessage(msg);
                status = 2;
                continue;
            }
            time = System.currentTimeMillis();
            EntityObjectInfo entryEntity = loader.getEntity(entryBosType);
            String parentName = this.getEntryParentName(entryEntity);
            liEntryInfo = this.getLiEntryInfo(ctx, ruleInfo);
            String barNum = this.generateBarcodeString(ctx, ruleInfo, (IObjectValue)billInfo, paramInfo.getBarcodeDate(), isBaseData, parentName, entryEntity, billInfo1);
            if (barNum == null) {
                msg = "\u6761\u7801\u503c\u751f\u6210\u89c4\u5219\u51fa\u73b0\u51fa\u9519";
                genRslt.addMessage(msg);
                status = 1;
                continue;
            }
            BigDecimal maxValueBig = this.getMaxValue(ctx, barNum, ruleInfo, (IObjectValue)billInfo, paramInfo.getBarcodeDate(), isBaseData, liEntryInfo, new BigDecimal(barCt));
            StringBuffer barcodeStr = new StringBuffer();
            ArrayList<String> barcodeList = new ArrayList<String>();
            HashMap<String, String> barcodeMap = new HashMap<String, String>();
            for (int j = 0; j < barCt; ++j) {
                String barcode;
                BigDecimal cacheMaxValue;
                if (barcodeBigMap.containsKey(barNum) && (cacheMaxValue = barcodeBigMap.get(barNum)).compareTo(maxValueBig) > 0) {
                    maxValueBig = cacheMaxValue;
                }
                String string = barcode = barNum.equals("li") ? "" : barNum;
                if (liEntryInfo != null) {
                    String maxValue = (maxValueBig = maxValueBig.add(BigDecimal.ONE)).toString();
                    if (maxValue.length() > liEntryInfo.getLengt() && !liEntryInfo.isIsDilatation()) {
                        throw new EASBizException(new NumericExceptionSubItem("", "\u987a\u5e8f\u53f7\u7684\u6700\u5927\u503c\u5df2\u7ecf\u8d85\u8fc7\u4e0a\u9650,\u8bf7\u4fee\u6539\u751f\u6210\u89c4\u5219"));
                    }
                    for (int l = maxValue.length(); l < liEntryInfo.getLengt(); ++l) {
                        maxValue = "0" + maxValue;
                    }
                    barcode = barcode + maxValue;
                }
                if (ruleInfo.getFixedValue() != null && !"".equals(ruleInfo.getFixedValue())) {
                    barcode = barcode + ruleInfo.getFixedValue();
                }
                if (barcodeBigMap.containsKey(barNum)) {
                    BigDecimal cacheMaxValue2 = barcodeBigMap.get(barNum);
                    if (maxValueBig.compareTo(cacheMaxValue2) > 0) {
                        barcodeBigMap.put(barNum, maxValueBig);
                    }
                    if (cacheMaxValue2.compareTo(maxValueBig) > 0) {
                        maxValueBig = cacheMaxValue2;
                    }
                } else {
                    barcodeBigMap.put(barNum, maxValueBig);
                }
                if (barcodeMap.containsKey(barcode)) continue;
                barcodeMap.put(barcode, barcode);
                if (barcodeStr.length() > 0) {
                    barcodeStr.append(",").append(barcode);
                } else {
                    barcodeStr.append(barcode);
                }
                barcodeList.add(barcode);
            }
            HashMap<String, String> existBarcodeMap = new HashMap<String, String>();
            if (barcodeStr.length() > 0) {
                BarcodeDossierCollection dossierCol = this.getBarcodeDossierCol(ctx, iBarcode, barcodeStr.toString());
                int size = dossierCol.size();
                for (int j = 0; j < size; ++j) {
                    BarcodeDossierInfo dossierInfo = dossierCol.get(j);
                    String key = dossierInfo.getNumber();
                    if (existBarcodeMap.containsKey(key)) continue;
                    existBarcodeMap.put(key, key);
                }
            }
            time = System.currentTimeMillis() - time;
            logger.info((Object)(" \u6279\u91cf\u751f\u6210\u6761\u7801\uff1a" + time));
            BarcodeDossierInfo cloneBInfo = this.buildBarcodeInfo1(ctx, null, indBarcodeSetupInfo, billInfo1, (IObjectValue)billInfo, paramInfo, isBaseData, storageInfo, entrykey);
            cloneBInfo.setSrcBillId(srcBillId);
            cloneBInfo.setSrcBosType(entityObject.getType().toString());
            cloneBInfo.setSrcBillNumber(paramInfo.getBillNum());
            BarcodeDossierEntryCollection entrys = this.getTpFiledColl(ctx, cloneBInfo);
            String currDataStr = this.getTemplateModeStr(ctx, entrys);
            BarcodeDossierTemplateInfo templateinfo = this.findExistTemplate(ctx, cloneBInfo, currDataStr);
            if (templateinfo == null) {
                templateinfo = this.covert2Template(cloneBInfo, entrys, currDataStr);
                BarcodeDossierTemplateFactory.getLocalInstance(ctx).save((CoreBaseInfo)templateinfo);
            }
            BarcodeDossierEntryCollection useEntrys = this.getNotTpFiledColl(ctx, cloneBInfo);
            String qrcode = this.genQrCode(cloneBInfo);
            cloneBInfo.setQrcode(qrcode);
            time = System.currentTimeMillis();
            logger.info((Object)("" + barcodeList.size()));
            StringBuffer existBarcodeStr = new StringBuffer();
            int size = barcodeList.size();
            for (int j = 0; j < size; ++j) {
                boolean fExcced;
                String barcode = (String)barcodeList.get(j);
                if (existBarcodeMap.containsKey(barcode)) {
                    logger.error((Object)" duplicated barcode ");
                    msg = "\u6761\u7801\u91cd\u590d\uff0c" + barcode;
                    genRslt.addMessage(msg);
                    status = 1;
                    if (existBarcodeStr.length() > 0) {
                        existBarcodeStr.append(",").append(barcode);
                        continue;
                    }
                    existBarcodeStr.append(barcode);
                    continue;
                }
                boolean fNull = StringUtils.isEmpty((String)barcode);
                boolean bl = fExcced = barcode != null && barcode.length() > maxLength;
                if (fNull || fExcced) {
                    logger.error((Object)(fNull ? " cannot generate barcode" : " barcode exceed maxLength"));
                    msg = fNull ? "\u6761\u7801\u503c\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u5904\u7406\u3002" : "\u6761\u7801\u503c\u5b57\u7b26\u4e32\u8d85\u8fc7" + maxLength + "\uff0c\u8bf7\u68c0\u67e5\u6761\u7801\u751f\u6210\u89c4\u5219\u3002";
                    genRslt.addMessage(msg);
                    status = 2;
                    continue;
                }
                BarcodeDossierInfo bInfo = new BarcodeDossierInfo();
                bInfo.putAll((IObjectValue)cloneBInfo);
                bInfo.setTemplate(templateinfo);
                bInfo.setStorageOrgUnit(paramInfo.getStorageOrgUnitInfo());
                bInfo.setId(null);
                BarcodeDossierEntryCollection dossierEntryCol = new BarcodeDossierEntryCollection();
                int m = useEntrys.size();
                for (int l = 0; l < m; ++l) {
                    BarcodeDossierEntryInfo entryInfo = useEntrys.get(l);
                    BarcodeDossierEntryInfo newEntryInfo = new BarcodeDossierEntryInfo();
                    newEntryInfo.putAll((IObjectValue)entryInfo);
                    newEntryInfo.setId(null);
                    newEntryInfo.setParent(bInfo);
                    dossierEntryCol.add(newEntryInfo);
                }
                bInfo.put("entrys", (Object)dossierEntryCol);
                bInfo.setNumber(barcode);
                bInfo.setCreateTime(this.getTime());
                bInfo.setLastUpdateTime(this.getTime());
                bInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                bInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                bInfo.setGeneRule(ruleInfo);
                bInfo.setUseType(ruleInfo.getUseType());
                barcodes.add(bInfo);
                barcodeDossierCol.add((CoreBaseInfo)bInfo);
            }
            time = System.currentTimeMillis() - time;
            logger.info((Object)(" \u89e3\u6790\u6761\u7801\uff1a" + time));
            if (existBarcodeStr.length() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)existBarcodeStr.toString(), CompareType.INCLUDE));
                view.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("*");
                sic.add("entrys.*");
                sic.add("entrys.displayName.*");
                sic.add("material.*");
                sic.add("barRule.*");
                sic.add("barRule.barcodeType.*");
                sic.add(new SelectorItemInfo("template.number"));
                sic.add(new SelectorItemInfo("template.entrys.name"));
                sic.add(new SelectorItemInfo("template.entrys.value"));
                sic.add(new SelectorItemInfo("template.entrys.displayName.*"));
                view.setSelector(sic);
                BarcodeDossierCollection barcodeDossiercol = iBarcode.getBarcodeDossierCollection(view);
                int size2 = barcodeDossiercol.size();
                for (int j = 0; j < size2; ++j) {
                    BarcodeDossierInfo dossierInfo = barcodeDossiercol.get(j);
                    pkList.add(dossierInfo.getId().toString());
                }
                barcodes.addCollection(barcodeDossiercol);
            }
            time = System.currentTimeMillis();
            IndBarcodeRuleSNFactory.getLocalInstance(ctx).updateBarcodeRuleSN(ruleInfo, barNum, new BigDecimal(paramInfo.getBarcodeCount()));
            time = System.currentTimeMillis() - time;
            logger.info((Object)(" \u66f4\u65b0\u6761\u7801\u89c4\u5219\u987a\u5e8f\u53f7\uff1a" + time));
            IndBarCodeCountMsgInfo indBarcodeCountMsgInfo = new IndBarCodeCountMsgInfo();
            if ("1D0D80DD".equalsIgnoreCase(billBosType.toString())) {
                indBarcodeCountMsgInfo.setBillId(paramInfo.getBillId());
            } else {
                indBarcodeCountMsgInfo.setBillId(paramInfo.getEntryId());
            }
            time = System.currentTimeMillis();
            indBarcodeCountMsgInfo.setTotalCount(paramInfo.getTotalCount());
            indBarcodeCountMsgInfo.setCounted(new BigDecimal(paramInfo.getBarcodeCount()));
            IndBarCodeCountMsgFactory.getLocalInstance(ctx).saveIndBarCodeCountMsg(indBarcodeCountMsgInfo);
            time = System.currentTimeMillis() - time;
            logger.info((Object)(" \u66f4\u65b0\u6761\u7801\u4e2a\u6570\uff1a" + time));
            if (updateStr.length() > 0) {
                updateStr.append("','").append(paramInfo.getBillNum());
            } else {
                updateStr.append(paramInfo.getBillNum());
            }
            barcodeStr = null;
            barcodeList.clear();
        }
        if (barcodeDossierCol.size() > 0 && isSaveBarcode) {
            time = System.currentTimeMillis();
            this.batchSaveData(iBarcode, ctx, barcodeDossierCol);
            time = System.currentTimeMillis() - time;
            logger.info((Object)(" \u6279\u91cf\u65b0\u589e\u6761\u7801\u6863\u6848\u4fe1\u606f\uff1a" + time));
            int size = barcodeDossierCol.size();
            for (i = 0; i < size; ++i) {
                BarcodeDossierInfo dossierInfo = (BarcodeDossierInfo)barcodeDossierCol.get(i);
                pkList.add(dossierInfo.getId().toString());
            }
        }
        genRslt.setBarcodes(barcodes);
        genRslt.setStatus(status);
        genRslt.setPkList(pkList);
        return genRslt;
    }

    private Map<String, IndBarCodeCountMsgInfo> getControlQtyMap(Context ctx, List<BarcodeGenerateParamInfo> params) throws BOSException {
        StringBuffer sbfStr = new StringBuffer();
        int n = params.size();
        for (int i = 0; i < n; ++i) {
            BarcodeGenerateParamInfo paramInfo = params.get(i);
            if (sbfStr.length() > 0) {
                sbfStr.append(",").append(paramInfo.getEntryId());
                continue;
            }
            sbfStr.append(paramInfo.getEntryId());
        }
        HashMap<String, IndBarCodeCountMsgInfo> countMsgMap = new HashMap<String, IndBarCodeCountMsgInfo>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("billId"));
        sic.add(new SelectorItemInfo("totalCount"));
        sic.add(new SelectorItemInfo("counted"));
        sic.add(new SelectorItemInfo("unCount"));
        view.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billId", (Object)sbfStr.toString()));
        IndBarCodeCountMsgCollection barcodeCountMsgCol = IndBarCodeCountMsgFactory.getLocalInstance(ctx).getIndBarCodeCountMsgCollection(view);
        int size = barcodeCountMsgCol.size();
        for (int i = 0; i < size; ++i) {
            IndBarCodeCountMsgInfo barcodeMsgInfo = barcodeCountMsgCol.get(i);
            String billID = barcodeMsgInfo.getBillId();
            if (countMsgMap.containsKey(billID)) continue;
            countMsgMap.put(billID, barcodeMsgInfo);
        }
        return countMsgMap;
    }

    private void batchSaveData(IBarcodeDossier iBarcode, Context ctx, CoreBaseCollection barcodeDossierCol) throws EASBizException, BOSException {
        int batchNum = 1000;
        int size = barcodeDossierCol.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        System.out.print("save total " + size);
        for (int index = 0; index < count; ++index) {
            CoreBaseCollection savecoll = new CoreBaseCollection();
            int k = 1;
            while (k <= batchNum) {
                if (pos < size) {
                    savecoll.add(barcodeDossierCol.get(pos));
                }
                ++k;
                ++pos;
            }
            iBarcode.saveBatchData(savecoll);
            System.out.print("save size " + savecoll.size());
            savecoll = null;
        }
    }

    private String genQrCode(BarcodeDossierInfo info) {
        IndBarcodeMasterInfo materInfo = info.getBarRule();
        IndBarcodeMasterEntryCollection materEntrys = materInfo.getEntry();
        BarcodeDossierEntryCollection entrys = info.getEntrys();
        LinkedHashMap<String, String> qrmap = new LinkedHashMap<String, String>();
        BarcodeDossierEntryInfo entry = null;
        int count = materEntrys.size();
        for (int i = 0; i < count; ++i) {
            if (!materEntrys.get(i).isDCode()) continue;
            entry = this.getTargetItemInfo(entrys, materEntrys.get(i));
            qrmap.put(materEntrys.get(i).getName(), (entry.getValue() == null ? "" : entry.getValue()) + "#" + (entry.getName() == null ? "" : entry.getName()));
        }
        if (qrmap.size() > 0) {
            return BarcodeUtils.getQrCodeVersionPreStr() + Json.toString(qrmap, true);
        }
        return null;
    }

    private BarcodeDossierCollection getBarcodeDossierCol(Context ctx, IBarcodeDossier iBarcode, String barcodeNumber) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)barcodeNumber, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("number"));
        viewInfo.setSelector(coll);
        BarcodeDossierCollection barcodeDossierCol = iBarcode.getBarcodeDossierCollection(viewInfo);
        return barcodeDossierCol;
    }

    private IndBarcodeSetupInfo getBillIndBarcodeSetup(Context ctx, String billBosType) throws BOSException, EASBizException {
        String oql;
        IndBarcodeSetupInfo indBarcodeSetupInfo = null;
        IIndBarcodeSetup iBarcodeSetup = IndBarcodeSetupFactory.getLocalInstance(ctx);
        IndBarcodeSetupCollection indBarcodeSetups = iBarcodeSetup.getIndBarcodeSetupCollection(oql = "select *, master.id, Entry.*, Entry.property.* where id='" + billBosType + "'");
        if (indBarcodeSetups == null) {
            logger.error((Object)("the bill type doesnot has IndBarcode setup  " + billBosType));
            return null;
        }
        indBarcodeSetupInfo = indBarcodeSetups.get(0);
        return indBarcodeSetupInfo;
    }

    private int getBarcodeMaxLength(IMetaDataLoader loader) {
        if (this.barcodeMaxLength == -1) {
            EntityObjectInfo barcodeEntity = loader.getEntity(this.barcodeBosType);
            PropertyInfo prop = barcodeEntity.getPropertyByName("number");
            ColumnInfo col = prop.getMappingField();
            this.barcodeMaxLength = col.getLength();
        }
        return 500;
    }

    private String getBillSelect1(IMetaDataLoader loader, BOSObjectType billBosType, BOSObjectType entryBosType, IndBarcodeSetupInfo indBarcodeSetupInfo, IndBarcodeRuleInfo ruleInfo, boolean isBaseData) {
        boolean fHasBillProp = false;
        ArrayList<String> props = new ArrayList<String>();
        String propName = null;
        String[] propArr = null;
        IndBarcodeSetupEntryCollection setupEntries = indBarcodeSetupInfo.getEntry();
        int n = setupEntries.size();
        for (int i = 0; i < n; ++i) {
            IndBarcodeSetupEntryInfo entryInfo = setupEntries.get(i);
            propName = entryInfo.getFullName();
            if (StringUtils.isEmpty((String)propName)) continue;
            if (!props.contains(propName)) {
                props.add(propName);
            }
            if (fHasBillProp) continue;
            fHasBillProp = !propName.contains(".");
        }
        IndBarcodeRuleEntryCollection ruleEntries = ruleInfo.getEntry();
        int n2 = ruleEntries.size();
        for (int i = 0; i < n2; ++i) {
            IndBarcodeRuleEntryInfo entryInfo = ruleEntries.get(i);
            propName = entryInfo.getFullName();
            if (StringUtils.isEmpty((String)propName)) continue;
            if (!props.contains(propName)) {
                props.add(propName);
            }
            if (fHasBillProp) continue;
            fHasBillProp = !propName.contains(".");
        }
        StringBuffer oql = new StringBuffer();
        PropertyInfo propInfo = null;
        if (isBaseData) {
            EntityObjectInfo entity = loader.getEntity(billBosType);
            oql.append("select ");
            int n3 = props.size();
            for (int i = 0; i < n3; ++i) {
                propName = (String)props.get(i);
                propArr = propName.split("\\.");
                if (propArr.length == 1) {
                    oql.append(propName);
                } else if (propArr.length >= 2) {
                    oql.append(propName);
                }
                if (i + 1 >= n3) continue;
                oql.append(", ");
            }
        } else {
            EntityObjectInfo entryEntity = loader.getEntity(entryBosType);
            EntityObjectInfo billEntity = loader.getEntity(billBosType);
            if (fHasBillProp) {
                billEntity = loader.getEntity(billBosType);
            }
            Map<String, EntityObjectInfo> entryEntityObjectMap = this.getEntryEntityObjectInfo(billEntity);
            oql.append("select id, number");
            int n4 = props.size();
            for (int i = 0; i < n4; ++i) {
                propName = (String)props.get(i);
                if (StringUtils.isEmpty((String)propName)) continue;
                oql.append(", ").append(propName);
                propArr = propName.split("\\.");
                if (propArr.length == 1) {
                    propInfo = billEntity.getPropertyByName(propName);
                    if (!(propInfo instanceof LinkPropertyInfo)) continue;
                    oql.append(".id, ").append(propName).append(".name");
                    oql.append(", ").append(propName).append(".number");
                    if (!"material".equalsIgnoreCase(propInfo.getName())) continue;
                    oql.append(", ").append(propName).append(".model");
                    continue;
                }
                if (propArr.length == 2) {
                    String key = propArr[0];
                    if (entryEntity == null || !((propInfo = entryEntity.getPropertyByName(propArr[1])) instanceof LinkPropertyInfo)) continue;
                    oql.append(".id, ").append(propName).append(".name");
                    oql.append(", ").append(propName).append(".number");
                    if (!"material".equalsIgnoreCase(propInfo.getName())) continue;
                    oql.append(", ").append(propName).append(".model");
                    continue;
                }
                if (propArr.length != 3) continue;
                logger.warn((Object)("prop in 3 level, " + propName));
            }
        }
        logger.debug((Object)(" getBillSelect, select: " + oql));
        return oql.toString();
    }

    private Map<String, EntityObjectInfo> getEntryEntityObjectInfo(EntityObjectInfo billEntity) {
        HashMap<String, EntityObjectInfo> bosTypeMap = new HashMap<String, EntityObjectInfo>();
        PropertyCollection pyColl = billEntity.getEntityProperties();
        for (int i = 0; i < pyColl.size(); ++i) {
            PropertyInfo property = pyColl.get(i);
            if (property.getName().equalsIgnoreCase("ID") || !BarcodeUtils.isEntryProperty(billEntity, property)) continue;
            RelationshipInfo relation = ((LinkPropertyInfo)property).getRelationship();
            String bosType = relation.getSupplierObject().getType().toString();
            EntityObjectInfo entryEntity = BarcodeUtils.getEntityByBosType(bosType);
            bosTypeMap.put(property.getName(), entryEntity);
        }
        return bosTypeMap;
    }

    private String getBillSelect(IMetaDataLoader loader, BOSObjectType billBosType, BOSObjectType entryBosType, IndBarcodeSetupInfo indBarcodeSetupInfo, IndBarcodeRuleInfo ruleInfo, boolean isBaseData) {
        boolean fHasBillProp = false;
        ArrayList<String> props = new ArrayList<String>();
        String propName = null;
        String[] propArr = null;
        IndBarcodeSetupEntryCollection setupEntries = indBarcodeSetupInfo.getEntry();
        int n = setupEntries.size();
        for (int i = 0; i < n; ++i) {
            IndBarcodeSetupEntryInfo entryInfo = setupEntries.get(i);
            propName = entryInfo.getFullName();
            if (StringUtils.isEmpty((String)propName)) continue;
            if (!props.contains(propName)) {
                props.add(propName);
            }
            if (fHasBillProp) continue;
            fHasBillProp = !propName.contains(".");
        }
        IndBarcodeRuleEntryCollection ruleEntries = ruleInfo.getEntry();
        int n2 = ruleEntries.size();
        for (int i = 0; i < n2; ++i) {
            IndBarcodeRuleEntryInfo entryInfo = ruleEntries.get(i);
            propName = entryInfo.getFullName();
            if (StringUtils.isEmpty((String)propName)) continue;
            if (!props.contains(propName)) {
                props.add(propName);
            }
            if (fHasBillProp) continue;
            fHasBillProp = !propName.contains(".");
        }
        StringBuffer oql = new StringBuffer();
        PropertyInfo propInfo = null;
        if (isBaseData) {
            EntityObjectInfo entity = loader.getEntity(billBosType);
            oql.append("select ");
            int n3 = props.size();
            for (int i = 0; i < n3; ++i) {
                propName = (String)props.get(i);
                propArr = propName.split("\\.");
                if (propArr.length == 1) {
                    oql.append(propName);
                } else if (propArr.length >= 2) {
                    oql.append(propName);
                }
                if (i + 1 >= n3) continue;
                oql.append(", ");
            }
        } else {
            EntityObjectInfo entryEntity = loader.getEntity(entryBosType);
            EntityObjectInfo billEntity = null;
            if (fHasBillProp) {
                billEntity = loader.getEntity(billBosType);
            }
            String parentName = this.getEntryParentName(entryEntity);
            oql.append("select ");
            int n4 = props.size();
            for (int i = 0; i < n4; ++i) {
                propName = (String)props.get(i);
                propArr = propName.split("\\.");
                if (propArr.length == 1) {
                    oql.append(parentName).append(".").append(propName);
                    propInfo = billEntity.getPropertyByName(propName);
                    if (propInfo instanceof LinkPropertyInfo) {
                        oql.append(".id, ").append(parentName).append(".");
                        oql.append(propName).append(".number");
                        oql.append(", ").append(parentName).append(".");
                        oql.append(propName).append(".name");
                    }
                } else if (propArr.length == 2) {
                    boolean isEntryProperty = BarcodeUtils.isEntryProperty(entryEntity, entryEntity.getPropertyByName(propArr[0]));
                    if (isEntryProperty) {
                        oql.append(propArr[1]);
                        propInfo = entryEntity.getPropertyByName(propArr[1]);
                        if (propInfo instanceof LinkPropertyInfo) {
                            oql.append(".id, ").append(propArr[1]).append(".number");
                            oql.append(", ").append(propArr[1]).append(".name");
                        }
                    } else {
                        oql.append(parentName).append(".");
                        oql.append(propName);
                    }
                } else if (propArr.length >= 3) {
                    oql.append(propArr[1]);
                    propInfo = entryEntity.getPropertyByName(propArr[1]);
                    if (propInfo instanceof LinkPropertyInfo) {
                        oql.append(".id, ").append(propArr[1]).append(".number");
                        oql.append(", ").append(propArr[1]).append(".name");
                        oql.append(", ").append(propArr[1]).append(".").append(propArr[2]);
                    }
                    logger.debug((Object)(" getBillSelect, prop 3 level: " + propName));
                }
                if (i + 1 >= n4) continue;
                oql.append(", ");
            }
        }
        logger.debug((Object)(" getBillSelect, select: " + oql));
        return oql.toString();
    }

    private String getEntryParentName(EntityObjectInfo entryEntity) {
        PropertyCollection props = entryEntity.getProperties();
        for (PropertyInfo property : props) {
            RelationshipInfo relation;
            if (!(property instanceof LinkPropertyInfo) || !RelationshipType.COMPOSITION.equals((Object)(relation = ((LinkPropertyInfo)property).getRelationship()).getType()) || !relation.getSupplierObject().getFullName().equals(entryEntity.getFullName()) || !relation.getClientCardinality().equals((Object)CardinalityType.ONE) || !relation.getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED)) continue;
            return property.getName();
        }
        return null;
    }

    private IObjectValue getBillInfo(ICoreBase iBill, String entryId, String parentID, String oqlSelect) throws BOSException, EASBizException {
        CoreBaseInfo billInfo = null;
        if (entryId == null) {
            return billInfo;
        }
        String oql = oqlSelect + " where id = '" + entryId + "'";
        billInfo = iBill.getValue(oql);
        return billInfo;
    }

    private IndBarcodeRuleEntryInfo getLiEntryInfo(Context ctx, IndBarcodeRuleInfo ruleInfo) {
        IndBarcodeRuleEntryCollection ruleEntries = ruleInfo.getEntry();
        IndBarcodeRuleEntryInfo liEntryInfo = null;
        int n = ruleEntries.size();
        for (int i = 0; i < n; ++i) {
            IndBarcodeRuleEntryInfo ruleEntryInfo = ruleEntries.get(i);
            FormtEnum entryType = ruleEntryInfo.getPerType();
            if (!FormtEnum.li.equals((Object)entryType)) continue;
            liEntryInfo = ruleEntryInfo;
        }
        return liEntryInfo;
    }

    private String generateBarcodeString(Context ctx, IndBarcodeRuleInfo ruleInfo, IObjectValue billInfo, Date barCodeDate, boolean isBaseData, String parentName, EntityObjectInfo entryEntity, IObjectValue billInfo1) throws BOSException, EASBizException {
        IndBarcodeRuleEntryCollection ruleEntries = ruleInfo.getEntry();
        StringBuffer barNum = new StringBuffer();
        IndBarcodeRuleEntryInfo ruleEntryInfo = null;
        String part = null;
        int n = ruleEntries.size();
        for (int i = 0; i < n; ++i) {
            part = null;
            ruleEntryInfo = ruleEntries.get(i);
            FormtEnum entryType = ruleEntryInfo.getPerType();
            if (!FormtEnum.li.equals((Object)entryType) && (part = BarcodeFacadeControllerBean.getBarcodePart(ctx, ruleEntryInfo, billInfo, barCodeDate, isBaseData, parentName, entryEntity, billInfo1)) != null && FormtEnum.property.equals((Object)entryType) && AttUsingModeEnum.part.equals((Object)ruleEntryInfo.getAttUsingMode())) {
                int interceptDic = new Integer(ruleEntryInfo.getInterceptDirection().getValue());
                part = this.interceptString(part, ruleEntryInfo.getInterceptPos(), ruleEntryInfo.getInterceptLength(), interceptDic);
            }
            if (i == n - 1 && n == 1 && FormtEnum.li.equals((Object)entryType)) {
                part = "li";
            }
            if (StringUtils.isEmpty(part)) continue;
            barNum.append(part);
        }
        String barcode = null;
        if (barNum.length() > 0) {
            barcode = barNum.toString();
        }
        return barcode;
    }

    private BigDecimal getMaxValue(Context ctx, String barNum, IndBarcodeRuleInfo ruleInfo, IObjectValue billInfo, Date barCodeDate, boolean isBaseData, IndBarcodeRuleEntryInfo liEntryInfo, BigDecimal thisBarcodeCount) throws EASBizException, BOSException {
        if (liEntryInfo != null) {
            BigDecimal maxValueBig = IndBarcodeRuleSNFactory.getLocalInstance(ctx).getBarcodeMaxValue(ruleInfo, barNum.toString(), liEntryInfo, thisBarcodeCount);
            String part = maxValueBig.toString();
            if (part == null) {
                logger.error((Object)"failed to generate barcode seq field");
                throw new EASBizException(new NumericExceptionSubItem("", "\u751f\u6210\u6761\u7801\u503c\u9519\u8bef"));
            }
            return maxValueBig;
        }
        return BigDecimal.ZERO;
    }

    private static String getBarcodePart(Context ctx, IndBarcodeRuleEntryInfo ruleEntryInfo, IObjectValue entryInfo, Date getBarcodePart, boolean isBaseData, String parentName, EntityObjectInfo entryEntity, IObjectValue billInfo1) throws BOSException, EASBizException {
        String part = null;
        FormtEnum entryType = ruleEntryInfo.getPerType();
        logger.debug((Object)(" entryType " + entryType.getValue()));
        if (FormtEnum.fasten.equals((Object)entryType)) {
            if (!StringUtils.isEmpty((String)ruleEntryInfo.getFormt())) {
                part = ruleEntryInfo.getFormt();
            }
        } else if (FormtEnum.property.equals((Object)entryType) && entryInfo != null) {
            String propName = ruleEntryInfo.getFullName();
            logger.debug((Object)(" ruleEntry, property " + entryType.getValue()));
            String[] propArr = propName.split("\\.");
            if (propArr.length == 1) {
                IObjectValue pInfo = isBaseData ? entryInfo : billInfo1;
                part = BarcodeFacadeControllerBean.getBillInfoBarcodeProp(pInfo, propName);
            } else if (propArr.length == 2) {
                part = BarcodeFacadeControllerBean.getBillInfoBarcodeProp(entryInfo, propArr[1]);
                Object propValObje = null;
                boolean isEntryProperty = BarcodeUtils.isEntryProperty(entryEntity, entryEntity.getPropertyByName(propArr[0]));
                if (isEntryProperty) {
                    part = BarcodeFacadeControllerBean.getBillInfoBarcodeProp(entryInfo, propArr[1]);
                    propValObje = entryInfo.get(propArr[1]);
                    if (propValObje instanceof IObjectValue) {
                        part = propValObje instanceof MaterialInfo ? ((IObjectValue)propValObje).getString("number") : ((IObjectValue)propValObje).getString("number");
                    }
                } else {
                    IObjectValue pInfo;
                    IObjectValue iObjectValue = pInfo = entryInfo.getObjectValue(parentName) == null ? entryInfo : billInfo1;
                    if (pInfo != null && (propValObje = pInfo.get(propArr[0])) instanceof IObjectValue) {
                        part = propValObje instanceof MaterialInfo ? ((IObjectValue)propValObje).getString(propArr[1]) : ((IObjectValue)propValObje).getString(propArr[1]);
                    }
                }
            } else if (propArr.length > 2) {
                part = BarcodeFacadeControllerBean.getBillInfoBarcodeProp(entryInfo, propArr[1]);
            }
        } else if (FormtEnum.sysDate.equals((Object)entryType)) {
            SimpleDateFormat time = new SimpleDateFormat(ruleEntryInfo.getFormt());
            if (getBarcodePart == null) {
                getBarcodePart = new Date();
            }
            part = time.format(getBarcodePart);
        } else if (FormtEnum.li.equals((Object)entryType) && (part = IndBarcodeRuleSNFactory.getLocalInstance(ctx).generateBarcode(ruleEntryInfo, getBarcodePart)) == null) {
            logger.error((Object)"failed to generate barcode seq field");
            throw new EASBizException(new NumericExceptionSubItem("", "\u751f\u6210\u6761\u7801\u503c\u9519\u8bef"));
        }
        logger.debug((Object)(" barcode Part: " + part));
        return part;
    }

    private String interceptString(String initStr, int interceptPos, int interceptLength, int interceptDic) {
        logger.info((Object)("interceptString:" + initStr + " ,interceptPos = " + interceptPos + " ,interceptLength = " + interceptLength + " , interceptDic = " + interceptDic));
        int beginIndex = 0;
        int endIndex = initStr.length();
        if (interceptLength > 0 && interceptPos > 0 && interceptDic >= 0 && interceptPos <= initStr.length()) {
            if (interceptDic == 0) {
                beginIndex = interceptPos <= initStr.length() ? initStr.length() - (interceptPos - 1) - interceptLength : 0;
            } else if (interceptDic == 1) {
                beginIndex = interceptPos <= initStr.length() ? interceptPos - 1 : initStr.length() - 1;
            }
        }
        beginIndex = beginIndex >= 0 ? beginIndex : 0;
        endIndex = beginIndex + interceptLength;
        int n = endIndex = endIndex < initStr.length() ? endIndex : initStr.length();
        if (interceptDic == 0) {
            endIndex = interceptLength < initStr.length() - interceptPos ? endIndex : initStr.length() - interceptPos + 1;
        }
        logger.info((Object)("beginIndex" + beginIndex + ",endIndex" + endIndex));
        if (beginIndex < 0 || beginIndex > endIndex || endIndex > initStr.length()) {
            return "";
        }
        return initStr.substring(beginIndex, endIndex);
    }

    private static String getBillInfoBarcodeProp(IObjectValue pInfo, String propName) {
        if (pInfo == null) {
            logger.error((Object)"getBillInfoBarcodeProp, pInfo is null!");
            return null;
        }
        String part = null;
        Object val = pInfo.get(propName);
        if (val != null) {
            if (val instanceof CoreBaseInfo) {
                CoreBaseInfo linkObj = (CoreBaseInfo)val;
                if (linkObj.get("number") != null) {
                    part = linkObj.get("number").toString();
                }
            } else {
                part = val instanceof BigDecimal ? (((BigDecimal)val).compareTo(BigDecimal.ZERO) != 0 ? ((BigDecimal)val).stripTrailingZeros().toPlainString() : "0") : val.toString();
            }
        }
        return part;
    }

    private boolean isUniqueBarcode(IBarcodeDossier iBarcode, String barcode) throws BOSException, EASBizException {
        boolean fUnique = iBarcode.exists("select id where number = '" + barcode + "'");
        return fUnique;
    }

    private BarcodeDossierInfo buildBarcodeInfo1(Context ctx, String barcode, IndBarcodeSetupInfo indBarcodeSetupInfo, IObjectValue billInfo, IObjectValue entryInfo, BarcodeGenerateParamInfo paramInfo, boolean isBaseData, StorageOrgUnitInfo storageInfo, String entrykey) {
        Map<String, String> rowValueMap = paramInfo.getRowValueMap();
        BarcodeDossierInfo barcodeInfo = new BarcodeDossierInfo();
        barcodeInfo.setId(BOSUuid.create((BOSObjectType)barcodeInfo.getBOSType()));
        barcodeInfo.setNumber(barcode);
        barcodeInfo.setBarRule(indBarcodeSetupInfo.getMaster());
        barcodeInfo.setCreateTime(this.getTime());
        barcodeInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        IndBarcodeSetupEntryCollection setupEntries = indBarcodeSetupInfo.getEntry();
        if (setupEntries == null || setupEntries.size() == 0) {
            return barcodeInfo;
        }
        BarcodeDossierEntryCollection entries = new BarcodeDossierEntryCollection();
        String propName = null;
        String[] nameArr = null;
        Object propVal = null;
        if (billInfo == null) {
            logger.debug((Object)" the entry's parent property name is not parent");
        }
        MaterialInfo materialInfo = null;
        if (entryInfo instanceof SCMBillEntryBaseInfo) {
            materialInfo = ((SCMBillEntryBaseInfo)entryInfo).getMaterial();
        }
        if (billInfo instanceof ManufactureOrderInfo) {
            materialInfo = ((ManufactureOrderInfo)billInfo).getMaterial();
        }
        if (billInfo instanceof MaterialInfo) {
            materialInfo = (MaterialInfo)billInfo;
        }
        FaCurCardInfo curCarInfo = null;
        if (billInfo instanceof FaCurCardInfo) {
            curCarInfo = (FaCurCardInfo)billInfo;
        }
        IndBarcodeSetupEntryInfo setupEntryInfo = null;
        int n = setupEntries.size();
        for (int i = 0; i < n; ++i) {
            setupEntryInfo = setupEntries.get(i);
            propName = setupEntryInfo.getFullName();
            propVal = null;
            BarcodeDossierEntryInfo bEntryInfo = null;
            IndBarcodeMasterEntryInfo propertyInfo = setupEntryInfo.getProperty();
            if (StringUtils.isEmpty((String)propName) || propName.equals("materialName") || propName.equals("material_model")) {
                propVal = null;
                if (setupEntryInfo.getProperty() != null) {
                    String masterEntryName = setupEntryInfo.getProperty().getName();
                    if (!StringUtils.isEmpty((String)masterEntryName) && "\u89c4\u683c\u578b\u53f7".equals(masterEntryName) && materialInfo != null) {
                        try {
                            if (materialInfo.getId() != null) {
                                materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()));
                                propVal = materialInfo.getModel();
                            }
                        }
                        catch (EASBizException e) {
                            e.printStackTrace();
                        }
                        catch (BOSException e) {
                            e.printStackTrace();
                        }
                    }
                    if (!StringUtils.isEmpty((String)masterEntryName) && "\u7269\u6599\u540d\u79f0".equals(masterEntryName) && materialInfo != null) {
                        propVal = materialInfo.getName();
                    }
                }
            } else {
                nameArr = propName.split("\\.");
                if (nameArr.length == 1) {
                    if (billInfo != null) {
                        propVal = billInfo.get(propName);
                    }
                    if (propVal instanceof IObjectValue) {
                        propVal = ((IObjectValue)propVal).get("number");
                    }
                } else if (nameArr.length == 2) {
                    propVal = isBaseData ? this.getPropVal(entryInfo, propName, 0) : (entrykey != null && entrykey.endsWith(nameArr[0]) ? this.getPropVal(entryInfo, propName, 1) : this.getPropVal(billInfo, propName, 0));
                } else if (nameArr.length > 2) {
                    propVal = this.getPropVal(entryInfo, propName, 1);
                }
            }
            if (rowValueMap.containsKey(propertyInfo.getName())) {
                propVal = rowValueMap.get(propertyInfo.getName());
            }
            if ((bEntryInfo = this.buildBarcodeEntryInfo(ctx, barcodeInfo, propVal, setupEntryInfo, rowValueMap, paramInfo.getBarcodeQty())) == null) continue;
            entries.add(bEntryInfo);
        }
        barcodeInfo.setMaterial(materialInfo);
        if (materialInfo != null && materialInfo.getBaseUnit() != null) {
            barcodeInfo.setMeasure(materialInfo.getBaseUnit().getId().toString());
        }
        if (paramInfo.getBarcodeQty() != null) {
            barcodeInfo.setQty(paramInfo.getBarcodeQty());
        }
        barcodeInfo.setFaCurCard(curCarInfo);
        barcodeInfo.getEntrys().addCollection(entries);
        return barcodeInfo;
    }

    private BarcodeDossierInfo buildBarcodeInfo(Context ctx, String barcode, IndBarcodeSetupInfo indBarcodeSetupInfo, IObjectValue entryInfo, BarcodeGenerateParamInfo paramInfo, boolean isBaseData, StorageOrgUnitInfo storageInfo) {
        Map<String, String> rowValueMap = paramInfo.getRowValueMap();
        BarcodeDossierInfo barcodeInfo = new BarcodeDossierInfo();
        barcodeInfo.setId(BOSUuid.create((BOSObjectType)barcodeInfo.getBOSType()));
        barcodeInfo.setNumber(barcode);
        barcodeInfo.setBarRule(indBarcodeSetupInfo.getMaster());
        barcodeInfo.setCreateTime(this.getTime());
        barcodeInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        IndBarcodeSetupEntryCollection setupEntries = indBarcodeSetupInfo.getEntry();
        if (setupEntries == null || setupEntries.size() == 0) {
            return barcodeInfo;
        }
        BarcodeDossierEntryCollection entries = new BarcodeDossierEntryCollection();
        String propName = null;
        String[] nameArr = null;
        Object propVal = null;
        IObjectValue billInfo = null;
        billInfo = isBaseData ? entryInfo : entryInfo.getObjectValue("parent");
        if (billInfo == null) {
            logger.debug((Object)" the entry's parent property name is not parent");
        }
        MaterialInfo materialInfo = null;
        if (entryInfo instanceof SCMBillEntryBaseInfo) {
            materialInfo = ((SCMBillEntryBaseInfo)entryInfo).getMaterial();
        }
        if (billInfo instanceof ManufactureOrderInfo) {
            materialInfo = ((ManufactureOrderInfo)billInfo).getMaterial();
        }
        if (billInfo instanceof MaterialInfo) {
            materialInfo = (MaterialInfo)billInfo;
        }
        FaCurCardInfo curCarInfo = null;
        if (billInfo instanceof FaCurCardInfo) {
            curCarInfo = (FaCurCardInfo)billInfo;
        }
        IndBarcodeSetupEntryInfo setupEntryInfo = null;
        int n = setupEntries.size();
        for (int i = 0; i < n; ++i) {
            setupEntryInfo = setupEntries.get(i);
            propName = setupEntryInfo.getFullName();
            propVal = null;
            BarcodeDossierEntryInfo bEntryInfo = null;
            if (StringUtils.isEmpty((String)propName) || propName.equals("materialName") || propName.equals("material_model")) {
                propVal = null;
                if (setupEntryInfo.getProperty() != null) {
                    String masterEntryName = setupEntryInfo.getProperty().getName();
                    if (!StringUtils.isEmpty((String)masterEntryName) && "\u89c4\u683c\u578b\u53f7".equals(masterEntryName) && materialInfo != null) {
                        try {
                            if (materialInfo.getId() != null) {
                                materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()));
                                propVal = materialInfo.getModel();
                            }
                        }
                        catch (EASBizException e) {
                            e.printStackTrace();
                        }
                        catch (BOSException e) {
                            e.printStackTrace();
                        }
                    }
                    if (!StringUtils.isEmpty((String)masterEntryName) && "\u7269\u6599\u540d\u79f0".equals(masterEntryName) && materialInfo != null) {
                        propVal = materialInfo.getName();
                    }
                }
            } else {
                nameArr = propName.split("\\.");
                if (nameArr.length == 1) {
                    if (billInfo != null) {
                        propVal = billInfo.get(propName);
                    }
                    if (propVal instanceof IObjectValue) {
                        propVal = ((IObjectValue)propVal).get("number");
                    }
                } else if (nameArr.length == 2) {
                    propVal = isBaseData ? this.getPropVal(entryInfo, propName, 0) : this.getPropVal(entryInfo, propName, 1);
                } else if (nameArr.length > 2) {
                    propVal = this.getPropVal(entryInfo, propName, 1);
                }
            }
            if (rowValueMap.containsKey(propName) && (propVal == null || "".equals(propVal))) {
                propVal = rowValueMap.get(propName);
            }
            if ((bEntryInfo = this.buildBarcodeEntryInfo(ctx, barcodeInfo, propVal, setupEntryInfo, rowValueMap, paramInfo.getBarcodeQty())) == null) continue;
            entries.add(bEntryInfo);
        }
        barcodeInfo.setMaterial(materialInfo);
        if (materialInfo != null && materialInfo.getBaseUnit() != null) {
            barcodeInfo.setMeasure(materialInfo.getBaseUnit().getId().toString());
        }
        if (paramInfo.getBarcodeQty() != null) {
            barcodeInfo.setQty(paramInfo.getBarcodeQty());
        }
        barcodeInfo.setFaCurCard(curCarInfo);
        barcodeInfo.getEntrys().addCollection(entries);
        return barcodeInfo;
    }

    private BarcodeDossierTemplateInfo findExistTemplate(Context ctx, BarcodeDossierInfo info, String currDataStr) throws BOSException {
        String codemd5 = this.getStrMd5(currDataStr);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("codemd5", (Object)codemd5));
        view.setTopCount(1);
        BarcodeDossierTemplateCollection coll = BarcodeDossierTemplateFactory.getLocalInstance(ctx).getBarcodeDossierTemplateCollection(view);
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    private String getStrMd5(String code) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(code.getBytes());
            byte[] signarr = md5.digest();
            StringBuffer buf = new StringBuffer("");
            for (int offset = 0; offset < signarr.length; ++offset) {
                int i = signarr[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
            return buf.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Md5.hash() failed!", e);
        }
    }

    private BarcodeDossierEntryCollection getNotTpFiledColl(Context ctx, BarcodeDossierInfo info) throws BOSException {
        IndBarcodeMasterInfo materInfo = info.getBarRule();
        IndBarcodeMasterEntryCollection materEntrys = materInfo.getEntry();
        BarcodeDossierEntryCollection entrys = info.getEntrys();
        BarcodeDossierEntryCollection revColl = new BarcodeDossierEntryCollection();
        int count = materEntrys.size();
        for (int i = 0; i < count; ++i) {
            if (materEntrys.get(i).isTpField()) continue;
            revColl.add(this.getTargetItemInfo(entrys, materEntrys.get(i)));
        }
        return revColl;
    }

    private BarcodeDossierEntryCollection getTpFiledColl(Context ctx, BarcodeDossierInfo info) throws BOSException {
        IndBarcodeMasterInfo materInfo = info.getBarRule();
        boolean needReLoad = true;
        IndBarcodeMasterEntryCollection materEntrys = null;
        if (materInfo.getEntry() != null && materInfo.getEntry().size() > 0 && materInfo.getEntry().get(0).getName() != null) {
            needReLoad = false;
        }
        if (needReLoad) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)new ObjectUuidPK(materInfo.getId())));
            materEntrys = IndBarcodeMasterEntryFactory.getLocalInstance(ctx).getIndBarcodeMasterEntryCollection(view);
            info.getBarRule().put("Entry", (Object)materEntrys);
        } else {
            materEntrys = materInfo.getEntry();
        }
        BarcodeDossierEntryCollection entrys = info.getEntrys();
        BarcodeDossierEntryCollection revColl = new BarcodeDossierEntryCollection();
        int count = materEntrys.size();
        for (int i = 0; i < count; ++i) {
            if (!materEntrys.get(i).isTpField()) continue;
            revColl.add(this.getTargetItemInfo(entrys, materEntrys.get(i)));
        }
        return revColl;
    }

    private String getTemplateModeStr(Context ctx, BarcodeDossierEntryCollection entrys) throws BOSException {
        TreeMap<String, String> fieldMpping = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        int count = entrys.size();
        for (int i = 0; i < count; ++i) {
            fieldMpping.put(entrys.get(i).getDisplayName().getName(), entrys.get(i).getValue() == null ? "" : entrys.get(i).getValue());
        }
        return Json.toString(fieldMpping, true);
    }

    private BarcodeDossierEntryInfo getTargetItemInfo(BarcodeDossierEntryCollection entrys, IndBarcodeMasterEntryInfo masterInfo) {
        int count = entrys.size();
        for (int i = 0; i < count; ++i) {
            if (!masterInfo.getId().equals((Object)entrys.get(i).getDisplayName().getId())) continue;
            return entrys.get(i);
        }
        return null;
    }

    private BarcodeDossierTemplateInfo covert2Template(BarcodeDossierInfo info, BarcodeDossierEntryCollection entrys, String currDataStr) {
        BarcodeDossierTemplateInfo templateInfo = new BarcodeDossierTemplateInfo();
        templateInfo.setNumber(info.getNumber());
        templateInfo.setBarRule(info.getBarRule());
        String codemd5 = this.getStrMd5(currDataStr);
        templateInfo.setCodeinfo(currDataStr);
        templateInfo.setCodemd5(codemd5);
        BarcodeDossierTemplateEntryCollection dossierEntryCol = new BarcodeDossierTemplateEntryCollection();
        int m = entrys.size();
        for (int i = 0; i < m; ++i) {
            BarcodeDossierEntryInfo entryInfo = entrys.get(i);
            BarcodeDossierTemplateEntryInfo newEntryInfo = new BarcodeDossierTemplateEntryInfo();
            newEntryInfo.putAll((IObjectValue)entryInfo);
            newEntryInfo.setId(null);
            newEntryInfo.setParent(templateInfo);
            dossierEntryCol.add(newEntryInfo);
        }
        templateInfo.put("entrys", (Object)dossierEntryCol);
        return templateInfo;
    }

    private Object getPropVal(IObjectValue info, String propName, int index) {
        Object propVal = null;
        String[] propArr = propName.split("\\.");
        for (int i = index; i < propArr.length; ++i) {
            String propNameAr = propArr[index];
            propVal = info.get(propNameAr);
            if (!(propVal instanceof IObjectValue)) continue;
            propVal = this.getPropVal((IObjectValue)propVal, propName, ++i);
            break;
        }
        return propVal;
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private BarcodeDossierEntryInfo buildBarcodeEntryInfo(Context ctx, BarcodeDossierInfo barcodeInfo, Object propVal, IndBarcodeSetupEntryInfo setupEntryInfo, Map<String, String> rowValueMap, BigDecimal barcodeQty) {
        if (setupEntryInfo == null) {
            logger.debug((Object)" setupEntryInfo is null");
            return null;
        }
        String masterEntryName = setupEntryInfo.getProperty().getName();
        logger.debug((Object)(" propVal:" + propVal));
        logger.debug((Object)(" setupEntryInfo:" + setupEntryInfo));
        BarcodeDossierEntryInfo entryInfo = new BarcodeDossierEntryInfo();
        entryInfo.setName(setupEntryInfo.getFullName());
        entryInfo.setDisplayName(setupEntryInfo.getProperty());
        entryInfo.setSeq(setupEntryInfo.getProperty().getSeq());
        String strVal = null;
        if (propVal != null) {
            BigDecimal amt;
            strVal = propVal instanceof IObjectValue ? (propVal instanceof MaterialInfo ? ((IObjectValue)propVal).getString("number") : ((IObjectValue)propVal).getString("number")) : (propVal instanceof BigDecimal ? ((amt = (BigDecimal)propVal).compareTo(BigDecimal.ZERO) == 0 ? "0" : amt.stripTrailingZeros().toPlainString()) : propVal.toString());
            entryInfo.setValue(strVal);
        }
        if ("assistID".equals(entryInfo.getName())) {
            barcodeInfo.setAssistNature(strVal);
        }
        if ("\u6570\u91cf".equals(masterEntryName) && barcodeQty != null) {
            entryInfo.setValue(barcodeQty.stripTrailingZeros().toPlainString());
        }
        if ("barcodeQ".equals(entryInfo.getName()) && strVal != null && !"".equals(strVal)) {
            barcodeInfo.setQty(new BigDecimal(strVal));
        }
        if ("barcodeRemart".equals(entryInfo.getName())) {
            barcodeInfo.setRemate(strVal);
        }
        return entryInfo;
    }

    @Override
    protected BarcodeGenResult _importBarcodes(Context ctx, BarcodeExcelData excelData) throws BOSException, EASBizException {
        if (excelData == null || StringUtils.isEmpty((String)excelData.getBarcodeMasterId()) || excelData.getBarcodeSetupInfo() == null || excelData.getRows().size() == 0) {
            logger.error((Object)" no data to import");
            return null;
        }
        logger.debug((Object)(" excelData: " + excelData.getRows()));
        String masterId = excelData.getBarcodeMasterId();
        String oql = "select *, Entry.* where id = '" + masterId + "'";
        IIndBarcodeMaster iMaster = IndBarcodeMasterFactory.getLocalInstance(ctx);
        IndBarcodeMasterInfo barcodeMasterInfo = iMaster.getIndBarcodeMasterInfo(oql);
        IndBarcodeMasterEntryCollection mEntries = barcodeMasterInfo.getEntry();
        BarcodeGenResult genRslt = new BarcodeGenResult();
        int status = 0;
        BarcodeDossierCollection barcodes = new BarcodeDossierCollection();
        String msg = null;
        IBarcodeDossier iBarcode = BarcodeDossierFactory.getLocalInstance(ctx);
        List<Map<String, String>> rawRows = excelData.getRows();
        IBarcodeDossierTemplate iBarcodeDossierTemplate = BarcodeDossierTemplateFactory.getLocalInstance(ctx);
        int n = rawRows.size();
        for (int i = 0; i < n; ++i) {
            Map<String, String> rRow = rawRows.get(i);
            BarcodeDossierInfo bInfo = this.buildBarcodeInfo(ctx, rRow, mEntries, excelData.getBarcodeSetupInfo());
            bInfo.setStorageOrgUnit(excelData.getOrgUnitInfo());
            bInfo.setBarRule(barcodeMasterInfo);
            BarcodeDossierEntryCollection entrys = this.getTpFiledColl(ctx, bInfo);
            String currDataStr = this.getTemplateModeStr(ctx, entrys);
            BarcodeDossierTemplateInfo templateinfo = this.findExistTemplate(ctx, bInfo, currDataStr);
            if (templateinfo == null) {
                templateinfo = this.covert2Template(bInfo, entrys, currDataStr);
                iBarcodeDossierTemplate.save((CoreBaseInfo)templateinfo);
            }
            bInfo.setTemplate(templateinfo);
            barcodes.add(bInfo);
            try {
                boolean fUnique = this.isUniqueBarcode(iBarcode, bInfo.getNumber());
                if (fUnique) {
                    logger.error((Object)" duplicated barcode ");
                    msg = "\u6761\u7801\u91cd\u590d\uff0c" + bInfo.getNumber();
                    genRslt.addMessage(msg);
                    status = 1;
                    continue;
                }
                logger.error((Object)(" save barcode: " + bInfo));
                IObjectPK iObjectPK = iBarcode.save((CoreBaseInfo)bInfo);
                continue;
            }
            catch (EASBizException e) {
                msg = "\u5bfc\u5165[" + bInfo.getNumber() + "]\u6761\u7801\u4fdd\u5b58\u51fa\u9519\uff0c" + e.getMessage();
                genRslt.addMessage(msg);
                status = 2;
            }
        }
        if (barcodes.isEmpty()) {
            status = -1;
        }
        genRslt.setBarcodes(barcodes);
        genRslt.setStatus(status);
        return genRslt;
    }

    private BarcodeDossierInfo buildBarcodeInfo(Context ctx, Map<String, String> rRow, IndBarcodeMasterEntryCollection mEntries, IndBarcodeSetupInfo indbarcodeSetupInfo) {
        Iterator<String> it = rRow.keySet().iterator();
        BarcodeDossierInfo barcodeInfo = new BarcodeDossierInfo();
        BarcodeDossierEntryCollection entries = new BarcodeDossierEntryCollection();
        IndBarcodeSetupEntryCollection indBarcodesetuoCol = indbarcodeSetupInfo.getEntry();
        int m = mEntries.size();
        for (int j = 0; j < m; ++j) {
            IndBarcodeMasterEntryInfo mEntry = mEntries.get(j);
            BarcodeDossierEntryInfo entryInfo = new BarcodeDossierEntryInfo();
            entryInfo.setSeq(mEntry.getSeq());
            entryInfo.setDisplayName(mEntry);
            entries.add(entryInfo);
            int size = indBarcodesetuoCol.size();
            for (int i = 0; i < size; ++i) {
                IndBarcodeSetupEntryInfo setEntryInfo = indBarcodesetuoCol.get(i);
                if (!setEntryInfo.getProperty().getId().equals((Object)mEntry.getId())) continue;
                entryInfo.setName(setEntryInfo.getFullName());
            }
        }
        block4: while (it.hasNext()) {
            String key = it.next();
            if (key.equals("barcode")) {
                barcodeInfo.setNumber(rRow.get(key));
                continue;
            }
            if (key.equals("billNum")) {
                barcodeInfo.setSrcBillNumber(rRow.get(key));
                continue;
            }
            int m2 = mEntries.size();
            for (int j = 0; j < m2; ++j) {
                IndBarcodeMasterEntryInfo mEntry = mEntries.get(j);
                if (!mEntry.getId().toString().equals(key)) continue;
                BarcodeDossierEntryInfo entryInfo = entries.get(j);
                entryInfo.setValue(rRow.get(key));
                String value = rRow.get(key);
                if ("\u6279\u53f7".equals(mEntry.getName()) && value != null) {
                    barcodeInfo.setBatchNumber(value.toString());
                }
                if ("\u6570\u91cf".equals(mEntry.getName()) && value != null && !"".equals(value)) {
                    barcodeInfo.setQty(new BigDecimal(value.toString()));
                }
                if (!"\u7269\u6599\u7f16\u7801".equals(mEntry.getName()) || value == null || "".equals(value)) continue block4;
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)value));
                viewInfo.setFilter(filter);
                SelectorItemCollection coll = new SelectorItemCollection();
                coll.add(new SelectorItemInfo("name"));
                coll.add(new SelectorItemInfo("model"));
                coll.add(new SelectorItemInfo("*"));
                viewInfo.setSelector(coll);
                try {
                    MaterialCollection materialcol = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(viewInfo);
                    if (materialcol.size() <= 0) continue block4;
                    MaterialInfo materialInfo = materialcol.get(0);
                    barcodeInfo.setMaterial(materialInfo);
                    barcodeInfo.setModel(materialInfo.getModel());
                    barcodeInfo.setMaterialName(materialInfo.getName());
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                continue block4;
            }
        }
        barcodeInfo.getEntrys().addCollection(entries);
        return barcodeInfo;
    }
}

