/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.scm.BarcodeDictEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodeRuleCollection;
import com.kingdee.eas.barcode.scm.BarcodeRuleEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodeRuleFactory;
import com.kingdee.eas.barcode.scm.BarcodeRuleInfo;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.app.AbstractBarcodeGenerateFacodeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.enums.Enum;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.log4j.Logger;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.BarcodeUtil;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;

public class BarcodeGenerateFacodeControllerBean
extends AbstractBarcodeGenerateFacodeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.barcode.app.BarcodeGenerateFacodeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] _generateBarcodePicture(Context ctx, String barcode, String type, Map config) throws BOSException, EASBizException {
        config.put("barcode", barcode);
        config.put("type", type);
        byte[] result = null;
        int dpi = 0;
        if (config.get("dpi") != null) {
            try {
                dpi = Integer.parseInt("dpi");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (dpi == 0) {
            dpi = 200;
        }
        try {
            Configuration cfg = this.buildConfiguration(config);
            BarcodeUtil util = BarcodeUtil.getInstance();
            BarcodeGenerator gen = util.createBarcodeGenerator(cfg);
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                BitmapCanvasProvider canvas = new BitmapCanvasProvider((OutputStream)out, "image/jpeg", dpi, 12, false, 0);
                gen.generateBarcode((CanvasProvider)canvas, barcode);
                canvas.finish();
                result = out.toByteArray();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem(e.getMessage(), e.getMessage()));
        }
        return result;
    }

    @Override
    protected List _generateBarcodeString(Context ctx, String barcodeRuleID, String objectPk) throws BOSException, EASBizException {
        BarcodeRuleInfo ruleInfo = this.getBarcodeRuleEnabled(ctx, barcodeRuleID);
        if (ruleInfo == null) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"3_BarcodeAnalysisFacadeControllerBean", (Locale)ctx.getLocale())));
        }
        ICoreBase iCoreBase = this.getInterface(ctx, BarcodeUtils.getEntityByBosType(ruleInfo.getEntityBosType()));
        CoreBaseInfo value = iCoreBase.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)objectPk)));
        if (value == null) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"28_BarcodeGenerateFacodeControllerBean", (Locale)ctx.getLocale())));
        }
        List result = this._generateBarcodeString(ctx, ruleInfo, (IObjectValue)value);
        return result;
    }

    protected BarcodeRuleInfo getBarcodeRuleEnabled(Context ctx, String id) throws BOSException, EASBizException {
        if (id == null) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"29_BarcodeGenerateFacodeControllerBean", (Locale)ctx.getLocale())));
        }
        BarcodeRuleInfo ruleInfo = null;
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection selectorColl = new SelectorItemCollection();
        selectorColl.add("*");
        selectorColl.add("CU.*");
        selectorColl.add("barcodeType.*");
        selectorColl.add("details.*");
        selectorColl.add("details.barcodeDict.*");
        selectorColl.add("details.barcodeDict.details.*");
        ev.setSelector(selectorColl);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        ev.setFilter(filter);
        BarcodeRuleCollection coll = BarcodeRuleFactory.getLocalInstance(ctx).getBarcodeRuleCollection(ev);
        if (coll != null && coll.size() > 0) {
            ruleInfo = coll.get(0);
        }
        return ruleInfo;
    }

    @Override
    protected List _generateBarcodeString(Context ctx, String barcodeRuleID, IObjectValue iObjectValue) throws BOSException, EASBizException {
        BarcodeRuleInfo ruleInfo = this.getBarcodeRuleEnabled(ctx, barcodeRuleID);
        if (ruleInfo == null) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"3_BarcodeAnalysisFacadeControllerBean", (Locale)ctx.getLocale())));
        }
        List result = this._generateBarcodeString(ctx, ruleInfo, iObjectValue);
        return result;
    }

    protected List _generateBarcodeString(Context ctx, BarcodeRuleInfo ruleInfo, IObjectValue value) throws BOSException, EASBizException {
        if (value == null || ruleInfo.getDetails() == null || ruleInfo.getDetails().size() == 0) {
            return null;
        }
        String entryField = ruleInfo.getDetails().get(0).getProperty();
        if (entryField.indexOf(".") > -1) {
            entryField = entryField.substring(0, entryField.lastIndexOf("."));
        }
        ArrayList list = new ArrayList();
        this.getNeedTranColl(value, entryField, list);
        ArrayList<String> barcodes = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            String barcode = this._generateSingeleBarcode(ctx, ruleInfo, (IObjectValue)list.get(i));
            barcodes.add(barcode);
        }
        return barcodes;
    }

    protected void getNeedTranColl(IObjectValue objValue, String field, List list) {
        if (field.indexOf(".") > -1) {
            String[] ss = field.split("\\.");
            IObjectCollection temp = (IObjectCollection)objValue.get(ss[0]);
            field = field.substring(field.indexOf(".") + 1, field.length());
            for (int i = 0; i < temp.size(); ++i) {
                this.getNeedTranColl(temp.getObject(i), field, list);
            }
        } else {
            IObjectCollection temp = (IObjectCollection)objValue.get(field);
            for (int i = 0; i < temp.size(); ++i) {
                list.add(temp.getObject(i));
            }
            return;
        }
    }

    protected String _generateSingeleBarcode(Context ctx, BarcodeRuleInfo ruleInfo, IObjectValue obj) throws EASBizException, BOSException {
        int i;
        EntityObjectInfo entity = BarcodeUtils.getEntityByBosType(obj.getBOSType().toString());
        char[] ss = new char[ruleInfo.getLength()];
        for (i = 0; i < ss.length; ++i) {
            ss[i] = 48;
        }
        for (i = 0; i < ruleInfo.getDetails().size(); ++i) {
            BarcodeRuleEntryInfo entry = ruleInfo.getDetails().get(i);
            String[] keys = entry.getProperty().split("\\.");
            String key = keys[keys.length - 1];
            int start = entry.getStartsWith();
            int end = entry.getEndsWith();
            int length = end - start + 1;
            String value = this.getTranValue(ctx, obj, entity.getPropertyByName(key), key, length);
            String barcode = null;
            if (value != null) {
                BarcodeDictEntryInfo dictEntry;
                if (entry.getBarcodeDict() != null && (dictEntry = entry.getBarcodeDict().getDetailByNumber(value)) != null) {
                    barcode = dictEntry.getBarcode();
                }
                if (barcode == null) {
                    barcode = value;
                }
            }
            if (barcode == null || barcode.length() != length) continue;
            char[] tempArr = barcode.toCharArray();
            int count = start - 1;
            for (int j = 0; j < tempArr.length; ++j) {
                ss[count] = tempArr[j];
                ++count;
            }
        }
        return new String(ss);
    }

    public String getTranValue(Context ctx, IObjectValue easValue, PropertyInfo propertyInfo, String key, int length) throws BOSException, EASBizException {
        String dataType = propertyInfo.getString("dataType");
        Object value = easValue.get(key);
        if (value != null) {
            if (propertyInfo instanceof LinkPropertyInfo) {
                IObjectValue fieldValue = (IObjectValue)value;
                String number = null;
                if (fieldValue.get("number") == null) {
                    EntityObjectInfo tEntity = BarcodeUtils.getEntityByBosType(fieldValue.getBOSType().toString());
                    ICoreBase icb = this.getInterface(ctx, tEntity);
                    fieldValue = icb.getValue("select id,number where id='" + fieldValue.get("id").toString() + "'");
                }
                number = (String)fieldValue.get("number");
                return number;
            }
            if ("Enum".equals(dataType)) {
                return ((Enum)value).getName();
            }
            if ("Boolean".equals(dataType)) {
                if ("true".equalsIgnoreCase(value.toString())) {
                    return "1";
                }
                return "0";
            }
            if ("Date".equals(dataType) || "TimeStamp".equals(dataType)) {
                String temp = BarcodeUtils.SIMPLE_DATE_FORMAT.format(value);
                return temp.replaceAll("-", "");
            }
            if ("BigDecimal".equals(dataType)) {
                String temp = value.toString();
                if (temp == null) {
                    return null;
                }
                temp = temp.replaceAll("\\.", "");
                while (temp.length() < length) {
                    temp = "0" + temp;
                }
                return temp;
            }
            if ("Integer".equals(dataType)) {
                String temp = value.toString();
                if (temp == null) {
                    return null;
                }
                while (temp.length() < length) {
                    temp = "0" + temp;
                }
                return temp;
            }
            return value.toString();
        }
        return null;
    }

    public ICoreBase getInterface(Context ctx, EntityObjectInfo entity) throws BOSException {
        return (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)entity.getType());
    }

    public Configuration buildConfiguration(Map config) {
        DefaultConfiguration attr;
        String type;
        DefaultConfiguration cfg = new DefaultConfiguration("barcode");
        boolean autoMatch = false;
        if (config.get("autoMatch") != null && !"".equals(config.get("autoMatch").toString().trim())) {
            try {
                autoMatch = Boolean.valueOf(config.get("autoMatch").toString());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if ((type = (String)config.get("type")) == null) {
            type = "code128";
        }
        DefaultConfiguration child = new DefaultConfiguration(type);
        cfg.addChild((Configuration)child);
        if (config.get("height") != null && !"".equals(config.get("height").toString().trim())) {
            try {
                double height = Double.parseDouble(config.get("height").toString());
                if (height != 0.0) {
                    attr = new DefaultConfiguration("height");
                    attr.setValue(height + "");
                    child.addChild((Configuration)attr);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (config.get("modelWidth") != null && !"".equals(config.get("modelWidth").toString().trim())) {
            try {
                double modelWidth = Double.parseDouble(config.get("modelWidth").toString());
                if (modelWidth != 0.0) {
                    attr = new DefaultConfiguration("module-width");
                    attr.setValue(modelWidth + "");
                    child.addChild((Configuration)attr);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (config.get("shape") != null && !"".equals(config.get("shape").toString().trim())) {
            attr = new DefaultConfiguration("shape");
            attr.setValue(config.get("shape").toString());
            child.addChild((Configuration)attr);
        }
        return cfg;
    }
}

