/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.scm.BarcodeInventoryCollection;
import com.kingdee.eas.barcode.scm.BarcodeInventoryFactory;
import com.kingdee.eas.barcode.scm.BarcodeInventoryInfo;
import com.kingdee.eas.barcode.scm.BarcodeOfDateMinCollection;
import com.kingdee.eas.barcode.scm.BarcodeOfDateMinFactory;
import com.kingdee.eas.barcode.scm.BarcodeOfDateMinInfo;
import com.kingdee.eas.barcode.scm.IBarcodeInventory;
import com.kingdee.eas.barcode.scm.IBarcodeOfDateMin;
import com.kingdee.eas.barcode.scm.app.AbstractBarcodeInventoryControllerBean;
import com.kingdee.eas.barcode.scm.util.BarcodeInvDateInfo;
import com.kingdee.eas.barcode.scm.util.BarcodeInvServerUtils;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class BarcodeInventoryControllerBean
extends AbstractBarcodeInventoryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.scm.app.BarcodeInventoryControllerBean");

    @Override
    protected void _updateBarcodeInv(Context ctx, List barcodeInvList) throws BOSException, EASBizException {
        super._updateBarcodeInv(ctx, barcodeInvList);
        IBarcodeInventory iBarcodeInventory = BarcodeInventoryFactory.getLocalInstance(ctx);
        IBarcodeOfDateMin iBarcodeOfDateMin = BarcodeOfDateMinFactory.getLocalInstance(ctx);
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection barcodeInventotyCol = new CoreBaseCollection();
        CoreBaseCollection barcodeInventotyDateCol = new CoreBaseCollection();
        HashMap<String, BarcodeInventoryInfo> updateBarcodeInvMap = new HashMap<String, BarcodeInventoryInfo>();
        HashMap<String, BarcodeOfDateMinInfo> updateBarcodeDateMap = new HashMap<String, BarcodeOfDateMinInfo>();
        int size = barcodeInvList.size();
        for (int i = 0; i < size; ++i) {
            BarcodeInvDateInfo barcodeInvDateInfo = (BarcodeInvDateInfo)barcodeInvList.get(i);
            BarcodeInventoryInfo barcodeInvInfo = barcodeInvDateInfo.getBarcodeInventoryInfo();
            String barcode = barcodeInvInfo.getBarcode();
            String materialInfoId = barcodeInvInfo.getMaterial() != null ? barcodeInvInfo.getMaterial().getId().toString() : null;
            String orgUnitInfoId = barcodeInvInfo.getStorageOrgUnit() != null ? barcodeInvInfo.getStorageOrgUnit().getId().toString() : null;
            String wareInfoId = barcodeInvInfo.getWarehouse() != null ? barcodeInvInfo.getWarehouse().getId().toString() : null;
            String locationInfoId = barcodeInvInfo.getLocation() != null ? barcodeInvInfo.getLocation().getId().toString() : null;
            String positionId = barcodeInvInfo.getPosition() != null ? barcodeInvInfo.getPosition().getId().toString() : null;
            String lot = barcodeInvInfo.getLot();
            BarcodeInventoryCollection barcodeCol = BarcodeInvServerUtils.getBarcodeInventoryCol(ctx, barcode, materialInfoId, wareInfoId, locationInfoId, positionId, lot);
            boolean iskoujian = barcodeInvDateInfo.isKoujian();
            BigDecimal thisInvQty = barcodeInvInfo.getCurStoreQty().abs();
            if (barcodeCol.size() > 0) {
                String key;
                BarcodeInventoryInfo oldInventoryInfo = barcodeCol.get(0);
                barcodeInvInfo.setId(oldInventoryInfo.getId());
                barcodeInvInfo.setCurStoreQty(oldInventoryInfo.getCurStoreQty().add(barcodeInvInfo.getCurStoreQty()));
                if (barcodeInvDateInfo.isLock() && barcodeInvInfo.getLockQty() != null) {
                    barcodeInvInfo.setLockQty(oldInventoryInfo.getLockQty().subtract(barcodeInvInfo.getLockQty()));
                }
                if (updateBarcodeInvMap.containsKey(key = oldInventoryInfo.getId().toString())) {
                    BarcodeInventoryInfo updaetbarcodeInvInfo = (BarcodeInventoryInfo)updateBarcodeInvMap.get(key);
                    if (barcodeInvDateInfo.isLock() && updaetbarcodeInvInfo.getLockQty() != null) {
                        barcodeInvInfo.setLockQty(barcodeInvInfo.getLockQty().subtract(updaetbarcodeInvInfo.getLockQty()));
                    }
                    barcodeInvInfo.setCurStoreQty(barcodeInvInfo.getCurStoreQty().add(updaetbarcodeInvInfo.getCurStoreQty()));
                    updateBarcodeInvMap.put(key, barcodeInvInfo);
                } else {
                    updateBarcodeInvMap.put(key, barcodeInvInfo);
                }
            } else if (!iskoujian) {
                StoreStateInfo stateInfo = new StoreStateInfo();
                stateInfo.setId(BOSUuid.read((String)"181875d5-0105-1000-e000-012ec0a812fd62A73FA5"));
                barcodeInvInfo.setStorestatus(stateInfo);
                iBarcodeInventory.addnew(barcodeInvInfo);
            } else {
                if (barcodeInvInfo.getMaterial().getName() == null) {
                    MaterialInfo materialInfo = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfoId));
                    barcodeInvInfo.setMaterial(materialInfo);
                }
                throw new EASBizException(new NumericExceptionSubItem("", "[" + barcodeInvInfo.getMaterial().getName() + "]\u7269\u6599\u7684\u6761\u7801\u5e93\u5b58\u4e0d\u8db3\uff0c\u64cd\u4f5c\u5931\u8d25\uff01"));
            }
            BarcodeOfDateMinCollection barcodeOfDateMinCol = barcodeInvDateInfo.getBarcodeDateMinCol();
            CoreBaseCollection coreBaseInvCol = new CoreBaseCollection();
            int m = barcodeOfDateMinCol.size();
            for (int j = 0; j < m; ++j) {
                BarcodeOfDateMinInfo barcodeDateMinInfo = barcodeOfDateMinCol.get(j);
                barcodeDateMinInfo.setBarcodeInventory(barcodeInvInfo);
                coreBaseInvCol.add((CoreBaseInfo)barcodeDateMinInfo);
            }
            if (!iskoujian) {
                if (coreBaseInvCol.size() <= 0) continue;
                iBarcodeOfDateMin.addnewBatchData(coreBaseInvCol);
                continue;
            }
            if (barcodeInvInfo.getId() == null) continue;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo selectfilterInfo = new FilterInfo();
            selectfilterInfo.getFilterItems().add(new FilterItemInfo("barcodeInventory.id", (Object)barcodeInvInfo.getId()));
            selectfilterInfo.getFilterItems().add(new FilterItemInfo("qty", (Object)BigDecimal.ZERO, CompareType.GREATER));
            view.setFilter(selectfilterInfo);
            view.setSelector(this.getBarcodeOfDateMinSelect());
            SorterItemCollection sortColl = new SorterItemCollection();
            SorterItemInfo info = new SorterItemInfo();
            info.setPropertyName("inWarehouseDate");
            info.setSortType(SortType.ASCEND);
            sortColl.add(info);
            view.setSorter(sortColl);
            BarcodeOfDateMinCollection barcodeofDateCol = iBarcodeOfDateMin.getBarcodeOfDateMinCollection(view);
            BigDecimal totalOutQty = BigDecimal.ZERO;
            int m2 = barcodeofDateCol.size();
            for (int j = 0; j < m2 && totalOutQty.compareTo(thisInvQty) != 0; ++j) {
                BarcodeOfDateMinInfo barcodeDateInfo = barcodeofDateCol.get(j);
                if (barcodeDateInfo.getQty().compareTo(thisInvQty.subtract(totalOutQty)) >= 0) {
                    barcodeDateInfo.setQty(barcodeDateInfo.getQty().subtract(thisInvQty.subtract(totalOutQty)));
                    totalOutQty = totalOutQty.add(thisInvQty.subtract(totalOutQty));
                } else {
                    totalOutQty = totalOutQty.add(barcodeDateInfo.getQty());
                    barcodeDateInfo.setQty(BigDecimal.ZERO);
                }
                String key = barcodeDateInfo.getId().toString();
                if (updateBarcodeDateMap.containsKey(key)) {
                    BarcodeOfDateMinInfo updateBarcodeDateInfo = (BarcodeOfDateMinInfo)updateBarcodeDateMap.get(key);
                    barcodeDateInfo.setQty(barcodeDateInfo.getQty().subtract(updateBarcodeDateInfo.getQty()));
                    updateBarcodeDateMap.put(key, barcodeDateInfo);
                    continue;
                }
                updateBarcodeDateMap.put(key, barcodeDateInfo);
            }
        }
        for (String key : updateBarcodeDateMap.keySet()) {
            barcodeInventotyDateCol.add((CoreBaseInfo)updateBarcodeDateMap.get(key));
        }
        if (barcodeInventotyDateCol.size() > 0) {
            iBarcodeOfDateMin.updateBatchData(barcodeInventotyDateCol);
        }
        for (String key : updateBarcodeInvMap.keySet()) {
            iBarcodeInventory.updatePartial((BarcodeInventoryInfo)updateBarcodeInvMap.get(key), this.getBarcodeInvSelect());
            barcodeInventotyCol.add((CoreBaseInfo)updateBarcodeInvMap.get(key));
        }
        FilterInfo deletefilterInfo = new FilterInfo();
        deletefilterInfo.getFilterItems().add(new FilterItemInfo("qty", (Object)BigDecimal.ZERO, CompareType.EQUALS));
        iBarcodeOfDateMin.delete(deletefilterInfo);
    }

    private SelectorItemCollection getBarcodeOfDateMinSelect() {
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("barcode"));
        coll.add(new SelectorItemInfo("lot"));
        coll.add(new SelectorItemInfo("inWarehouseDate"));
        coll.add(new SelectorItemInfo("qty"));
        coll.add(new SelectorItemInfo("barcodeInventory.id"));
        coll.add(new SelectorItemInfo("id"));
        return coll;
    }

    private SelectorItemCollection getBarcodeInvSelect() {
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("curStoreQty"));
        coll.add(new SelectorItemInfo("id"));
        return coll;
    }

    private Timestamp getMonthTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
        String dateString = formatter.format(date);
        Timestamp createtime = null;
        try {
            createtime = new Timestamp(formatter.parse(dateString).getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return createtime;
    }

    @Override
    protected void _adjustStatus(Context ctx, IObjectCollection barcodeInvList) throws BOSException, EASBizException {
        super._adjustStatus(ctx, barcodeInvList);
        BarcodeInventoryCollection barocdeInvCol = (BarcodeInventoryCollection)barcodeInvList;
        if (barocdeInvCol.size() == 0) {
            return;
        }
        IBarcodeInventory iBarcodeInventory = BarcodeInventoryFactory.getLocalInstance(ctx);
        int size = barocdeInvCol.size();
        for (int i = 0; i < size; ++i) {
            StringBuffer updateSql;
            BigDecimal oldQty;
            StoreStateInfo oldStateInfo;
            BarcodeInventoryInfo barcodeInventory = barocdeInvCol.get(i);
            StoreStateInfo storeStateInfo = oldStateInfo = barcodeInventory.get("oldStatus") != null ? (StoreStateInfo)barcodeInventory.get("oldStatus") : null;
            if (barcodeInventory.get("oldQty") != null && (oldQty = (BigDecimal)barcodeInventory.get("oldQty")).compareTo(barcodeInventory.getCurStoreQty()) == 0 && oldStateInfo != null && "181875d5-0105-1000-e000-0134c0a812fd62A73FA5".equals(oldStateInfo.getId().toString())) {
                iBarcodeInventory.update((IObjectPK)new ObjectUuidPK(barcodeInventory.getId()), barcodeInventory);
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("barcode", (Object)barcodeInventory.getBarcode()));
            filterInfo.getFilterItems().add(new FilterItemInfo("storestatus.id", (Object)barcodeInventory.getStorestatus().getId()));
            if (!iBarcodeInventory.exists(filterInfo)) {
                BarcodeInventoryInfo newInventoryInfo = (BarcodeInventoryInfo)barcodeInventory.clone();
                newInventoryInfo.setId(null);
                iBarcodeInventory.addnew(newInventoryInfo);
            } else {
                updateSql = new StringBuffer();
                updateSql.append("update T_IND_BarcodeInventory set FCurStoreQty=FCurStoreQty+").append(barcodeInventory.getCurStoreQty().stripTrailingZeros().toPlainString()).append("\t\n");
                updateSql.append(" where FBarcode='").append(barcodeInventory.getBarcode()).append("' \t\n");
                updateSql.append(" and FStorestatusId='").append(barcodeInventory.getStorestatus().getId()).append("'");
                DbUtil.execute((Context)ctx, (String)updateSql.toString());
            }
            updateSql = new StringBuffer();
            updateSql.append("update T_IND_BarcodeInventory  set FCurStoreQty=FCurStoreQty-").append(barcodeInventory.getCurStoreQty().stripTrailingZeros().toPlainString()).append("\t\n");
            updateSql.append(" where fid='").append(barcodeInventory.getId()).append("'");
            DbUtil.execute((Context)ctx, (String)updateSql.toString());
        }
        DbUtil.execute((Context)ctx, (String)"delete from T_IND_BarcodeInventory where FCurStoreQty=0");
    }
}

