/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.scm.BarcodeAnalysisResult;
import com.kingdee.eas.barcode.scm.BarcodeAnalysisResultItem;
import com.kingdee.eas.barcode.scm.BarcodeConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodeConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeConfigXML;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLDetail;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLProperty;
import com.kingdee.eas.barcode.scm.BarcodeScanningBarcodeInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningCollection;
import com.kingdee.eas.barcode.scm.BarcodeScanningFactory;
import com.kingdee.eas.barcode.scm.BarcodeScanningInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningPropertyInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningRecodeInfo;
import com.kingdee.eas.barcode.scm.BarcodeUploadFacadeFactory;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.BarcodeXMLHelper;
import com.kingdee.eas.barcode.scm.DataBasePermissionUtil;
import com.kingdee.eas.barcode.scm.ForegrdStautsEnum;
import com.kingdee.eas.barcode.scm.app.AbstractBarcodeScanningControllerBean;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleUtils;
import com.kingdee.eas.base.form.ide.utils.EntityObjectInfoHelp;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.IObjectBase;
import com.kingdee.eas.framework.ObjectBaseCollection;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class BarcodeScanningControllerBean
extends AbstractBarcodeScanningControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.barcode.app.BarcodeScanningControllerBean");
    public String barcodeScanningId = null;
    public static String countTableEntryBosType = "CF0E4015";
    public static String countTalbeBosType = "D9D2CA5D";
    public List<BarcodeConfigXMLDetail> xmlDetail;
    public static final String COUNTINGTABLE_BOSTYPE = "D9D2CA5D";
    public static final String COUNTINGTASK_BOSTYPE = "AC301916";
    public static final String COUNTINGTABLEENTRY_BOSTYPE = "CF0E4015";
    public ForegrdStautsEnum status = null;
    public static String commonFileds = "ID_PARENTID_BOSTYPE_PARENTBOSTYPE_ENTITYNAME_ENTITYALIAS_SRCBILLID_SRCENTRYID_DIFQTY";

    @Override
    public Object _getDestBill(Context ctx, Object list) throws BOSException, EASBizException {
        LinkedHashMap paramMap = (LinkedHashMap)list;
        ObjectBaseCollection destBillColl = new ObjectBaseCollection();
        String bosType = null;
        if (paramMap.get("srcBosType") != null && !paramMap.get("srcBosType").equals("")) {
            bosType = paramMap.get("srcBosType").toString();
        } else if (paramMap.get("destBosType") != null && !paramMap.get("destBosType").equals("")) {
            bosType = paramMap.get("destBosType").toString();
        }
        if (bosType == null) {
            return null;
        }
        BarcodeAnalysisResult barcodeResult = (BarcodeAnalysisResult)paramMap.get("barcodeResult");
        CoreBillBaseInfo info = this._getBillData(ctx, barcodeResult);
        if (paramMap.get("srcBosType") != null && !paramMap.get("srcBosType").equals("")) {
            if (paramMap.get("srcBosType").toString().equals(COUNTINGTASK_BOSTYPE)) {
                String select = this.getSelectFields();
                String whereSql = select + " where countingTask.id = '" + info.getId().toString() + "'";
                ObjectBaseCollection coll = ((IObjectBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)COUNTINGTABLE_BOSTYPE))).getObjectBaseCollection(whereSql);
                destBillColl.addObjectCollection((IObjectCollection)coll);
            } else if (paramMap.get("srcBosType").toString().equals(barcodeResult.getBosType())) {
                IBTPManager ibtp = BTPManagerFactory.getLocalInstance((Context)ctx);
                BOTMappingInfo botMappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo(" where name = '" + paramMap.get("botpNumber") + "'");
                BTPTransformResult result = ibtp.transform(info, botMappingInfo);
                IObjectCollection resultCol = result.getBills();
                destBillColl.addObject(resultCol.getObject(0));
            }
        } else {
            destBillColl.addObject((IObjectValue)info);
        }
        return destBillColl;
    }

    @Override
    protected CoreBillBaseInfo _getBillData(Context ctx, BarcodeAnalysisResult barcodeAnalysisResult) throws BOSException, EASBizException {
        LinkedHashMap<String, Object> entryMap = new LinkedHashMap<String, Object>();
        String entryName = "";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        CoreBillBaseInfo info = null;
        for (int i = 0; i < barcodeAnalysisResult.getItems().size(); ++i) {
            BarcodeAnalysisResultItem item = barcodeAnalysisResult.getItems().get(i);
            String filed = item.getField();
            if (filed.indexOf(".") == -1) {
                if (item.isLinkedProperty()) {
                    filed = filed + ".number";
                }
                if (filed.equalsIgnoreCase("barcodeQ") || filed.equals("materialName") || filed.equals("material_model") || filed.equals("assistProperty") || filed.equals("assistID") || filed.equals("lot") || filed.equals("qty")) continue;
                filter.getFilterItems().add(new FilterItemInfo(filed, item.getValue()));
                continue;
            }
            entryName = filed.substring(0, filed.indexOf("."));
            String key = filed.substring(filed.lastIndexOf(".") + 1);
            entryMap.put(key, item.getValue() == null ? null : item.getValue());
        }
        view.setFilter(filter);
        ICoreBillBase iCoreBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)barcodeAnalysisResult.getBosType()));
        CoreBillBaseCollection coll = null;
        if (view.getFilter().getFilterItems().size() > 0) {
            coll = iCoreBase.getCoreBillBaseCollection(view);
        }
        if (coll != null && coll.size() > 0) {
            info = coll.get(0);
            if (!entryName.equals("")) {
                this.filterEntry(ctx, entryMap, entryName, info);
                IObjectCollection entryColl = (IObjectCollection)info.get(entryName);
                if (entryColl == null || entryColl.size() <= 0) {
                    throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"46_BarcodeScanningControllerBean", (Locale)ctx.getLocale())));
                }
            }
        } else {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"46_BarcodeScanningControllerBean", (Locale)ctx.getLocale())));
        }
        return info;
    }

    private String getSelectFields() {
        String select = "select *,storageOrgUnit.number,storageOrgUnit.name,warehouse.number,warehouse.name,countingPerson.number,countingPerson.name,countingAgainPerson.number,countingAgainPerson.name,countingMonitorer.number,entry.*,entry.location.number,entry.location.name,entry.material.number,entry.material.name,entry.storeType.number,entry.storeType.name,entry.unit.number,entry.unit.name,entry.assistUnit.number,entry.assistUnit.name,entry.storeStatus.number,entry.storeStatus.name";
        return select;
    }

    private void filterEntry(Context ctx, Map<String, Object> entryMap, String entryName, CoreBillBaseInfo info) throws EASBizException, BOSException {
        if (entryMap.size() > 0) {
            IObjectCollection entryColl = (IObjectCollection)info.get(entryName);
            ArrayList<IObjectValue> removeIndx = new ArrayList<IObjectValue>();
            if (entryColl != null && entryColl.size() > 0) {
                int i;
                for (i = 0; i < entryColl.size(); ++i) {
                    int keySize = 0;
                    int matchSize = 0;
                    IObjectValue entryInfo = entryColl.getObject(i);
                    Iterator<String> keys = entryMap.keySet().iterator();
                    while (keys.hasNext()) {
                        ++keySize;
                        String key = keys.next();
                        Object value = entryInfo.get(key);
                        if (value == null || entryMap.get(key) == null) continue;
                        if (value.getClass() == Integer.class) {
                            if (!value.toString().equals(new Integer(entryMap.get(key).toString()).toString())) continue;
                            ++matchSize;
                            continue;
                        }
                        if (value instanceof IObjectValue) {
                            IObjectValue objectValue = (IObjectValue)this._getIObjectValueById(ctx, ((IObjectValue)value).getString("id"));
                            if (!objectValue.getString("number").equals(entryMap.get(key))) continue;
                            ++matchSize;
                            continue;
                        }
                        if (!value.toString().equals(entryMap.get(key).toString())) continue;
                        ++matchSize;
                    }
                    if (matchSize == keySize) continue;
                    removeIndx.add(entryInfo);
                }
                for (i = 0; i < removeIndx.size(); ++i) {
                    entryColl.removeObject((IObjectValue)removeIndx.get(i));
                }
            }
        }
    }

    @Override
    protected Object _getIObjectValueById(Context ctx, String id) throws BOSException, EASBizException {
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)id, (boolean)true);
        ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("name");
        sic.add("number");
        sic.add("id");
        CoreBaseInfo value = null;
        try {
            if (iCoreBase.exists((IObjectPK)new ObjectUuidPK(id))) {
                value = iCoreBase.getValue((IObjectPK)new ObjectUuidPK(id), sic);
            }
        }
        catch (EASBizException e) {
            throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
        }
        return value;
    }

    @Override
    protected void _saveScanningRecodes(Context ctx, List list, String entityBosType, Object xml) throws BOSException, EASBizException {
        List recodeList;
        BarcodeConfigXML configXml = (BarcodeConfigXML)xml;
        this.xmlDetail = configXml.getDetails();
        if (list != null && (recodeList = list).size() > 0) {
            this.barcodeScanningId = ((BarcodeScanningRecodeInfo)recodeList.get(0)).getFparentId();
            this.deleteRecodesAndSeq(ctx, entityBosType);
            this.updateData(ctx, recodeList);
            this.updateRecodesList(ctx, entityBosType, recodeList);
            this.updateBarcodes(ctx, entityBosType, recodeList);
            this.updateSeqNos(ctx, entityBosType, recodeList);
        }
    }

    private void deleteRecodesAndSeq(Context ctx, String entityBosType) throws BOSException {
        String sql = "delete from T_BC_" + entityBosType + "_Barcode where fbarcodescanningid = '" + this.barcodeScanningId + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from T_BC_" + entityBosType + "_Seqno where fbarcodescanningid = '" + this.barcodeScanningId + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void updateBarcodes(Context ctx, String entityBosType, List<BarcodeScanningRecodeInfo> recodeList) throws SQLDataException {
        ArrayList<String> listSql = new ArrayList<String>();
        for (int i = 0; i < recodeList.size(); ++i) {
            BarcodeScanningRecodeInfo info = recodeList.get(i);
            List<BarcodeScanningBarcodeInfo> barcodeList = info.getBarcodeList();
            if (barcodeList == null || barcodeList.size() <= 0) continue;
            for (int j = 0; j < barcodeList.size(); ++j) {
                BarcodeScanningBarcodeInfo barcodeInfo = barcodeList.get(j);
                String sql = "insert into T_BC_" + entityBosType + "_Barcode(fparentid,fparentbostype,fbarcode,fbarcoderuleid,fbarcodescanningid) values('" + info.getFid() + "','" + info.getFbosType() + "','" + barcodeInfo.getBarcode() + "','" + barcodeInfo.getBarcodeRuleId() + "','" + this.barcodeScanningId + "')";
                listSql.add(sql);
            }
        }
        if (listSql.size() > 0) {
            com.kingdee.eas.base.core.util.DbUtil.executeBatch((Context)ctx, listSql);
        }
    }

    private void updateSeqNos(Context ctx, String entityBosType, List<BarcodeScanningRecodeInfo> recodeList) throws SQLDataException {
        ArrayList<String> listSql = new ArrayList<String>();
        for (int i = 0; i < recodeList.size(); ++i) {
            BarcodeScanningRecodeInfo info = recodeList.get(i);
            List<String> seqNoList = info.getSeqNoList();
            if (seqNoList == null || seqNoList.size() <= 0) continue;
            for (int j = 0; j < seqNoList.size(); ++j) {
                String seqNo = seqNoList.get(j);
                String sql = "insert into T_BC_" + entityBosType + "_Seqno(fparentid,fparentbostype,fsequenceno,fbarcodescanningid) values('" + info.getFid() + "','" + info.getFbosType() + "','" + seqNo + "','" + this.barcodeScanningId + "')";
                listSql.add(sql);
            }
        }
        if (listSql.size() > 0) {
            com.kingdee.eas.base.core.util.DbUtil.executeBatch((Context)ctx, listSql);
        }
    }

    private void updateRecodesList(Context ctx, String entityBosType, List<BarcodeScanningRecodeInfo> list) throws BOSException, EASBizException {
        ArrayList<BarcodeScanningRecodeInfo> allChildList = new ArrayList<BarcodeScanningRecodeInfo>();
        for (int i = 0; i < list.size(); ++i) {
            BarcodeScanningRecodeInfo info = list.get(i);
            Map<String, List<BarcodeScanningRecodeInfo>> childMap = info.getEntriesMap();
            if (childMap == null || childMap.size() <= 0) continue;
            Iterator<String> keys = childMap.keySet().iterator();
            while (keys.hasNext()) {
                List<BarcodeScanningRecodeInfo> childList = childMap.get(keys.next());
                allChildList.addAll(childList);
            }
        }
        if (allChildList.size() > 0) {
            this.updateData(ctx, allChildList);
            this.updateBarcodes(ctx, entityBosType, allChildList);
            this.updateSeqNos(ctx, entityBosType, allChildList);
            this.updateRecodesList(ctx, entityBosType, allChildList);
        }
    }

    private void insertRecodes(Context ctx, List<BarcodeScanningRecodeInfo> list) throws SQLDataException {
        if (list.size() > 0) {
            ArrayList<String> listSql = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                BarcodeScanningRecodeInfo info = list.get(i);
                Map<String, BarcodeScanningPropertyInfo> properties = info.getProperties();
                Iterator<String> keys = properties.keySet().iterator();
                String colunms = "(";
                String values = "(";
                if (!keys.hasNext()) continue;
                while (keys.hasNext()) {
                    String key = keys.next();
                    BarcodeScanningPropertyInfo propertyInfo = properties.get(key);
                    if (propertyInfo == null) continue;
                    colunms = colunms + "\"" + key.toUpperCase() + "\",";
                    Object value = propertyInfo.getValue();
                    if (value != null) {
                        if (value.getClass() == Date.class || value.getClass() == Timestamp.class) {
                            values = values + "to_date('" + value + "'),";
                            continue;
                        }
                        if (value.getClass() == BigDecimal.class) {
                            values = values + "to_decimal('" + ((BigDecimal)value).toPlainString() + "',21,8),";
                            continue;
                        }
                        values = values + "'" + value + "',";
                        continue;
                    }
                    if ("fdifqty".equalsIgnoreCase(propertyInfo.getKey()) || "fsrcqty".equalsIgnoreCase(propertyInfo.getKey())) {
                        values = values + "0,";
                        continue;
                    }
                    values = values + value + ",";
                }
                colunms = colunms + "\"FENTITYNAME\",\"FENTITYALIAS\",\"FBOSTYPE\",\"FPARENTBOSTYPE\"";
                colunms = colunms + ")";
                values = values + "'" + info.getFentityName() + "', '" + info.getFentityAlias() + "','" + info.getFbosType() + "','" + info.getFparentBosType() + "'";
                values = values + ")";
                String sql = "insert into T_BC_" + info.getFbosType() + colunms + "values" + values;
                listSql.add(sql);
            }
            if (listSql.size() > 0) {
                com.kingdee.eas.base.core.util.DbUtil.executeBatch((Context)ctx, listSql);
            }
        }
    }

    private void updateData(Context ctx, List<BarcodeScanningRecodeInfo> list) throws BOSException, EASBizException {
        Map<String, List<BarcodeScanningRecodeInfo>> map = this.getUpdAndInsRecdList(ctx, list);
        String bosType = list.get(0).getFbosType();
        List<BarcodeScanningRecodeInfo> updateList = map.get("update");
        List<BarcodeScanningRecodeInfo> insertList = map.get("insert");
        String deleteIdStr = (String)((Object)map.get("delete"));
        if (insertList.size() > 0) {
            this.insertRecodes(ctx, insertList);
        }
        if (updateList.size() > 0) {
            this.updateRecodes(ctx, updateList);
        }
        if (deleteIdStr != null) {
            String sql = "delete from T_BC_" + bosType + " where fid in (" + deleteIdStr + ")";
            com.kingdee.eas.base.core.util.DbUtil.execute((Context)ctx, (String)sql);
            this.deleteEntryData(ctx, bosType, deleteIdStr);
        }
    }

    private void deleteEntryData(Context ctx, String bosType, String deleteIdStr) throws BOSException, EASBizException {
        for (int i = 0; i < this.xmlDetail.size(); ++i) {
            String parentBosType = this.xmlDetail.get(i).getParentBosType();
            String childBosType = this.xmlDetail.get(i).getBosType();
            if (parentBosType == null || !parentBosType.equals(bosType)) continue;
            String idSql = "select fid from T_BC_" + childBosType + " where fparentid in (" + deleteIdStr + ")";
            IRowSet idSet = DbUtil.executeQuery((Context)ctx, (String)idSql);
            String idStr = "";
            try {
                while (idSet.next()) {
                    idStr = idStr + "'" + idSet.getString("fid") + "',";
                }
            }
            catch (SQLException e) {
                throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
            }
            String childSql = "delete from T_BC_" + childBosType + " where fparentid in (" + deleteIdStr + ")";
            com.kingdee.eas.base.core.util.DbUtil.execute((Context)ctx, (String)childSql);
            if (idStr.length() <= 0) continue;
            idStr = idStr.substring(0, idStr.lastIndexOf(","));
            this.deleteEntryData(ctx, childBosType, idStr);
        }
    }

    private void updateRecodes(Context ctx, List<BarcodeScanningRecodeInfo> updateList) throws SQLDataException {
        ArrayList<String> listSql = new ArrayList<String>();
        for (int i = 0; i < updateList.size(); ++i) {
            BarcodeScanningRecodeInfo info = updateList.get(i);
            String sql = "update T_BC_" + info.getFbosType() + "  set ";
            Map<String, BarcodeScanningPropertyInfo> properties = info.getProperties();
            Iterator<String> keys = properties.keySet().iterator();
            if (!keys.hasNext()) continue;
            while (keys.hasNext()) {
                String key = keys.next();
                BarcodeScanningPropertyInfo propertyInfo = properties.get(key);
                if (propertyInfo == null) continue;
                sql = sql + "\"" + key.toUpperCase() + "\" = ";
                Object value = propertyInfo.getValue();
                if (value != null) {
                    if (value.getClass() == Date.class || value.getClass() == Timestamp.class) {
                        sql = sql + "to_date('" + value + "'),";
                        continue;
                    }
                    if (value.getClass() == BigDecimal.class) {
                        sql = sql + "to_decimal('" + ((BigDecimal)value).toPlainString() + "',21,8),";
                        continue;
                    }
                    sql = sql + "'" + value + "',";
                    continue;
                }
                if ("fdifqty".equalsIgnoreCase(propertyInfo.getKey()) || "fsrcqty".equalsIgnoreCase(propertyInfo.getKey())) {
                    sql = sql + "0,";
                    continue;
                }
                sql = sql + value + ",";
            }
            sql = sql.substring(0, sql.lastIndexOf(","));
            sql = sql + " where \"FID\" = '" + info.getFid() + "'";
            listSql.add(sql);
        }
        if (listSql.size() > 0) {
            com.kingdee.eas.base.core.util.DbUtil.executeBatch((Context)ctx, listSql);
        }
    }

    private Map<String, List<BarcodeScanningRecodeInfo>> getUpdAndInsRecdList(Context ctx, List<BarcodeScanningRecodeInfo> list) throws BOSException, EASBizException {
        HashMap<String, List<BarcodeScanningRecodeInfo>> map = new HashMap<String, List<BarcodeScanningRecodeInfo>>();
        ArrayList<BarcodeScanningRecodeInfo> updateList = new ArrayList<BarcodeScanningRecodeInfo>();
        ArrayList<BarcodeScanningRecodeInfo> insertList = new ArrayList<BarcodeScanningRecodeInfo>();
        String deleteIdStr = "";
        String bosType = list.get(0).getFbosType();
        String sql = "select fid,fparentid from t_bc_" + bosType + " where fScanningId = '" + this.barcodeScanningId + "'";
        ArrayList<String> idList = new ArrayList<String>();
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (set.size() > 0) {
            int i;
            try {
                while (set.next()) {
                    idList.add(set.getString("fid"));
                }
            }
            catch (SQLException e) {
                throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
            }
            block3: for (i = 0; i < idList.size(); ++i) {
                String oldId = (String)idList.get(i);
                for (int j = 0; j < list.size(); ++j) {
                    BarcodeScanningRecodeInfo recodeInfo = list.get(j);
                    String id = recodeInfo.getFid();
                    if (oldId.equals(id)) {
                        updateList.add(recodeInfo);
                        continue block3;
                    }
                    if (oldId.equals(id) || j != list.size() - 1) continue;
                    deleteIdStr = deleteIdStr + "'" + oldId + "',";
                }
            }
            for (i = 0; i < list.size(); ++i) {
                String oldId;
                BarcodeScanningRecodeInfo recodeInfo = list.get(i);
                String id = recodeInfo.getFid();
                for (int j = 0; j < idList.size() && !id.equals(oldId = (String)idList.get(j)); ++j) {
                    if (id.equals(oldId) || j != idList.size() - 1) continue;
                    insertList.add(recodeInfo);
                }
            }
        } else {
            insertList.addAll(list);
        }
        map.put("update", updateList);
        map.put("insert", insertList);
        map.put("delete", (List<BarcodeScanningRecodeInfo>)((Object)(deleteIdStr.equals("") ? null : deleteIdStr.substring(0, deleteIdStr.lastIndexOf(",")))));
        return map;
    }

    private void setSeqNoList(Context ctx, String bosType, List<BarcodeScanningRecodeInfo> recodesList) throws BOSException, SQLException {
        for (int j = 0; j < recodesList.size(); ++j) {
            BarcodeScanningRecodeInfo recodeInfo = recodesList.get(j);
            String sql = "select fsequenceno from T_BC_" + bosType + "_Seqno where fparentid = '" + recodeInfo.getFid() + "'";
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
            ArrayList<String> seqList = new ArrayList<String>();
            while (set.next()) {
                seqList.add(set.getString("fsequenceno"));
            }
            recodeInfo.setSeqNoList(seqList);
        }
    }

    private void setBarcodeList(Context ctx, String bosType, List<BarcodeScanningRecodeInfo> recodesList) throws BOSException, SQLException {
        for (int j = 0; j < recodesList.size(); ++j) {
            BarcodeScanningRecodeInfo recodeInfo = recodesList.get(j);
            String sql = "select fbarcode,fbarcoderuleid from T_BC_" + bosType + "_Barcode where fparentid = '" + recodeInfo.getFid() + "'";
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
            ArrayList<BarcodeScanningBarcodeInfo> barcodeList = new ArrayList<BarcodeScanningBarcodeInfo>();
            while (set.next()) {
                BarcodeScanningBarcodeInfo bsbi = new BarcodeScanningBarcodeInfo();
                bsbi.setBarcode(set.getString("fbarcode"));
                bsbi.setBarcodeRuleId(set.getString("fbarcoderuleid"));
                barcodeList.add(bsbi);
            }
            recodeInfo.setBarcodeList(barcodeList);
        }
    }

    private void setEntryMap(Context ctx, List<BarcodeConfigXMLDetail> detailList, String bosType, List<BarcodeScanningRecodeInfo> recodesList, String billBosType) throws SQLException, BOSException, EASBizException, ParseException {
        for (int j = 0; j < detailList.size(); ++j) {
            BarcodeConfigXMLDetail childDetail = detailList.get(j);
            String parentBosType = childDetail.getParentBosType();
            if (parentBosType == null || !parentBosType.equals(bosType)) continue;
            String currBosType = childDetail.getBosType();
            List<BarcodeConfigXMLProperty> childProList = childDetail.getProperties();
            for (int k = 0; k < recodesList.size(); ++k) {
                ArrayList<BarcodeScanningRecodeInfo> childRecList = new ArrayList<BarcodeScanningRecodeInfo>();
                String id = recodesList.get(k).getFid();
                IRowSet childRowset = this.getRowSet(ctx, id, childProList, currBosType);
                while (childRowset.next()) {
                    BarcodeScanningRecodeInfo childRecodeInfo = this.createRecodesInfo(childProList, childRowset, currBosType);
                    childRecList.add(childRecodeInfo);
                }
                recodesList.get(k).getEntriesMap().put(childDetail.getName(), childRecList);
                this.setBarcodeList(ctx, billBosType, childRecList);
                this.setSeqNoList(ctx, billBosType, childRecList);
                this.setEntryMap(ctx, detailList, currBosType, childRecList, billBosType);
            }
        }
    }

    private IRowSet getRowSet(Context ctx, String id, List<BarcodeConfigXMLProperty> propertyList, String bosType) throws EASBizException {
        String sql = "select ";
        for (int j = 0; j < propertyList.size(); ++j) {
            BarcodeConfigXMLProperty xmlProperty = propertyList.get(j);
            String filed = xmlProperty.getName();
            sql = xmlProperty.isLinkedProperty() ? sql + filed + "_number," + filed + "_name," : sql + filed + ",";
        }
        sql = sql + "fid,fbosType,fparentId,fsrcBillId,fsrcentryid,fentityName,fentityAlias,fparentBosType,fsrcQty,fdifQty,feasbillnumber,fdestbillid,fScanningId,fseq from T_BC_" + bosType + " where fparentId = '" + id + "' order by fseq";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            return rowSet;
        }
        catch (BOSException e1) {
            throw new EASBizException(new NumericExceptionSubItem("", e1.getMessage()));
        }
    }

    private BarcodeScanningRecodeInfo createRecodesInfo(List<BarcodeConfigXMLProperty> propertyList, IRowSet rowSet, String bosType) throws SQLException, ParseException {
        BarcodeScanningPropertyInfo proInfo;
        BarcodeScanningRecodeInfo recodeInfo = new BarcodeScanningRecodeInfo();
        recodeInfo.setFid(rowSet.getString("fid"));
        recodeInfo.setFparentId(rowSet.getString("fparentId"));
        recodeInfo.setFbosType(rowSet.getString("fbosType"));
        recodeInfo.setFparentBosType(rowSet.getString("fparentBosType"));
        recodeInfo.setFsrcBillId(rowSet.getString("fsrcBillId"));
        recodeInfo.setFsrcEntryId(rowSet.getString("fsrcEntryId"));
        recodeInfo.setFentityName(rowSet.getString("fentityName"));
        recodeInfo.setFentityAlias(rowSet.getString("fentityAlias"));
        TreeMap<String, BarcodeScanningPropertyInfo> propertyMap = new TreeMap<String, BarcodeScanningPropertyInfo>();
        boolean hasNumberFiled = false;
        for (int j = 0; j < propertyList.size(); ++j) {
            proInfo = new BarcodeScanningPropertyInfo();
            BarcodeConfigXMLProperty xmlPro = propertyList.get(j);
            String key = xmlPro.getName();
            if (xmlPro.isLinkedProperty()) {
                proInfo.setKey(key + "_number");
                proInfo.setValue(rowSet.getString(key + "_number"));
                propertyMap.put(key + "_number", proInfo);
                proInfo = new BarcodeScanningPropertyInfo();
                proInfo.setKey(key + "_name");
                proInfo.setValue(rowSet.getString(key + "_name"));
                propertyMap.put(key + "_name", proInfo);
                continue;
            }
            if (key.equals("number")) {
                hasNumberFiled = true;
            }
            Object value = rowSet.getObject(key);
            if (xmlPro.getDataType().equals("Date") && value != null) {
                value = Date.valueOf(value.toString().substring(0, 10));
            }
            if (xmlPro.getDataType().equals("Boolean") && value != null) {
                value = !value.equals("false");
            }
            if (xmlPro.getDataType().equals("Integer") && value != null) {
                value = Integer.valueOf(rowSet.getString(key));
            }
            proInfo.setKey(key);
            proInfo.setValue(value);
            propertyMap.put(key, proInfo);
        }
        propertyMap.put("fid", this.getCommonProInfo(rowSet, "fid"));
        propertyMap.put("fparentId", this.getCommonProInfo(rowSet, "fparentId"));
        propertyMap.put("fsrcBillId", this.getCommonProInfo(rowSet, "fsrcBillId"));
        propertyMap.put("fsrcEntryId", this.getCommonProInfo(rowSet, "fsrcEntryId"));
        propertyMap.put("fsrcQty", this.getCommonProInfo(rowSet, "fsrcQty"));
        propertyMap.put("fdifQty", this.getCommonProInfo(rowSet, "fdifQty"));
        propertyMap.put("fdestBillid", this.getCommonProInfo(rowSet, "fdestBillid"));
        propertyMap.put("fScanningId", this.getCommonProInfo(rowSet, "fScanningId"));
        BarcodeScanningPropertyInfo proSeq = new BarcodeScanningPropertyInfo();
        proSeq.setKey("fseq");
        proSeq.setValue(rowSet.getInt("fseq"));
        propertyMap.put("fseq", proSeq);
        if (hasNumberFiled && rowSet.getString("feasbillnumber") != null) {
            proInfo = new BarcodeScanningPropertyInfo();
            proInfo.setKey("number");
            proInfo.setValue(rowSet.getObject("feasbillnumber"));
            propertyMap.put("number", proInfo);
        }
        if (this.status != null && this.status == ForegrdStautsEnum.UPOVER) {
            if (bosType.equals(COUNTINGTABLEENTRY_BOSTYPE)) {
                proInfo = this.getCommonProInfo(rowSet, "fdifQty");
            }
            BarcodeScanningPropertyInfo pInfo = this.getCommonProInfo(rowSet, "fdestBillid");
            pInfo.setKey("id");
            propertyMap.put("id", pInfo);
        }
        recodeInfo.setProperties(propertyMap);
        return recodeInfo;
    }

    private BarcodeScanningPropertyInfo getCommonProInfo(IRowSet rowSet, String key) throws SQLException {
        BarcodeScanningPropertyInfo proInfo = new BarcodeScanningPropertyInfo();
        proInfo.setKey(key);
        proInfo.setValue(rowSet.getObject(key));
        return proInfo;
    }

    private BarcodeScanningPropertyInfo getCommonProInfo(IRowSet rowSet, String key, String srcKey) throws SQLException {
        BarcodeScanningPropertyInfo proInfo = new BarcodeScanningPropertyInfo();
        proInfo.setKey(key);
        BigDecimal value = rowSet.getBigDecimal(key).subtract(rowSet.getBigDecimal(srcKey));
        proInfo.setValue(value);
        return proInfo;
    }

    @Override
    protected void _barcodeUpLoad(Context ctx, Map paraMap) throws BOSException, EASBizException {
        BarcodeConfigXML xmlInfo = (BarcodeConfigXML)paraMap.get("xmlInfo");
        String id = (String)paraMap.get("id");
        String srcBosType = (String)paraMap.get("srcBosType");
        String bosType = (String)paraMap.get("bosType");
        String botpId = (String)paraMap.get("botpId");
        String defaultSolutionId = (String)paraMap.get("defaultSolutionId");
        BarcodeScanningInfo info = (BarcodeScanningInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(id));
        ObjectUuidPK orgPK = new ObjectUuidPK(info.getCU().getId());
        DataBasePermissionUtil.chekcPermission(ctx, (IObjectPK)orgPK, "barcodeScan_upload");
        if (info.getStatus() == ForegrdStautsEnum.SUSPEND || info.getStatus() == ForegrdStautsEnum.UPOVER) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"47_BarcodeScanningControllerBean", (Locale)ctx.getLocale())));
        }
        this.status = ForegrdStautsEnum.UPOVER;
        List barcodeList = (List)this._getRecodesList(ctx, id, xmlInfo);
        try {
            BarcodeUploadFacadeFactory.getLocalInstance(ctx).uploadBarcodeBill(barcodeList, defaultSolutionId, srcBosType, bosType, botpId);
            this._updateStatus(ctx, 3, id);
        }
        catch (EASBizException e) {
            throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
        }
    }

    @Override
    protected Object _getRecodesList(Context ctx, String id, Object xml) throws BOSException, EASBizException {
        BarcodeConfigXML xmlInfo = (BarcodeConfigXML)xml;
        List<BarcodeConfigXMLDetail> detailList = xmlInfo.getDetails();
        for (int i = 0; i < detailList.size(); ++i) {
            BarcodeConfigXMLDetail xmlDetail = detailList.get(i);
            if (xmlDetail.getParentBosType() != null) continue;
            String bosType = xmlDetail.getBosType();
            List<BarcodeConfigXMLProperty> propertyList = xmlDetail.getProperties();
            IRowSet rowSet = this.getRowSet(ctx, id, propertyList, bosType);
            ArrayList<BarcodeScanningRecodeInfo> recodesList = new ArrayList<BarcodeScanningRecodeInfo>();
            try {
                while (rowSet.next()) {
                    BarcodeScanningRecodeInfo recodeInfo = this.createRecodesInfo(propertyList, rowSet, bosType);
                    recodesList.add(recodeInfo);
                }
                this.setEntryMap(ctx, detailList, bosType, recodesList, bosType);
                this.setBarcodeList(ctx, bosType, recodesList);
                this.setSeqNoList(ctx, bosType, recodesList);
            }
            catch (Exception e) {
                throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
            }
            return recodesList;
        }
        return null;
    }

    @Override
    protected void _updateStatus(Context ctx, int status, String id) throws BOSException {
        String sql = "update t_bc_barcodescanning set fstatus = " + status + " where fid = '" + id + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BarcodeScanningInfo info = (BarcodeScanningInfo)model;
        if (info.getNumber() == null || info.getNumber().equals("")) {
            String number = CodingRuleUtils.getNumberByCtrlBean((Context)ctx, (IObjectValue)model, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
            info.setNumber(number);
        }
        this.verfiy(ctx, model);
        if (info.getStatus() == ForegrdStautsEnum.UPOVER) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"48_BarcodeScanningControllerBean", (Locale)ctx.getLocale())));
        }
        boolean isAddNewSave = false;
        if (info.getCreateTime() == null) {
            isAddNewSave = true;
        }
        IObjectPK pk = super._submit(ctx, model);
        if (isAddNewSave) {
            String sql = "update t_bc_barcodescanning  set flastupdateuserid = null,flastupdatetime = null where fid = '" + pk.toString() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        String oql = "select id,detailsXML where id ='" + info.getConfigName().getId() + "'";
        BarcodeConfigInfo configInfo = BarcodeConfigFactory.getLocalInstance(ctx).getBarcodeConfigInfo(oql);
        BarcodeConfigXML configXml = BarcodeXMLHelper.toBarcodeConfigXML(configInfo.getDetailsXML());
        this._saveScanningRecodes(ctx, info.getScanRecodeList(), info.getDestBosType(), configXml);
        return pk;
    }

    private void verfiy(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BarcodeScanningInfo info = (BarcodeScanningInfo)model;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        view.setFilter(filter);
        BarcodeScanningCollection coll = BarcodeScanningFactory.getLocalInstance(ctx).getBarcodeScanningCollection(view);
        if (coll != null && coll.size() >= 1) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"10_BarcodeConfigControllerBean", (Locale)ctx.getLocale())));
        }
    }

    @Override
    protected Object _getScanningRowSet(Context ctx, Object param) throws BOSException, EASBizException {
        Map para = (Map)param;
        String whereSql = (String)para.get("whereSql");
        String orderBy = " order by scann.fnumber";
        String joinSql = "";
        BarcodeConfigXML xmlInfo = (BarcodeConfigXML)para.get("xmlInfo");
        String sql = "select configName.fnumber as \"configName.number\",configName.FName_l2 as \"configName.name\", scann.fnumber as \"scanNumber\", cu.fnumber as \"cu.number\",cu.FName_l2 as \"cu.name\", (case when scann.fstatus = 1 then '" + ForegrdStautsEnum.SAVED.getAlias() + "' when scann.fstatus = 2 then '" + ForegrdStautsEnum.SUSPEND.getAlias() + "'  when scann.fstatus = 3 then '" + ForegrdStautsEnum.UPOVER.getAlias() + "' end) as \"status\",scann.fid as \"scanId\",";
        String parentBosType = null;
        String childBosType = null;
        for (int i = 0; i < xmlInfo.getDetails().size(); ++i) {
            BarcodeConfigXMLProperty xmlProperty;
            int j;
            BarcodeConfigXMLDetail xmlDetail = xmlInfo.getDetails().get(i);
            if (xmlDetail.getParentBosType() == null) {
                parentBosType = xmlDetail.getBosType();
                for (j = 0; j < xmlDetail.getProperties().size(); ++j) {
                    xmlProperty = xmlDetail.getProperties().get(j);
                    if (xmlProperty.isLinkedProperty()) {
                        sql = sql + "\"" + parentBosType + "\"." + xmlProperty.getName() + "_number as \"" + xmlProperty.getName() + "_number\",";
                        sql = sql + "\"" + parentBosType + "\"." + xmlProperty.getName() + "_name as \"" + xmlProperty.getName() + "_name\",";
                        continue;
                    }
                    sql = xmlProperty.getName().equals("number") ? sql + " (case when \"" + parentBosType + "\".feasbillnumber is not null then \"" + parentBosType + "\".feasbillnumber else \"" + parentBosType + "\"." + xmlProperty.getName() + " end) as \"" + xmlProperty.getName() + "\"," : sql + "\"" + parentBosType + "\"." + xmlProperty.getName() + " as \"" + xmlProperty.getName() + "\",";
                }
            }
            if (parentBosType == null || xmlDetail.getParentBosType() == null || !xmlDetail.getParentBosType().equals(parentBosType)) continue;
            childBosType = xmlDetail.getBosType();
            for (j = 0; j < xmlDetail.getProperties().size(); ++j) {
                String aliasq;
                xmlProperty = xmlDetail.getProperties().get(j);
                if (xmlProperty.isLinkedProperty()) {
                    String alias = xmlProperty.getFullName();
                    if (xmlProperty.getFullName().length() > 23) {
                        alias = xmlProperty.getFullName().substring(0, 23);
                    }
                    sql = sql + "\"" + childBosType + "\"." + xmlProperty.getName() + "_number as \"" + alias + "_number\",";
                    sql = sql + "\"" + childBosType + "\"." + xmlProperty.getName() + "_name as \"" + alias + "_name\",";
                    continue;
                }
                if (xmlProperty.isScanQty()) {
                    sql = sql + "\"" + childBosType + "\".fsrcEntryId as fsrcEntryId,";
                    sql = sql + "\"" + childBosType + "\".fsrcQty as fsrcQty,";
                    aliasq = xmlProperty.getFullName();
                    if (xmlProperty.getFullName().length() > 27) {
                        aliasq = xmlProperty.getFullName().substring(0, 27);
                    }
                    sql = sql + "\"" + childBosType + "\"." + xmlProperty.getName() + " as \"" + aliasq + "\",";
                    sql = sql + "\"" + childBosType + "\".fdifQty as fdifQty,";
                    continue;
                }
                aliasq = xmlProperty.getFullName();
                if (xmlProperty.getFullName().length() > 27) {
                    aliasq = xmlProperty.getFullName().substring(0, 27);
                }
                sql = sql + "\"" + childBosType + "\"." + xmlProperty.getName() + " as \"" + aliasq + "\",";
            }
            orderBy = orderBy + ",\"" + childBosType + "\".fseq";
            joinSql = joinSql + " left join T_BC_" + childBosType + " \"" + childBosType + "\" on \"" + parentBosType + "\".fid = \"" + childBosType + "\".fparentid ";
        }
        sql = sql.substring(0, sql.lastIndexOf(","));
        sql = sql + " from t_bc_barcodescanning scann left join t_bc_barcodeconfig configName on scann.FConfigNameID = configName.fid left join t_org_ctrlunit cu on cu.fid = scann.fcontrolunitid left join T_BC_" + parentBosType + " \"" + parentBosType + "\" on scann.fid = \"" + parentBosType + "\".fparentid" + joinSql + whereSql + orderBy;
        try {
            RptRowSet rowSet = DBUtil.executeQuery((String)sql, (Connection)this.getConnection(ctx));
            while (rowSet.next()) {
                for (int i = 0; i < xmlInfo.getDetails().size(); ++i) {
                    BarcodeConfigXMLDetail xmlDetail = xmlInfo.getDetails().get(i);
                    if (xmlDetail.getParentBosType() == null) {
                        this.transfromValue(rowSet, xmlDetail);
                    }
                    if (parentBosType == null || xmlDetail.getParentBosType() == null || !xmlDetail.getParentBosType().equals(parentBosType)) continue;
                    this.transfromValue(rowSet, xmlDetail);
                }
            }
            rowSet.moveTo(0);
            return rowSet;
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
        }
    }

    protected void transfromValue(RptRowSet rowSet, BarcodeConfigXMLDetail xmlDetail) {
        EntityObjectInfo entity = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)xmlDetail.getBosType()));
        for (int x = 0; x < xmlDetail.getProperties().size(); ++x) {
            PropertyInfo property;
            boolean isValueNull;
            BarcodeConfigXMLProperty xmlProperty = xmlDetail.getProperties().get(x);
            String dataType = xmlProperty.getDataType();
            if (dataType == null) continue;
            String key = xmlProperty.getFullName();
            Object value = rowSet.getObject(key);
            boolean bl = isValueNull = value == null || value.equals("");
            if (dataType.equals("Boolean")) {
                if (isValueNull) continue;
                rowSet.setValue(key, (Object)rowSet.getBoolean(key, false));
                continue;
            }
            if (!dataType.equals("Enum") || (property = entity.getPropertyByName(xmlProperty.getName())) == null) continue;
            String enumClass = (String)property.get("metadataRef");
            List emList = EnumUtils.getEnumList((String)enumClass);
            if (isValueNull || enumClass == null) continue;
            Enum enu = (Enum)BarcodeUtils.getEnum(emList, value.toString());
            rowSet.setValue(key, (Object)enu.getAlias());
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BarcodeScanningInfo info = (BarcodeScanningInfo)this._getValue(ctx, pk);
        ObjectUuidPK orgPK = new ObjectUuidPK(info.getCU().getId());
        DataBasePermissionUtil.chekcPermission(ctx, (IObjectPK)orgPK, "barcodeScan_delete");
        if (info.getStatus() == ForegrdStautsEnum.UPOVER) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"51_BarcodeScanningControllerBean", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
        BarcodeConfigInfo configInfo = BarcodeConfigFactory.getLocalInstance(ctx).getBarcodeConfigInfo((IObjectPK)new ObjectUuidPK(info.getConfigName().getId()));
        String xmlStr = configInfo.getDetailsXML();
        BarcodeConfigXML xmlInfo = BarcodeXMLHelper.toBarcodeConfigXML(xmlStr);
        List<BarcodeConfigXMLDetail> xmlDetailList = xmlInfo.getDetails();
        for (int i = 0; i < xmlDetailList.size(); ++i) {
            BarcodeConfigXMLDetail xmlDetail = xmlDetailList.get(i);
            com.kingdee.eas.base.core.util.DbUtil.execute((Context)ctx, (String)("delete from t_bc_" + xmlDetail.getBosType() + " where fscanningid = '" + pk + "'"));
            if (xmlDetail.getParentBosType() != null && !xmlDetail.getParentBosType().equals("")) continue;
            com.kingdee.eas.base.core.util.DbUtil.execute((Context)ctx, (String)("delete from t_bc_" + xmlDetail.getBosType() + "_Barcode where fbarcodescanningid = '" + pk + "'"));
        }
    }
}

